<?php
/**
 * 缓存抽象类
 * @copyright reginx.com
 * $Id: cache.extra.php 5 2013-01-14 13:22:55Z reginx $
 */
abstract class cache_extra{

    /**
     * 缓存实例
     *
     * @var unknown_type
     */
    private static $obj = NULL;

    /**
     * 架构函数
     *
     * @param unknown_type $config
     */
    public static function getCacheObj(&$app){
        if(empty(self::$obj)){
            $GLOBALS['_APP']['cache_reads'] = 0;
            $GLOBALS['_APP']['cache_writes'] = 0;
            $class = $app['cache']['type'] . '_cache';
            $file = REGINX_PATH . '/extra/cache/' . $app['cache']['type'] . '.cache.php';
            !is_file($file) && core::error(core::L('no-driver', $app['cache']['type']));
            include ($file);
            self::$obj = new $class($app['cache'][$app['cache']['type']]);
        }
        return self::$obj;
    }

    /**
     * 缓存数据统计
     * 0 CW OTHERS CR
     *
     * @param unknown_type $type
     */
    public static function count($type = 0){
        $type ? $GLOBALS['_APP']['cache_reads']++ : $GLOBALS['_APP']['cache_writes']++;
    }

    /**
     * 获取缓存
     *
     * @param String $key
     */
    abstract function get($key);

    /**
     * 设置缓存
     *
     * @param String $key
     * @param Mixed $value
     * @param Integer $ttl
     */
    abstract function set($key, $value, $ttl = 0);

    /**
     * 清除缓存
     */
    abstract function clear($key = NUll);

    /**
     * 删除指定缓存
     *
     * @param String $key
     */
    abstract function delete($key);
}
?>