<?php
/**
 * APC 缓存驱动类
 * @copyright reginx.com
 * $Id$
 */
class apc_cache{
    
    /**
     * 配置信息
     *
     * @var unknown_type
     */
    private $_pre = 'pre_';
    
    /**
     * 架构函数
     *
     * @param unknown_type $conf
     */
    public function __construct($conf = array()){
        $this->_pre = isset($conf['pre']) ? $conf['pre'] : 'pre_';
        if(!function_exists('apc_fetch')){
            core::error(core::L('no-support', 'APC'));
        }
    }
    
    /**
     * 获取值
     *
     * @param unknown_type $key
     * @return unknown
     */
    public function get($key){
        cache_extra::count(1);
        return apc_fetch(strtolower($this->_pre . $key));
    }
    
    /**
     * 写入缓存
     *
     * @param String $key
     * @param Mixed $val
     * @param Integer $ttl
     * @return Mixed
     */
    function set($key, $val, $ttl = null){
        cache_extra::count(0);
        return apc_store(strtolower($this->_pre . $key) , $val , $ttl ? $ttl : 86400);
    }

    /**
     * 清除缓存数据
     *
     * @param unknown_type $key
     */
    public function clear($key = null){
        if($key === null){
            return apc_clear_cache('user');
        }else{
            return $this->delete($key);
        }
    }
    
    
    /**
     * clear 别名方法
     *
     * @param unknown_type $key
     * @param unknown_type $pre
     * @return unknown
     */
    public function delete($key){
        return apc_delete(strtolower($this->_pre . $key));
    }
    
    
    /**
     * 运行状态统计
     */
    public function stat(){
        $ret  = array();
        $ret[] = array('无可用内容' , '');
        return $ret;
    }
    
}// End Class
?>