<?php
/**
 * mem cache
 * @copyright reginx.com
 * $Id: mem.cache.php 108 2013-02-21 15:47:52Z reginx $
 */
class mem_cache{

    /**
     * 当前连接的 Server ID
     *
     * @var unknown_type
     */
    private $_serverid = null;

    /**
     * 配置信息
     *
     * @var unknown_type
     */
    private $_conf = array();

    /**
     * 当前配置信息
     *
     * @var unknown_type
     */
    // private $_serv = array();
    
    private $_pre = 'pre_';

    /**
     * 当前Memcache 对象
     *
     * @var unknown_type
     */
    private $_mobj = null;

    /**
     * 架构函数
     *
     * @param unknown_type $opts
     */
    public function __construct($opts){
        $this->_conf = &$opts;
        $this->_serverid = mt_rand(0, count($this->_conf) - 1);
        $this->_serv = $this->_conf[$this->_serverid];
        $this->_pre  = isset($this->_conf[$this->_serverid]['pre']) ? $this->_conf[$this->_serverid]['pre'] : $this->_pre;
        if(!class_exists('Memcache', false)){
            core::error(core::L('no-support', 'Memcache'));
        }
        $this->_mobj = new Memcache();
        if(count($this->_conf) == 1){
            // 单台
            if(!$this->_mobj->connect($this->_serv['host'], $this->_serv['port'])){
                core::error(core::L('conn-fail', 'Memcache Server'));
            }
        }else{
            // 集群
            foreach($this->_conf as $v){
                $p = (!isset($v['p']) || $v['p']) ? true : false;
                $w = intval(isset($v['w']) ? $v['w'] : (100 / count($this->_conf)));
                $this->_mobj->addServer($v["host"], $v["port"], $p, $w);
            }
        }
    }

    /**
     * 存入值
     *
     * @param unknown_type $key
     * @param unknown_type $val
     * @param unknown_type $ttl
     * @param unknown_type $pre
     */
    public function set($key, $val, $ttl = 0, $pre = false){
        cache_extra::count(0);
        // 默认不使用 zlib压缩
        $this->_mobj->set(strtolower($this->_pre.$key), $val, 0, intval($ttl));
    }

    /**
     * 获取值
     *
     * @param unknown_type $key
     * @return unknown
     */
    public function get($key){
        cache_extra::count(1);
        return $this->_mobj->get(strtolower($this->_pre.$key));
    }

    /**
     * 清除缓存数据
     *
     * @param unknown_type $key
     */
    public function clear($key = null){
        if($key === null){
            $this->_mobj->flush();
        }else{
            $this->_mobj->delete(strtolower($this->_pre.$key));
        }
    }

    /**
     * clear 别名方法
     *
     * @param unknown_type $key
     * @param unknown_type $pre
     * @return unknown
     */
    public function delete($key, $pre = null){
        return $this->clear(strtolower($this->_pre.$key));
    }

    /**
     * 运行状态统计
     */
    public function stat(){
        $ret  = array();
        $stat = $this->_mobj->getStats();
        $ret[] = array('命中率' , sprintf('%.2f' , $stat["get_hits"] / ($stat["get_misses"] + $stat["get_hits"])));
        $ret[] = array('丢失率' , sprintf('%.2f' , $stat["get_misses"] / ($stat["get_misses"] + $stat["get_hits"])));
        $ret[] = array('已读数' , sprintf('%.2f K' , $stat["bytes_read"]/ 1024 ));
        $ret[] = array('已写数' , sprintf('%.2f K' , $stat["bytes_written"]/ 1024 ));
        $ret[] = array('总内存' , sprintf('%.2f M' , $stat["limit_maxbytes"]/ 1024 / 1024 ));
        return $ret;
    }

    /**
     * 析构函数
     */
    public function __destruct(){
        if($this->_mobj){
            $this->_mobj->close();
        }
    }
}
?>