<?php
/**
 * Xcache缓存
 * @copyright reginx.com
 * $Id: x.cache.php 5 2013-01-14 13:22:55Z reginx $
 */
class x_cache{

    /**
     * 键前缀
     *
     * @var unknown_type
     */
    private $_pre = '';

    /**
     * 架构函数
     *
     * @param unknown_type $conf
     */
    public function __construct($conf){
        $this->_pre = $conf['pre'] ? $conf['pre'] : 'pre_';
        if(!function_exists('xcache_set')){
            core::error(core::L('no-support', 'Xcache'));
        }
    }

    /**
     * 设置缓存
     *
     * @param String $key
     * @param Mixed $val
     * @param Integer $ttl
     * @return Mixed
     */
    function set($key, $val, $ttl = 0){
        cache_extra::count(0);
        return xcache_set(strtolower($this->_pre . $key), $val, $ttl);
    }

    /**
     * 获取缓存内容
     *
     * @param String $key
     * @return Mixed
     */
    function get($key){
        cache_extra::count(1);
        return xcache_get(strtolower($this->_pre . $key));
    }

    /**
     * 删除单个缓存
     *
     * @param unknown_type $key
     */
    function delete($key = null){
        if(!empty($key)){
            return xcache_unset(strtolower($this->_pre . $key));
        }else{
            return $this->clear(null);
        }
    }

    /**
     * 清除所有缓存
     */
    function clear($key = null){
        return xcache_clear_cache(XC_TYPE_VAR, 0);
    }
    
    /**
     * 运行状态统计
     */
    public function stat(){
        $ret  = array();
        $ret[] = array('无可用内容' , '');
        return $ret;
    }
}
?>