<?php
/**
 * 数据库驱动接口类
 * @copyright reginx.com
 * $Id: db.extra.php 5 2013-01-14 13:22:55Z reginx $
 */
class db_extra{

    /**
     * 构造函数
     *
     * @param unknown_type $conf
     * @return db_extra
     */
    private static function get($conf, $extra = array()){
        $file = REGINX_PATH . 'extra/db/' . $conf['class'] . '.db.php';
        !is_file($file) && core::error(core::L('no-driver', $conf['class']));
        include ($file);
        $class = $conf['class'] . '_db';
        $serverid = count($conf[$conf['class']]) > 1 ? rand(0, count($conf[$conf['class']])) : 0;
        return new $class($conf[$conf['class']], $serverid, $extra);
    }

    /**
     * 获取数据库操作对象
     *
     * @param unknown_type $conf
     * @return unknown
     */
    public static function getobj($conf = array()){
        static $dbobj = null;
        if(empty($dbobj)){
            $dbobj = self::get($conf);
        }
        return $dbobj;
    }
}
?>