<?php
/**
 * mysql驱动类
 * @copyright reginx.com
 * $Id: mysql.db.php 112 2013-02-22 05:53:41Z reginx $
 */
class mysql_db{

    /**
     * 当前连接
     *
     * @var unknown_type
     */
    private $_link = '';

    /**
     * 配置信息
     *
     * @var unknown_type
     */
    public $_conf = array();

    /**
     * 查询计数
     *
     * @var unknown_type
     */
    private $_count = 0;

    /**
     * 架构函数
     *
     * @param unknown_type $conf
     */
    function __construct($conf, $serverid, $extra = array()){
        $this->_conf = $conf[$serverid];
        $this->_conf['serverid'] = $serverid;
        !$this->connect(isset($extra['p']) ? $extra['p'] : 0) && core::error(core::L('conn-fail', 'Mysql Server'));
        !$this->selectdb() && core::error(core::L('db-not-exists', $this->_conf['name']));
        $this->query("set names `{$this->_conf['charset']}`");
        $GLOBALS['_APP']['db_queries']  = &$this->_count;
    }

    /**
     * 选择目标数据库
     *
     * @return unknown
     */
    public function selectdb(){
        return mysql_select_db($this->_conf['name'], $this->_link);
    }

    /**
     * 获取当前 server id
     *
     * @return unknown
     */
    public function serverid(){
        return $this->_conf['serverid'];
    }

    /**
     * 连接数据库
     */
    private function connect($p = false){
        if($p){
            $this->_link = mysql_pconnect($this->_conf['host'], $this->_conf['user'], $this->_conf['passwd']);
        }else{
            $this->_link = mysql_connect($this->_conf['host'], $this->_conf['user'], $this->_conf['passwd']);
        }
        return $this->_link ? true : false;
    }

    /**
     * 获取表中字段信息
     *
     * @param unknown_type $table
     */
    public function getfields($table){
        $ret = array();
        $query = $this->query('SHOW FULL FIELDS FROM ' . $table);
        while($row = mysql_fetch_array($query, MYSQL_ASSOC)){
            // 主键
            if($row['Key'] === 'PRI' || $row['Extra'] === 'auto_increment'){
                $ret['pk'] = $row['Field'];
            }
            $ret['list'][strtolower($row['Field'])] = empty($row['Comment']) ? strtolower($row['Field']) : trim($row['Comment']);
        }
        return $ret;
    }

    /**
     * 获取上步 insert 操作产生的ID
     *
     * @return unknown
     */
    public function insertid(){
        return mysql_insert_id($this->_link);
    }

    /**
     * 检查连接是否正常
     *
     * @return boolean
     */
    public function ping(){
        return mysql_ping($this->_link);
    }

    /**
     * 返回当前错误信息
     *
     * @return unknown
     */
    public function error(){
        return mysql_errno($this->_link) . ' : ' . mysql_error($this->_link);
    }

    /**
     * 返回当前系统状态
     *
     * @return unknown
     */
    public function stat(){
        return mysql_stat($this->_link);
    }

    /**
     * 查询
     *
     * @param unknown_type $sql
     * @param unknown_type $link
     * @return unknown
     */
    public function query($sql, $link = null){
        $this->_count++;
        $ret = mysql_query($sql, $link ? $link : $this->_link);
        if(!$ret){
            core::error(core::L('db-sql-err', $this->error()), 'mysql::query', 1, $sql);
        }
        return $ret;
    }

    /**
     * query 别名函数
     *
     * @param unknown_type $sql
     * @param unknown_type $link
     * @return unknown
     */
    public function exec($sql, $link = null){
        return $this->query($sql, $link);
    }

    /**
     * 获取计数
     *
     * @return unknown
     */
    public function getcount(){
        return $this->_count;
    }

    /**
     * 获取字段
     *
     * @param unknown_type $res
     * @return unknown
     */
    public function fetch_field($res){
        return mysql_fetch_field($res);
    }

    /**
     * 获取一行数据
     *
     * @param unknown_type $res
     * @param unknown_type $t
     * @return unknown
     */
    public function fetch_array($res, $t = MYSQL_ASSOC){
        return mysql_fetch_array($res, $t);
    }

    /**
     * 关闭当前连接
     *
     * @return unknown
     */
    public function close(){
        $this->_link && mysql_close($this->_link);
        $this->_link = null;
    }

    /**
     * 获取数据
     *
     * @param unknown_type $sql
     * @param unknown_type $rkey
     * @return unknown
     */
    public function getall($sql, $rkey = null){
        $ret = array();
        $query = $this->exec($sql);
        while($row = $this->fetch_array($query)){
            if($rkey && isset($row[$rkey])){
                $ret[$row[$rkey]] = $row;
            }else{
                $ret[] = $row;
            }
        }
        mysql_free_result($query);
        return $ret;
    }

    /**
     * unbuffered sql query
     *
     * @param unknown_type $sql
     * @param unknown_type $link
     * @return unknown
     */
    public function unbufquery($sql, $link = null){
        return mysql_unbuffered_query($sql, empty($link) ? $this->_link : $link);
    }

    /**
     * 统计
     *
     * @param unknown_type $sql
     * @return unknown
     */
    public function count($sql){
        $ret = mysql_fetch_array($this->query($sql), MYSQL_NUM);
        return intval($ret ? $ret[0] : 0);
    }

    /**
     * 返回上一次sql所影响的数据条数
     *
     * @param unknown_type $res
     * @return unknown
     */
    public function affected_rows($res){
        return mysql_affected_rows($res);
    }

    /**
     * 更新操作
     *
     * @param unknown_type $sql
     * @return unknown
     */
    public function update($sql){
        $ret = array(
                'code' => 1,
                'msg' => ''
        );
        if($this->exec($sql)){
            $ret['code'] = 0;
            $ret['msg'] = $this->affected_rows($this->_link);
        }else{
            $ret['msg'] = $this->error();
        }
        return $ret;
    }

    /**
     * 新增
     *
     * @param unknown_type $sql
     * @return unknown
     */
    public function add($sql){
        $ret = array(
                'code' => 1,
                'msg' => ''
        );
        if($this->exec($sql)){
            $ret['code'] = 0;
            $ret['msg'] = $this->insertid();
        }else{
            $ret['msg'] = $this->error();
        }
        return $ret;
    }

    /**
     * 获取一条记录
     *
     * @param unknown_type $sql
     * @return unknown
     */
    public function get($sql){
        return $this->fetch_array($this->exec($sql));
    }

    /**
     * 关闭链接
     */
    public function __destruct(){
        $this->close();
    }
}
?>