<?php
/**
 * session 操作类
 * @copyright reginx.com
 * $Id: sess.extra.php 5 2013-01-14 13:22:55Z reginx $
 */
class sess_extra{

    /**
     * 构造函数
     *
     * @param unknown_type $conf
     * @return db_extra
     */
    private static function get($conf, $extra = array()){
        $conf['class'] = $conf['class'] ? $conf['class'] : 'default';
        $file = REGINX_PATH . 'extra/sess/' . $conf['class'] . '.sess.php';
        !is_file($file) && core::error(core::L('no-sess-driver', $conf['class']));
        include ($file);
        $class = $conf['class'] . '_sess';
        return new $class($conf[$conf['class']], $extra);
    }

    /**
     * 获取 sess 操作对象
     *
     * @param unknown_type $conf
     * @return unknown
     */
    public static function &getobj($conf, $extra = true){
        static $sobj = null;
        if(empty($sobj)){
            $sobj = self::get($conf, $extra);
        }
        return $sobj;
    }
}
?>