<?php
/**
 * 默认会话管理类
 * @copyright reginx.com
 * $Id: default.sess.php 64 2013-02-06 16:06:52Z reginx $
 */
class default_sess {

    /**
     * 架构函数
     *
     * @param unknown_type $conf
     * @param unknown_type $extra
     */
    public function __construct($conf = array() , $extra = true){
        $rdomain = $_SERVER['HTTP_HOST'];
        if(substr_count($_SERVER['HTTP_HOST'] , '.') >= 2 ){
            $rdomain = substr($_SERVER['HTTP_HOST'] , strpos($_SERVER['HTTP_HOST'] , '.'));
        }else{
            $rdomain = '.' . $_SERVER['HTTP_HOST'];
        }
        session_start();
        // 默认开启了session 会禁用会话页面缓存
        $extra && header("Cache-control: private"); // 直接使用头信息控制缓存
        // $extra && session_cache_limiter('private'); // php 自带方法控制
        setcookie(session_name(),session_id(),time() + $conf['ttl'] ? $conf['ttl'] : 600 , '/' , $rdomain);
        //ini_set('session.gc_maxlifetime',$conf['ttl'] ? $conf['ttl'] : 600);
    }

    /**
     * 存储
     *
     * @param string $k
     * @param mixed $v
     */
    public function set($k , $v){
        $_SESSION[$k] = $v;
    }

    /**
     * 获取
     *
     * @param string $k
     * @return mixed
     */
    public function get($k){
        return isset($_SESSION[$k]) ? $_SESSION[$k] : null;
    }

    /**
     * 删除
     *
     * @param unknown_type $k
     */
    public function del($k){
        $_SESSION[$k] = null;
        unset($_SESSION[$k]);
    }

    /**
     * 注销会话
     *
     */
    public function remove(){
        session_destroy();
    }

    /**
     * 判断值是否存在
     *
     */
    public function has($k){
        return isset($_SESSION[$k]);
    }

}
?>