<?php
/**
 * reginx 入口文件
 * @copyright reginx.com
 * $Id: reginx.php 123 2013-02-25 02:50:32Z reginx $
 */
class reginx{

    /**
     * 核心变量
     *
     * @var unknown_type
     */
    private $_core = array();

    /**
     * 构造函数
     *
     * @param unknown_type $file
     */
    public function __construct($file){
        $GLOBALS['_MISC']['STIME'] = isset($_SERVER["REQUEST_TIME_FLOAT"]) ? $_SERVER["REQUEST_TIME_FLOAT"] : microtime(TRUE);
        phpversion() < 5.2 && exit("PHP版本最低要求:5.2");
        /**
         * 加载运行所需文件
         */
        $this->init();

        /**
         * 生成核心对象
         */
        $GLOBALS['_CORE'] = $this->_core =  new core($file,include(BASE_PATH.'config/default.php'));

        $mod = $GLOBALS['_MOD'].'_mod';
        $act = $GLOBALS['_ACT'].'Act';
        $GLOBALS['_CURMOD'] = new $mod($GLOBALS['_APP']);
        if(!method_exists($GLOBALS['_CURMOD'],$act) && !method_exists($GLOBALS['_CURMOD'],'__call')){
            $GLOBALS['_CURMOD']->show404('common' , core::L('not-found',$act));
        }else{
            $GLOBALS['_CURMOD']->$act();
        }

    }

    /**
     * 初始化 加载运行类库文件
     *
     */
    private function init(){
        if(!defined('IS_DEBUG')){
            define('IS_DEBUG' , false);
        }
        !IS_DEBUG && ob_start();
        error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
        define('IS_CLI' , php_sapi_name() == 'cli');
        define('REGINX_VERSION' , '1.1.0');
        define('REGINX_RELEASE' , '20131229');
        define('REGINX_URL'     , 'http://www.reginx.com/');
        define('REGINX_PATH'    , dirname(__FILE__) . '/');
        define('CACHE_PATH'     , BASE_PATH . 'data/cache/');
        if(!file_exists(CACHE_PATH . '~runtime.php') || IS_DEBUG ){
            $s  = file_get_contents(REGINX_PATH . 'class/mod.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/core.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/tab.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/tpl.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/block.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/filter.class.php');
            $s .= file_get_contents(REGINX_PATH . 'class/plugin.class.php');
            $s .= file_get_contents(REGINX_PATH . 'extra/db.extra.php');
            $s .= file_get_contents(REGINX_PATH . 'extra/sess.extra.php');
            $s .= file_get_contents(REGINX_PATH . 'extra/cache.extra.php');
            $s .= file_get_contents(REGINX_PATH . 'extra/lang.extra.php');
            !is_dir(CACHE_PATH) && mkdir(CACHE_PATH , 0755);
            file_put_contents(CACHE_PATH . '~runtime.php' , preg_replace('/\?\>\s*\<\?php\s+/is',"\r\n" , $s ) , LOCK_EX)
            or die('create file ~runtime.php fail !');
            $s = null;
            !IS_DEBUG &&
            file_put_contents(CACHE_PATH . '~runtime.php' , php_strip_whitespace(CACHE_PATH . '~runtime.php') , LOCK_EX);
        }

        include(CACHE_PATH . '~runtime.php');
        
        /**
         * autoload
         */
        if(function_exists('spl_autoload_register')){
            spl_autoload_register(array('core' , 'loader'));
        }else{
            function __autoload($class){
                return core::loader($class);
            }
        }

        /**
         * class Alias
         */
        if(!function_exists('class_alias')) {
            function class_alias($original, $alias) {
                eval('abstract class ' . $alias . ' extends ' . $original . ' {}');
            }
        }
    }
}
?>