<?php
/**
 * 命令行应用生成工具
 * @copyright reginx.com
 * $Id: app.php 43 2013-02-05 06:34:45Z reginx $
 */
class app {

    // base path
    private $base = '';

    // app path
    private $app  = '';

    // app name
    private $name = '';

    // contruct
    public function app($appname){
        $this->name = $appname;
        $this->base = realpath('../../');
        if($appname == 'default'){
            $this->app  = $this->base;
        }else{
            $this->app  = $this->base . '/' . $this->name;
        }
        !is_dir($this->app) && $this->mkdir($this->app , 0755);
        $this->initbase();
        $this->initapp();
        $this->initconf();
        $this->sayhi();
    }

    // init base dir
    public function initbase(){
        !is_dir($this->base . '/config')      && $this->mkdir($this->base . '/config'      , 0755);
        !is_dir($this->base . '/include')     && $this->mkdir($this->base . '/include'     , 0755);
        !is_dir($this->base . '/include/tab') && $this->mkdir($this->base . '/include/tab' , 0755);
        !is_dir($this->base . '/include/lib') && $this->mkdir($this->base . '/include/lib' , 0755);
        !is_dir($this->base . '/data')        && $this->mkdir($this->base . '/data'        , 0755);
        !is_dir($this->base . '/data/cache')  && $this->mkdir($this->base . '/data/cache'  , 0755);
        !is_dir($this->base . '/data/images') && $this->mkdir($this->base . '/data/images' , 0755);
        !is_dir($this->base . '/data/log')    && $this->mkdir($this->base . '/data/log'    , 0755);
        !is_dir($this->base . '/data/temp')   && $this->mkdir($this->base . '/data/temp'   , 0755);
        !is_dir($this->base . '/data/attachment') && $this->mkdir($this->base . '/data/attachment'   , 0755);
    }

    // hi act
    public function sayhi(){
        $code = '<?php ' . PHP_EOL . '/**' .PHP_EOL . ' * 演示MOD ' . PHP_EOL . ' * @copyright reginx.com ' . PHP_EOL;
        $code.= ' * $Id: app.php 43 2013-02-05 06:34:45Z reginx $ ' .PHP_EOL . ' */ ' . PHP_EOL . 'class index_mod extends mod { ' . PHP_EOL . '    /** ' . PHP_EOL;
        $code.= '     * 默认Act ' . PHP_EOL . '     * ' . PHP_EOL . '     */' .PHP_EOL . '    function indexAct(){ ' .PHP_EOL;
        $code.= '        echo(\':-) <br/> hi !   \');' . PHP_EOL .  '    }' . PHP_EOL . '}' . PHP_EOL . '?>';
        file_put_contents($this->app . '/include/mod/index.mod.php' , $code );
    }

    // init default config
    public function initconf(){
        copy(realpath( dirname(__FILE__). '/config.default.php') , $this->app . '/config/default.php');
    }

    public function mkdir($dir , $mode = '0755'){
        mkdir($dir , $mode);
        file_put_contents($dir . '/index.html' , ' ');
    }
    // init app dir
    function initapp(){
        !is_dir($this->app . '/config')      && $this->mkdir($this->app . '/config'      , 0755);
        !is_dir($this->app . '/include')     && $this->mkdir($this->app . '/include'     , 0755);
        !is_dir($this->app . '/include/mod') && mkdir($this->app . '/include/mod' , 0755);
        // template
        !is_dir($this->app . '/template')                 && $this->mkdir($this->app . '/template'    , 0755);
        !is_dir($this->app . '/template/default')         && $this->mkdir($this->app . '/template/default' , 0755);
        !is_dir($this->app . '/template/default/js')      && $this->mkdir($this->app . '/template/default/js' , 0755);
        !is_dir($this->app . '/template/default/css')     && $this->mkdir($this->app . '/template/default/css' , 0755);
        !is_dir($this->app . '/template/default/images')  && $this->mkdir($this->app . '/template/default/images' , 0755);
        $code = '<?php' . PHP_EOL . 'define(\'IN_REGINX\' , true);' . PHP_EOL;
        $code.= 'define(\'DIR_SEP\'   , DIRECTORY_SEPARATOR);' . PHP_EOL;
        $code.= 'define(\'BASE_PATH\' , realpath(\''  .($this->name == 'default' ? '.' : '..' ).'/\') . DIR_SEP);' . PHP_EOL;
        $code.= 'define(\'APP_PATH\'  , BASE_PATH . ' .(($this->name == 'default' || $this->name == '') ? '\'\''  : ('\'' . ($this->name ? $this->name : '') . '\'' .' . DIR_SEP')) .' );'. PHP_EOL;
        $code.= 'include(\''  .($this->name == 'default' ? '.' : '..' ).'/reginx/reginx.php\');' . PHP_EOL;
        $code.= 'new reginx(__file__);' . PHP_EOL . '?>';
        file_put_contents($this->app . '/index.php' , $code );
        echo(' it\'s ok ! ' .PHP_EOL. ' see url : http://your.site.url/' . ($this->name == 'default' ? '' : $this->name) . "\n");
    }
}

// run in cli
if(php_sapi_name() != 'cli'){
    die('Only run from command line' . "\n");
}
// shift argv file name
array_shift($argv);
$str = join(' ' , $argv);

preg_match('/(\w+)\=(\w+)/i' , $str , $m);

if(count($m[0]) < 1 || empty($m[0])){
    die('eg : php tool.php app=demo' . "\n");
}
$appname  = trim($m[2]);
// validate
if(!preg_match('/^\w+$/i' , $appname)){
    die('appname error' . "\n");
}
// create
new app(strtolower($appname));
?>