<?php
class AlbumAction extends CommonAction{
	public function _initialize(){
		if(C('IS_FACE')) $this->isface();
		$this->setSite(setweb());
	}
	
	public function _before_index(){
		$this->fill('album');
		$this->song_top();
	}
	
	public function index(){
		$allowtype=array(
				'like','collect','comment'
		);
		$M=M();
		$prefix=C('DB_PREFIX');
		$count=$M->table("{$prefix}album")->count();
		import('ORG.Util.Page');
		$Page= new Page($count,15);
		$show= $Page->show();
		if(in_array(trim($_GET['sort']),$allowtype)){
			$list = $M->table("{$prefix}album")->order("{$_GET['sort']}_count desc")->limit($Page->firstRow.','.$Page->listRows)->field('xalbumid',true)->select();
		}else{
			$list = $M->table("{$prefix}album")->order("id desc")->limit($Page->firstRow.','.$Page->listRows)->field('xalbumid',true)->select();
		}
		if(is_array($list)){
			foreach ($list as $k=>$v){
				$list[$k]['singer']=$M->table("{$prefix}singer")->where("id={$v['singerid']}")->field('xsingid',true)->cache(true)->find();
			}
		}
		//最近收藏专辑
		$collect=$M->table("{$prefix}albumcollect")->where("albumid>0")->order("addtime desc")->field("albumid,uid")->limit('8')->select();
		foreach($collect as $k=> $v){
			$collect[$k]['album']=$M->table("{$prefix}album")->where("id={$v['albumid']}")->field("albumname,singerid,cover")->cache(true)->find();
			$collect[$k]['album']['singername']=$M->table("{$prefix}singer")->where("id={$collect[$k]['album']['singerid']}")->cache(true)->getField("singername");
			$collect[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field("username")->cache(true)->find();
		}
		$this->assign('collect',$collect);
		//最近专辑评论
		$comment=$M->table("{$prefix}albumcomment")->order("addtime desc")->field("uid,content,albumid")->where("albumid>0")->limit('8')->select();
		foreach ($comment as $k=>$v){
			$comment[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field("username,face")->cache(true)->find();
			$comment[$k]['user']['face']=avatar($comment[$k]['user']['face']);
			$comment[$k]['album']=$M->table("{$prefix}album")->where("id={$v['albumid']}")->field("singerid,albumname")->cache(true)->find();
			$comment[$k]['singername']=$M->table("{$prefix}singer")->where("id={$comment[$k]['album']['singerid']}")->cache(true)->getField("singername");
		}
		$this->assign('comment',$comment);
		$this->setTitle('歌手专辑');
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	public function _before_albums(){
		$this->_before_index();
	}
	
	public function albums($sid){
		$sid=$_GET['sid']>0 ? intval($_GET['sid']) : $this->redirect('Index/index');
		$M=M();
		$prefix=C('DB_PREFIX');
		$count=$M->table("{$prefix}album")->where("singerid={$sid}")->count();
		if($count>1){
			$singer=$M->table("{$prefix}singer")->where("id={$sid}")->getField('singername');
			import('ORG.Util.Page');
			$Page= new Page($count,15);
			$show= $Page->show();
			$list =$M->table("{$prefix}album")->where("singerid={$sid}")->order('like_count desc')->field('xalbumid',true)->limit($Page->firstRow.','.$Page->listRows)->select();
			//最近收藏专辑
			$collect=$M->table("{$prefix}albumcollect")->where("albumid>0")->order("addtime desc")->field("albumid,uid")->limit('8')->select();
			foreach($collect as $k=> $v){
				$collect[$k]['album']=$M->table("{$prefix}album")->where("id={$v['albumid']}")->field("albumname,singerid,cover")->cache(true)->find();
				$collect[$k]['album']['singername']=$M->table("{$prefix}singer")->where("id={$collect[$k]['album']['singerid']}")->cache(true)->getField("singername");
				$collect[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field("username")->cache(true)->find();
			}
			$this->assign('collect',$collect);
			//最近专辑评论
			$comment=$M->table("{$prefix}albumcomment")->order("addtime desc")->field("uid,content,albumid")->limit('8')->select();
			foreach ($comment as $k=>$v){
				$comment[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field("username,face")->cache(true)->find();
				$comment[$k]['user']['face']=avatar($comment[$k]['user']['face']);
				$comment[$k]['album']=$M->table("{$prefix}album")->where("id={$v['albumid']}")->field("singerid,albumname")->cache(true)->find();
				$comment[$k]['singername']=$M->table("{$prefix}singer")->where("id={$comment[$k]['album']['singerid']}")->cache(true)->getField("singername");
			}
			$this->assign('comment',$comment);
			$this->setTitle($singer.'的专辑');
			$this->assign('list',$list);
			$this->assign('page',$show);
			$this->display();
		}elseif($count==1){
			$aid=$M->table("{$prefix}album")->where("singerid={$sid}")->getField('id');
			$this->redirect("album/view?aid={$aid}");
		}else{
			$this->error('暂未找到该歌手的专辑');
		}
	}
	
	
	public function view($aid){
		$aid=$_GET['aid']>0 ? intval($_GET['aid']) : $this->redirect('Album/index');
		$M=M();
		$prefix=C('DB_PREFIX');
		$album=$M->table("{$prefix}album")->find($aid);
		if($album){
			$user=$M->table("{$prefix}albumlike")->where("albumid={$aid}")->field('uid')->select();
			foreach ($user as $k=>$v){
				$user[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field('username,face')->cache(true)->find();
				$user[$k]['user']['face']=avatar($user[$k]['user']['face']);
			}
			$album['singer']=$M->table("{$prefix}singer")->where("id={$album['singerid']}")->find();
			$songlist=$M->table("{$prefix}song")->where("albumid={$aid}")->order("like_count desc")->select();
			foreach($songlist as $k=> $v){
				$songlist[$k]['flashcode']=makecode($album['singer']['xsingid'], $v['xsongid']);
			}
			import('ORG.Util.Page');
			$count=$M->table("{$prefix}albumcomment")->where("albumid={$aid}")->count();
			$Page= new Page($count,20);
			$show= $Page->show();
			$commentlist = $M->table("{$prefix}albumcomment")->where("albumid={$aid}")->order("addtime desc")->limit($Page->firstRow.','.$Page->listRows)->select();
			if(is_array($commentlist)){
				foreach($commentlist as $k=> $v){
					$commentlist[$k]['com_user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field('id,username,face')->cache(true)->find();
					$commentlist[$k]['com_user']['face']=avatar($commentlist[$k]['com_user']['face']);
				}
			}
			$hot=$M->table("{$prefix}song")->where("xsongid>0")->order("like_count desc")->field("songname,id,xsongid,singerid")->limit('10')->select();
			foreach($hot as $k=>$v){
				$hot[$k]['singer']=$M->table("{$prefix}singer")->where("id={$v['singerid']}")->field("id,singername")->cache(true)->find();
				$hot[$k]['flashcode']=makecode($hot[$k]['singer']['id'], $v['xsongid']);
			}
			$this->hotalbum=$M->table("{$prefix}album")->where()->order("like_count desc")->field("albumname,id,singerid,cover")->limit('10')->select();
		}else{
			$this->error('该专辑不存在');
		}
		$this->setTitle("{$album['albumname']}-{$album['singer']['singername']}专辑");
		$this->assign('likeuser',$user);
		$this->assign('album',$album);
		$this->assign('hot',$hot);
		$this->assign('songlist',$songlist);
		$this->assign('list',$commentlist);
		$this->display();
	}
	
	public function collect(){
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['albumid']=intval($_POST['albumid']);
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}albumcollect")->where($where)->count();
		if($bool>0){	
			$this->ajaxReturn('','报告，您已收藏啦！^_^',101);
		}else{
			$data['albumid']=intval($_POST['albumid']);
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}albumcollect")->add($data);
			$M->table("{$prefix}album")->where("id={$_POST['albumid']}")->setInc('collect_count',1);
			$this->ajaxReturn('','报告，收藏完毕！^_^',101);
		}
	}
	
	public function like(){
		$albumid=intval($_POST['albumid']);
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['albumid']=$albumid;
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}albumlike")->where($where)->field("id")->count();
		if($bool>0){	
			$this->ajaxReturn('','报告，您已喜欢啦！^_^',101);
		}else{
			$data['albumid']=$albumid;
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}albumlike")->add($data);
			//更新song表中的喜欢
			$M->table("{$prefix}album")->where("id={$albumid}")->setInc('like_count',1);
			$this->ajaxReturn('','',100);
		}
	}
	
	
	public function comment(){
		$data['ualbumid']=I('post.ualbumid','','intval');
		$data['albumid']=I('post.albumid','','intval');
		$data['uid']=$_SESSION['uid'];
		$data['content']=I('post.content','','strip_tags');
		$data['addtime']=time();
		if($data['ualbumid']>0) unset($data['albumid']);
		if($data['albumid']>0) unset($data['ualbumid']);
		if($this->isAjax()){
			if(empty($data['uid']) || empty($data['content'])) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
		}else{
			if(empty($data['uid']) || empty($data['content'])) $this->error('所填项不能为空');
		}
		$M=M();
		$prefix=C('DB_PREFIX');
		if($M->table("{$prefix}albumcomment")->add($data)){
			if($data['albumid']>0){
				$M->table("{$prefix}album")->where("id={$data['albumid']}")->setField('comment_count',1);
				if($this->isAjax()){
					$this->ajaxReturn('','',100);
				}else{
					$this->redirect("album/view?aid={$data['albumid']}");
				}
			}
			if($data['ualbumid']>0){
				$M->table("{$prefix}ualbum")->where("id={$data['ualbumid']}")->setField('comment_count',1);
				if($this->isAjax()){
					$this->ajaxReturn('','',100);
				}else{
					$this->redirect("ualbum/view?aid={$data['ualbumid']}");
				}
			}
		}else{
			if($this->isAjax()) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
			else $this->error('评论失败');
		}
	}
	
	public function _empty(){
		$this->wrong();
	}
}