﻿<?php
class SongAction extends CommonAction{
	public function _initialize(){
		if(C('IS_FACE')) $this->isface();
		$this->setSite(setweb());
	}
	/*
	 * 一首歌展示页
	 */
	public function view($sid){
		$sid=$_GET['sid']>0 ? intval($_GET['sid']) : $this->redirect('Song/index');
		$M=M();
		$prefix=C('DB_PREFIX');
		$song=$M->table("{$prefix}song")->where("id={$sid}")->field("id,songname,area,musicurl,pic,singerid,xsongid,albumid,like_count,uid,addtime")->find();
		if(!$song) $this->redirect('Song/index');
		if($song['albumid']>0){
			$song['album']=$M->table("{$prefix}album")->where("id={$song['albumid']}")->field('id,albumname,cover')->find();
		}elseif($song['albumid']==0 && $song['pic']!=''){
			$song['album']['cover']=$song['pic'];
		}else{
			$song['album']['cover']='images/default/'.rand(1,12).'.jpg';
		}
		if($song['singerid']>0){
			$song['singer']=$M->table("{$prefix}singer")->where("id={$song['singerid']}")->field("id,singername,xsingid")->find();
			$other=$M->table("{$prefix}song")->where("singerid={$song['singerid']} AND id<>{$sid}")->order("like_count desc")->field("id,songname")->limit('10')->select();
			$other[0]['count']=count($other);
		}
		$song['flashcode']= $song['xsongid']>0 ? makecode($song['singer']['xsingid'], $song['xsongid']) : embed($song['musicurl'],$song['songname'],$song['singer']['singername']);
		$song['lrc']=$M->table("{$prefix}lrc")->where("songid={$sid}")->cache(true)->find();
		$song['comment']=$M->table("{$prefix}songcomment")->where("songid={$sid} AND uid={$song['uid']}")->order("addtime asc")->field("id,content")->find();
		$User=D('User');
		$song['user']=$User->cache(true)->GetUserByid($song['uid']);
		$song['user']['face']=avatar($song['user']['face']);
		$this->tag=$M->table("{$prefix}songtag")->where("songid={$sid}")->field('tag')->select();
		//根据当前歌曲的语言选择歌曲
		$where['area']=array('like',$song['area']);
		$where['id']=array('neq',$sid);
		$hot=$M->table("{$prefix}song")->where($where)->order("like_count desc")->field('id,songname,singerid,xsongid,musicurl')->limit('10')->select();
		foreach($hot as $k=>$v){
			if($v['singerid']>0) $hot[$k]['singer']=$M->table("{$prefix}singer")->where("id={$v['singerid']}")->field("id,singername,xsingid")->cache(true)->find();
			$hot[$k]['flashcode']=$v['xsongid']>0 ? makecode($hot[$k]['singer']['xsingid'],$v['xsongid']) : embed($v['musicurl'],$v['songname'],$hot[$k]['singer']['singername']);
		}
		$this->albums=$M->table("{$prefix}album")->order("like_count desc")->limit('10')->field("id,cover,albumname")->select();
		
		import('ORG.Util.Page');
		$count = $M->table("{$prefix}songcomment")->where("songid={$sid} AND id<>{$song['comment']['id']}")->count();
		$Page= new Page($count,10);
		$show= $Page->show();
		$list = $M->table("{$prefix}songcomment")->where("songid={$sid} AND id<>{$song['comment']['id']}")->order('addtime desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		if(is_array($list)){
			foreach($list as $k=>$v){
				$list[$k]['com_user']=$User->cache(true)->GetUserByid($v['uid']);
				$list[$k]['com_user']['face']=avatar($list[$k]['com_user']['face']);
			}
		}
		$user=$M->table("{$prefix}songlike")->where("songid={$sid}")->field("uid")->select();
		foreach($user as $k=> $v){
			$user[$k]['user']=$User->cache(true)->GetUserByid($v['uid']);
			$user[$k]['user']['face']=avatar($user[$k]['user']['face']);
		}
		$this->title= $song['singer']['singername']!='' ? ($song['songname'].'-'.$song['singer']['singername']) : $song['songname'];
		$this->assign('likeuser',$user);
		$this->assign('hot',$hot);
		$this->assign('other',$other);
		$this->assign('song',$song);
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	
	/*
	 * 歌曲列表页
	 */
	public function index(){
		$allowtype=array(
			'like','collect','comment'
		);
		$M=M();
		$prefix=C('DB_PREFIX');
		if(isset($_GET['tag']) && $_GET['tag']!=''){
			$tag=iconv('gbk','utf-8',$_GET['tag']);//URL传参乱码
			$where["{$prefix}songtag.tag"]=array("like","%{$tag}%");
			//$where["{$prefix}song.xsongid"]=array('gt',0);
			$count=$M->table("{$prefix}songtag")->where($where)->DISTINCT("songid")->count();
		}else{
			$count=$M->table("{$prefix}song")->where('xsongid>0')->count();
		}
		import('ORG.Util.Page');
		$Page= new Page($count,15);
		$show= $Page->show();
		if(isset($_GET['sort']) && in_array(trim($_GET['sort']),$allowtype)){
			$list = $M->table("{$prefix}song")->order("{$_GET['sort']}_count desc")->where('xsongid>0')->limit($Page->firstRow.','.$Page->listRows)->field("id,songname,uid,albumid,pic,like_count,comment_count,singerid")->select();
		}elseif (isset($tag)){
			$list=$M->table("{$prefix}song")->join("{$prefix}songtag on {$prefix}song.id={$prefix}songtag.songid")->where($where)->limit($Page->firstRow.','.$Page->listRows)->field("id,songname,uid,albumid,pic,like_count,comment_count,singerid")->select();
		}else{
			$list = $M->table("{$prefix}song")->order("addtime desc")->where('xsongid>0')->limit($Page->firstRow.','.$Page->listRows)->field("id,songname,uid,albumid,pic,like_count,comment_count,singerid")->select();
		}
		if(is_array($list)){
			foreach ($list as $k=>$v){
				if($v['singerid']>0) $list[$k]['singer']=$M->table("{$prefix}singer")->where("id={$v['singerid']}")->cache(true)->getField("singername");
				$list[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->cache(true)->getfield('username');
				if($v['albumid']>0){
					$list[$k]['album']=$M->table("{$prefix}album")->where("id={$v['albumid']}")->field('albumname,cover')->cache(true)->find();
				}elseif($v['albumid']==0 && $v['pic']!=''){
					$list[$k]['album']['cover']=$v['pic'];
				}else{
					$list[$k]['album']['cover']='/images/default/'.rand(1,12).'.jpg';
				}
			}
		}
		$array=array(
				'collect'=>array(
					'addtime','8'	
				),
				'comment'=>array(
					'addtime','8'	
				)
		);
		$this->getmusic($array);
		$this->setTitle('单曲');
		$this->fill('song');
		$this->song_top();
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	
	/*
	 * 歌曲评论
	 */
	public function comment(){
		$data['songid']=I('post.songid','','intval');
		$data['uid']=$_SESSION['uid'];
		//$data['referid']=I('post.referid','','intval');
		$data['content']=I('post.content','','strip_tags');
		$data['addtime']=time();
		if($this->isAjax()){
			if(empty($data['songid']) ||empty($data['uid']) || empty($data['content'])) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
		}else{
			if(empty($data['songid']) ||empty($data['uid']) || empty($data['content'])) $this->error('所填项不能为空');
		}
		$M=M();
		$prefix=C('DB_PREFIX');
		if($M->table("{$prefix}songcomment")->add($data)){
			$M->table("{$prefix}song")->where("id={$data['songid']}")->setField('comment_count',1);
			if($this->isAjax()) $this->ajaxReturn('','',100);
			else $this->redirect("song/view?sid={$data['songid']}");
		}else{
			if($this->isAjax()) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
			else $this->error('评论失败');
		}
	}
	
	
	/*
	 * 单曲收藏
	 */
	public function collect(){
		$songid=intval($_POST['songid']);
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['songid']=$songid;
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}songcollect")->where($where)->count();
		if($bool>0){
			$this->ajaxReturn('','报告，您已收藏啦！^_^',101);
		}else{
			$data['songid']=$songid;
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}songcollect")->add($data);
			$M->table("{$prefix}song")->where("id={$songid}")->setInc('like_count',1);
			$this->ajaxReturn('','报告，收藏完毕！^_^',101);
		}
	}
	
	public function like(){
		$songid=intval($_POST['songid']);
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['songid']=$songid;
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}songlike")->where($where)->field("id")->count();
		if($bool>0){
			$this->ajaxReturn('','报告，您已喜欢啦！^_^',101);
		}else{
			$data['songid']=$songid;
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}songlike")->add($data);
			//更新song表中的喜欢
			$M->table("{$prefix}song")->where("id={$songid}")->setInc('like_count',1);
			$this->ajaxReturn('','',100);
		}
	}
	
	public function _empty(){
		$this->wrong();
	}
}