<?php
/*
 * 后台操作系统类
 */
class SystemAction extends BaseAction{
	public function _initialize(){
		parent::_initialize();
		$this->setsoft();
	}
	public function index(){
		$this->title='管理中心';
		$this->display();
	}
	
	public function main(){
		$os = explode(" ", php_uname());
		if(!function_exists("gd_info")){$gd = '不支持,无法处理图像';}
		if(function_exists(gd_info)) {  $gd = @gd_info();  $gd = $gd["GD Version"];  $gd ? '&nbsp; 版本：'.$gd : '';}
	
		$system= array(
				'server'	=> $_SERVER['SERVER_SOFTWARE'],
				'phpos'	=> PHP_OS,
				'phpversion'	=> PHP_VERSION,
				'os' =>$os[0] .''.$os[1].' '.$os[3],
				'gd'=>$gd,
				'upload' =>'表单允许'.ini_get('post_max_size').',上传总大小'.ini_get('upload_max_filesize')
		);
		$this->assign('title','系统首页');
		$this->assign('system',$system);
		$this->display();
	}
	
	public function manger(){
		$site=$this->info();
		$this->assign('site',$site);
		$this->assign('title','系统管理');
		$this->display();
	}
	
	public function sql(){
		$M=M();
		$arrtables = $M->query("SHOW TABLES");
		foreach($arrtables as $key=>$item){
			$Table[] = $item['Tables_in_'.C('DB_NAME')];
		}
		$this->assign('title','数据库管理');
		$this->assign('table',$Table);
		$this->display();
	}
	
	public function optimize($table){
		$tabel=$_GET['table'];
		$M=M();
		$M->query("OPTIMIZE TABLE `".$table."` ");
		$this->success('优化数据表'.$table.'成功！');
	}
	
	public function change(){
		if(isset($_POST['DATA_CACHE_TIME'])) $_POST['DATA_CACHE_TIME']=(trim($_POST['DATA_CACHE_TIME']))*3600;
		$Sys=M('System');
		foreach($_POST as $k=>$v){
			$where['optionname']=$k;
			$Sys->where($where)->setField("optionvalue",trim($v));
		}
		$this->makeconf();
		$this->success('数据更新成功');
	}
	
	
	public function baidu(){
		$site=$this->info();
		$this->assign('site',$site);
		$this->assign('title','百度云存储设置');
		$this->display();
	}
	
	public function email(){
		$site=$this->info();
		$this->assign('site',$site);
		$this->assign('title','邮箱设置');
		$this->display();
	}
	
	public function cache(){
		$Sys=M('System');
		$cachetime=$Sys->where("optionname='DATA_CACHE_TIME'")->getField("optionvalue");
		$cachetime=$cachetime/3600;
		$this->assign('cachetime',$cachetime);
		$this->display();
	}
	
	//删除缓存
	public function clear(){
		cleandir(C('DATA_CACHE_PATH')) ? $this->success('操作成功') : $this->error('操作失败');
	}
	
	//导航设置
	public function nav(){
		$Nav=M('Songarea');
		$navarr=$Nav->order("id asc")->select();
		$this->assign('nav',$navarr);
		$this->display();
	}
	
	//修改导航DELETE FROM `m_songarea`
	public function donav(){
		$count=count($_POST['nav']);
		if($count==0) $this->error('所填项不能为空');
		for($i=0;$i<$count;$i++){
			if(trim($_POST['sort'][$i])!='' && trim($_POST['nav'][$i])!='') {
				$data[$i]['id']=$_POST['sort'][$i];
				$data[$i]['area']=$_POST['nav'][$i];
				$data[$i]['appname']=$_POST['appname'][$i];
				$filedata[$_POST['sort'][$i]]=array(
							$_POST['nav'][$i],
							$_POST['appname'][$i]);
			}
		}
		$M=M();
		$prefix=C('DB_PREFIX');
		$M->QUERY("DELETE FROM {$prefix}songarea");
		$M->table("{$prefix}songarea")->addAll($data);
		fileWrite('nav.php', APP_PATH.'Conf/',$filedata);
		$this->success('操作成功');
	}
	
	public function delnav($id){
		$M=M('Songarea');
		if($M->where("id={$_GET['id']}")->delete()){
			$arr=$M->select();
			foreach($arr as $v){
				$data[$v['id']]=array($v['area'],$v['appname']);
			}
			fileWrite('nav.php', APP_PATH.'Conf/', $data);
			$this->success('操作成功');
		}else{
			$this->error('操作失败');
		}
	}
	
	
	private function info(){
		$M=M();
		$prefix=C('DB_PREFIX');
		$sitearr=$M->table("{$prefix}system")->field("id",true)->select();
		foreach ($sitearr as $v){
			$site[$v['optionname']]=$v['optionvalue'];
		}
		return $site;
	}
	
	public function makeconf(){
		$confpath=APP_PATH.'Conf/';
		$Sys=M('System');
		$arr=$Sys->field("optionname,optionvalue")->select();
		foreach($arr as $v){
			$data[$v['optionname']]=$v['optionvalue'];
		}
		fileWrite('config.inc.php',$confpath, $data);
	}
	
	//首页设置
	public function setindex(){
		$this->assign('site',$this->info());
		$this->display();
	}
	
	public function snssdk(){
		$M=M('snsconfig');
		$arr=$M->select();
		foreach($arr as $k=>$v){
			$sns[$v['snsname']]=array(
				'appkey'=>$v['appkey'],
				'appsecret'=>$v['appsecret'],
			);
		}
		$this->sns=$sns;
		$this->display();	
	}
	
	public function dosdk(){
		//插入数据库
		$M=M('snsconfig');
		foreach($_POST as $k=>$v){
			//数据过滤
			$v['appkey']=trim($v['APP_KEY']);
			$v['appsecret']=trim($v['APP_SECRET']);
			$where['snsname']=$k;
			$M->where($where)->save($v);
			unset($where);
		}
		define('URL',substr(C('SITE_URL'),7,strlen(C('SITE_URL'))).'/index.php?m=login&a=callback&type=');
		$data= "<?php\n"
					."	return array(\n"
					."	'THINK_SDK_QQ'=> array(\n"
					."	'APP_KEY'=> '".$_POST['THINK_SDK_QQ']['APP_KEY']."',\n"
					."	'APP_SECRET'=>'".$_POST['THINK_SDK_QQ']['APP_SECRET']."',\n"
					."	'CALLBACK'=>'".URL."qq',\n"
					."	),\n"
					."	'THINK_SDK_SINA'=> array(\n"
					."	'APP_KEY'=> '".$_POST['THINK_SDK_SINA']['APP_KEY']."',\n"
					."	'APP_SECRET'=>'".$_POST['THINK_SDK_SINA']['APP_SECRET']."',\n"
					."	'CALLBACK'=>'".URL."sina',\n"
					."	),\n"
					."	'THINK_SDK_TAOBAO'=> array(\n"
					."	'APP_KEY'=> '".$_POST['THINK_SDK_TAOBAO']['APP_KEY']."',\n"
					."	'APP_SECRET'=>'".$_POST['THINK_SDK_TAOBAO']['APP_SECRET']."',\n"
					."	'CALLBACK'=>'".URL."taobao',\n"
					."	),\n"
					."	);\n";
		$fp =  fopen('./Home/Conf/snsconfig.php','w');
		$fw =  fwrite($fp,$data);
		$this->success('操作成功');
	}
	
	public function lic(){
		$this->val=base64_encode($_SERVER['HTTP_HOST']);
		$this->display();	
	}
	
	public function dolic(){
		$Sys=M('System');
		foreach($_POST as $k=>$v){
			$where['optionname']=$k;
			$Sys->where($where)->setField("optionvalue",trim($v));
		}
		$this->makeconf();
		$this->success('授权成功',U('system/index'));
	}
	
	//歌曲管理
	public function song(){
		$M=M();
		$prefix=C('DB_PREFIX');
		$count=$M->table("{$prefix}song")->count();
		import('ORG.Util.Page');
		$Page= new Page($count,20);
		$show= $Page->show();
		if($_GET['sort']!=''){
			$list=$M->table("{$prefix}song")->order("{$_GET['sort']}_count desc")->field("id,songname,uid,xsongid,singerid")->limit($Page->firstRow.','.$Page->listRows)->select();
		}else{
			$list=$M->table("{$prefix}song")->order("addtime desc")->field("id,songname,uid,xsongid,singerid")->limit($Page->firstRow.','.$Page->listRows)->select();
		}
		if(is_array($list)){
			foreach($list as $k=>$v){
				$list[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->getField("username");
				if($v['singerid']>0) $list[$k]['singer']=$M->table("{$prefix}singer")->where("id={$v['singerid']}")->getField("singername");
			}
		}
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	public function delsong(){
		$sid=$_GET['sid']>0 ? intval($_GET['sid']) : $this->error('参数错误');
		$M=M();
		$prefix=C('DB_PREFIX');
		$song=$M->table("{$prefix}song")->where("id={$sid}")->field("albumid,xsongid")->find();
		if(!$song) $this->error('歌曲不存在');
		//song表搜索albumid
		if($song['albumid']>0){
			$count=$M->table("{$prefix}song")->where("albumid={$song['albumid']}")->count();
			if($count==1){
				$M->table("{$prefix}album")->where("id={$song['albumid']}")->delete();
			}
		}
		$M->table("{$prefix}song")->where("id={$sid}")->delete();
		$M->table("{$prefix}lrc")->where("songid={$sid}")->delete();
		$this->success('删除成功');
	}
	
	public function ads(){
		$this->display();	
	}
	
}