<?php
class UalbumAction extends CommonAction{
	public function _initialize(){
		if(C('IS_FACE')) $this->isface();
		$this->setSite(setweb());
	}
	
	public function index(){
		$allowtype=array(
				'like','collect','comment'
		);
		$M=M();
		$prefix=C('DB_PREFIX');
		if(isset($_GET['sort']) && $_GET['sort']!=''){
			$count=$M->table("{$prefix}ualbum")->order("{$_GET['sort']}_count desc")->count();
		}elseif(isset($_GET['tag']) && $_GET['tag']!=''){
			$tag=iconv('gbk','utf-8',$_GET['tag']);//URL传参乱码
			$where["{$prefix}ualbumtag.tag"]=array("like","%{$tag}%");
			$count=$M->table("{$prefix}ualbumtag")->field("ualbumid")->where($where)->count();
		}else{
			$count=$M->table("{$prefix}ualbum")->count();
		}
		import('ORG.Util.Page');
		$Page= new Page($count,20);
		$show= $Page->show();
		if(in_array(trim($_GET['sort']),$allowtype)){
			$list = $M->table("{$prefix}ualbum")->order("{$_GET['sort']}_count desc")->limit($Page->firstRow.','.$Page->listRows)->field('xalbumid',true)->select();
		}elseif(isset($tag)){
			$list=$M->table("{$prefix}ualbum")->join("{$prefix}ualbumtag on {$prefix}ualbum.id={$prefix}ualbumtag.ualbumid")->where($where)->limit($Page->firstRow.','.$Page->listRows)->select();
		}else{
			$list = $M->table("{$prefix}ualbum")->order("addtime desc")->limit($Page->firstRow.','.$Page->listRows)->field('albumdesc,like_count,collect_count,addtime',true)->select();
		}
		if(is_array($list)){
			foreach ($list as $k=>$v){
				$list[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field('id,username,face')->cache(true)->find();
				$list[$k]['user']['face']=avatar($list[$k]['user']['face']);
			}
		}
		$array=array(
				'ualbum'=>array(
					'addtime','8'	
				),
				'comment'=>array(
					'addtime','8'	
				)
		);
		$this->getmusic($array);
		$this->setTitle('分享专辑');
		$this->fill('ualbum');
		$this->song_top();
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	
	
	/*
	 * 个人专辑展示页
	 */
	public function view(){
		$aid=intval($_GET['aid'])>0 ? intval($_GET['aid']) : $this->redirect('Ualbum/index');
		$M=M();
		$prefix=C('DB_PREFIX');
		$ualbum=$M->table("{$prefix}ualbum")->field("id,albumname,uid,cover,albumdesc,like_count,addtime")->find($aid);
		if($ualbum){
			$ualbum['user']=$M->table("{$prefix}user")->where("id={$ualbum['uid']}")->field('username,face')->find();//获取分享歌曲者的信息
			$ualbum['user']['face']=avatar($ualbum['user']['face']);
			$ualbum['comment']=$M->table("{$prefix}albumcomment")->where("ualbumid={$aid} AND uid={$ualbum['uid']}")->order("addtime asc")->field('id,content')->find();
			
			$songlist=$M->table("{$prefix}ualbumsong")->where("ualbumid={$aid}")->field("songid")->order("id asc")->select();
			foreach($songlist as $k=>$v){
				$songlist[$k]['song']=$M->table("{$prefix}song")->where("id={$v['songid']}")->field("id,songname,singerid,musicurl,pic,xsongid")->find();
				if($songlist[$k]['song']['xsongid']>0){
					$songlist[$k]['song']['singer']=$M->table("{$prefix}singer")->where("id={$songlist[$k]['song']['singerid']}")->field("singername,xsingid")->cache(true)->find();
					$songlist[$k]['flashcode']=makecode($songlist[$k]['song']['singer']['xsingid'],$songlist[$k]['song']['xsongid']);
				}else{
					$songlist[$k]['flashcode']=embed($songlist[$k]['song']['musicurl'],$songlist[$k]['song']['songname'],$songlist[$k]['song']['singer']);
				}
			}
			
			$user=$M->table("{$prefix}albumlike")->where("ualbumid={$aid}")->field("uid")->select();
			foreach ($user as $k =>$v){
				$user[$k]['user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field("username,face")->cache(true)->find();
				$user[$k]['user']['face']=avatar($user[$k]['user']['face']);
			}
			
			$this->tag=$M->table("{$prefix}ualbumtag")->where("ualbumid={$aid}")->field("tag")->select();
			
			$this->hotualbum=$M->table("{$prefix}ualbum")->order("like_count desc")->limit("10")->field("id,albumname,cover")->select();
			
			$hot=$M->table("{$prefix}song")->order("like_count desc")->limit('10')->where("xsongid>0")->field("id,songname,singerid,xsongid")->select();
			foreach($hot as $k=> $v){
					$hot[$k]['singer']=$M->table("{$prefix}singer")->field("id,singername,xsingid")->where("id={$v['singerid']}")->cache(true)->find();
					$hot[$k]['flashcode']=makecode($hot[$k]['singer']['xsingid'], $v['xsongid']);
			}
			
			import('ORG.Util.Page');
			$count=$M->table("{$prefix}albumcomment")->where("ualbumid={$aid}")->count();
			$Page= new Page($count,15);
			$show= $Page->show();
			$list = $M->table("{$prefix}albumcomment")->where("ualbumid={$aid}")->order("addtime desc")->field('uid,content,addtime')->limit($Page->firstRow.','.$Page->listRows)->select();
			if(is_array($list)){
				foreach($list as $k=> $v){
					$list[$k]['com_user']=$M->table("{$prefix}user")->where("id={$v['uid']}")->field('username,face')->cache(true)->find();
					$list[$k]['com_user']['face']=avatar($list[$k]['com_user']['face']);
				}
			}
		}else{
			$this->error('该专辑不存在');
		}
		$this->setTitle($ualbum['albumname']);
		$this->assign('hot',$hot);
		$this->assign('album',$ualbum);
		$this->assign('songlist',$songlist);
		$this->assign('likeuser',$user);
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
	}
	
	
	public function collect(){
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['ualbumid']=intval($_POST['ualbumid']);
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}albumcollect")->where($where)->count();
		if($bool>0){
			$this->ajaxReturn('','报告，您已收藏啦！^_^',101);
		}else{
			$data['ualbumid']=intval($_POST['ualbumid']);
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}albumcollect")->add($data);
			$M->table("{$prefix}ualbum")->where("id={$_POST['ualbumid']}")->setInc('collect_count',1);
			$this->ajaxReturn('','报告，收藏完毕！^_^',101);
		}
	}
	/*
	 * 歌曲喜欢
	*/
	public function like(){
		$ualbumid=intval($_POST['ualbumid']);
		$M=M();
		$prefix=C('DB_PREFIX');
		$where['ualbumid']=$ualbumid;
		$where['uid']=$_SESSION['uid'];
		$bool=$M->table("{$prefix}albumlike")->where($where)->field("id")->count();
		if($bool>0){
			$this->ajaxReturn('','报告，您已喜欢啦！^_^',101);
		}else{
			$data['ualbumid']=$ualbumid;
			$data['uid']=$_SESSION['uid'];
			$data['addtime']=time();
			$M->table("{$prefix}albumlike")->add($data);
			//更新song表中的喜欢
			$M->table("{$prefix}ualbum")->where("id={$ualbumid}")->setInc('like_count',1);
			$this->ajaxReturn('','',100);
		}
	}
	/*
	 * 专辑评论
	*/
	public function comment(){
		$data['ualbumid']=I('post.ualbumid','','intval');
		$data['uid']=$_SESSION['uid'];
		//$data['referid']=I('post.referid','','intval');
		$data['content']=I('post.content','','strip_tags');
		$data['addtime']=time();
		//$this->ajaxReturn($data,'',101);
		if($this->isAjax()){
			if(empty($data['ualbumid']) ||empty($data['uid']) || empty($data['content'])) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
		}else{
			if(empty($data['ualbumid']) ||empty($data['uid']) || empty($data['content'])) $this->error('所填项不能为空');
		}
		$M=M();
		$prefix=C('DB_PREFIX');
		if($M->table("{$prefix}albumcomment")->add($data)){
			$M->table("{$prefix}ualbum")->where("id={$data['ualbumid']}")->setField('comment_count',1);
			if($this->isAjax()) $this->ajaxReturn('','',100);
			else $this->redirect("ualbum/view?aid={$data['ualbumid']}");
		}else{
			if($this->isAjax()) $this->ajaxReturn('','咳咳，貌似出了点问题',101);
			else $this->error('评论失败');
		}
	}
	
	public function _empty(){
		$this->wrong();
	}
}