<?php

class CommonAction extends Action {

	public function uid(){
		$uid=$_SESSION['admin']['id'];

		return $uid;
	}

	function _initialize() {
		$u=$_SESSION['admin'];
		if (empty($u)) {
			//跳转到认证网关
			redirect(PHP_FILE . C('USER_AUTH_GATEWAY'));
			//exit();
		}else{
			if (!$this->user_access()){

				$this->error('操作未授权');
				exit();
			}
		}
		$theme=cookie('theme');
		if (empty($theme)){
			$theme='default';
			cookie('theme','default');
		}
		$this->assign('mb',$theme);
	}

	public function index(){
		$this->display();
	}
	/**
	 * datagrid 数据获取(默认方式)
	 * Enter description here ...
	 */
	public function get_data(){
		$name=$this->getActionName();
		$model=D($name);
		$page=I('post.page');//获取当前分页
		$rows=I('post.rows');//获取每页显示数
		$sort=I('post.sort');//获取当前排序字段
		$order=I('post.order');//获取排序方式
		$list=array();
		$list['total']=	$model->count();
		$list['rows']=  $model->order($sort.' '.$order)->limit(($page-1)*$rows,$rows)->select();
		$list=json_encode($list);
		echo $list;
	}

	public function get_data_w($where,$model){
		//$name=$this->getActionName();
		$model=D($model);
		$page=I('post.page');//获取当前分页
		$rows=I('post.rows');//获取每页显示数
		$sort=I('post.sort');//获取当前排序字段
		$order=I('post.order');//获取排序方式
		$list=array();
		$list['total']=	$model->count();
		$list['rows']=  $model->where($where)->order($sort.' '.$order)->limit(($page-1)*$rows,$page*$rows)->select();
		$list=json_encode($list);
		echo $list;
	}

	/**
	 * 默认添加操作
	 * Enter description here ...
	 */
	public function add(){
		$m=D($this->getActionName());
		$data=$m->create();
		if ($data) {
			$id=$m->add($data);
			if ($id){
				$this->ajaxReturn('添加成功');
			}else{
				$this->ajaxReturn('添加失败');
			}
		}
	}
	/**
	 * 默认修改操作
	 * Enter description here ...
	 */
	public function edit(){
		$m=D($this->getActionName());
		$data=$m->create();
		if ($data) {
			$id=$m->save($data);
			if ($id){
				$this->ajaxReturn('修改成功');
			}else{
				$this->ajaxReturn('修改失败');
			}
		}
	}
	/**
	 * 删除操作
	 * Enter description here ...
	 */
	public function delete() {
		//删除指定记录
		$name = $this->getActionName();
		$model = M($name);
		if (!empty($model)) {
			$pk = $model->getPk();
			$id = I('request.ids');
			if (isset($id)) {
				$condition = array($pk => array('in',$id));
				$list = $model->where($condition)->delete();
				if ($list !== false) {
					$this->success('删除成功！');
				} else {
					$this->error('删除失败！');
				}
			} else {
				$this->error('非法操作');
			}
		}
	}


	protected function user_access(){
		if ($_SESSION['administrator']){
			return true;
		}
		$model=MODULE_NAME;//当前模块名称
		$action=ACTION_NAME;//当前操作名称
		//echo $model.'---'.$action;
		if (in_array($model,array('Index'))){//默认不需要认证模块
			return true;exit();
		}
		if (in_array($action, array('get_data','get_department'))){//默认不需要认证操作
			return true;exit();
		}
		$m_s=M('node')->where(array('href'=>$model,'level'=>'2','id'=>array('in',$this->get_access_id())))->find();

		if (!empty($m_s)){
			$a_s=M('node')->where(array('href'=>$action,'level'=>'3','id'=>array('in',$this->get_access_id())))->find();
			if (isset($a_s)){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	/**
	 * 获取当前登录用户所用权限节点ID
	 * Enter description here ...
	 */
	protected  function get_access_id(){
		if ( $_SESSION['administrator']){//超级管理员无权限限制
			$access_id=M('node')->field('id')->Distinct(true)->select();
			$access_id=arr2_arr1($access_id,'id');

		}else{
			//获取当前用户的所属用户组用户组
			$role_id_arrs=M('role_user')->where(array('user_id'=>$this->uid()))->field('role_id')->select();
			$role_id_arrs=arr2_arr1($role_id_arrs,'role_id');
			//获取用户组全部权限节点id
			$access_id=M('access')->where(array('role_id'=>array('in',$role_id_arrs)))->field('node_id')->Distinct(true)->select();
			$access_id=arr2_arr1($access_id,'node_id');
		}
		return $access_id;

	}

	protected function down_img($img,$v_id,$th='',$type){
		$p_1=substr($v_id,-1,1);
		$path= __ROOT_PATH__.'/uploads/'.$type.'/'.$p_1;
		$this->createFolder($path);

		$p_2=substr($v_id,-2,2);
		$path_2=$path.'/'.$p_2;
		$this->createFolder($path_2);

		$n_path=$path_2.'/'.$v_id;
		$this->createFolder($n_path);
		$down_avatar=$this->downloadImage($img, $n_path.'/'.md5($th.$v_id));

		return $down_avatar['filename'];
	}
	/**
	 * 下载远程图片
	 * @param string $url 图片的绝对url
	 * @param string $filepath 文件的完整路径（包括目录，不包括后缀名,例如/www/images/test） ，此函数会自动根据图片url和http头信息确定图片的后缀名
	 * @return mixed 下载成功返回一个描述图片信息的数组，下载失败则返回false
	 */
	private function downloadImage($url, $filepath) {
		//服务器返回的头信息
		$responseHeaders = array();
		//原始图片名
		$originalfilename = '';
		//图片的后缀名
		$ext = '';
		$ch = curl_init($url);
		//设置curl_exec返回的值包含Http头
		curl_setopt($ch, CURLOPT_HEADER, 1);
		//设置curl_exec返回的值包含Http内容
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		//设置抓取跳转（http 301，302）后的页面
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		//设置最多的HTTP重定向的数量
		curl_setopt($ch, CURLOPT_MAXREDIRS, 2);

		//服务器返回的数据（包括http头信息和内容）
		$html = curl_exec($ch);
		//获取此次抓取的相关信息
		$httpinfo = curl_getinfo($ch);
		curl_close($ch);
		if ($html !== false) {
			//分离response的header和body，由于服务器可能使用了302跳转，所以此处需要将字符串分离为 2+跳转次数 个子串
			$httpArr = explode("\r\n\r\n", $html, 2 + $httpinfo['redirect_count']);
			//倒数第二段是服务器最后一次response的http头
			$header = $httpArr[count($httpArr) - 2];
			//倒数第一段是服务器最后一次response的内容
			$body = $httpArr[count($httpArr) - 1];
			$header.="\r\n";

			//获取最后一次response的header信息
			preg_match_all('/([a-z0-9-_]+):\s*([^\r\n]+)\r\n/i', $header, $matches);
			if (!empty($matches) && count($matches) == 3 && !empty($matches[1]) && !empty($matches[1])) {
				for ($i = 0; $i < count($matches[1]); $i++) {
					if (array_key_exists($i, $matches[2])) {
						$responseHeaders[$matches[1][$i]] = $matches[2][$i];
					}
				}
			}
			//获取图片后缀名
			if (0 < preg_match('{(?:[^\/\\\\]+)\.(jpg|jpeg|gif|png|bmp)$}i', $url, $matches)) {
				$originalfilename = $matches[0];
				$ext = $matches[1];
			} else {
				if (array_key_exists('Content-Type', $responseHeaders)) {
					if (0 < preg_match('{image/(\w+)}i', $responseHeaders['Content-Type'], $extmatches)) {
						$ext = $extmatches[1];
					}
				}
			}
			//保存文件
			if (!empty($ext)) {
				$filepath .= ".$ext";
				//如果目录不存在，则先要创建目录
				$local_file = fopen($filepath, 'w');
				if (false !== $local_file) {
					if (false !== fwrite($local_file, $body)) {
						fclose($local_file);
						$sizeinfo = getimagesize($filepath);
						$new_name = pathinfo($filepath, PATHINFO_BASENAME);
						$type = end(explode('.', $new_name));
						return array(
						//'filepath' => realpath($filepath),
						//'width' => $sizeinfo[0],
						//'height' => $sizeinfo[1],
						//'orginalfilename' => $originalfilename,
	                      'filename' => $new_name,
						//'type' => $type,
						//'ext' => '.'.$type,
						//'size' => $sizeinfo['bits'],
						//'hash' => hash_file('md5',realpath($filepath)),
						//'mime' => $sizeinfo['mime']
						);
					}
				}
			}
		}
		return false;
	}

	protected function createFolder( $path ){
		if (!file_exists($path)){
			//$path=(dirname($path));
			@mkdir($path);
			//@chmod($path,$chmod);
		}
	}

}