<?php
class PublicAction extends Action {
    // 检查用户是否登录
    protected function checkUser() {
        if(!isset($_SESSION[C('USER_AUTH_KEY')])) {
            $this->error('没有登录','Public/login');
        }
    }

    // 顶部页面
    public function top() {
        C('SHOW_RUN_TIME',false);			// 运行时间显示
        C('SHOW_PAGE_TRACE',false);
        $model	=	M("Group");
        $list	=	$model->where('status=1')->getField('id,title');
        $this->assign('nodeGroupList',$list);
        $this->display();
    }





   

    // 后台首页 查看系统信息
    public function main() {
        $info = array(
            '操作系统'=>PHP_OS,
            '运行环境'=>$_SERVER["SERVER_SOFTWARE"],
            'PHP运行方式'=>php_sapi_name(),
            '程序版本'=>'1.1 [ <a href="http://bbs.leyix.com" target="_blank">查看最新版本</a> ]',
            '上传附件限制'=>ini_get('upload_max_filesize'),
            '执行时间限制'=>ini_get('max_execution_time').'秒',
            '服务器时间'=>date("Y年n月j日 H:i:s"),
            '北京时间'=>gmdate("Y年n月j日 H:i:s",time()+8*3600),
            '服务器域名/IP'=>$_SERVER['SERVER_NAME'].' [ '.gethostbyname($_SERVER['SERVER_NAME']).' ]',
            '剩余空间'=>round((@disk_free_space(".")/(1024*1024)),2).'M',
            'register_globals'=>get_cfg_var("register_globals")=="1" ? "ON" : "OFF",
            'magic_quotes_gpc'=>(1===get_magic_quotes_gpc())?'YES':'NO',
            'magic_quotes_runtime'=>(1===get_magic_quotes_runtime())?'YES':'NO',
            );
        $this->assign('info',$info);
        $this->display();
    }

    // 用户登录页面
    public function login() {
        if(!isset($_SESSION[C('USER_AUTH_KEY')])) {
            $this->display();
        }else{
            $this->redirect('Index/index');
        }
    }

    public function index() {
        //如果通过认证跳转到首页
        redirect(__APP__);
    }

    // 用户登出
    public function logout() {
        if(isset($_SESSION[C('USER_AUTH_KEY')])) {
            unset($_SESSION[C('USER_AUTH_KEY')]);
            unset($_SESSION);
            session_destroy();
            $this->success('登出成功！',__URL__.'/login/');
        }else {
            $this->error('已经登出！');
        }
    }
    // 登录检测
    public function checkLogin() {
    	$account=trim(I('post.account'));
    	$password=trim(I('post.password'));
        if(empty($account)) {
            $this->error('帐号必须！');
        }elseif (empty($password)){
            $this->error('密码必须！');
        }
        //生成认证条件
        $map            =   array();
        // 支持使用绑定帐号登录
        $map['account']	= $account;
        $map["status"]	=	array('gt',0);
        import ( 'ORG.Util.RBAC' );
        $authInfo = RBAC::authenticate($map);
        //使用用户名、密码和状态的方式进行认证
        if(false === $authInfo) {
            $this->error('帐号不存在或已禁用！');
        }else {
            if($authInfo['password'] != md5($password)) {
                $this->error('密码错误！');
            }
            $_SESSION[C('USER_AUTH_KEY')]	=	$authInfo['id'];
            $_SESSION['admin']=$authInfo;
            if($authInfo['account']=='admin') {//超级管理员
                $_SESSION['administrator']		=	true;
            }
            //保存登录信息
            $User	=	M('User');
            $ip		=	get_client_ip();
            $time	=	time();
            $data = array();
            $data['id']	=	$authInfo['id'];
            $data['last_login_time']	=	$time;
            $data['login_count']	=	array('exp','login_count+1');
            $data['last_login_ip']	=	$ip;
            $User->save($data);

            // 缓存访问权限
            RBAC::saveAccessList();
            $this->success('登录成功！',__APP__.'/Index/index');

        }
    }
    // 更换密码
    public function changePwd() {
        $this->checkUser();
        //对表单提交处理进行处理或者增加非表单数据
        if(md5($_POST['verify'])	!= $_SESSION['verify']) {
            $this->error('验证码错误！');
        }
        $map	=	array();
        $map['password']= pwdHash($_POST['oldpassword']);
        if(isset($_POST['account'])) {
            $map['account']	 =	 $_POST['account'];
        }elseif(isset($_SESSION[C('USER_AUTH_KEY')])) {
            $map['id']		=	$_SESSION[C('USER_AUTH_KEY')];
        }
        //检查用户
        $User    =   M("User");
        if(!$User->where($map)->field('id')->find()) {
            $this->error('旧密码不符或者用户名错误！');
        }else {
            $User->password	=	pwdHash($_POST['password']);
            $User->save();
            $this->success('密码修改成功！');
         }
    }

    
    
    public function theme(){
    	$name=I('post.name');
    	cookie('theme',$name,99999999*9999999999);
    	$theme=cookie('theme');
    	if (isset($theme)){
    		$this->ajaxReturn('更换主题成功');
    	}else{
    	    $this->ajaxReturn('更换主题失败');
    	}
    }
    public function profile() {
        $this->checkUser();
        $User	 =	 M("User");
        $vo	=	$User->getById($_SESSION[C('USER_AUTH_KEY')]);
        $this->assign('vo',$vo);
        $this->display();
    }

    public function verify() {
        $type	 =	 isset($_GET['type'])?$_GET['type']:'gif';
        import("@.ORG.Util.Image");
        Image::buildImageVerify(4,1,$type);
    }

    // 修改资料
    public function change() {
        $this->checkUser();
        $User	 =	 D("User");
        if(!$User->create()) {
            $this->error($User->getError());
        }
        $result	=	$User->save();
        if(false !== $result) {
            $this->success('资料修改成功！');
        }else{
            $this->error('资料修改失败!');
        }
    }
    
    
    //*****************************************//
    public function get_department(){
    	$list=M('department')->select();
    	$list=json_encode($list);
    	
    	echo $list;
    }
    
    public function get_project(){
    	$list=M('project')->select();
    	$list=json_encode($list);   	
    	echo $list;
    }
    public function get_computeproperty(){
    	$list=M('computeproperty')->select();
    	$list=json_encode($list);
    	
    	echo $list;
    }
    
	public function up_img(){
		//$this->ck_login();
		$type=I('get.type');
		$status=I('get.status');
		$path=I('get.path');
		import('ORG.Net.UploadFile');
		import('ORG.Util.Image.ThinkImage'); 
		$img = new ThinkImage();
		$upload = new UploadFile();// 实例化上传类
		$upload->maxSize  = 2048000;// 设置附件上传大小
		$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
		$upload->savePath =  './uploads/'.$path.'/';// 设置附件上传目录
		if(!$upload->upload()) {// 上传错误提示错误信息
			echo $upload->getErrorMsg();
		}else{// 上传成功 获取上传文件信息
			$info =  $upload->getUploadFileInfo();
			//$img->open('./uploads/img_saall/'.$info['0']['savename'])->water('./sy.png',rand(1,9))->save('./uploads/img/'.$info['0']['savename']);
		
		$img_data=array();
		$img_data['filename']=$info['0']['savename'];
		$img_data['ext']=$info['0']['extension'];
		$data['data']=serialize($img_data);
		$data['uid']=$_SESSION['user']['id'];
		$data['status']=$status;
		$data['type']=$type;
		$img_id=M('share_img')->add($data);
		$callback= array('img_id'=>$img_id,'img_name'=>$info['0']['savename']);
		$this->ajaxReturn($callback,'',1);
		}
		//$this->ajaxReturn(1,'保存成功',1);
		// 保存表单数据 包括附件数据
		/*$User = M("User"); // 实例化User对象
		 $User->create(); // 创建数据对象
		 $User->photo = $info[0]['savename']; // 保存上传的照片根据需要自行组装
		 $User->add(); // 写入用户数据到数据库
		 $this->success('数据保存成功！');*/

	}
    
}