<?php
class ShowdataAction extends CommonAction{
	public function get_data(){
		$model=D('showdata');
		//组装查询条件
		$where['status']=array('eq',0);//初始化条件
		$id=I('post.id');
		if (!empty($id)){
			$where['v_id']=array('like','%'.$id.'%');
		}
		$title=I('post.title');
		if (!empty($title)){
			$where['title']=array('like','%'.$title.'%');
		}
		$page=I('post.page');//获取当前分页
		$rows=I('post.rows');//获取每页显示数
		$sort=I('post.sort');//获取当前排序字段
		$order=I('post.order');//获取排序方式
		$list=array();
		$list['total']=	$model->where($where)->count();
		$list['rows']=  $model->where($where)->order($sort.' '.$order)->limit(($page-1)*$rows,$rows)->select();
		if (empty($list['rows'])){
			$list['rows']='';
		}
		$list=json_encode($list);
		echo $list;
	}

	/**
	 * 采集ID
	 * Enter description here ...
	 */
	public function collect(){
		$m=M('showdata');
		$form=$m->create();
		include 'Http.class.php';
		$get=new Http();
		$yk=C('youku');
		$form['client_id']=$yk['client_id'];
		$url="https://openapi.youku.com/v2/shows/by_category.json";
		$get_data=$get->get($url,$form);
		$data=json_decode($get_data,true);
		foreach ($data['shows'] as $k=>$v){
			$status=$m->where(array('v_id'=>$v['id']))->find();
			if (empty($status)){
				$data['v_id']=$v['id'];
				$data['title']=$v['name'];
				$data['category']=$form['category'];
				$data['genre']=$form['genre'];
				$data['area']=$form['area'];
				$data['time']=time();
				$id=$m->add($data);
				if ($id){
					$re="<p style=\"color: #0D6BF8;\">《".$v['name']."》采集成功</p>";
					echo $re;
				}
			}else{
				$re="<p style=\"color: #F80D0D;\">《".$v['name']."》已采集过了</p>";
				echo $re;
			}
		}
	}
	/**
	 * 采集视频数据
	 * Enter description here ...
	 */
	public  function data_show(){
		$m=M('showinfo');
		$id = I('request.ids');
		include 'Http.class.php';
		$get= new Http();
		$yk=C('youku');
		foreach ($id as $v){
			$url="https://openapi.youku.com/v2/shows/show.json";
			$get_data=$get->get($url,array('client_id'=>$yk["client_id"],'show_id'=>$v));
			$d=json_decode($get_data,true);
			if (!empty($d)){
			$data_id=M('showdata')->where(array('v_id'=>$v))->find();
			$status=$m->where(array('id'=>$v))->field('id')->find();
			if (empty($status)){
				//数据组装
				$d['alias']=serialize($d['alias']);
				$d['poster']=$this->down_img($d['poster'], $d['id'],'poster', 'show');
				$d['poster_large']=$this->down_img($d['poster_large'], $d['id'],'poster_large', 'show');
				$d['thumbnail']=$this->down_img($d['thumbnail'], $d['id'],'thumbnail', 'show');
				$d['streamtypes']=serialize($d['streamtypes']);
				$d['hasvideotype']=serialize($d['hasvideotype']);
				$d['site']=serialize($d['site']);
				$d['distributor']=serialize($d['distributor']);
				$d['production']=serialize($d['production']);
				$d['attr']=serialize($d['attr']);
				$d['performer']=serialize($d['performer']);
				$d['screenwriter']=serialize($d['screenwriter']);
				$d['producer']=serialize($d['producer']);
				$d['time']=time();				
				$id=$m->add($d);
				if ($id){
					$d_s['id']=$data_id['id'];
					$d_s['status']=1;
					M('showdata')->save($d_s);
					$re="<p style=\"color: #0D6BF8;\">《".$d['name']."》采集成功</p>";
					echo $re;
				}
			}else{
				$re="<p style=\"color: #F80D0D;\">《".$d['name']."》已采集过了</p>";
				echo $re;
			}
			}else{
				$d_s['id']=$data_id['id'];
				$d_s['status']=1;
				M('showdata')->save($d_s);
				$re="<p style=\"color: #F80D0D;\">".$v."无法采集数据</p>";
				echo $re;
			}
		}
	}

	public function get_typr(){
		$fid=I('get.fid');
		if (empty($fid)){
			$list=M('showtype')->where(array('fid'=>'0'))->select();
		}else{
			$list=M('showtype')->where(array('fid'=>$fid))->select();
		}
		$list=json_encode($list);
		echo $list;
	}

	public function get_area(){
		$list=M('Schemas')->select();
		$list=json_encode($list);
		echo $list;
	}
}