<?php
# Name: PHP版程氏音乐CMS管理系统 v3.0
# Author: 程氏<web@chshcms.com> [QQ:848769359]
# Homepage:http://www.chshcms.cn/

//获取页面源代码
function geturlcontent($url,$charset){
	if(function_exists("file_get_contents")){
	        for($i=0;$i<3;$i++){
		      $content = @file_get_contents($url);
		      if($content) break;
	        }
		if(empty($content) && function_exists('curl_init')){
			  $ch = curl_init();
			  $timeout = 5; // set to zero for no timeout
			  curl_setopt ($ch, CURLOPT_URL, $url);
			  curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1); 
			  curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
			  $content = curl_exec($ch);
			  curl_close($ch);		
		}
	}
	if($charset=='UTF-8'){
		$content=convert_encoding($content,'GBK','UTF-8');
	}	
  return $content;				  		
}

//截取函数
function getContent ($sourceStr,$star,$end,$flag=1){
  $star=CS_ReplaceStr($star,'\\','');
  $end=CS_ReplaceStr($end,'\\','');
  switch ($flag) {
    case 0:  //取指定字符前面的
        echo strrpos( $sourceStr, $end );
        echo '-----'.strlen( $end );
        $content = substr( $sourceStr, 0, strrpos( $sourceStr, $end ) + strlen( $end ) );
        break;
    case 1:  //取指定字符之间的,不包括指定字符
		if($star!="" && $end!=""){
			if(strpos($sourceStr,$star)!=""){
        		$content = substr($sourceStr,strpos($sourceStr,$star)+strlen($star));
				$content = substr($content,0,strpos($content,$end));
			}else{
				$content="";
			}	
		}else{
			$content="";
		}
        break;
    case 2:  //取指定字符之间的，包括指定字符
        $content =strstr( $sourceStr, $star );

        $content = substr( $content, 0, strrpos( $content, $end ) + strlen( $end ) );
        break;
    case 3:  //取指定字符之后的，不包括指定字符
        $content = substr( $sourceStr, strrpos( $sourceStr,$star)+ strlen( $star ));
        break;
    case 4:  //取指定字符之后的，包括指定字符
        $content =strstr( $sourceStr, $star );
        break;
	case 5:  //取指定字符之间的,不包括指定字符(规则导入专属)
		if($star!="" && $end!=""){
        		$content = substr($sourceStr,strpos($sourceStr,$star)+strlen($star));
			$content = dh(substr($content,0,strpos($content,$end)));	
		}else{
			$content="";
		}
        break;	
  }

        return $content;
}

//返回结果 字符串数组
function getArr($startstr,$endstr,$content)
{	 
	  $startstr=CS_ReplaceStr($startstr,'/','\/');
	  $endstr=CS_ReplaceStr($endstr,'/','\/');
	  $theregstr='/'.$startstr.'(.*?)'.$endstr.'/';
	  preg_match_all($theregstr,$content,$match_array);
	  $newarray=$match_array[1];
	  return $newarray;
}

//采集内容替换
function collectRep($str,$reg){
  if(!empty($reg)){
	$reg=CS_ReplaceStr($reg,'\\','');
	$regArr=explode("\n",$reg);
	for($i=0;$i<count($regArr);$i++){
		$restr=explode('@@cscms@@',$regArr[$i]);
		$ostr=$restr[0];
		$nstr=$restr[1];
		$str=CS_ReplaceStr($str,$ostr,$nstr);
	}
  }
  return $str;	
}

//安全内容替换
function dh($str){
  $t_Val = str_replace("&", "&amp;",$str); 
  $t_Val = str_replace("<", "&lt;",$t_Val);
  $t_Val = str_replace(">", "&gt;",$t_Val);
  if ( get_magic_quotes_gpc() )
  {
    $t_Val = str_replace("\\\"", "&quot;",$t_Val);
    $t_Val = str_replace("\\''", "&#039;",$t_Val);
  }
  else
  {
    $t_Val = str_replace("\"", "&quot;",$t_Val);
    $t_Val = str_replace("'", "&#039;",$t_Val);
  }
  return $t_Val;	
}

//安全内容输出
function dhc($str){
  $t_Val = str_replace("&amp;", "&",$str); 
  $t_Val = str_replace("&lt;", "<",$t_Val);
  $t_Val = str_replace("&gt;", ">",$t_Val);
  if ( get_magic_quotes_gpc() )
  {
    $t_Val = str_replace("&quot;", "\\\"",$t_Val);
    $t_Val = str_replace("&#039;", "\\''",$t_Val);
  }
  else
  {
    $t_Val = str_replace("&quot;", "\"",$t_Val);
    $t_Val = str_replace("&#039;", "'",$t_Val);
  }
  return $t_Val;	
}
