<?php
/**
 * UCenter 应用程序开发 API Example
 *
 * 此文件为 api/uc.php 文件的开发样例，用户处理 UCenter 通知给应用程序的任务
 */

define('UC_VERSION', '1.6.0');		//UCenter 版本标识

define('API_DELETEUSER', 1);		//用户删除 API 接口开关
define('API_RENAMEUSER', 1);		//用户改名 API 接口开关
define('API_UPDATEPW', 1);		//用户改密码 API 接口开关
define('API_GETTAG', 0);		//获取标签 API 接口开关
define('API_SYNLOGIN', 1);		//同步登录 API 接口开关
define('API_SYNLOGOUT', 1);		//同步登出 API 接口开关
define('API_UPDATEBADWORDS', 1);	//更新关键字列表 开关
define('API_UPDATEHOSTS', 1);		//更新域名解析缓存 开关
define('API_UPDATEAPPS', 1);		//更新应用列表 开关
define('API_UPDATECLIENT', 1);		//更新客户端缓存 开关
define('API_UPDATECREDIT', 1);		//更新用户积分 开关
define('API_GETCREDITSETTINGS', 1);	//向 UCenter 提供积分设置 开关
define('API_UPDATECREDITSETTINGS', 1);	//更新应用积分设置 开关

define('API_RETURN_SUCCEED', '1');
define('API_RETURN_FAILED', '-1');
define('API_RETURN_FORBIDDEN', '-2');

error_reporting(7);

define('UC_CLIENT_ROOT', DISCUZ_ROOT.'./lib/client/');
chdir('../');
require_once './lib/cs_config_uc.php';
$code = @$_GET['code'];
parse_str(authcode($code, 'DECODE', UC_KEY), $get);
if(MAGIC_QUOTES_GPC) {
	$get = dstripslashes($get);
}

if(time() - $get['time'] > 3600) {
	exit('Authracation has expiried');
}
if(empty($get)) {
	exit('Invalid Request');
}
$action = $get['action'];
$timestamp = time();

//导入文件
if($action=='deleteuser'||$action=='renameuser'||$action=='updatepw'||$action=='synlogin'||$action=='synlogout')
{
	require_once './lib/cs_conn.php';
	require_once './lib/cs_common.php';
	global $db;
}

if($action == 'test') {

	exit(API_RETURN_SUCCEED);

} elseif($action == 'deleteuser') {

	!API_DELETEUSER && exit(API_RETURN_FORBIDDEN);

	//用户删除 API 接口

	$uids = $get['ids'];

	$ur=explode(',',$uids);
	$count=count($ur);
	for($i=0;$i<$count;$i++)
	{

		//获取会员名
        	$sql= "select cs_id from ".Getdbname('user')." where cs_uid='".intval($ur[$i])."'";
        	$s_id= $db->Getone($sql);
		if($s_id){
	           $sqlc="select CS_Name from ".Getdbname('user')." where cs_uid=".intval($ur[$i])."";
	           $crow=$db->getrow($sqlc);
                   $chsh_username=$crow['CS_Name'];
		}
		//删除会员
		$db->query("delete from ".Getdbname('user')." where cs_name='".$chsh_username."'");
                //删除消息
		$db->query("delete from ".Getdbname('msg')." where cs_usera='".$chsh_username."' or cs_userb='".$chsh_username."'");
		//删除收藏
		$db->query("delete from ".Getdbname('fav')." where cs_user='".$chsh_username."'");
		//删除购买记录
		$db->query("delete from ".Getdbname('pay')." where cs_user='".$chsh_username."'");
		//删除下载记录
		$db->query("delete from ".Getdbname('down')." where cs_user='".$chsh_username."'");
		//删除好友记录
		$db->query("delete from ".Getdbname('friend')." where cs_usera='".$chsh_username."' or cs_userb='".$chsh_username."'");
		//删除留言
		$db->query("delete from ".Getdbname('gbook')." where cs_user='".$chsh_username."'");
		//删除相册
		$db->query("delete from ".Getdbname('pic')." where cs_user='".$chsh_username."'");
		//删除粉丝
		$db->query("delete from ".Getdbname('fans')." where cs_usera='".$chsh_username."' or cs_userb='".$chsh_username."'");
	}
	exit(API_RETURN_SUCCEED);

} elseif($action == 'renameuser') {

	!API_RENAMEUSER && exit(API_RETURN_FORBIDDEN);

	//用户改名 API 接口
	$uid = $get['uid'];
	$usernamenew = $get['newusername'];
	$usernameold = $get['oldusername'];

	//会员表
	//$db->query("update ".Getdbname('user')." set cs_name='$usernamenew' where cs_name='$usernameold'");

	exit(API_RETURN_SUCCEED);

} elseif($action == 'updatepw') {

	!API_UPDATEPW && exit(API_RETURN_FORBIDDEN);

	//更改用户密码
	$username=$get['username'];
	$password=Md5($get['password']);
	$sql="update ".Getdbname('user')." set cs_pass='$password' where cs_name='$username'";
        if($db->query($sql)){
	   setcookie("cs_id","",time()-86400*365,"/",Host_User());
	   setcookie("cs_name","",time()-86400*365,"/",Host_User());
	   exit(API_RETURN_SUCCEED);
        }

} elseif($action == 'gettag') {

	!API_GETTAG && exit(API_RETURN_FORBIDDEN);

	//获取标签 API 接口
	exit(API_RETURN_SUCCEED);

} elseif($action == 'synlogin') {

	!API_SYNLOGIN && exit(API_RETURN_FORBIDDEN);

	//同步登录 API 接口

	//$uid = intval($get['uid']);
	$uid = $get['uid'];
	$cookietime=86400*365;//cookie保存时间
	$ur=$db->getrow("select cs_id,cs_name from ".Getdbname('user')." where cs_uid='$uid'");
	if($ur['cs_id'])
	{
		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
	        setcookie('cs_id',$ur['cs_id'],time()+$cookietime,'/',Host_User());
	        setcookie('cs_name',$ur['cs_name'],time()+$cookietime,'/',Host_User());
	}

} elseif($action == 'synlogout') {

	!API_SYNLOGOUT && exit(API_RETURN_FORBIDDEN);

	//同步登出 API 接口
	header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
	setcookie("cs_id","",time()-86400*365,"/",Host_User());
	setcookie("cs_name","",time()-86400*365,"/",Host_User());

} elseif($action == 'updatebadwords') {

	!API_UPDATEBADWORDS && exit(API_RETURN_FORBIDDEN);

	//更新关键字列表
	exit(API_RETURN_SUCCEED);

} elseif($action == 'updatehosts') {

	!API_UPDATEHOSTS && exit(API_RETURN_FORBIDDEN);

	//更新HOST文件
	exit(API_RETURN_SUCCEED);

} elseif($action == 'updateapps') {

	!API_UPDATEAPPS && exit(API_RETURN_FORBIDDEN);

	//更新应用列表
	exit(API_RETURN_SUCCEED);

} elseif($action == 'updateclient') {

	!API_UPDATECLIENT && exit(API_RETURN_FORBIDDEN);

	//更新客户端缓存
	exit(API_RETURN_SUCCEED);

} elseif($action == 'updatecredit') {

	!UPDATECREDIT && exit(API_RETURN_FORBIDDEN);

	//更新用户积分
	exit(API_RETURN_SUCCEED);

} elseif($action == 'getcreditsettings') {

	!GETCREDITSETTINGS && exit(API_RETURN_FORBIDDEN);

	//向 UCenter 提供积分设置
	echo uc_serialize($credits);

} elseif($action == 'updatecreditsettings') {

	!API_UPDATECREDITSETTINGS && exit(API_RETURN_FORBIDDEN);

	//更新应用积分设置
	exit(API_RETURN_SUCCEED);

} else {

	exit(API_RETURN_FAILED);

}

function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {

	$ckey_length = 4;

	$key = md5($key ? $key : UC_KEY);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}

}

function dsetcookie($var, $value, $life = 0, $prefix = 1) {
	global $cookiedomain, $cookiepath, $timestamp, $_SERVER;
	setcookie($var, $value,
		$life ? $timestamp + $life : 0, $cookiepath,
		$cookiedomain, $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

function dstripslashes($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = dstripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}

function uc_serialize($arr, $htmlon = 0) {
	include_once UC_CLIENT_ROOT.'./lib/xml.class.php';
	return xml_serialize($arr, $htmlon);
}

function uc_unserialize($s) {
	include_once UC_CLIENT_ROOT.'./lib/xml.class.php';
	return xml_unserialize($s);
}

function uc_note() {
	$this->appdir = substr(dirname(__FILE__), 0, -3);
	$this->dbconfig = $this->appdir.'./lib/cs_config_uc.php';
}
