<?php
# Name: PHP版程氏音乐CMS管理系统 v3.0
# Author: 程氏<web@chshcms.com> [QQ:848769359]
# Homepage:http://www.chshcms.cn/

require_once("cs_conn.php");
require_once("cs_common.php");
//读取模板文件内容
function GetTemp($tpl,$ids){
	$tplpath=_CSDJ_ROOT_.CS_Templateurl.$tpl;
	if(file_exists($tplpath)){
		$Mark_Text=@file_get_contents($tplpath);
		$Mark_Text=Common_Mark($Mark_Text,$ids);
		return $Mark_Text;
		}
	else{
		die("".$tpl."模板文件不存在!");
		}	
	}
//头部和底部
function topandbottom($Mark_Text){
	$top_txt=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."cs-head.html");
	$bottom_txt=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."cs-bottom.html");
	$Mark_Text=str_replace('{csdjcms:head}',$top_txt,$Mark_Text);
	$Mark_Text=str_replace('{csdjcms:bottom}',$bottom_txt,$Mark_Text);
	return $Mark_Text;
	}

//同用标签解析
function Common_Mark($Mark_Text,$IDs,$Mode='0'){
	global $db;
	if(!IsNull($Mark_Text)) die("模板文件无内容！！");
	$TempImg =CS_WebPath.substr(substr(CS_Templateurl,0,strlen(CS_Templateurl)-1),0,strrpos(substr(CS_Templateurl,0,strlen(CS_Templateurl)-1),'/')+1);
	preg_match_all('/{csdjcmsself:([\S]+?)}/',$Mark_Text,$Arrself);   //自定义标签解析
	if(!empty($Arrself[1])){
		for($i=0;$i<count($Arrself[1]);$i++){
			$sqlself="select CS_SelfLable from Getdbname('label') where CS_Name='".$Arrself[1][$i]."'";
			$row=$db->getrow($sqlself);
			if($row){
				$Mark_Text=CS_ReplaceStr($Mark_Text,$Arrself[0][$i],$row['CS_SelfLable']);
			}
		}
	}
	unset($Arrself);

	preg_match_all('/{csdjcmszm:([A-Za-z0-9-_]+)}/',$Mark_Text,$Mark_ZM);  //字母搜索标签解析
	if(!empty($Mark_ZM[1])){
                $szm='';
                $strzm=array('A','B','C','D','E','F','J','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		for($i=0;$i<$Mark_ZM[1][0];$i++){
                    if(CS_Webmode==2){
                          $szm.="<a href=\"{csdjcms:path}so-dance-zm-".$strzm[$i].".html\" target=\"so\">".$strzm[$i]."</a>";
                    }else{
                          $szm.="<a href=\"{csdjcms:path}?cs=so-dance-zm-".$strzm[$i].".html\" target=\"so\">".$strzm[$i]."</a>";
                    }
		}
                $Mark_Text=CS_ReplaceStr($Mark_Text,$Mark_ZM[0][0],$szm);
	unset($Mark_ZM);
	}

	$Mark_Text  = topandbottom($Mark_Text);	
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:webname}",CS_WebName);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:weburl}",CS_WebUrl);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:path}",CS_WebPath);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:stat}",html_entity_decode(stripslashes(CS_WebCount)));
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:title}",CS_WebName);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:notice}",stripslashes(html_entity_decode(CS_WebNotice)));
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",stripslashes(html_entity_decode(CS_Key)));
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:description}",stripslashes(html_entity_decode(CS_Description)));
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:keyword}",HotSearch(CS_Keywords));
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:mail}",CS_Adminmail); 
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:qq}",CS_AdminQQ);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:tel}",CS_Admintel);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:tempurl}",$TempImg);
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:icp}",CS_Webicp);

        if(CS_Webmode==2){
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:solink}",CS_WebPath."so-dance-all.html");
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:gbooklink}",CS_WebPath."gbook.html");
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:lblink}",CS_WebPath."lb-all.html");
        }else{
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:solink}",CS_WebPath."?cs=so-dance-all.html");
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:gbooklink}",CS_WebPath."?cs=gbook.html");
	   $Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:lblink}",CS_WebPath."?cs=lb-all.html");
        }
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:topiclink}",LinkUrl('list','zj','id'));

        //数据统计标签
	$DanceCount="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=dc'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:dcount}",$DanceCount);
	$DanceDay="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=dd'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:dcountday}",$DanceDay);
	$NewsDay="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=ad'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:ncountday}",$NewsDay);
	$NewsCount="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=ac'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:ncount}",$NewsCount);
	$UserCount="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=uc'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:ucount}",$UserCount);
	$UserDay="<script type='text/javascript' language='javascript' src='".CS_WebPath."public/count.php?ac=ud'></script>";
	$Mark_Text  = CS_ReplaceStr($Mark_Text,"{csdjcms:ucountday}",$UserDay);
        $Mark_Text  = csdjcopyright($Mark_Text);

	if($Mode=='1'){		
		return $Mark_Text;	
	}else{
		return Data_Mark($Mark_Text,$IDs);
	}	
}

//数据处理
function Data_Mark($Mark_Text,$IDs){
	global $db;
	if(!IsNull($Mark_Text)) die("模板文件没有内容！！");
	preg_match_all('/{csdjcms:([\S]+)\s+(.*?)}([\s\S]+?){\/csdjcms:\1}/',$Mark_Text,$Mark_Arr);
	if(!empty($Mark_Arr)){
		for($i=0;$i<count($Mark_Arr[0]);$i++){
			$Ytable=$Mark_Arr[1][$i];
			$table=Getdbname($Mark_Arr[1][$i]);
			$para=$Mark_Arr[2][$i];
			$sql=Mark_Sql($table,$para,$IDs);//sql语句的组织返回
			$result=$db->query($sql);
			$resultcount=$db->num_rows($result);
			if($result){
				if($resultcount==0){
					$Data_Content="无相关的数据!";
					$Mark_Text=CS_ReplaceStr($Mark_Text,$Mark_Arr[0][$i],$Data_Content);
				}else{
					$Data_Content='';$Data_Content_Temp='';$sorti=1;
					while($row=$db->fetch_array($result)){	
						switch($Ytable){
							case 'dance':$Data_Content.=datadance($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti);break;
							case 'class':$Data_Content.=dataclass($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti);break;
							case 'type':$Data_Content.=datatype($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti);break;
							case 'topic':$Data_Content.=datatopic($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti);break;
							case 'link':$Data_Content.=datalink($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti);break;
							case 'news':$Data_Content.=datanews($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti); break;
							case 'user':$Data_Content.=datauser($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti); break;
							case 'pic':$Data_Content.=datapic($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti); break;
							case 'blog':$Data_Content.=datablog($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti); break;
							case 'tags':$Data_Content.=datatags($Mark_Arr[0][$i],$Mark_Arr[3][$i],$row,$sorti); break;
							}//end switch
							$sorti=$sorti+1;
						}//end while
						
					}//end if($resultcount)	
				$Mark_Text=CS_ReplaceStr($Mark_Text,$Mark_Arr[0][$i],$Data_Content);	
				}//end if($result)	
			}//end for
		} 
	$Mark_Text=labelif($Mark_Text);
	return $Mark_Text;
	}
	
//舞曲标签解析
function datadance($para,$label,$row,$sorti){//文件内容，标签参数，标签内容
	preg_match_all('/\[dance:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
                        if(CS_Plmode==0){
			     $comment="<script language='javascript' src='".CS_WebPath."public/js/plajax.js'></script><script>var cs_sid='1';var cs_did='".$row['CS_ID']."';var cs_path='".CS_WebPath."';getpllist('1','".$row['CS_ID']."','1');</script><div id='csdjcms_pl'><div style='padding:5px;text-align:center;'><img src='".CS_WebPath."public/images/load.gif'/>&nbsp;&nbsp;评论载入中，请稍候.....</div></div>";
                        }elseif(CS_Plmode==2){
			     $comment="<div style='padding:5px;text-align:center;'>&nbsp;&nbsp;评论已经被站长关闭!</div>";
                        }else{
			     $comment="<div id=\"uyan_frame\"></div><script type=\"text/javascript\" id=\"UYScript\" src=\"http://v1.uyan.cc/js/iframe.js?UYUserId=0\" async=\"\"></script>";
                        }
			switch($field_arr[1][$i]){
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[dance:link]',LinkUrl('play','dance','id',$row['CS_CID'],$row['CS_ID']));break;
				case 'downlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:downlink]',"javascript:Popsboxif('下载歌曲',450,180,'".CS_WebPath."public/down.php?id=".$row['CS_ID']."');");break;
				case 'errorlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:errorlink]',"javascript:Popsboxif('歌曲报错',450,305,'".CS_WebPath."public/error.php?id=".$row['CS_ID']."');");break;
				case 'favlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:favlink]',CS_WebPath."user/do.php?ac=fav&id=".$row['CS_ID']);break;
				case 'qqlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:qqlink]','http://'.$_SERVER['HTTP_HOST'].CS_WebPath.'public/url.php/'.$row['CS_ID'].'/csdj.mp3');break;
				case 'pic':$datatmp=CS_ReplaceStr($datatmp,'[dance:pic]',piclink('dance',$row['CS_Pic']));break;
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[dance:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[dance:i]',$sorti);break;
				case 'color':$datatmp=CS_ReplaceStr($datatmp,'[dance:color]',$row['CS_Color']);break;
				case 'year':$datatmp=CS_ReplaceStr($datatmp,'[dance:year]',$row['CS_Year']);break;
				case 'singer':$datatmp=CS_ReplaceStr($datatmp,'[dance:singer]',$row['CS_Singer']);break;
				case 'stars':$datatmp=CS_ReplaceStr($datatmp,'[dance:stars]',$row['CS_Reco']);break;
				case 'hits':$datatmp=CS_ReplaceStr($datatmp,'[dance:hits]',$row['CS_Hits']);break;
				case 'shits':$datatmp=CS_ReplaceStr($datatmp,'[dance:shits]',$row['CS_Shits']);break;
				case 'xhits':$datatmp=CS_ReplaceStr($datatmp,'[dance:xhits]',$row['CS_Xhits']);break;
				case 'rhits':$datatmp=CS_ReplaceStr($datatmp,'[dance:rhits]',$row['CS_Rhits']);break;
				case 'zhits':$datatmp=CS_ReplaceStr($datatmp,'[dance:zhits]',$row['CS_Zhits']);break;
				case 'yhits':$datatmp=CS_ReplaceStr($datatmp,'[dance:yhits]',$row['CS_Yhits']);break;
				case 'dhits':$datatmp=CS_ReplaceStr($datatmp,'[dance:dhits]',$row['CS_Dhits']);break;
				case 'chits':$datatmp=CS_ReplaceStr($datatmp,'[dance:chits]',$row['CS_Chits']);break;
				case 'tags':$datatmp=CS_ReplaceStr($datatmp,'[dance:tags]',HotSearch($row['CS_Tags']));break;
				case 'classlink':$datatmp=CS_ReplaceStr($datatmp,"[dance:classlink]",LinkUrl('list','dance','id',$row['CS_CID'],$row['CS_ID']));break;
				case 'classnlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classnlink]',LinkUrl('list','dance','new',$row['CS_CID'],$row['CS_ID']));break;
				case 'classhlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classhlink]',LinkUrl('list','dance','hits',$row['CS_CID'],$row['CS_ID']));break;
				case 'classtlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classtlink]',LinkUrl('list','dance','reco',$row['CS_CID'],$row['CS_ID']));break;
				case 'classylink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classylink]',LinkUrl('list','dance','yue',$row['CS_CID'],$row['CS_ID']));break;
				case 'classzlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classzlink]',LinkUrl('list','dance','zhou',$row['CS_CID'],$row['CS_ID']));break;
				case 'classrlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classrlink]',LinkUrl('list','dance','ri',$row['CS_CID'],$row['CS_ID']));break;
				case 'classdlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classdlink]',LinkUrl('list','dance','ding',$row['CS_CID'],$row['CS_ID']));break;
				case 'classxlink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classxlink]',LinkUrl('list','dance','down',$row['CS_CID'],$row['CS_ID']));break;
				case 'classslink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classslink]',LinkUrl('list','dance','fav',$row['CS_CID'],$row['CS_ID']));break;
				case 'classplink':$datatmp=CS_ReplaceStr($datatmp,'[dance:classplink]',LinkUrl('list','dance','play',$row['CS_CID'],$row['CS_ID']));break;
				case 'classname':$datatmp=CS_ReplaceStr($datatmp,"[dance:classname]",getclass($row['CS_CID']));break;
				case 'classid':$datatmp=CS_ReplaceStr($datatmp,"[dance:classid]",$row['CS_CID']);break;
				case 'pl':$datatmp=CS_ReplaceStr($datatmp,"[dance:pl]",$comment);break;
				case 'uname':$datatmp=CS_ReplaceStr($datatmp,"[dance:uname]",$row['CS_User']);break;
				case 'ulink':$datatmp=CS_ReplaceStr($datatmp,"[dance:ulink]",userlink('index',getuser('uid',$row['CS_User'])));break;
				case 'uqq':$datatmp=CS_ReplaceStr($datatmp,"[dance:uqq]",getuser('qq',$row['CS_User']));break;
				case 'usex':$datatmp=CS_ReplaceStr($datatmp,"[dance:usex]",getuser('sex',$row['CS_User']));break;
				case 'ucity':$datatmp=CS_ReplaceStr($datatmp,"[dance:ucity]",getuser('city',$row['CS_User']));break;
				case 'unichen':$datatmp=CS_ReplaceStr($datatmp,"[dance:unichen]",getuser('nichen',$row['CS_User']));break;
				case 'upic':$datatmp=CS_ReplaceStr($datatmp,"[dance:upic]",getuser('pic',$row['CS_User']));break;
				case 'uid':$datatmp=CS_ReplaceStr($datatmp,"[dance:uid]",getuser('uid',$row['CS_User']));break;
				case 'cion':$datatmp=CS_ReplaceStr($datatmp,"[dance:cion]",$row['CS_Coin']);break;
				case 'dx':$datatmp=CS_ReplaceStr($datatmp,"[dance:dx]",$row['CS_Dx']);break;
				case 'yz':$datatmp=CS_ReplaceStr($datatmp,"[dance:yz]",$row['CS_Yz']);break;
				case 'sc':$datatmp=CS_ReplaceStr($datatmp,"[dance:sc]",$row['CS_Sc']);break;
				case 'xzqx':$datatmp=CS_ReplaceStr($datatmp,"[dance:xzqx]",Downqx($row['CS_Vip']));break;
				case 'coin':$datatmp=CS_ReplaceStr($datatmp,"[dance:coin]",Downqx($row['CS_Coin']));break;
				case 'url':$datatmp=CS_ReplaceStr($datatmp,"[dance:url]",$row['CS_PlayUrl']);break;
				case 'qurl':$datatmp=CS_ReplaceStr($datatmp,"[dance:qurl]",playurl($row['CS_PlayUrl'],$row['CS_FID']));break;
				case 'playtime':$datatmp=CS_ReplaceStr($datatmp,"[dance:playtime]",datetime($row['CS_Playtime']));break;
				case 'addtime':$datatmp=CS_ReplaceStr($datatmp,"[dance:addtime]",datetime($row['CS_AddTime']));break;
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;
				case 'content':
					$content=getlen($field_arr[2][$i],$field_arr[3][$i],stripslashes(html_entity_decode(h($row['CS_Content']))));
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$content);break;				
					break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					break;
				}//end switch		
			}//end for
			//$Mark_Text=CS_ReplaceStr($Mark_Text,$para,$data);
		}
		unset($field_arr);
		return $datatmp;		
}

//文章标签解析
function datanews($para,$label,$row,$sorti){
	preg_match_all('/\[news:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
                        if(CS_Plmode==0){
			     $comment="<script language='javascript' src='".CS_WebPath."public/js/plajax.js'></script><script>var cs_sid='2';var cs_did='".$row['CS_ID']."';var cs_path='".CS_WebPath."';getpllist('1','".$row['CS_ID']."','2');</script><div id='csdjcms_pl'><div style='padding:5px;text-align:center;'><img src='".CS_WebPath."public/images/load.gif'/>&nbsp;&nbsp;评论载入中，请稍候.....</div></div>";
                        }elseif(CS_Plmode==2){
			     $comment="<div style='padding:5px;text-align:center;'>&nbsp;&nbsp;评论已经被站长关闭!</div>";
                        }else{
			     $comment="<div id=\"uyan_frame\"></div><script type=\"text/javascript\" id=\"UYScript\" src=\"http://v1.uyan.cc/js/iframe.js?UYUserId=0\" async=\"\"></script>";
                        }
			switch($field_arr[1][$i]){
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[news:link]',LinkUrl('show','news','id',$row['CS_CID'],$row['CS_ID']));break;
				case 'pic':$datatmp=CS_ReplaceStr($datatmp,'[news:pic]',piclink('news',$row['CS_Pic']));break;
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[news:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[news:i]',$sorti);break;
				case 'color':$datatmp=CS_ReplaceStr($datatmp,'[news:color]',$row['CS_Color']);break;
				case 'stars':$datatmp=CS_ReplaceStr($datatmp,'[news:stars]',$row['CS_Reco']);break;
				case 'hits':$datatmp=CS_ReplaceStr($datatmp,'[news:hits]',$row['CS_Hits']);break;
				case 'rhits':$datatmp=CS_ReplaceStr($datatmp,'[news:rhits]',$row['CS_Rhits']);break;
				case 'zhits':$datatmp=CS_ReplaceStr($datatmp,'[news:zhits]',$row['CS_Zhits']);break;
				case 'yhits':$datatmp=CS_ReplaceStr($datatmp,'[news:yhits]',$row['CS_Yhits']);break;
				case 'classlink':$datatmp=CS_ReplaceStr($datatmp,"[news:classlink]",LinkUrl('list','news','id',$row['CS_CID'],$row['CS_ID']));break;
				case 'classnlink':$datatmp=CS_ReplaceStr($datatmp,'[news:classnlink]',LinkUrl('list','news','new',$row['CS_CID'],$row['CS_ID']));break;
				case 'classhlink':$datatmp=CS_ReplaceStr($datatmp,'[news:classhlink]',LinkUrl('list','news','hits',$row['CS_CID'],$row['CS_ID']));break;
				case 'classtlink':$datatmp=CS_ReplaceStr($datatmp,'[news:classtlink]',LinkUrl('list','news','reco',$row['CS_CID'],$row['CS_ID']));break;
				case 'classylink':$datatmp=CS_ReplaceStr($datatmp,'[news:classylink]',LinkUrl('list','news','yue',$row['CS_CID'],$row['CS_ID']));break;
				case 'classzlink':$datatmp=CS_ReplaceStr($datatmp,'[news:classzlink]',LinkUrl('list','news','zhou',$row['CS_CID'],$row['CS_ID']));break;
				case 'classrlink':$datatmp=CS_ReplaceStr($datatmp,'[news:classrlink]',LinkUrl('list','news','ri',$row['CS_CID'],$row['CS_ID']));break;
				case 'classname':$datatmp=CS_ReplaceStr($datatmp,"[news:classname]",getclass($row['CS_CID']));break;
				case 'classid':$datatmp=CS_ReplaceStr($datatmp,"[news:classid]",$row['CS_CID']);break;
				case 'pl':$datatmp=CS_ReplaceStr($datatmp,"[news:pl]",$comment);break;
				case 'laiyuan':$datatmp=CS_ReplaceStr($datatmp,"[news:laiyuan]",$row['CS_Laiyuan']);break;
				case 'uname':$datatmp=CS_ReplaceStr($datatmp,"[news:uname]",$row['CS_User']);break;
				case 'ulink':$datatmp=CS_ReplaceStr($datatmp,"[news:ulink]",userlink('index',getuser('uid',$row['CS_User'])));break;
				case 'uqq':$datatmp=CS_ReplaceStr($datatmp,"[news:uqq]",getuser('qq',$row['CS_User']));break;
				case 'usex':$datatmp=CS_ReplaceStr($datatmp,"[news:usex]",getuser('sex',$row['CS_User']));break;
				case 'ucity':$datatmp=CS_ReplaceStr($datatmp,"[news:ucity]",getuser('city',$row['CS_User']));break;
				case 'unichen':$datatmp=CS_ReplaceStr($datatmp,"[news:unichen]",getuser('nichen',$row['CS_User']));break;
				case 'upic':$datatmp=CS_ReplaceStr($datatmp,"[news:upic]",getuser('pic',$row['CS_User']));break;
				case 'uid':$datatmp=CS_ReplaceStr($datatmp,"[news:uid]",getuser('uid',$row['CS_User']));break;	
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;
				case 'content':
					$content=getlen($field_arr[2][$i],$field_arr[3][$i],stripslashes(html_entity_decode(h($row['CS_Content']))));
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$content);break;				
					break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					
					break;
				}//end switch		
			}//end for
			//$Mark_Text=CS_ReplaceStr($Mark_Text,$para,$data);
		}
		unset($field_arr);
		return $datatmp;		
}

//分类解析标签
function dataclass($para,$label,$row,$sorti){
	global $db;
	preg_match_all('/\[class:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
        $data_type="";
	if(!empty($field_arr)){
		preg_match('/{csdjcms:type\s+([\s\S]+?)}([\s\S]+?){\/csdjcms:type}/',$label,$type_arr);//判断是否二级分类嵌套
		if(!empty($type_arr)){
			$sqltype=Mark_Sql("type",$type_arr[1],$row['CS_ID']);
			$typeresult=$db->query($sqltype);
			$typenums=$db->num_rows($typeresult);
			if($typeresult && $typenums>0){
				$typei=1;
				while($row2=$db->fetch_array($typeresult)){
					$data_type.=datatype($type_arr[2],$type_arr[2],$row2,$typei);
					$typei=$typei+1;
				}
				$datatmp=CS_ReplaceStr($datatmp,$type_arr[0],$data_type);
			}else{
				$datatmp=CS_ReplaceStr($datatmp,$type_arr[0],'');	
			}
		}

		for($i=0;$i<count($field_arr[0]);$i++){

                        if($row['CS_SID']==1){
                                $fid="dance";
                        }else{
                                $fid="news";
                        }

			switch($field_arr[1][$i]){
				case 'name':$datatmp=CS_ReplaceStr($datatmp,'[class:name]',$row['CS_Name']);break;
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[class:link]',LinkUrl('list',$fid,'id',$row['CS_ID']));break;
				case 'nlink':$datatmp=CS_ReplaceStr($datatmp,'[class:nlink]',LinkUrl('list',$fid,'new',$row['CS_ID']));break;
				case 'hlink':$datatmp=CS_ReplaceStr($datatmp,'[class:hlink]',LinkUrl('list',$fid,'hits',$row['CS_ID']));break;
				case 'ylink':$datatmp=CS_ReplaceStr($datatmp,'[class:ylink]',LinkUrl('list',$fid,'yue',$row['CS_ID']));break;
				case 'zlink':$datatmp=CS_ReplaceStr($datatmp,'[class:zlink]',LinkUrl('list',$fid,'zhou',$row['CS_ID']));break;
				case 'rlink':$datatmp=CS_ReplaceStr($datatmp,'[class:rlink]',LinkUrl('list',$fid,'ri',$row['CS_ID']));break;
				case 'slink':$datatmp=CS_ReplaceStr($datatmp,'[class:slink]',LinkUrl('list',$fid,'fav',$row['CS_ID']));break;
				case 'xlink':$datatmp=CS_ReplaceStr($datatmp,'[class:xlink]',LinkUrl('list',$fid,'down',$row['CS_ID']));break;
				case 'tlink':$datatmp=CS_ReplaceStr($datatmp,'[class:tlink]',LinkUrl('list',$fid,'reco',$row['CS_ID']));break;
				case 'dlink':$datatmp=CS_ReplaceStr($datatmp,'[class:dlink]',LinkUrl('list',$fid,'ding',$row['CS_ID']));break;
				case 'count':$datatmp=CS_ReplaceStr($datatmp,'[class:count]',getclasscount($row['CS_ID'],$row['CS_SID']));break;
				case 'daycount':$datatmp=CS_ReplaceStr($datatmp,'[class:daycount]',getclasscount($row['CS_ID'],$row['CS_SID'],1));break;
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[class:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[class:i]',$sorti);break;
			}	
		}
	}
		unset($field_arr);
		return $datatmp;	
}

//二级分类
function datatype($para,$label,$row,$sorti){
	preg_match_all('/\[type:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){

                        if($row['CS_SID']==1){
                                $fid="dance";
                        }else{
                                $fid="news";
                        }

			switch($field_arr[1][$i]){
				case 'name':$datatmp=CS_ReplaceStr($datatmp,'[type:name]',$row['CS_Name']);break;			
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[type:link]',LinkUrl('list',$fid,'id',$row['CS_ID']));break;
				case 'nlink':$datatmp=CS_ReplaceStr($datatmp,'[type:nlink]',LinkUrl('list',$fid,'new',$row['CS_ID']));break;
				case 'hlink':$datatmp=CS_ReplaceStr($datatmp,'[type:hlink]',LinkUrl('list',$fid,'hits',$row['CS_ID']));break;
				case 'ylink':$datatmp=CS_ReplaceStr($datatmp,'[type:ylink]',LinkUrl('list',$fid,'yue',$row['CS_ID']));break;
				case 'zlink':$datatmp=CS_ReplaceStr($datatmp,'[type:zlink]',LinkUrl('list',$fid,'zhou',$row['CS_ID']));break;
				case 'rlink':$datatmp=CS_ReplaceStr($datatmp,'[type:rlink]',LinkUrl('list',$fid,'ri',$row['CS_ID']));break;
				case 'slink':$datatmp=CS_ReplaceStr($datatmp,'[type:slink]',LinkUrl('list',$fid,'fav',$row['CS_ID']));break;
				case 'xlink':$datatmp=CS_ReplaceStr($datatmp,'[type:xlink]',LinkUrl('list',$fid,'down',$row['CS_ID']));break;
				case 'tlink':$datatmp=CS_ReplaceStr($datatmp,'[type:tlink]',LinkUrl('list',$fid,'reco',$row['CS_ID']));break;
				case 'dlink':$datatmp=CS_ReplaceStr($datatmp,'[type:dlink]',LinkUrl('list',$fid,'ding',$row['CS_ID']));break;
				case 'count':$datatmp=CS_ReplaceStr($datatmp,'[type:count]',getclasscount($row['CS_ID'],$row['CS_SID']));break;
				case 'daycount':$datatmp=CS_ReplaceStr($datatmp,'[type:daycount]',getclasscount($row['CS_ID'],$row['CS_SID'],1));break;
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[type:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[type:i]',$sorti);break;
				}
			}
	}
		unset($field_arr);
		return $datatmp;	
}

//专集标签解析
function datatopic($para,$label,$row,$sorti){
	preg_match_all('/\[topic:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;		
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[topic:link]',LinkUrl('show','zj','id',$row['CS_CID'],$row['CS_ID']));break;			
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[topic:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[topic:i]',$sorti);break;
				case 'color':$datatmp=CS_ReplaceStr($datatmp,'[topic:color]',$row['CS_Color']);break;
				case 'hits':$datatmp=CS_ReplaceStr($datatmp,'[topic:hits]',$row['CS_Hits']);break;
				case 'rhits':$datatmp=CS_ReplaceStr($datatmp,'[topic:rhits]',$row['CS_Rhits']);break;
				case 'zhits':$datatmp=CS_ReplaceStr($datatmp,'[topic:zhits]',$row['CS_Zhits']);break;
				case 'yhits':$datatmp=CS_ReplaceStr($datatmp,'[topic:yhits]',$row['CS_Yhits']);break;
				case 'fxgs':$datatmp=CS_ReplaceStr($datatmp,'[topic:fxgs]',$row['CS_Fxgs']);break;
				case 'year':$datatmp=CS_ReplaceStr($datatmp,'[topic:year]',$row['CS_Year']);break;
				case 'yuyan':$datatmp=CS_ReplaceStr($datatmp,'[topic:yuyan]',$row['CS_Yuyan']);break;
				case 'diqu':$datatmp=CS_ReplaceStr($datatmp,'[topic:diqu]',$row['CS_Diqu']);break;
				case 'uname':$datatmp=CS_ReplaceStr($datatmp,'[topic:uname]',$row['CS_User']);break;
				case 'upic':$datatmp=CS_ReplaceStr($datatmp,'[topic:upic]',getuser('pic',$row['CS_User']));break;
				case 'uqq':$datatmp=CS_ReplaceStr($datatmp,'[topic:uqq]',getuser('qq',$row['CS_User']));break;
				case 'unichen':$datatmp=CS_ReplaceStr($datatmp,'[topic:unichen]',getuser('nichen',$row['CS_User']));break;
				case 'ulink':$datatmp=CS_ReplaceStr($datatmp,'[topic:ulink]',userlink('index',getuser('uid',$row['CS_User'])));break;
				case 'pic':$datatmp=CS_ReplaceStr($datatmp,'[topic:pic]',piclink('topic',$row['CS_Pic']));break;
				case 'stars':$datatmp=CS_ReplaceStr($datatmp,'[topic:stars]',$row['CS_Reco']);break;
				case 'tags':$datatmp=CS_ReplaceStr($datatmp,'[topic:tags]',HotSearch($row['CS_Tags']));break;
				case 'classlink':$datatmp=CS_ReplaceStr($datatmp,"[topic:classlink]",LinkUrl('list','zj','id',$row['CS_CID'],$row['CS_ID']));break;
				case 'classlink':$datatmp=CS_ReplaceStr($datatmp,"[topic:classnlink]",LinkUrl('list','zj','new',$row['CS_CID'],$row['CS_ID']));break;
				case 'classhlink':$datatmp=CS_ReplaceStr($datatmp,'[topic:classhlink]',LinkUrl('list','zj','hits',$row['CS_CID'],$row['CS_ID']));break;
				case 'classtlink':$datatmp=CS_ReplaceStr($datatmp,'[topic:classtlink]',LinkUrl('list','zj','reco',$row['CS_CID'],$row['CS_ID']));break;
				case 'classylink':$datatmp=CS_ReplaceStr($datatmp,'[topic:classylink]',LinkUrl('list','zj','yue',$row['CS_CID'],$row['CS_ID']));break;
				case 'classzlink':$datatmp=CS_ReplaceStr($datatmp,'[topic:classzlink]',LinkUrl('list','zj','zhou',$row['CS_CID'],$row['CS_ID']));break;
				case 'classrlink':$datatmp=CS_ReplaceStr($datatmp,'[topic:classrlink]',LinkUrl('list','zj','ri',$row['CS_CID'],$row['CS_ID']));break;
				case 'classname':$datatmp=CS_ReplaceStr($datatmp,"[topic:classname]",getclass($row['CS_CID']));break;
				case 'classid':$datatmp=CS_ReplaceStr($datatmp,"[topic:classid]",$row['CS_CID']);break;
				case 'count':$datatmp=CS_ReplaceStr($datatmp,"[topic:count]",gettopiccount($row['CS_ID'],$row['CS_SID']));break;
				case 'content':
					$content=getlen($field_arr[2][$i],$field_arr[3][$i],stripslashes(html_entity_decode(h($row['CS_Content']))));
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$content);break;
					break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					break;					
				}
			}
	}
		unset($field_arr);
		return $datatmp;		
}

//相册标签解析
function datapic($para,$label,$row,$sorti){
	preg_match_all('/\[pic:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;					
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[pic:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[pic:i]',$sorti);break;
				case 'url':$datatmp=CS_ReplaceStr($datatmp,'[pic:url]',piclink('pic',$row['CS_Pic']));break;
				case 'uname':$datatmp=CS_ReplaceStr($datatmp,'[pic:uname]',$row['CS_User']);break;
				case 'upic':$datatmp=CS_ReplaceStr($datatmp,'[pic:upic]',getuser('pic',$row['CS_User']));break;
				case 'uqq':$datatmp=CS_ReplaceStr($datatmp,'[pic:uqq]',getuser('qq',$row['CS_User']));break;
				case 'unichen':$datatmp=CS_ReplaceStr($datatmp,'[pic:unichen]',getuser('nichen',$row['CS_User']));break;
				case 'ulink':$datatmp=CS_ReplaceStr($datatmp,'[pic:ulink]',userlink('index',getuser('uid',$row['CS_User'])));break;
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[pic:link]',userlink('picx',getuser('uid',$row['CS_User']),$row['CS_ID']));break;
				case 'count':$datatmp=CS_ReplaceStr($datatmp,'[pic:count]',getpic('count',$row['CS_ID']));break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					break;	
				case 'content':
					$content=getlen($field_arr[2][$i],$field_arr[3][$i],stripslashes(html_entity_decode(h($row['CS_Content']))));
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$content);break;
					break;				
			}
		}
	}
	unset($field_arr);
	return $datatmp;		
}

//会员标签解析
function datauser($para,$label,$row,$sorti){
	preg_match_all('/\[user:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;					
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[user:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[user:i]',$sorti);break;
				case 'hits':$datatmp=CS_ReplaceStr($datatmp,'[user:hits]',$row['CS_Hits']);break;
				case 'qq':$datatmp=CS_ReplaceStr($datatmp,'[user:qq]',getuser('qq',$row['S_Name']));break;
				case 'loghits':$datatmp=CS_ReplaceStr($datatmp,'[user:loghits]',$row['CS_LogNum']);break;
				case 'email':$datatmp=CS_ReplaceStr($datatmp,'[user:email]',getuser('email',$row['S_Name']));break;
				case 'sex':$datatmp=CS_ReplaceStr($datatmp,'[user:sex]',getuser('sex',$row['S_Name']));break;
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[user:link]',userlink('index',$row['CS_ID']));break;
				case 'pic':$datatmp=CS_ReplaceStr($datatmp,'[user:pic]',piclink('logo',$row['CS_Logo']));break;
				case 'coin':$datatmp=CS_ReplaceStr($datatmp,'[user:coin]',$row['CS_Coin']);break;
				case 'city':$datatmp=CS_ReplaceStr($datatmp,'[user:city]',getuser('city',$row['S_Name']));break;
				case 'vip':$datatmp=CS_ReplaceStr($datatmp,'[user:vip]',getuser('vip',$row['CS_Name']));break;
				case 'fscount':$datatmp=CS_ReplaceStr($datatmp,'[user:fscount]',getusercount($row['CS_Name'],'fs'));break;
				case 'hycount':$datatmp=CS_ReplaceStr($datatmp,'[user:hycount]',getusercount($row['CS_Name'],'hy'));break;
				case 'musiccount':$datatmp=CS_ReplaceStr($datatmp,'[user:musiccount]',getusercount($row['CS_Name'],'dance'));break;
				case 'nichen':
					$nichen=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Nichen']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$nichen);break;
					break;
				case 'qianm':
                                        if($row['CS_Qianm']!=""){
                                             $Qianm=stripslashes(html_entity_decode(h($row['CS_Qianm'])));
                                        }else{
                                             $Qianm="这家伙很懒，什么也没有留下!";
                                        }
					$Qianm=getlen($field_arr[2][$i],$field_arr[3][$i],$Qianm);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$Qianm);break;
					break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					break;	
				case 'viptime':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_VipTime'])));
					break;				
				case 'endtime':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_EndTime'])));
					break;				
				case 'logtime':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_LogTime'])));
					break;				
				}
			}
	}
		unset($field_arr);
		return $datatmp;		
}

//友情链接
function datalink($para,$label,$row,$sorti){
	preg_match_all('/\[link:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;					
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[link:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[link:i]',$sorti);break;
				case 'url':$datatmp=CS_ReplaceStr($datatmp,'[link:url]',$row['CS_Url']);break;
				case 'pic':$datatmp=CS_ReplaceStr($datatmp,'[link:pic]',$row['CS_Pic']);break;
				}
			}
	}
		unset($field_arr);
		return $datatmp;		
}

//歌曲标签
function datatags($para,$label,$row,$sorti){
	preg_match_all('/\[tags:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){
				case 'name':
					$name=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Name']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],$name);break;
					break;					
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[tags:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[tags:i]',$sorti);break;
				case 'link':$datatmp=CS_ReplaceStr($datatmp,'[tags:link]',LinkUrl('so','dance','tags',urlencode($row['CS_Name']),1,1));break;
				case 'count':$datatmp=CS_ReplaceStr($datatmp,'[tags:count]',gettagscount($row['CS_Name'],'dance'));break;
				case 'tlink':$datatmp=CS_ReplaceStr($datatmp,'[tags:tlink]',LinkUrl('so','topic','tags',urlencode($row['CS_Name']),1,1));break;
				case 'tcount':$datatmp=CS_ReplaceStr($datatmp,'[tags:tcount]',gettagscount($row['CS_Name'],'topic'));break;
				}
			}
	}
		unset($field_arr);
		return $datatmp;		
}

//微薄标签
function datablog($para,$label,$row,$sorti){
	preg_match_all('/\[blog:\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/',$para,$field_arr);
	$datatmp=$label;
	if(!empty($field_arr)){
		for($i=0;$i<count($field_arr[0]);$i++){
			switch($field_arr[1][$i]){				
				case 'id':$datatmp=CS_ReplaceStr($datatmp,'[blog:id]',$row['CS_ID']);break;
				case 'i':$datatmp=CS_ReplaceStr($datatmp,'[blog:i]',$sorti);break;
				case 'uname':$datatmp=CS_ReplaceStr($datatmp,'[blog:uname]',$row['CS_User']);break;
				case 'upic':$datatmp=CS_ReplaceStr($datatmp,'[blog:upic]',getuser('pic',$row['CS_User']));break;
				case 'uqq':$datatmp=CS_ReplaceStr($datatmp,'[blog:uqq]',getuser('qq',$row['CS_User']));break;
				case 'unichen':$datatmp=CS_ReplaceStr($datatmp,'[blog:unichen]',getuser('nichen',$row['CS_User']));break;
				case 'ulink':$datatmp=CS_ReplaceStr($datatmp,'[blog:ulink]',userlink('index',getuser('uid',$row['CS_User'])));break;
				case 'content':
					$content=getlen($field_arr[2][$i],$field_arr[3][$i],$row['CS_Neir']);
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],facehtml(stripslashes(html_entity_decode(h($content)))));break;
					break;
				case 'time':
					$datatmp=CS_ReplaceStr($datatmp,$field_arr[0][$i],date(CS_ReplaceStr($field_arr[3][$i],'f','i'),strtotime($row['CS_AddTime'])));
					break;				
				}
			}
	}
		unset($field_arr);
		return $datatmp;		
}

//sql组织
function Mark_Sql($table,$para,$ids,$fid=''){
        $Ytable=CS_ReplaceStr($table,CS_SqlPrefix,''); //去掉表前缀
	$loop='';$order='';$sort='';$start='';$cid='';$stars='';$tid='';$sid=1;$hide='';
	preg_match_all('/([a-z0-9]+)=([a-z0-9|,]+)/',$para,$para_arr);
	if(!empty($para_arr)){
		for($i=0;$i<count($para_arr[0]);$i++){
			switch($para_arr[1][$i]){
				case 'loop':$loop=$para_arr[2][$i];break;
				case 'order':$order=$para_arr[2][$i];break;
				case 'sort':$sort=$para_arr[2][$i];break;
				case 'start':$start=$para_arr[2][$i];break;
				case 'cid':$cid=$para_arr[2][$i];break;
				case 'stars':$stars=$para_arr[2][$i];break;
				case 'tid':$tid=$para_arr[2][$i];break;
				case 'sid':$sid=$para_arr[2][$i];break;
				case 'hide':$hide=$para_arr[2][$i];break;				
			}
		}
			$sql="select * from `$table` where 1=1 ";
			if(isset($order)=="" or $order!="asc") $order="desc";	
			switch($Ytable){
				case 'dance':
					if(isset($start)=="" or $start==0) $start=1;
					if($sort=="id" or $fid=='id' ){
							$sort="CS_ID";
					}elseif($sort=='hits' or $fid=='hits'){
							$sort="CS_Hits";
					}elseif($sort=="rhits" or $fid=='ri'){
							$sort="CS_Rhits";
					}elseif($sort=="zhits" or $fid=='zhou'){
							$sort="CS_Zhits";
					}elseif($sort=="yhits" or $fid=='yue'){
							$sort="CS_Yhits";
					}elseif($sort=="shits" or $fid=='fav'){
							$sort="CS_Shits";
					}elseif($sort=="xhits" or $fid=='down'){
							$sort="CS_Xhits";
					}elseif($sort=="stars" or $fid=='reco'){
							$sort="CS_Reco";
					}elseif($sort=="dhits" or $fid=='ding'){
							$sort="CS_Dhits";
					}elseif($sort=="play" or $fid=='play'){
							$sort="CS_PlayTime";
					}elseif($sort=="rand"){
							$sort='rand()';
					}else{
							$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}		
				  	if($cid!="all" and $cid!="" and $cid!="auto"){
						$cid=getChild($cid);
						$sql.=" and CS_CID in ($cid) ";
					}elseif($cid=="auto" and $ids!=""){
					 	$ids=getChild($ids);
					 	$sql.=" and CS_CID in($ids) ";
					}	
					  
					 if($tid!="all" and $tid!="" and $tid!="auto" ){
						 $sql.=" and CS_TID in ($tid)";
					 }elseif($tid=='auto'){
						 $sql.=" and CS_TID in ($ids)";
					 }elseif($tid=='all'){
						 $sql.=" and CS_TID >0";
					 }
					 
				  	if($stars!="" and $stars!="all") $sql.=" and  CS_Reco in (".$stars.")";
				  	$sql.=" and CS_YID=0 and CS_CID<>0  Order by ".$sort." ".$order." ";  						  
					if($loop!="all" and $loop!="") $sql.="limit ".($start-1).",".($loop)."";
					break;
				case 'news':
					if(isset($start)=="" or $start==0) $start=1;
					if($sort=="id" or $fid=='id'){
							$sort="CS_ID";
					}elseif($sort=="hits" or $fid=='hits'){
							$sort="CS_Hits";
					}elseif($sort=="rhits" or $fid=='ri'){
							$sort="CS_Rhits";
					}elseif($sort=="zhits" or $fid=='zhou'){
							$sort="CS_Zhits";
					}elseif($sort=="yhits" or $fid=='yue'){
							$sort="CS_Yhits";
					}elseif($sort=="stars" or $fid=='reco'){
							$sort="CS_Reco";
					}elseif($sort=="rand"){
							$sort='rand()';
					}else{
							$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}
												
				  	if($cid!="all" and $cid!="" and $cid!="auto"){
						$cid=getChild($cid);
						$sql.=" and CS_CID in ($cid) ";
					}elseif($cid=="auto" and $ids!=""){
					 	$ids=getChild($ids);
					 	$sql.=" and CS_CID in($ids) ";
					}
					  
					if($tid!="all" and $tid!="" and $tid!="auto" ){
						 $sql.=" and CS_TID in ($tid)";
					}elseif($tid=='auto'){
						 $sql.=" and CS_TID in ($ids)";
					}elseif($tid=='all'){
						 $sql.=" and CS_TID >0";
					}
					 
				  	if($stars!="" and $stars!="all") $sql.=" and  CS_Reco in (".$stars.")";
				  	$sql.=" and CS_YID=0 and CS_CID<>0  Order by ".$sort." ".$order." ";  						  
					if($loop!="all" and $loop!="") $sql.="limit ".($start-1).",".($loop)."";				
					break;
				case 'class':	
					if($sort=="" or $sort=="xid"){
						$sort="CS_XID";
                                                $order="asc";
					}elseif($sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="CS_XID";
                                                $order="asc";
					}	

					if($cid!="all" and $cid!="" and $cid!="auto"){
						$sql.=" and CS_ID in ($cid) and CS_SID=".$sid."";					
					}else{
						$sql.=" and CS_FID=0 and CS_SID=".$sid."";	
                                        }

					$sql.=" and CS_YID=0 order by ".$sort." ".$order.""	;				
					break;
				case 'type':
					if($sort=="" or $sort=="xid"){
						$sort="CS_XID";
                                                $order="asc";
					}elseif($sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="CS_XID";
                                                $order="asc";
					}			
	
				  	$sql="select * from ".Getdbname('class')." where 1=1 ";
				  	if($cid!="all" and $cid!="" and $cid!="auto"){				
						  $sql.=" and CS_FID in ($cid) ";				
					}elseif($cid=="auto"){
						  $sql.=" and CS_FID=".$ids." ";		
					}
					$sql.=" and CS_YID=0 order by ".$sort." ".$order." ";
					break;
				case 'topic':
					if($sort=="id" or $fid=='id'){
							$sort="CS_ID";
					}elseif($sort=="hits" or $fid='hits'){
							$sort="CS_Hits";
					}elseif($sort=="rhits" or $fid=='ri'){
							$sort="CS_Rhits";
					}elseif($sort=="zhits" or $fid=='zhou'){
							$sort="CS_Zhits";
					}elseif($sort=="yhits" or $fid=='yue'){
							$sort="CS_Yhits";
					}elseif($sort=="stars" or $fid=='reco'){
							$sort="CS_Reco";
					}elseif($sort=="rand"){
							$sort='rand()';
					}else{
							$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}
	
					if($tid!="all" and $tid!="" and $tid!="auto" ){
						if($sid==1){
							$sql.=" and CS_ID in ($tid) and CS_SID=1";
						}elseif($sid==2){
							$sql.=" and CS_ID in ($tid) and S_SID=2";
						}else{
							$sql.=" and CS_ID in ($tid)";
						}	
					}elseif($tid=='auto'){
						$sql.=" and CS_ID in ($ids)";
					}else{
						if($sid==1){
							$sql.=" and CS_SID=1";
						}elseif($sid==2){
							$sql.=" and CS_SID=2";
						}					
					}
	
				  	if($cid!="all" and $cid!="" and $cid!="auto"){
						$cid=getChild($cid);
						$sql.=" and CS_CID in ($cid) ";
					}elseif($cid=="auto" and $ids!=""){
					 	$ids=getChild($ids);
					 	$sql.=" and CS_CID in($ids) ";
					}
				  	if($stars!='' and $stars!="all") $sql.=" and  CS_Reco in (".$stars.")";
					$sql.=" and CS_YID=0  Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";				
					break;
				case 'pic':
					if($sort=="" or $sort=="time"){
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}elseif($sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}
	
					$sql.=" Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";
					break;
				case 'blog':
					if($sort=="" or $sort=="time"){
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}elseif($sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}
	
					$sql.=" Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";
					break;
				case 'user':
					if($sort=="" or $sort=="time"){
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}elseif($sort=="id"){
						$sort="CS_ID";
					}elseif($sort=="coin"){
						$sort="CS_Cion";
					}elseif($sort=="rmb"){
						$sort="CS_RMB";
					}elseif($sort=="hits"){
						$sort="CS_Hits";
					}elseif($sort=="loghits"){
						$sort="CS_LogNum";
					}elseif($sort=="logtime"){
						$sort="UNIX_TIMESTAMP(CS_LogTime)";
					}elseif($sort=="viptime"){
						$sort="UNIX_TIMESTAMP(CS_EndTime)";
					}else{
						$sort="UNIX_TIMESTAMP(CS_AddTime)";
					}
	
				  	if($cid=="1"){
						$sql.=" and CS_Vip=1 ";
					}

				  	if($cid=="0"){
						$sql.=" and CS_Vip=0 ";
					}
	
				  	if($tid=="yes"){
						$sql.=" and CS_TID=1 ";
					}

					$sql.=" Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";
					break;
				case 'link':
					if($sort=="" or $sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="CS_ID";
					}
					if($cid!="all" and $cid!="")$sql.=" and  CS_CID in ($cid) ";
					$sql.=" and CS_YID=0";	
					$sql.=" Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";
					break;
				case 'tags':
					if($sort=="" or $sort=="id"){
						$sort="CS_ID";
					}else{
						$sort="CS_ID";
					}
					if($cid!="all" and $cid!="")$sql.=" and  CS_CID in ($cid) ";
					$sql.=" Order by ".$sort." ".$order." ";
					if($loop!="all" and $loop!="") $sql.="limit ".($loop)."";
					break;
				default:
                                        echo Web_Error('抱歉标签{csdjcms:'.$Ytable.' ...}错误，该标签目前还不能使用，请联系开发商程氏，QQ:848769359','');
                                        exit();
				}
				unset($para_arr);
				return $sql;
		}
}

//舞曲分类列表
function SpanDanceList($ids,$sort='id',$pages=1){
	global $db;
	//获取分类名和id
	$data_content="";
	$row=$db->getRow("select * from ".Getdbname('class')." where CS_ID=".$ids." and CS_SID=1");
	if($row){
		if(IsNull($row['CS_Template']) && file_exists(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template'])){
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template']);
		}else{
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."dance-list.html");
		}	
	}else{
                        $Mark_Text=Web_Error('对不起,找不到相关的数据信息!',CS_WebPath);
                        return $Mark_Text;
	}
        //SEO标题
        if (empty($row['CS_Title'])){
               $seo_title=$row['CS_Name']." - ".CS_WebName;
        }else{
               $seo_title=$row['CS_Title'];
        }
        //SEO关键词
        if (empty($row['CS_Keywords'])){
               $seo_keywords=$row['CS_Name']."mp3,".$row['CS_Name']."视听,".$row['CS_Name']."下载";
        }else{
               $seo_keywords=$row['CS_Keywords'];
        }
        //SEO描述
        if (empty($row['CS_Description'])){
               $seo_description=$row['CS_Name']." 是由".CS_WebName."提供视听和下载。";
        }else{
               $seo_description=$row['CS_Description'];
        }
	$Mark_Text=topandbottom($Mark_Text);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[dance:classname]",$row['CS_Name']);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}",$seo_title);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",$seo_keywords);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",$seo_description);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[dance:classlink]",LinkUrl('list','dance','id',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classnlink]',LinkUrl('list','dance','new',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classplink]',LinkUrl('list','dance','play',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classhlink]',LinkUrl('list','dance','hits',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classtlink]',LinkUrl('list','dance','reco',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classxlink]',LinkUrl('list','dance','down',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classslink]',LinkUrl('list','dance','fav',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classylink]',LinkUrl('list','dance','yue',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classzlink]',LinkUrl('list','dance','zhou',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:classrlink]',LinkUrl('list','dance','ri',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[dance:classid]",$row['CS_ID']);
	//预先除了分页
	$pagenum=getpagenum($Mark_Text);
	preg_match_all('/{csdjcms:dance(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:dance}/',$Mark_Text,$page_arr);//判断是否有分页标识
	if(!empty($page_arr) && !empty($page_arr[2])){
		$sqlstr=Mark_Sql(Getdbname('dance'),$page_arr[1][0],$ids,$sort);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'list','dance',$sort,$row['CS_ID'],1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);
		if($recount==0){
			$data_content="<div align=center><strong><font style=font-size:12px;>该分类暂无数据！</font></strong></div>";
		}else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datadance($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
					}
				}
			}// end if recount
		$Mark_Text=Page_Mark($Mark_Text,$Arr);	
		$Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		unset($Arr);
                }
	unset($page_arr);
	$Mark_Text=	Common_Mark($Mark_Text,$ids);
	return $Mark_Text;
}

//文章分类列表
function SpanNewsList($ids,$sort='id',$pages=1){
	global $db;
	//获取分类名和id
	$data_content="";
	$row=$db->getRow("select * from ".Getdbname('class')." where CS_ID=".$ids." and CS_SID=2");
	if($row){
		if(IsNull($row['CS_Template']) && file_exists(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template'])){
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template']);
		}else{
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."news-list.html");
		}	
	}else{
                        $Mark_Text=Msg_Error('对不起,找不到相关的数据信息!',CS_WebPath);
                        return $Mark_Text;
	}
        //SEO标题
        if (empty($row['CS_Title'])){
               $seo_title=$row['CS_Name']." - ".CS_WebName;
        }else{
               $seo_title=$row['CS_Title'];
        }
        //SEO关键词
        if (empty($row['CS_Keywords'])){
               $seo_keywords=$row['CS_Name']."文章,".$row['CS_Name']."咨讯";
        }else{
               $seo_keywords=$row['CS_Keywords'];
        }
        //SEO描述
        if (empty($row['CS_Description'])){
               $seo_description=$row['CS_Name']." 是由".CS_WebName."提供发布和阅读。";
        }else{
               $seo_description=$row['CS_Description'];
        }
	$Mark_Text=topandbottom($Mark_Text);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[news:classname]",$row['CS_Name']);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}",$seo_title);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",$seo_keywords);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",$seo_description);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[news:classlink]",LinkUrl('list','news','id',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classhlink]',LinkUrl('list','news','hits',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classtlink]',LinkUrl('list','news','reco',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classylink]',LinkUrl('list','news','yue',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classzlink]',LinkUrl('list','news','zhou',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classrlink]',LinkUrl('list','news','ri',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classnlink]',LinkUrl('list','news','new',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:classrlink]',LinkUrl('list','news','reco',$row['CS_ID']));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[news:classid]",$row['CS_ID']);
	//预先除了分页
	$pagenum=getpagenum($Mark_Text);
	preg_match_all('/{csdjcms:news(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:news}/',$Mark_Text,$page_arr);//判断是否有分页标识
	if(!empty($page_arr) && !empty($page_arr[2])){
		$sqlstr=Mark_Sql(Getdbname('news'),$page_arr[1][0],$ids,$sort);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'list','news',$sort,$row['CS_ID'],1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);
		if($recount==0){
			$data_content="<div align=center><strong><font style=font-size:12px;>该分类暂无数据！</font></strong></div>";
		}else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datanews($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
					}
				}
			}// end if recount
		$Mark_Text=Page_Mark($Mark_Text,$Arr);	
		$Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		unset($Arr);
                }
	unset($page_arr);
	$Mark_Text=	Common_Mark($Mark_Text,$ids);
	return $Mark_Text;
}

//专集列表页面
function SpanTopicList($pages,$sort='id',$fid='dance'){
	global $db;
        $ids="";
	$data_content="";
        if($fid=='news'){
	      $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."topic-news.html");
        }else{
	      $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."topic-dance.html");
        }
	$Mark_Text=topandbottom($Mark_Text);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}","音乐专集 - ".CS_WebName);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",stripslashes(html_entity_decode(CS_Key)));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",stripslashes(html_entity_decode(CS_Description)));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:sort]",$sort);
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classlink]",LinkUrl('list','zj','id'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classhlink]",LinkUrl('list','zj','hits'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classtlink]",LinkUrl('list','zj','reco'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classylink]",LinkUrl('list','zj','yue'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classzlink]",LinkUrl('list','zj','zhou'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classrlink]",LinkUrl('list','zj','ri'));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classnlink]",LinkUrl('list','zj','time'));
	$pagenum=getpagenum($Mark_Text);
	preg_match_all('/{csdjcms:topic(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:topic}/',$Mark_Text,$page_arr);//判断是否有分页标识
	if(!empty($page_arr) && !empty($page_arr[2])){
		$sqlstr=Mark_Sql(Getdbname('topic'),$page_arr[1][0],$ids,$sort);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'list','zj',$sort,1,1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);
		if($recount==0){
			$data_content="<div align=center><strong><font style=font-size:12px;>暂无专集数据！</font></strong></div>";
		}else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datatopic($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
				}
			}
		}// end if recount
		$Mark_Text=Page_Mark($Mark_Text,$Arr);	
		$Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		unset($Arr);
	}
	unset($page_arr);
	$Mark_Text=	Common_Mark($Mark_Text,$ids);
	return $Mark_Text;	
}

//专集内容页
function SpanTopicShow($ids,$sort='id',$pages=1){
	global $db;
	$data_content="";
	$sqlstr2="select * from ".Getdbname('topic')." where CS_ID=".$ids." and CS_YID=0";
	$row=$db->getrow($sqlstr2);
	if($row){
		if($row['CS_SID']==1){
			$Table='dance';
                        $Template="topic-dance-show.html";
		}else{
			$Table='news';
                        $Template="topic-news-show.html";
		}
		if(IsNull($row['CS_Template']) && file_exists(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template'])){
			  $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template']);

		}else{
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$Template);
		}
                if(CS_Plmode==0){
			$comment="<script language='javascript' src='".CS_WebPath."public/js/plajax.js'></script><script>var cs_sid='3';var cs_did='".$row['CS_ID']."';var cs_path='".CS_WebPath."';getpllist('1','".$row['CS_ID']."','3');</script><div id='csdjcms_pl'><div style='padding:5px;text-align:center;'><img src='".CS_WebPath."public/images/load.gif'/>&nbsp;&nbsp;评论载入中，请稍候.....</div></div>";
                }elseif(CS_Plmode==2){
			$comment="<div style='padding:5px;text-align:center;'>&nbsp;&nbsp;评论已经被站长关闭!</div>";
                }else{
			$comment="<div id=\"uyan_frame\"></div><script type=\"text/javascript\" id=\"UYScript\" src=\"http://v1.uyan.cc/js/iframe.js?UYUserId=0\" async=\"\"></script>";
                }
                //SEO标题
                if (empty($row['CS_Title'])){
                       $seo_title=$row['CS_Name']."_".CS_WebName;
                }else{
                       $seo_title=$row['CS_Title'];
                }
                //SEO关键词
                if (empty($row['CS_Keywords'])){
                       $seo_keywords=$row['CS_Name']."专集,".$row['CS_Name']."专题";
                }else{
                       $seo_keywords=$row['CS_Keywords'];
                }
                //SEO描述
                if (empty($row['CS_Description'])){
                       $seo_description=$row['CS_Name']." 是由".CS_WebName."提供视听和下载。";
                }else{
                       $seo_description=$row['CS_Description'];
                }
		$Mark_Text=topandbottom($Mark_Text);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}",$seo_title);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",$seo_keywords);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",$seo_description);
		$pagenum=getpagenum($Mark_Text);
		preg_match_all('/{csdjcms:dance(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:dance}/',$Mark_Text,$page_arr);//判断是否有分页标识
		if(!empty($page_arr) && !empty($page_arr[2])){
			$sqlstr=Mark_Sql(Getdbname($Table),$page_arr[1][0],$ids,$sort);
			$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'show','zj',$sort,$row['CS_CID'],$row['CS_ID'],$pages);//sql,每页显示条数
			$result=$db->query($Arr[2]);
			$recount=$db->num_rows($result);
			if($recount==0){
				$data_content="<div align=center><strong><font style=font-size:12px;>该专集暂无数据！</font></strong></div>";
			}else{
				if($result){
					$sorti=1;
					while ($row2 = $db ->fetch_array($result)){
						switch($Table){
							case 'dance':$datatmp=datadance($page_arr[0][0],$page_arr[3][0],$row2,$sorti);break;
							case 'news':$datatmp=datanews($page_arr[0][0],$page_arr[3][0],$row2,$sorti);break;
							default :$datatmp=datadance($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
							}
						$sorti=$sorti+1;
						$data_content.=$datatmp;
						}
					}
				}// end if recount
			$Mark_Text=Page_Mark($Mark_Text,$Arr);	
			$Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
			unset($Arr);
			}
		$Mark_Text=	Common_Mark($Mark_Text,$ids);
		unset($page_arr);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:name]",$row['CS_Name']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:content]",stripslashes(html_entity_decode(h($row['CS_Content']))));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:hits]",$row['CS_Hits']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:rhits]",$row['CS_Rhits']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:zhits]",$row['CS_Zhits']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:yhits]",$row['CS_Yhits']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:stars]",$row['CS_Reco']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:uname]",$row['CS_User']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:count]",gettopiccount($row['CS_ID'],$row['CS_SID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:ulink]",userlink('index',getuser('uid',$row['CS_User'])));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:unichen]",getuser('nichen',$row['CS_User']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:pic]",piclink('topic',$row['CS_Pic']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:fxgs]",$row['CS_Fxgs']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:year]",$row['CS_Year']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:yuyan]",$row['CS_Yuyan']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:diqu]",$row['CS_Diqu']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:link]",LinkUrl('show','zj','id',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classlink]",LinkUrl('show','zj','id',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classhlink]",LinkUrl('show','zj','hits',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classtlink]",LinkUrl('show','zj','reco',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classylink]",LinkUrl('show','zj','yue',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classzlink]",LinkUrl('show','zj','zhou',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classrlink]",LinkUrl('show','zj','ri',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classnlink]",LinkUrl('show','zj','new',$row['CS_CID'],$row['CS_ID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classname]",getclass($row['CS_CID']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:classid]",$row['CS_CID']);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:tags]",HotSearch($row['CS_Tags']));
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[topic:pl]",$comment);
 		if(preg_match('/\[topic:time\s*([0-9a-zA-Z]+)([\s]*[len|style]*)[=]??([\da-zA-Z\-\\\\:\s]*)\]/', $Mark_Text, $field_arr)){  //解析时间标签
 			 $Ytime="[topic:time ".$field_arr[1]."=".$field_arr[3]."]";
		         $Mark_Text=CS_ReplaceStr($Mark_Text,$Ytime,date(CS_ReplaceStr($field_arr[3],'f','i'),strtotime($row['CS_AddTime'])));
		}

                //静态模式,动态人气
                if(CS_Webmode==3){
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[topic:hits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=hits&id=".$ids."&type=topic></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[topic:rhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=rhits&id=".$ids."&type=topic></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[topic:zhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=zhits&id=".$ids."&type=topic></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[topic:yhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=yhits&id=".$ids."&type=topic></script>");
                }
		$Mark_Text.="<script src=".CS_WebPath."public/hits.php?id=".$ids."&type=topic></script>";//增加人气
		return $Mark_Text;		
	}else{
                $Mark_Text=Msg_Error('没有找到该专集或者该专集还没有审核！',CS_WebPath);
                return $Mark_Text;
	}
}

//舞曲播放页
function SpanDancePlay($ids){
	global $db;
	$row=$db->getRow("select * from ".Getdbname('dance')." where CS_ID=".$ids." and cs_yid=0");
	if($row){
		if(IsNull($row['CS_Template']) && file_exists(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template'])){
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$row['CS_Template']);

		}else{
			$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."dance-play.html");
		}	
                //SEO标题
                if (empty($row['CS_Title'])){
                       $seo_title=$row['CS_Name']."_".CS_WebName;
                }else{
                       $seo_title=$row['CS_Title'];
                }
                //SEO关键词
                if (empty($row['CS_Keywords'])){
                       $seo_keywords=$row['CS_Name'];
                }else{
                       $seo_keywords=$row['CS_Keywords'];
                }
                //SEO描述
                if (empty($row['CS_Description'])){
                       $seo_description=CS_WebName."提供,".$row['CS_Name']."视听下载。";
                }else{
                       $seo_description=$row['CS_Description'];
                }
                //播放器
                $CS_player="<script type=\"text/javascript\" src=\"".CS_WebPath."public/player/play.php?id=".$ids."\"></script>";
		$Mark_Text=topandbottom($Mark_Text);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}",$seo_title);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",$seo_keywords);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",$seo_description);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[dance:player]",$CS_player);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"[dance:tags]",HotSearch($row['CS_Tags']));

                //静态模式,动态人气
                if(CS_Webmode==3){
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:hits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=hits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:shits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=shits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=xhits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:rhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=rhits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:zhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=zhits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:yhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=yhits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:dhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=dhits&id=".$ids."&type=dance></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:chits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=chits&id=".$ids."&type=dance></script>");
                }

		$Mark_Text=Common_Mark($Mark_Text,$row['CS_CID']);
		//舞曲上下曲开始
		$rowu=$db->getrow("Select CS_ID,CS_Name,CS_CID from ".Getdbname('dance')." where CS_ID<$ids and CS_YID=0 order by CS_ID desc");
		if($rowu){
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:sid]',$rowu['CS_ID']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:sname]',$rowu['CS_Name']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:slink]',LinkUrl('play','dance','id',$rowu['CS_CID'],$rowu['CS_ID']));
		}else{
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:sid]','0');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:sname]','没有了');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:slink]','#');
		}
		$rowd=$db->getrow("Select CS_ID,CS_Name,CS_CID from ".Getdbname('dance')." where CS_ID>$ids and CS_YID=0 order by CS_ID asc");
		if($rowd){
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xid]',$rowd['CS_ID']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xname]',$rowd['CS_Name']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xlink]',LinkUrl('play','dance','id',$rowd['CS_CID'],$rowd['CS_ID']));
		}else{
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xid]','0');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xname]','没有了');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[dance:xlink]','#');
		}
		$Mark_Text=datadance($Mark_Text,$Mark_Text,$row,'1'); //全部解析
		$Mark_Text.="<script src=".CS_WebPath."public/hits.php?id=".$ids."&type=dance></script>";//增加人气

		return $Mark_Text;
	}else{
                $Mark_Text=Msg_Error('对不起,该歌曲不存在或者正在审核中!',CS_WebPath);
                return $Mark_Text;
	}
}

//文章内容页面
function SpanNewsShow($ids){
	global $db;
	$row=$db->getRow("select * from ".Getdbname('news')." where CS_ID=".$ids." and cs_yid=0");
	if($row){
		$Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."news-show.html");
                //SEO标题
                if (empty($row['CS_Title'])){
                       $seo_title=$row['CS_Name']."_".CS_WebName;
                }else{
                       $seo_title=$row['CS_Title'];
                }
                //SEO关键词
                if (empty($row['CS_Keywords'])){
                       $seo_keywords=$row['CS_Name'];
                }else{
                       $seo_keywords=$row['CS_Keywords'];
                }
                //SEO描述
                if (empty($row['CS_Description'])){
                       $seo_description=html_entity_decode(CS_Description);
                }else{
                       $seo_description=$row['CS_Description'];
                }
		$Mark_Text=topandbottom($Mark_Text);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}",$seo_title);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",$seo_keywords);
		$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",$seo_description);

                //静态模式,动态人气
                if(CS_Webmode==3){
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:hits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=hits&id=".$ids."&type=news></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:rhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=rhits&id=".$ids."&type=news></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:zhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=zhits&id=".$ids."&type=news></script>");
			$Mark_Text=CS_ReplaceStr($Mark_Text,'[news:yhits]',"<script src=".CS_WebPath."public/hits.php?ac=dt&op=yhits&id=".$ids."&type=news></script>");
                }

		$Mark_Text=Common_Mark($Mark_Text,$row['CS_CID']);

		//文章上下编开始
		$rowu=$db->getrow("Select CS_ID,CS_Name,CS_CID from ".Getdbname('news')." where CS_ID<$ids and CS_YID=0 order by CS_ID desc");
		if($rowu){
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:sid]',$rowu['CS_ID']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:sname]',$rowu['CS_Name']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:slink]',LinkUrl(2,1,$rowu['CS_CID'],$rowu['CS_ID']));
		}else{
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:sid]','0');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:sname]','没有了');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:slink]','#');
		}
		$rowd=$db->getrow("Select CS_ID,CS_Name,CS_CID from ".Getdbname('news')." where CS_ID>$ids and CS_YID=0 order by CS_ID asc");
		if($rowd){
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xid]',$rowd['CS_ID']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xname]',$rowd['CS_Name']);
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xlink]',LinkUrl(2,1,$rowd['CS_CID'],$rowd['CS_ID']));
		}else{
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xid]','0');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xname]','没有了');
		       $Mark_Text=CS_ReplaceStr($Mark_Text,'[news:xlink]','#');
		}

		$Mark_Text=datanews($Mark_Text,$Mark_Text,$row,'1');
		$Mark_Text.="<script src=".CS_WebPath."public/hits.php?id=".$ids."&type=news></script>";//增加人气
		return $Mark_Text;
	}else{
                $Mark_Text=Msg_Error('对不起,找不到相关的数据信息!',CS_WebPath);
                return $Mark_Text;
	}
}

//歌曲联播页面
function SpanPlaysong($lbid){
	global $db;
          	if(empty($lbid) || $lbid=='all'){
                       $lbid='';
	               global $db;
	               $sql="select * from ".Getdbname('dance')." where CS_YID=0 order by rand() desc";
	               $rs=$db->query($sql);
	               $num=$db->num_rows($rs);
	               if($num==0){
	               	  $lbid=$lbid.'';
	               }else{
		          $nums=30;
		          if($num<$nums){
			          $j=$num;
		          }else{
			          $j=$nums;
		          }
		          for($i=0;$i<$j;$i++){
			          $row=$db->fetch_array($rs);
			          $lbid=$lbid.$row["CS_ID"].",";
                          }
		          $lbid=$lbid.']';
		          $lbid=CS_ReplaceStr($lbid,",]","");
	               }
          	}
                if(substr($lbid,-1)==',') $lbid=substr($lbid,0,-1);
          	if(file_exists(_CSDJ_ROOT_.CS_Templateurl."dance-playsong.html")){
	     	      $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl."dance-playsong.html");
		      $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}","歌曲联播 - ".CS_WebName);
		      $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",stripslashes(html_entity_decode(CS_Key)));
		      $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",stripslashes(html_entity_decode(CS_Description)));
	       	      $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:lbid}",$lbid);
	    	      $Mark_Text=Common_Mark($Mark_Text,0);
          	}else{
	    	      $Mark_Text=Web_Error('dance-playsong.html模板文件不存在！');
          	}
                return $Mark_Text;
}


//搜索页面
function SpanSearch($type,$tid,$key,$pages){
        $Tible="so-".$type.".html";
        if($tid=='tags') $Tible="so-".$type."-tags.html";
	global $db;
        if($tid=='tags' && file_exists(_CSDJ_ROOT_.CS_Templateurl.$Tible)){
                $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$Tible);
	        $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}","按标签 - ".$key);
        }elseif($tid!='tags' && file_exists(_CSDJ_ROOT_.CS_Templateurl.$Tible)){
                $Mark_Text=@file_get_contents(_CSDJ_ROOT_.CS_Templateurl.$Tible);
	        $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:title}","搜索关键词 - ".$key);
        }else{
	        $Mark_Text=Web_Error($Tible.'模板文件不存在！');
                return $Mark_Text;
                exit();
        }
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:keywords}",stripslashes(html_entity_decode($key)));
	$Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:description}",stripslashes(html_entity_decode(CS_Description)));
        $Mark_Text=topandbottom($Mark_Text);
        $Mark_Text=CS_ReplaceStr($Mark_Text,"{csdjcms:sokey}",$key);
	//预先除了分页
	$pagenum=getpagenum($Mark_Text);
        $data_content="";
        if($type=='dance'){
	     preg_match_all('/{csdjcms:dance(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:dance}/',$Mark_Text,$page_arr);
	     if(!empty($page_arr) && !empty($page_arr[2])){
		$zimu_arr=array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		$zimu_arr1=array(-20319,-20283,-19775,-19218,-18710,-18526,-18239,-17922,-1,-17417,-16474,-16212,-15640,-15165,-14922,-14914,-14630,-14149,-14090,-13318,-1,-1,-12838,-12556,-11847,-11055);
		$zimu_arr2=array(-20284,-19776,-19219,-18711  ,-18527,-18240,-17923,-17418,-1,-16475,-16213,-15641,-15166,-14923,-14915,-14631,-14150,-14091,-13319,-12839,-1,-1,-12557,-11848,-11056,-2050);
                
		if($tid=='zm' && in_array(strtoupper($key),$zimu_arr)){  //按字母搜索
			$posarr=array_keys($zimu_arr,strtoupper($key));
			$pos=$posarr[0];
			$sqlstr="SELECT * FROM ".Getdbname('dance')." where CS_YID=0 and ((ord( substring( CS_Name, 1, 1 ) ) -65536>=".($zimu_arr1[$pos])." and  ord( substring( CS_Name, 1, 1 ) ) -65536<=".($zimu_arr2[$pos]).")) or UPPER(substring( CS_Name, 1, 1 ))='".$zimu_arr[$pos]."'";
		}elseif($tid=='tags'){
                        $sqlstr="select * from ".Getdbname('dance')." where CS_YID=0 and CS_Tags like '%".$key."%'  order by CS_AddTime desc";
		}else{
                        $sqlstr="select * from ".Getdbname('dance')." where CS_YID=0 and CS_Tags like '%".$key."%' or CS_Name like '%".$key."%' or CS_Singer like '%".$key."%' or CS_Year like '%".$key."%'  order by CS_AddTime desc";
                }
  	        $res=$db -> query($sqlstr);
 	        $nums= $db -> num_rows($res);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'so',$type,$tid,urlencode($key),1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);

		if($recount==0){
                     if($tid=='tags'){
			$data_content.="<div align=center><a href=http://www.csdj.so/?keyword=".$key."><strong>对不起,《<font color=#FF0000>".$key."</font>》标签下没有数据,去歌曲库搜索!</strong></a></div>";
                     }else{
			$data_content.="<div align=center><a href=http://www.csdj.so/?keyword=".$key."><strong>对不起,没有找到《<font color=#FF0000>".$key."</font>》相关数据,去歌曲库搜索!</strong></a></div>";
                     }
                }else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datadance($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
				}
			}
                }
		 $Mark_Text=Page_Mark($Mark_Text,$Arr);	
		 $Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		 unset($Arr);
             }
             unset($page_arr);

        }elseif($type=='news'){
	     preg_match_all('/{csdjcms:news(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:news}/',$Mark_Text,$page_arr);
                $sqlstr="select * from ".Getdbname('news')." where CS_YID=0 and CS_Name like '%".$key."%'  order by CS_AddTime desc";

  	        $res=$db -> query($sqlstr);
 	        $nums= $db -> num_rows($res);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'so',$type,$tid,urlencode($key),1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);

		if($recount==0){
			$data_content.="<div align=center><strong><font color=#FF0000>对不起,没有找到《".$key."》相关数据!</font></strong></div>";
                }else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datanews($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
				}
			}
                }
		 $Mark_Text=Page_Mark($Mark_Text,$Arr);	
		 $Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		 unset($Arr);
                 unset($page_arr);

        }elseif($type=='topic'){
	     preg_match_all('/{csdjcms:topic(.*?pagesize=([\S]+).*?)}([\s\S]+?){\/csdjcms:topic}/',$Mark_Text,$page_arr);

		if($tid=='tags'){
                        $sqlstr="select * from ".Getdbname('topic')." where CS_YID=0 and CS_Tags like '%".$key."%'  order by CS_AddTime desc";
		}else{
                        $sqlstr="select * from ".Getdbname('topic')." where CS_YID=0 and CS_Tags like '%".$key."%' or CS_Name like '%".$key."%'  order by CS_AddTime desc";
                }

  	        $res=$db -> query($sqlstr);
 	        $nums= $db -> num_rows($res);
		$Arr=spanpage($sqlstr,$page_arr[2][0],$pagenum,'so',$type,'key',urlencode($key),1,$pages);//sql,每页显示条数
		$result=$db->query($Arr[2]);
		$recount=$db->num_rows($result);

		if($recount==0){
                     if($tid=='tags'){
			$data_content.="<div align=center><strong>对不起,没有找到专集《<font color=#FF0000>".$key."</font>》相关数据!</strong></div>";
                     }else{
			$data_content.="<div align=center><strong>对不起,没有找到专集《<font color=#FF0000>".$key."</font>》相关数据!</strong></div>";
                     }
                }else{
			if($result){
				$sorti=1;
				while ($row2 = $db ->fetch_array($result)){
					$datatmp=datatopic($page_arr[0][0],$page_arr[3][0],$row2,$sorti);
					$sorti=$sorti+1;
					$data_content.=$datatmp;
				}
			}
                }
		 $Mark_Text=Page_Mark($Mark_Text,$Arr);	
		 $Mark_Text=CS_ReplaceStr($Mark_Text,$page_arr[0][0],$data_content);
		 unset($Arr);
                 unset($page_arr);

        }

	$Mark_Text=Common_Mark($Mark_Text,0);
        return $Mark_Text;
}


//分页连接解析
function spanpage($mysql,$pagesize,$pagenum=10,$type,$fid,$sort='id',$cid=1,$id=1,$pages=1){

	global $db;
	$pagesok=$pagesize;//每页显示记录数
  	$sqlstr=$mysql;
  	$res=$db -> query($sqlstr);
 	$nums= $db -> num_rows($res);
	if($nums==0){$nums=1;}
        $pagejs=ceil($nums/$pagesok);//总页数

        if($pages>$pagejs){
            $pages=$pagejs;
        }

        $sql=$sqlstr." LIMIT ".$pagesok*($pages-1).",".$pagesok;

	$result = $db -> query($sql);
	$str="";
	$first=LinkUrl($type,$fid,$sort,$cid,$id,1);
        if($pages==1){
	     $pageup=LinkUrl($type,$fid,$sort,$cid,$id,$pages);
        }else{
	     $pageup=LinkUrl($type,$fid,$sort,$cid,$id,$pages-1);
        }
	$pagenext=LinkUrl($type,$fid,$sort,$cid,$id,$pages+1);
	$last=LinkUrl($type,$fid,$sort,$cid,$id,$pagejs);
	$pagelist="<select  onchange=javascript:window.location=this.options[this.selectedIndex].value;>\r\n<option value='0'>跳转</option>\r\n";
	for($k=1;$k<=$pagejs;$k++){
		$pagelist.="<option value='".LinkUrl($type,$fid,$sort,$cid,$id,$k)."'>第".$k."页</option>\r\n";
		}
	$pagelist.="</select>";	
	if($pagejs<=$pagenum){
  		for($i=1;$i<=$pagejs;$i++){
   			$str.="<a href='".LinkUrl($type,$fid,$sort,$cid,$id,$i)."'>".$i."</a>";
 	 	}
	}else{
 		if($pages>=$pagenum){
 			for($i=$pages-intval($pagenum/2);$i<=$pages+(intval($pagenum/2));$i++){
   				if($i<=$pagejs){
   					$str.="<a href='".LinkUrl($type,$fid,$sort,$cid,$id,$i)."'>".$i."</a>";
    			        }
  			}
  			if($i<=$pagejs){ 
	    		        $str.="<a href='".LinkUrl($type,$fid,$sort,$cid,$id,$pagejs)."'>".$pagejs."</a>";
   			}
   		}else{
  			for($i=1;$i<=$pagenum;$i++){
    			     $str.="<a href='".LinkUrl($type,$fid,$sort,$cid,$id,$i)."'>".$i."</a>";
 		        } 

 		        if($i<=$pagejs){ 
	  		     $str.="<a href='".LinkUrl($type,$fid,$sort,$cid,$id,$pagejs)."'>".$pagejs."</a>";
    			}
 		 }
	}
	 while ($row = $db -> fetch_array($result) ){ }
	 $arr=array($str,$result,$sql,$nums,$pagelist,$pages,$pagejs,$first,$pageup,$pagenext,$last,$pagesok);
	 @mysql_free_result($res);
	 return $arr;
}
function Page_Mark($Mark_Text,$Arr){
		$Mark_Text=preg_replace('/\{csdjcms:pagenum(.*?)\}/','{csdjcms:pagenum}',$Mark_Text);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagedata}',$Arr[3]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagedown}',$Arr[9]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagenow}',$Arr[5]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagecout}',$Arr[6]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagelist}',$Arr[4]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagesize}',$Arr[11]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagefirst}',$Arr[7]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pageup}',$Arr[8]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagenum}',$Arr[0]);
		$Mark_Text=CS_ReplaceStr($Mark_Text,'{csdjcms:pagelast}',$Arr[10]);	
		return $Mark_Text;
}
	
//if标签处理
function labelif($Mark_Text){
	$prg='/{if:(.*?)}(.*?){end if}/';
	preg_match_all($prg,$Mark_Text,$arr);
	if(!empty($arr[0]) && !empty($arr[0][0])){
		for($i=0;$i<count($arr[0]);$i++){
			$else=explode('{else}',$arr[2][$i]);
			if(count($else)==2){
				$evalstr="if(".$arr[1][$i]."){ return '".$else[0]."';}else{return '".$else[1]."';}";	
				$str=eval($evalstr);
				$Mark_Text=CS_ReplaceStr($Mark_Text,$arr[0][$i],$str);
			}else{
				$evalstr="if(".$arr[1][$i]."){ return '".$arr[2][$i]."' ;}";
				$str=eval($evalstr);
				$Mark_Text=CS_ReplaceStr($Mark_Text,$arr[0][$i],$str);
				
			}
		}
	}
	return $Mark_Text;
}

//获取专集舞曲数目
function gettopiccount($id,$sid){
	global $db;
	if($sid==2){
		$sql="select count(CS_ID) as rc from ".Getdbname('news')." where CS_TID=$id";
	}else{
		$sql="select count(CS_ID) as rc from ".Getdbname('dance')." where CS_TID=$id";
	}
	$row=$db->getRow($sql);
	if($row){
		return $row['rc'];
	}else{
		return "0";
	}
}
