<?php
/*
'**************************************************************************************************
' : һ Content Management System
' 汾: Version 1.X
' ٷվ: http://www.yixiu.cc
' ٷ̳http://bbs.yixiu.cc
' Ȩ: һӪŶ
' ֣:
'    1κθ˻֯δȨɾ޸ġһйڰȨϢ
'    2һҵķ׷Ȩ
' @author YGH 2012-12-13
'**************************************************************************************************
*/
/**
 * ݲɼҳַ·вȫ
 * @param $url
 * @param $str
 */
function formaturl($url, $str){
	if (is_array($str)) {
		$return = array();
		foreach ($str as $href) {
			$return[] = formaturl($url, $href);
		}
		return $return;
	} else {
		if (stripos($str, 'http://')===0 || stripos($str, 'ftp://')===0) {
			return $str;
		}
		$str = str_replace('\\', '/', $str);
		$parseUrl = parse_url(dirname($url).'/');
		$scheme = isset($parseUrl['scheme']) ? $parseUrl['scheme'] : 'http';
		$host = $parseUrl['host'];
		$path = isset($parseUrl['path']) ? $parseUrl['path'] : '';
		$port = isset($parseUrl['port']) ? $parseUrl['port'] : '';

		if (strpos($str, '/')===0) {
			return $scheme.'://'.$host.$str;
		} else {
			$part = explode('/', $path);
			array_shift($part);
			$count = substr_count($str, '../');
			if ($count>0) {
				for ($i=0; $i<=$count; $i++) {
					array_pop($part);
				}
			}
			$path = implode('/', $part);
			$str = str_replace(array('../','./'), '', $str);
			$path = $path=='' ? '/' : '/'.trim($path,'/').'/';
			return $scheme.'://'.$host.$path.$str;
		}		
	}

}

function preg_collect($rule, &$content, $isone = false){
	$return = NULL;
	if (is_array($rule) && $rule['iscurl']) {
		if ($rule['ispreg']) {
			$fun = $isone ? 'preg_match' : 'preg_match_all';
			$fun($rule['preg'], $content, $return);
			if (isset($return[1])) {
				$return = $return[1];
			}
		} else {
			$return = $rule['preg'];
		}
	}
	return $return;
}

/**
 * Զתַ ֧ת
 * @param $fContents
 * @param $from
 * @param $to
 */
function auto_charset(&$content,$from='utf-8',$to='gb2312'){
    $from   =  strtoupper($from)=='UTF8'? 'utf-8':$from;
    $to       =  strtoupper($to)=='UTF8'? 'utf-8':$to;
    if( strtoupper($from) === strtoupper($to) || empty($content) || (is_scalar($content) && !is_string($content)) ){
        return $content;
    }
    if(is_string($content) ) {
        if(function_exists('mb_convert_encoding')){
            return mb_convert_encoding ($content, $to, $from);
        }elseif(function_exists('iconv')){
            return iconv($from,$to,$content);
        }else{
            return $content;
        }
    }
    elseif(is_array($content)){
        foreach ( $content as $key => $val ) {
            $_key =     auto_charset($key,$from,$to);
            $content[$_key] = auto_charset($val,$from,$to);
            if($key != $_key )
                unset($content[$key]);
        }
        return $content;
    }
    else{
        return $content;
    }
}

function array_to_sql($data, $type='add'){
	if (!is_array($data)) {
		return false;
	}
	if ($type=='add') {
		$field = array();
		$value = array();
		foreach ($data as $key=>$val) {
			$field[] = '`'.$key.'`';
			$value[] = '\''.addslashes($val).'\'';
		}
		return '('.implode(',', $field).') values ('.implode(',', $value).')'; 
	} elseif ($type=='update'){
		$field = array();
		foreach ($data as $key=>$val) {
			$field[] = '`'.$key.'` = \''.addslashes($val).'\'';
		}
		return implode(',', $field);
	}
}

function rule_to_xml($filename='', $data){
	if(is_array($data)){
		$uniqid = uniqid();
		$filename = empty($filename) ? '../../../cache/'.$uniqid.'.txt' : $filename;
		$fp = fopen($filename, 'a+');
		foreach ($data as $key=>$value) {
			fwrite($fp, '<'.$key.'>'.$value.'</'.$key.'>'."\r\n");
		}
		fclose($fp);
		return $uniqid;
	}else{
		return false;
	}
}