CREATE TABLE bug_adminsession (
  uid mediumint(8) unsigned NOT NULL default '0',
  ip char(15) NOT NULL default '',
  dateline int(10) unsigned NOT NULL default '0',
  errorcount tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (uid)
) ENGINE=MEMORY CHARSET=utf8;

CREATE TABLE bug_bug (
  bugid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL,
  proid mediumint(8) unsigned NOT NULL default '0',
  title varchar(100) NOT NULL,
  bug text NOT NULL,
  quick tinyint(1) unsigned NOT NULL default '0',
  assign mediumint(8) unsigned NOT NULL,
  status tinyint(1) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL,
  updatetime int(10) unsigned NOT NULL,
  PRIMARY KEY  (bugid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_class (
  classid mediumint(8) unsigned NOT NULL auto_increment,
  classname varchar(10) NOT NULL,
  displayorder tinyint(3) unsigned NOT NULL default '0',
  type varchar(6) NOT NULL,
  PRIMARY KEY  (classid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_config (
  var varchar(30) NOT NULL default '',
  datavalue text NOT NULL,
  PRIMARY KEY  (var)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_data (
  var varchar(20) NOT NULL default '',
  datavalue text NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (var)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE bug_invite (
  id mediumint(8) unsigned NOT NULL auto_increment,
  proid mediumint(8) unsigned NOT NULL,
  uid mediumint(8) unsigned NOT NULL default '0',
  code varchar(20) NOT NULL default '',
  fuid mediumint(8) unsigned NOT NULL default '0',
  type tinyint(1) unsigned NOT NULL default '0',
  email varchar(100) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY uid (uid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_notice (
  id mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  type varchar(20) NOT NULL default '',
  new tinyint(1) NOT NULL default '0',
  authorid mediumint(8) unsigned NOT NULL default '0',
  author varchar(15) NOT NULL default '',
  note text NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY uid (uid,new,dateline)
) ENGINE=MyISAM CHARSET=utf8;
CREATE TABLE bug_paylog (
  logid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL,
  total_fee decimal(10,2) NOT NULL default '0.00',
  dingdan smallint(5) unsigned NOT NULL,
  dateline int(10) NOT NULL,
  PRIMARY KEY  (logid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_project (
  proid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL,
  proname varchar(30) NOT NULL,
  proinfo text NOT NULL,
  status tinyint(1) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL,
  PRIMARY KEY  (proid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_projectuserlist (
  id mediumint(8) unsigned NOT NULL auto_increment,
  proid mediumint(8) unsigned NOT NULL,
  uid mediumint(8) unsigned NOT NULL,
  groupid mediumint(8) unsigned NOT NULL,
  level tinyint(1) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_rebug (
  reid mediumint(8) unsigned NOT NULL auto_increment,
  bugid mediumint(8) unsigned NOT NULL,
  uid mediumint(8) unsigned NOT NULL,
  rebug text NOT NULL,
  status tinyint(1) NOT NULL default '0',
  dateline int(10) unsigned NOT NULL,
  PRIMARY KEY  (reid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_session (
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(15) NOT NULL default '',
  password char(32) NOT NULL default '',
  lastactivity int(10) unsigned NOT NULL default '0',
  ip int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY lastactivity (lastactivity),
  KEY ip (ip)
) ENGINE=MEMORY CHARSET=utf8;
CREATE TABLE bug_sysarticle (
  sid mediumint(8) unsigned NOT NULL auto_increment,
  title varchar(100) NOT NULL,
  class varchar(10) NOT NULL default '0',
  message text NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (sid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_user (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  username varchar(20) NOT NULL,
  realname varchar(15) NOT NULL,
  password char(32) NOT NULL,
  email varchar(100) NOT NULL,
  namestatus tinyint(1) unsigned NOT NULL,
  newnotice tinyint(1) unsigned NOT NULL default '0',
  amount decimal(10,2) NOT NULL,
  bugpronum smallint(5) unsigned NOT NULL default '0',
  totalpronum smallint(5) unsigned NOT NULL default '0',
  allowmanage tinyint(1) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL,
  PRIMARY KEY  (uid)
) ENGINE=MyISAM CHARSET=utf8;

CREATE TABLE bug_usergroup (
  groupid mediumint(8) unsigned NOT NULL auto_increment,
  grouptitle varchar(20) NOT NULL,
  uid mediumint(8) unsigned NOT NULL,
  system tinyint(1) unsigned NOT NULL,
  allowproject tinyint(1) unsigned NOT NULL,
  allowbug tinyint(1) unsigned NOT NULL,
  allowrebug tinyint(1) unsigned NOT NULL,
  allowedetail tinyint(1) unsigned NOT NULL,
  PRIMARY KEY  (groupid)
) ENGINE=MyISAM CHARSET=utf8;

