<?php

define('IN_SITE', TRUE);

error_reporting(0);
$_SGLOBAL = $_SCONFIG = $_SBLOCK = array();

//程序目录
define('S_ROOT', substr(dirname(__FILE__), 0, -7));

//获取时间
$_SGLOBAL['timestamp'] = time();

include_once(S_ROOT.'./source/function_common.php');
if(!@include_once(S_ROOT.'./config.php')) {
	show_msg('缺少 "config.php" 这个文件', 999);
}

//GPC过滤
if(!(get_magic_quotes_gpc())) {
	$_GET = saddslashes($_GET);
	$_POST = saddslashes($_POST);
}

//启用GIP
if ($_SC['gzipcompress'] && function_exists('ob_gzhandler')) {
	ob_start('ob_gzhandler');
} else {
	ob_start();
}

$formhash = formhash();
setcookie('openuc',0);
$theurl = 'index.php';
$sqlfile = S_ROOT.'./data/install.sql';
if(!file_exists($sqlfile)) {
	show_msg('请上传最新的 install.sql 数据库结构文件到程序的 ./data 目录下面，再重新运行本程序', 999);
}
$configfile = S_ROOT.'./config.php';

//变量
$step = empty($_GET['step'])?0:intval($_GET['step']);
$action = empty($_GET['action'])?'':trim($_GET['action']);
$nowarr = array('','','','','','','');

$lockfile = S_ROOT.'./data/install.lock';
if(file_exists($lockfile)) {
	show_msg('警告!您已经安装过BugCheck<br>
		为了保证数据安全，请立即手动删除 install/index.php 文件<br>
		如果您想重新安装BugCheck，请删除 data/install.lock 文件，再运行安装文件');
}

//检查config是否可写
if(!@$fp = fopen($configfile, 'a')) {
	show_msg("文件 $configfile 读写权限设置错误，请设置为可写，再执行安装程序");
} else {
	@fclose($fp);
}

//提交处理
if (submitcheck('ucsubmit')) {

	//安装UC配置
	$step = 1;

	//判断域名是否解析
	$ucapi = preg_replace("/\/$/", '', trim($_POST['ucapi']));
	$ucip = trim($_POST['ucip']);

	if(empty($ucapi) || !preg_match("/^(http:\/\/)/i", $ucapi)) {
		show_msg('UCenter的URL地址不正确');
	} else {
		//检查服务器 dns 解析是否正常, dns 解析不正常则要求用户输入ucenter的ip地址
		if(!$ucip) {
			$temp = @parse_url($ucapi);
			$ucip = gethostbyname($temp['host']);
			if(ip2long($ucip) == -1 || ip2long($ucip) === FALSE) {
				$ucip = '';
			}
		}
	}

	//验证BugCheck是否安装
	if(!@include_once S_ROOT.'./uc_client/client.php') {
		show_msg('uc_client目录不存在，请上传安装包中的 ./upload/uc_client 到程序根目录');
	}
	$ucinfo = uc_fopen2($ucapi.'/index.php?m=app&a=ucinfo&release='.UC_CLIENT_RELEASE, 500, '', '', 1, $ucip);
	list($status, $ucversion, $ucrelease, $uccharset, $ucdbcharset, $apptypes) = explode('|', $ucinfo);
	$dbcharset = strtolower(trim($_SC['dbcharset'] ? str_replace('-', '', $_SC['dbcharset']) : $_SC['dbcharset']));
	$ucdbcharset = strtolower(trim($ucdbcharset ? str_replace('-', '', $ucdbcharset) : $ucdbcharset));
	$apptypes = strtolower(trim($apptypes));
	if($status != 'UC_STATUS_OK') {
		show_header();
		print<<<END
		<form id="theform" method="post" action="$theurl">
		<table class="datatable">
		<tr><td><strong>UCenter无法正常连接，返回错误 ( $status )，请确认UCenter的IP地址是否正确</strong><br><br></td></tr>
		<tr><td>UCenter服务器的IP地址: <input type="text" name="ucip" value="$ucip"> 例如：192.168.0.1</td></tr>
		</table>
		<table class=button>
		<tr><td>
		<input type="hidden" name="ucapi" value="$ucapi">
		<input type="hidden" name="ucfounderpw" value="$_POST[ucfounderpw]">
		<input type="submit" id="ucsubmit" name="ucsubmit" value="确认IP地址"></td></tr>
		</table>
		<input type="hidden" name="formhash" value="$formhash">
		</form>
END;
		show_footer();
		exit();
	} elseif($dbcharset && $ucdbcharset && $ucdbcharset != $dbcharset) {
		show_msg('UCenter 服务端字符集与当前应用的字符集不同，请下载 '.$ucdbcharset.' 编码的 UCenter 进行安装，下载地址：http://download.comsenz.com/');
	} elseif(strexists($apptypes, 'BugCheck')) {
		show_msg('已经安装过一个 BugCheck 产品，如果想继续安装，请先到 UCenter 应用管理中删除已有的 BugCheck ！');
	}
	$tagtemplates = 'apptagtemplates[template]='.urlencode('<a href="{url}" target="_blank">{subject}</a>').'&'.
		'apptagtemplates[fields][subject]='.urlencode('日志标题').'&'.
		'apptagtemplates[fields][uid]='.urlencode('用户 ID').'&'.
		'apptagtemplates[fields][username]='.urlencode('用户名').'&'.
		'apptagtemplates[fields][dateline]='.urlencode('日期').'&'.
		'apptagtemplates[fields][spaceurl]='.urlencode('空间地址').'&'.
		'apptagtemplates[fields][url]='.urlencode('日志地址');

	$uri = $_SERVER['REQUEST_URI']?$_SERVER['REQUEST_URI']:($_SERVER['PHP_SELF']?$_SERVER['PHP_SELF']:$_SERVER['SCRIPT_NAME']);
	$app_url = strtolower(substr($_SERVER['SERVER_PROTOCOL'], 0, strpos($_SERVER['SERVER_PROTOCOL'], '/'))).'://'.$_SERVER['HTTP_HOST'].preg_replace("/\/*install$/i", '', substr($uri, 0, strrpos($uri, '/install')));

	$postdata = "m=app&a=add&ucfounder=&ucfounderpw=".urlencode($_POST['ucfounderpw'])."&apptype=".urlencode('OTHER')."&appname=".urlencode('bug反馈系统')."&appurl=".urlencode($app_url)."&appip=&appcharset=".$_SC['charset'].'&appdbcharset='.$_SC['dbcharset'].'&release='.UC_CLIENT_RELEASE.'&'.$tagtemplates;
	$s = uc_fopen2($ucapi.'/index.php', 500, $postdata, '', 1, $ucip);
	if(empty($s)) {
		show_msg('UCenter用户中心无法连接');
	} elseif($s == '-1') {
		show_msg('UCenter管理员帐号密码不正确');
	} else {
		$ucs = explode('|', $s);
		if(empty($ucs[0]) || empty($ucs[1])) {
			show_msg('UCenter返回的数据出现问题，请参考:<br />'.shtmlspecialchars($s));
		} else {

			//处理成功
			$apphidden = '';
			//验证是否可以直接联接MySQL
			$link = mysql_connect($ucs[2], $ucs[4], $ucs[5], 1);
			$connect = $link && mysql_select_db($ucs[3], $link) ? 'mysql' : '';
			//返回
			foreach (array('key', 'appid', 'dbhost', 'dbname', 'dbuser', 'dbpw', 'dbcharset', 'dbtablepre', 'charset') as $key => $value) {
				if($value == 'dbtablepre') {
					$ucs[$key] = '`'.$ucs[3].'`.'.$ucs[$key];
				}
				$apphidden .= "<input type=\"hidden\" name=\"uc[$value]\" value=\"".$ucs[$key]."\" />";
			}
			//内置
			$apphidden .= "<input type=\"hidden\" name=\"uc[connect]\" value=\"$connect\" />";
			$apphidden .= "<input type=\"hidden\" name=\"uc[api]\" value=\"$_POST[ucapi]\" />";
			$apphidden .= "<input type=\"hidden\" name=\"uc[ip]\" value=\"$ucip\" />";

			show_header();
			print<<<END
			<form id="theform" method="post" action="$theurl">
			<table>
			<tr><td>UCenter注册成功！当前程序ID标识为: $ucs[1]</td></tr>
			</table>

			<table class=button>
			<tr><td>$apphidden
			<input type="submit" id="uc2submit" name="uc2submit" value="进入下一步"></td></tr>
			</table>
			<input type="hidden" name="formhash" value="$formhash">
			</form>
END;
			show_footer();
			exit();
		}
	}

} elseif (submitcheck('uc2submit')) {

	//增加congfig配置
	$step = 2;

	//写入config文件
	$configcontent = sreadfile($configfile);
	$keys = array_keys($_POST['uc']);
	foreach ($keys as $value) {
		$upkey = strtoupper($value);
		$configcontent = preg_replace("/define\('UC_".$upkey."'\s*,\s*'.*?'\)/i", "define('UC_".$upkey."', '".$_POST['uc'][$value]."')", $configcontent);
	}
	setcookie('openuc',1);
	if(!$fp = fopen($configfile, 'w')) {
		show_msg("文件 $configfile 读写权限设置错误，请设置为可写后，再执行安装程序");
	}
	fwrite($fp, trim($configcontent));
	fclose($fp);

} elseif(!empty($_POST['sqlsubmit'])) {

	$step = 2;

	//先写入config文件
	$configcontent = sreadfile($configfile);
	$keys = array_keys($_POST['db']);
	foreach ($keys as $value) {
		$configcontent = preg_replace("/[$]\_SC\[\'".$value."\'\](\s*)\=\s*[\"'].*?[\"']/is", "\$_SC['".$value."']\\1= '".$_POST['db'][$value]."'", $configcontent);
	}
	if(!$fp = fopen($configfile, 'w')) {
		show_msg("文件 $configfile 读写权限设置错误，请设置为可写后，再执行安装程序");
	}
	fwrite($fp, trim($configcontent));
	fclose($fp);

	if(empty($_POST['db']['tablepre'])) {
		show_msg("填写的表名前缀不能为空");
	}

	//判断 BugCheck 数据库
	$havedata = false;
	if(!@mysql_connect($_POST['db']['dbhost'], $_POST['db']['dbuser'], $_POST['db']['dbpw'])) {
		show_msg('数据库连接信息填写错误，请确认');
	}
	if(mysql_select_db($_POST['db']['dbname'])) {
		if(mysql_query("SELECT COUNT(*) FROM {$_POST['db']['tablepre']}space")) {
			$havedata = true;
		}
	} else {
		if(!mysql_query("CREATE DATABASE `".$_POST['db']['dbname']."`")) {
			show_msg('设定的Bugcheck数据库无权限操作，请先手工操作后，再执行安装程序');
		}
	}

	if($havedata) {
		show_msg('危险!指定的Bugcheck数据库已有数据，如果继续将会清空原有数据!', ($step+1));
	} else {
		show_msg('数据库配置成功，进入下一步操作', ($step+1), 1);
	}

} elseif (submitcheck('opensubmit')) {

	//检查用户身份
	include_once(S_ROOT.'./data/data_config.php');

	$step = 5;

	dbconnect();

	//同步获取用户源
	$_SGLOBAL['timestamp'] = time();

	//UC注册用户
	if(!@include_once S_ROOT.'./uc_client/client.php') {
		showmessage('system_error');
	}
	$uid = uc_user_register($_POST['username'], $_POST['password'], 'webmastor@yourdomain.com');
	if($uid == -3) {
		//已存在，登录
		if(!$passport = getpassport($_POST['username'], $_POST['password'])) {
			show_msg('输入的用户名密码不正确，请确认');
		}
		$setarr = array(
			'uid' => $passport['uid'],
			'username' => addslashes($passport['username'])
		);
	} elseif($uid > 0) {
		$setarr = array(
			'uid' => $uid,
			'username' => $_POST['username']
		);
	} else {
		show_msg('输入的用户名无法注册，请重新确认');
	}
	$setarr['password'] = md5("$setarr[uid]|$_SGLOBAL[timestamp]");//本地密码随机生成
	$setarr = array(
		'password' => md5(md5($_POST['password'])),
		'username' => addslashes($_POST['username']),
		'email'	   => $email,
		'allowmanage' => 1,
		'dateline' => $_SGLOBAL['timestamp']
	);

	//更新本地用户库
	$setarr['uid'] = inserttable('user', $setarr, 1);

	//添加默认用户组
	$group = array(
		'grouptitle'	=>	'默认用户组',
		'uid'			=>	$setarr['uid'],
		'allowproject'	=>	'1',
		'allowbug'		=>	'1',
		'allowrebug'	=>	'1',
		'allowedetail'	=>	'1'
	);
	inserttable('usergroup', $group);

	//更新缓存
	include_once(S_ROOT.'./source/function_cache.php');
	include_once(S_ROOT.'./source/function_space.php');

	manager_cache();

	//清理在线session
	insertsession($setarr);

	//设置cookie
	ssetcookie('auth', authcode("$setarr[password]\t$setarr[uid]", 'ENCODE'), 2592000);
	ssetcookie('loginuser', $username, 31536000);
	file_put_contents(S_ROOT.'./data/install.lock', ' ');
	show_msg('<font color="red">恭喜! Bugcheck安装全部完成!</font>
		<br>为了您的数据安全，请登录ftp，删除install目录<br><br>
		您的管理员身份已经成功确认。接下来，您可以：<br>
		<br><a href="../space.php" target="_blank">进入项目主页</a>
		<br>进入我的主页，开始Bugcheck之旅
		<br><a href="../admincp.php" target="_blank">进入管理平台</a>
		<br>以管理员身份对站点参数进行设置', 999);

}

if(empty($step)) {

	show_header();

	//检查权限设置
	$checkok = true;
	$perms = array();
	if(!checkfdperm(S_ROOT.'./config.php', 1)) {
		$perms['config'] = '失败';
		$checkok = false;
	} else {
		$perms['config'] = 'OK';
	}
	if(!checkfdperm(S_ROOT.'./attached/')) {
		$perms['attached'] = '失败';
		$checkok = false;
	} else {
		$perms['attached'] = 'OK';
	}
	if(!checkfdperm(S_ROOT.'./data/')) {
		$perms['data'] = '失败';
		$checkok = false;
	} else {
		$perms['data'] = 'OK';
	}
	if(!checkfdperm(S_ROOT.'./uc_client/data/')) {
		$perms['uc_data'] = '失败';
		$checkok = false;
	} else {
		$perms['uc_data'] = 'OK';
	}

	//安装阅读
	print<<<END
	<script type="text/javascript">
	function readme() {
		var tbl_readme = document.getElementById('tbl_readme');
		if(tbl_readme.style.display == '') {
			tbl_readme.style.display = 'none';
		} else {
			tbl_readme.style.display = '';
		}
	}
	</script>
	<table class="showtable">
	<tr><td>
	<strong>欢迎您使用BugCheck</strong><br>
	通过 BugCheck，作为建站者的您，可以轻松构建一个以好友关系为核心的交流网络，让站点用户可以用一句话记录生活中的点点滴滴；方便快捷地发布日志、上传图片；更可以十分方便的与其好友们一起分享信息、讨论感兴趣的话题；轻松快捷的了解好友最新动态。
	<br><a href="javascript:;" onclick="readme()"><strong>请先认真阅读我们的软件使用授权协议</strong></a>
	</td></tr>
	</table>

	<table>
	</td></tr>
	<tr><td>
	<strong>文件/目录权限设置</strong><br>
	在您执行安装文件进行安装之前，先要设置相关的目录属性，以便数据文件可以被程序正确读/写/删/创建子目录。<br>
	推荐您这样做：<br>使用 FTP 软件登录您的服务器，将服务器上以下目录、以及该目录下面的所有文件的属性设置为777，win主机请设置internet来宾帐户可读写属性<br>
	<table class="datatable">
	<tr style="font-weight:bold;"><td>名称</td><td>所需权限属性</td><td>说明</td><td>检测结果</td></tr>
	<tr><td><strong>./config.php</strong></td><td>读/写</td><td>系统配置文件</td><td>$perms[config]</td></tr>
	<tr><td><strong>./attached/</strong> (包括本目录、子目录和文件)</td><td>读/写/删</td><td>附件目录</td><td>$perms[attached]</td></tr>
	<tr><td><strong>./data/</strong> (包括本目录、子目录和文件)</td><td>读/写/删</td><td>站点数据目录</td><td>$perms[data]</td></tr>
	</table>
	</td></tr>
	</table>
END;

	if(!$checkok) {
		echo "<table><tr><td><b>出现问题</b>:<br>系统检测到以上目录或文件权限没有正确设置<br>强烈建议正常设置权限后再刷新本页面以便继续安装<br>否则系统可能会出现无法预料的问题 [<a href=\"$theurl?step=1\">强制继续</a>]</td></tr></table>";
	} else {
		$ucapi = empty($_POST['ucapi'])?'/':$_POST['ucapi'];
		$ucfounderpw = empty($_POST['ucfounderpw'])?'':$_POST['ucfounderpw'];
		print <<<END
		<form id="theform" method="post" action="$theurl?step=1">
			<table class=button>
				<tr>
					<td><input type="submit" id="startsubmit" name="startsubmit" value="接受授权协议，开始安装BugCheck"></td>
				</tr>
			</table>
			<input type="hidden" name="ucapi" value="$ucapi" />
			<input type="hidden" name="ucfounderpw" value="$ucfounderpw" />
			<input type="hidden" name="formhash" value="$formhash">
		</form>
END;
	}

	print<<<END
	<table id="tbl_readme" style="display:none;" class="showtable">
	<tr>
	<td><strong>请您务必仔细阅读下面的许可协议:</strong> </td></tr>
	<tr>
	<td>
	<div>中文版授权协议 适用于中文用户
	<p>版权所有 (C) 2010-2012。
	</p><p>感谢您选择 BUgCheck。希望我们的努力能为您提供一个强大的问题反馈解决方案。通过 Bubcheck，建站者可以轻松构建一个以问题反馈系统，为您的软件测试提供一个很好的反馈平台。
	</p><p>官方网址为
	<a href="http://www.88tan.com" target="_blank">www.88tan.com</a>。
	</p></div>
	</td></tr>
	</table>
END;

	show_footer();

} elseif ($step == 1) {

	show_header();
	$ucapi = "http://";
	$ucfounderpw = '';
	$showdiv = 0;
	if($_POST['ucfounderpw']) {
		$showdiv = 1;
		$ucapi = trim($_POST['ucapi']);
		$ucfounderpw = trim($_POST['ucfounderpw']);
	}

	if($showdiv) {
		print<<<END
		<form id="theform" method="post" action="$theurl">
		<div>
			<table class="showtable">
				<tr><td><strong># UCenter 参数自动获取</strong></td></tr>
				<tr><td id="msg2">UCenter的相关信息已成功获取，请直接点击下面的按钮提交配置</td></tr>
			</table>
			<br/>
		</div>
		<div>
END;
	} else {
		$plus = '';
		if(!$ucfounderpw) {
			$plus = '';
		}
		print<<<END
		<form id="theform" method="post" action="$theurl">
		<div>
			<table class="showtable">
				<tr><td style="color:#F00;font-weight:bold;">配置UCenter后，可以将 BugCheck 和另外的 UCenter 应用进行同步.<br>如果不需要，请选择跳过，不会影响使用</td></tr>
			</table>
			<br>
			<p style="font-weight:bold;">请输入已安装UCenter的信息:</p>
			<p>
				如果您的站点还没有安装过UCenter，请这样操作：<br>
				1. <a href="http://download.comsenz.com/UCenter/" target="_blank">请点击这里下载最新版本的 UCenter </a>，并阅读程序包中的说明进行UCenter的安装。<br>
				2. 安装完毕 UCenter 后，在下面填入UCenter的相关信息即可继续进行 BugCheck 的安装。<br>
			</p>
END;
	}
	print<<<END
		<table class=datatable>
			<tbody>
				<tr>
					<td>UCenter 的 URL:</td>
					<td><input type="text" id="ucapi" name="ucapi" size="60" value="$ucapi"><br>例如：http://www.88tan.com/ucenter</td>
				</tr>
				<tr>
					<td>UCenter 的创始人密码:</td>
					<td><input type="password" id="ucfounderpw" name="ucfounderpw" size="20" value="$ucfounderpw"></td>
				</tr>
			</tbody>
		</table>
		<br>
	</div>
	<table class=button>
		<tr>
			<td>
				<input type="submit" id="ucsubmit" name="ucsubmit" value="提交UCenter配置信息">&nbsp;&nbsp;
				<input type="button" id="ucskip" name="ucsubmit" onclick="javascript:location='?step=2'" value="跳 过">
			</td>
		</tr>
	</table>
	<input type="hidden" id="ucfounder" name="ucfounder" size="20" value="">
	<input type="hidden" name="formhash" value="$formhash">
	</form>
END;
	show_footer();

} elseif ($step == 2) {

	//检测目录属性
	show_header();
	//设置数据库配置
	print<<<END
	<form id="theform" method="post" action="$theurl">

	<table class="showtable">
	<tr><td><strong># 设置BugCheck数据库信息</strong></td></tr>
	<tr><td id="msg1">这里设置BugCheck的数据库信息</td></tr>
	</table>
	<table class=datatable>
	<tr>
	<td width="25%">数据库服务器本地地址:</td>
	<td><input type="text" name="db[dbhost]" size="20" value="localhost"></td>
	<td width="30%">一般为localhost</td>
	</tr>
	<tr>
	<td>数据库用户名:</td>
	<td><input type="text" name="db[dbuser]" size="20" value=""></td>
	<td>&nbsp;</td>
	</tr>
	<tr>
	<td>数据库密码:</td>
	<td><input type="password" name="db[dbpw]" size="20" value=""></td>
	<td>&nbsp;</td>
	</tr>
	<tr>
	<td>数据库字符集:</td>
	<td>
	<select name="db[dbcharset]" onchange="addoption(this)">
	<option value="$_SC[dbcharset]">$_SC[dbcharset]</option>
	<option value="addoption" class="addoption">+自定义</option>
	</select>
	</td>
	<td>MySQL版本>4.1有效</td>
	</tr>
	<tr>
	<td>数据库名:</td>
	<td><input type="text" name="db[dbname]" size="20" value=""></td>
	<td>如果不存在，则会尝试自动创建</td>
	</tr>
	<tr>
	<td>表名前缀:</td>
	<td><input type="text" name="db[tablepre]" size="20" value="bug_"></td>
	<td>不能为空，默认为bug_</td>
	</tr>
	</table>

	<table class=button>
	<tr><td><input type="submit" id="sqlsubmit" name="sqlsubmit" value="设置完毕,检测我的数据库配置"></td></tr>
	</table>
	<input type="hidden" name="formhash" value="$formhash">
	</form>
END;
	show_footer();

} elseif ($step == 3) {

	//链接数据库
	dbconnect();

	//安装数据库
	//获取最新的sql文
	$newsql = sreadfile($sqlfile);

	if($_SC['tablepre'] != 'bug_') $newsql = str_replace('bug_', $_SC['tablepre'], $newsql);//替换表名前缀

	//获取要创建的表
	$tables = $sqls = array();
	if($newsql) {
		preg_match_all("/(CREATE TABLE ([a-z0-9\_\-`]+).+?\s*)(TYPE|ENGINE)+\=/is", $newsql, $mathes);
		$sqls = $mathes[1];
		$tables = $mathes[2];
	}
	if(empty($tables)) {
		show_msg("安装SQL语句获取失败，请确认SQL文件 $sqlfile 是否存在");
	}

	$heaptype = $_SGLOBAL['db']->version()>'4.1'?" ENGINE=MEMORY".(empty($_SC['dbcharset'])?'':" DEFAULT CHARSET=$_SC[dbcharset]" ):" TYPE=HEAP";
	$myisamtype = $_SGLOBAL['db']->version()>'4.1'?" ENGINE=MYISAM".(empty($_SC['dbcharset'])?'':" DEFAULT CHARSET=$_SC[dbcharset]" ):" TYPE=MYISAM";
	$installok = true;
	foreach ($tables as $key => $tablename) {
		if(strpos($tablename, 'session')) {
			$sqltype = $heaptype;
		} else {
			$sqltype = $myisamtype;
		}
		$_SGLOBAL['db']->query("DROP TABLE IF EXISTS `$tablename`");
		if(!$query = $_SGLOBAL['db']->query($sqls[$key].$sqltype, 'SILENT')) {
			$installok = false;
			break;
		}
	}
	if(!$installok) {
		show_msg("<font color=\"blue\">数据表 ($tablename) 自动安装失败</font><br />反馈: ".mysql_error()."<br /><br />请参照 $sqlfile 文件中的SQL文，自己手工安装数据库后，再继续进行安装操作<br /><br /><a href=\"?step=$step\">重试</a>");
	} else {
		show_msg('数据表已经全部安装完成，进入下一步操作', ($step+1), 1);
	}

} elseif ($step == 4) {

	//插入默认数据
	dbconnect();
	//config
	$datas = array(
		"('sitename', 'BugCheck')",
		"('template', 'default')",
		"('openuc', ".$_COOKIE['openuc'].")"
	);

	$_SGLOBAL['db']->query("TRUNCATE TABLE ".tname('config'));
	$_SGLOBAL['db']->query("REPLACE INTO ".tname('config')." (var, datavalue) VALUES ".implode(',', $datas));

	//class
	$datas = array(
		"('新特性', '1', 'quick')",
		"('不合理', '2', 'quick')",
		"('次要错误', '3', 'quick')",
		"('严重错误', '4', 'quick')",
		"('新问题', '1', 'status')",
		"('已分派', '2', 'status')",
		"('已解决', '3', 'status')",
		"('已关闭', '4', 'status')"
	);
	$_SGLOBAL['db']->query("TRUNCATE TABLE ".tname('class'));
	$_SGLOBAL['db']->query("REPLACE INTO ".tname('class')." (classname,displayorder,type) VALUES ".implode(',', $datas));

	//sysarticle
	$datas = array(
		"('帮助', '1', '帮助页面', $_SGLOBAL[timestamp])",
		"('关于BugCheck', '2', '<p>此版本是0.6的，不过相对于之前的0.5版的BugCheck是完全不同的版本了，整体构架重新写过了，因为平时忙，所以此次发布和上一个版本隔了很久的时间。<br />\r\n此版本的构架、缓存机制、模板机制都是利用康盛的uchome的，虽然界面和功能完全不同，不过看过熟悉uchome的人对这的代码应该会比较亲切。<br />\r\n此次改版增加了用户自主建立项目的功能，并可以进行站内邀请，让他人参与自己的项目测试<br />\r\n项目的excel文件导出功能，充值，站外邀请等功能免费版用户不予享受，如需购买全功能版直接联系作者<br />\r\n<span style=\"color:#e56600;\"><strong><span style=\"font-size:14px;\">email:360586201@qq.com<br>QQ：360586201</span></strong></span><br />\r\n如果大家在操作上感觉繁琐的，可以向我提出自己的意见，我会酌情做修改<br />\r\n如发现bug，请直接登陆<a href=\"http://www.88tan.com\">http://www.88tan.com</a>,在BugCheck的项目中提出问题，我会及时修改，并放出补丁，谢谢<br />\r\n<br />\r\n</p>', $_SGLOBAL[timestamp])",
		"('联系我们', '3', '联系我们', $_SGLOBAL[timestamp])"
	);
	$_SGLOBAL['db']->query("TRUNCATE TABLE ".tname('sysarticle'));
	$_SGLOBAL['db']->query("REPLACE INTO ".tname('sysarticle')." (title,class,message,dateline) VALUES ".implode(',', $datas));

	show_msg('系统默认数据添加完毕，进入下一步操作', ($step+1), 1);

} elseif ($step == 5) {

	//更新缓存
	dbconnect();
	include_once(S_ROOT.'./source/function_cache.php');

	config_cache();
	status_cache();
	quick_cache();
	app_cache();
	$ip = getonlineip();
	$dateline = $_SGLOBAL['timestamp'];
	$msg = <<<EOF
	<form method="post" action="$theurl">
	<table>
	<tr><td colspan="2">程序数据安装完成!<script type="text/javascript" src="http://www.88tan.com/tj.php?ip=$ip&time=$dateline" reload="1"></script><br><br>
	最后，请输入您的用户名和密码<br>系统将自动为您开通站内第一个帐号，并将您设为管理员!
	</td></tr>
	<tr><td>您的用户名</td><td><input type="text" name="username" value="" size="30"></td></tr>
	<tr><td>您的密码</td><td><input type="password" name="password" value="" size="30"></td></tr>
	<tr><td>您的邮箱</td><td><input type="text" name="email" value="" size="30"></td></tr>
	<tr><td></td><td><input type="submit" name="opensubmit" value="开通管理员空间"></td></tr>
	</table>
	<input type="hidden" name="formhash" value="$formhash">
	</form>
EOF;

	show_msg($msg, 999);
}

//页面头部
function show_header() {
	global $_SGLOBAL, $nowarr, $step, $theurl, $_SC;

	$nowarr[$step] = ' class="current"';
	print<<<END
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=$_SC[charset]" />
	<title> BugCheck 程序安装 </title>
	<style type="text/css">
	* {font-size:14px; font-family: 微软雅黑, Verdana, Arial, Helvetica, sans-serif; line-height: 1.5em; word-break: break-all; }
	body { background:#DADADA url(images/bg.gif) repeat-y top; text-align:center; margin: 0; padding: 0; }
	.bodydiv { width:980px; text-align:left; margin:0 auto; background: #FFF; }
	h1 { font-size: 18px; margin: 1px 0 0; line-height: 50px; height: 50px; background: #006CC5; color: #FFF; padding-left: 10px; }
	#menu {width: 100%; margin: 10px auto; text-align: center; }
	#menu td { height: 30px; line-height: 30px; color: #999; border-bottom: 3px solid #EEE; }
	.current { font-weight: bold; color: #090 !important; border-bottom-color: #F90 !important; }
	.showtable { width:100%; border: 2px solid #006CC5 ; margin: 10px auto; background: #F5FCFF; }
	.showtable td { padding: 3px; }
	.showtable strong { color: #006CC5; }
	.datatable { width: 100%; margin: 10px auto 25px; }
	.datatable td { padding: 5px 0; border-bottom: 1px solid #EEE; }
	input { border: 1px solid #B2C9D3; padding: 5px; background: #F5FCFF; }
	.button { margin: 10px auto 20px; width: 100%; }
	.button td { text-align: center; }
	.button input, .button button { border: solid; border-color:#F90; border-width: 1px 1px 3px; padding: 5px 10px; color: #090; background: #FFFAF0; cursor: pointer; }
	#footer { font-size: 10px; line-height: 40px; background: #E8F7FC; text-align: center; height: 38px; overflow: hidden; color: #5086A5; margin-top: 20px; }
	</style>
	<script type="text/javascript">
	function $(id) {
		return document.getElementById(id);
	}
	//添加Select选项
	function addoption(obj) {
		if (obj.value=='addoption') {
			var newOption=prompt('请输入:','');
			if (newOption!=null && newOption!='') {
				var newOptionTag=document.createElement('option');
				newOptionTag.text=newOption;
				newOptionTag.value=newOption;
				try {
					obj.add(newOptionTag, obj.options[0]); // doesn't work in IE
				}
				catch(ex) {
					obj.add(newOptionTag, obj.selecedIndex); // IE only
				}
				obj.value=newOption;
			} else {
				obj.value=obj.options[0].value;
			}
		}
	}
	</script>
	</head>
	<body id="append_parent">
	<div class="bodydiv">
	<h1>BugCheck程序安装</h1>
	<div style="width:90%;margin:0 auto;">
	<table id="menu">
	<tr>
	<td{$nowarr[0]}>1.安装开始</td>
	<td{$nowarr[1]}>2.设置UCenter信息</td>
	<td{$nowarr[2]}>3.设置数据库连接信息</td>
	<td{$nowarr[3]}>4.创建数据库结构</td>
	<td{$nowarr[4]}>5.添加默认数据</td>
	<td{$nowarr[5]}>6.安装完成</td>
	</tr>
	</table>
END;
}

//页面顶部
function show_footer() {
	print<<<END
	</div>
	<iframe id="phpframe" name="phpframe" width="0" height="0" marginwidth="0" frameborder="0" src="about:blank"></iframe>
	<div id="footer">&copy; BugCheck Inc. 2010 <a style="font-size:12px; color:#6CADE0" href="http://www.88tan.com">www.88tan.com</a></div>
	</div>
	<br>
	</body>
	</html>
END;
}


//显示
function show_msg($message, $next=0, $jump=0) {
	global $theurl;

	$nextstr = '';
	$backstr = '';

	obclean();
	if(empty($next)) {
		$backstr .= "<a href=\"javascript:history.go(-1);\">返回上一步</a>";
	} elseif ($next == 999) {
	} else {
		$url_forward = "$theurl?step=$next";
		if($jump) {
			$nextstr .= "<a href=\"$url_forward\">请稍等...</a><script>setTimeout(\"window.location.href ='$url_forward';\", 1000);</script>";
		} else {
			$nextstr .= "<a href=\"$url_forward\">继续下一步</a>";
			$backstr .= "<a href=\"javascript:history.go(-1);\">返回上一步</a>";
		}
	}

	show_header();
	print<<<END
	<table>
	<tr><td>$message</td></tr>
	<tr><td>&nbsp;</td></tr>
	<tr><td>$backstr $nextstr</td></tr>
	</table>
END;
	show_footer();
	exit();
}

//检查权限
function checkfdperm($path, $isfile=0) {
	if($isfile) {
		$file = $path;
		$mod = 'a';
	} else {
		$file = $path.'./install_tmptest.data';
		$mod = 'w';
	}
	if(!@$fp = fopen($file, $mod)) {
		return false;
	}
	if(!$isfile) {
		//是否可以删除
		fwrite($fp, ' ');
		fclose($fp);
		if(!@unlink($file)) {
			return false;
		}
		//检测是否可以创建子目录
		if(is_dir($path.'./install_tmpdir')) {
			if(!@rmdir($path.'./install_tmpdir')) {
				return false;
			}
		}
		if(!@mkdir($path.'./install_tmpdir')) {
			return false;
		}
		//是否可以删除
		if(!@rmdir($path.'./install_tmpdir')) {
			return false;
		}
	} else {
		fclose($fp);
	}
	return true;
}

?>
