<?php
include_once('../../../common.php');
require_once 'JSON.php';

//文件保存目录路径
$save_path = '../../../attached/';
//文件保存目录URL
$save_url = './attached/';
$ext_arr = array('gif', 'jpg', 'jpeg', 'png', 'bmp');
$max_size = 1000000;

if (empty($_FILES) === false) {
	$file_name = $_FILES['imgFile']['name'];
	$tmp_name = $_FILES['imgFile']['tmp_name'];
	$file_size = $_FILES['imgFile']['size'];
	if (!$file_name) {
		alert("请选择文件。");
	}

	$fileext = fileext($file_name);
	if(!in_array($fileext, $ext_arr)) {
		alert("文件类型错误");
	}

	if(!$filepath = getfilepath($fileext, true)) {
		alert("创建目录失败");
	}

	if (@is_uploaded_file($tmp_name) === false) {
		alert("临时文件可能不是上传文件。");
	}

	if ($file_size > $max_size) {
		alert("上传文件大小超过限制。");
	}

	$file_path = $save_path . $filepath;
	if (move_uploaded_file($tmp_name, $file_path) === false) {
		alert("上传文件失败。");
	}

	$file_url = $save_url . $filepath;

	$make_max = 1;

	//获取图片信息
	$im = '';
	if($data = getimagesize($file_path)) {
		if($data[2] == 1) {
			$make_max = 0;//gif不处理
		} elseif($data[2] == 2) {
			if(function_exists("imagecreatefromjpeg")) {
				$im = imagecreatefromjpeg($file_path);
			}
		} elseif($data[2] == 3) {
			if(function_exists("imagecreatefrompng")) {
				$im = imagecreatefrompng($file_path);
			}
		}
	}
	if(!$im) $make_max = 0;

	$srcw = imagesx($im);
	$srch = imagesy($im);
	$maxzoom = 800;  //缩放后的最大宽度
	$srcwh = $srcw/$srch;

	if(!($srcw < $maxzoom && $srch < $maxzoom && $make_max == 1)) {
		if($srcwh <= 1){
			$maxtoh = $maxzoom;
			$maxtow = $maxzoom*$srcwh;
		} else {
			$maxtow = $maxzoom;
			$maxtoh = $maxzoom/$srcwh;
		}

		if(function_exists("imagecreatetruecolor") && function_exists("imagecopyresampled") && @$maxni = imagecreatetruecolor($maxtow, $maxtoh)) {
			imagecopyresampled($maxni, $im, 0, 0, 0, 0, $maxtow, $maxtoh, $srcw, $srch);
		} else {
			return '';
		}

		if(function_exists('imagejpeg')) {
			imagejpeg($maxni, $file_path);
		} elseif(function_exists('imagepng')) {
			imagepng($maxni, $file_path);
		}
		imagedestroy($maxni);

	}

	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 0, 'url' => $file_url));
	exit;
}

function alert($msg) {
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 1, 'message' => $msg));
	exit;
}

//获取上传路径
function getfilepath($fileext, $mkdir=false) {
	global $_SGLOBAL, $save_path;

	$filepath = "{$_SGLOBAL['supe_uid']}_{$_SGLOBAL['timestamp']}".random(4).".$fileext";
	$name1 = gmdate('Ym');
	$name2 = gmdate('j');

	if($mkdir) {
		$newfilename = $save_path.'./'.$name1;
		if(!is_dir($newfilename)) {
			if(!@mkdir($newfilename)) {
				return $filepath;
			}
		}
		$newfilename .= '/'.$name2;
		if(!is_dir($newfilename)) {
			if(!@mkdir($newfilename)) {
				return $name1.'/'.$filepath;
			}
		}
	}
	return $name1.'/'.$name2.'/'.$filepath;
}
?>