var lastUserName = lastPassword = lastEmail = lastSecCode = '';

function checkUserName() {
	var userName = $('username').value;
	if(userName == lastUserName) {
		return;
	} else {
		lastUserName = userName;
	}
	var cu = $('checkusername');
	var unLen = userName.replace(/[^\x00-\xff]/g, "**").length;

	if(unLen < 3 || unLen > 15) {
		warning(cu, unLen < 3 ? '用户名小于3个字符' : '用户名超过 15 个字符');
		return;
	}
	ajaxresponse('checkusername', 'op=checkusername&username=' + (is_ie && document.charset == 'utf-8' ? encodeURIComponent(userName) : userName));
}

function checkemail(){
	var email = $('email').value;
	ajaxresponse('checkemail', 'op=checkemail&email=' + (is_ie && document.charset == 'utf-8' ? encodeURIComponent(email) : email));
}

function checkPassword() {

	var password = $('password').value;
	var cp = $('checkpassword');
	if(password == '' || /[\'\"\\]/.test(password)) {
		warning(cp, '密码空或包含非法字符');
		return false;
	} else {
		cp.style.display = '';
		cp.innerHTML = '<img src="images/check_right.gif" width="13" height="13">';
		if(!confirm) {
			checkPassword2(true);
		}
		return true;
	}
}

function checkPassword2(confirm) {
	var password = $('password').value;
	var password2 = $('password2').value;
	var cp2 = $('checkpassword2');
	if(password2 != '') {
		checkPassword(true);
	}
	if(password == '' || (confirm && password2 == '')) {
		cp2.style.display = 'none';
		return;
	}
	if(password != password2) {
		warning(cp2, '两次输入的密码不一致');
	} else {
		cp2.style.display = '';
		cp2.innerHTML = '<img src="images/check_right.gif" width="13" height="13">';
	}
}

function ajaxresponse(objname, data) {
	var x = new Ajax('XML', objname);
	x.get("do.php?ac=register&" + data, function(s){
		var obj = $(objname);
		s = trim(s);
		if(s.indexOf('succeed') > -1) {
			obj.style.display = '';
			obj.innerHTML = '<img src="images/check_right.gif" width="13" height="13">';
			obj.className = "warning";
		} else {
			warning(obj, s);
		}
	});
}

function warning(obj, msg) {
	obj.style.display = '';
	obj.innerHTML = '<img src="images/check_error.gif" width="13" height="13"> &nbsp;' + msg;
	obj.className = "warning";
}

function checkPwd(pwd){

	if (pwd == "") {
		$("chkpswd").className = "psdiv0";
		$("chkpswdcnt").innerHTML = "";
	} else if (pwd.length < 3) {
		$("chkpswd").className = "psdiv1";
		$("chkpswdcnt").innerHTML = "太短";
	} else if(!isPassword(pwd) || !/^[^%&]*$/.test(pwd)) {
		$("chkpswd").className = "psdiv0";
		$("chkpswdcnt").innerHTML = "";
	} else {
		var csint = checkStrong(pwd);
		switch(csint) {
			case 1:
				$("chkpswdcnt").innerHTML = "很弱";
				$( "chkpswd" ).className = "psdiv"+(csint + 1);
				break;
			case 2:
				$("chkpswdcnt").innerHTML = "一般";
				$( "chkpswd" ).className = "psdiv"+(csint + 1);
				break;
			case 3:		
				$("chkpswdcnt").innerHTML = "很强";
				$("chkpswd").className = "psdiv"+(csint + 1);
				break;
		}
	}
}
function isPassword(str){
	if (str.length < 3) return false;
	var len;
	var i;
	len = 0;
	for (i=0;i<str.length;i++){
		if (str.charCodeAt(i)>255) return false;
	}
	return true;
}
function charMode(iN){ 
	if (iN>=48 && iN <=57) //数字 
	return 1; 
	if (iN>=65 && iN <=90) //大写字母 
	return 2; 
	if (iN>=97 && iN <=122) //小写 
	return 4; 
	else 
	return 8; //特殊字符 
} 
//计算出当前密码当中一共有多少种模式 
function bitTotal(num){ 
	modes=0; 
	for (i=0;i<4;i++){ 
		if (num & 1) modes++; 
		num>>>=1; 
	} 
	return modes; 
} 

//返回密码的强度级别 
function checkStrong(pwd){ 
	modes=0; 
	for (i=0;i<pwd.length;i++){ 
		//测试每一个字符的类别并统计一共有多少种模式. 
		modes|=charMode(pwd.charCodeAt(i)); 
	} 
	return bitTotal(modes);
}