<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package MVC核心包
 * @author webw3cs@gmail.coms
+------------------------------------------------------------------------------ 
 */
class Action
{
    private $view;
	private $author;

    /**
     * 构造函数：实例化视图类
     */
    public function __construct()
    {
        $this -> view = new View();
    } 
	
    /**
     * 实现权限验证 登录验证
     */
	 public function check()
	 {
		 return $this -> author;
	 }

    /**
     * 变量注入视图
     * 
     * @param  $key 变量引用名称
     * @param  $value 变量值

     * 使用示例：$this->assign('varName',$value);或	$this->assign(array('varName'=>$value));
     */
    public function assign($key, $value = '')
    {
        $this -> view -> _assign($key, $value);
    } 

    /**
     * 加载视图
     * 
     * @param  $tpl 模板名称，留空则为当前操作的动作名称
     * 
     * 使用示例：$this->show('test');或位于subdir文件夹下用$this->show('subdir/test');
     */
    public function show($tpl = '')
    {
        $this -> view -> _show($tpl);
    } 

    /**
     * 返回数据缓存类对象
     * 
     * @param  $cacheKey 缓存唯一标识
     * 
     * 使用示例：$this->C()->findAll...或 $this->C(-1)->findAll.. 或$this->C($id)->findOne..
     */
    public function C($cacheKey = '')
    {
        return new Cache($cacheKey);
    } 

    /**
     * 数据过滤，返回过滤后的值或实例化对象
     * 
     * @param  $gpFields 过滤$_POST[]与$_GET[]数组的值
     * @param  $filterMethod 过滤方法，多个方法以','逗号分开
     * 
     * 使用示例：$this->F('title,content','_addslashes,filter_js');
     */
    public function F($gpFields = '', $filterMethod = '_addslashes')
    {
        $Filter = _class('Filter');
        if (func_num_args() > 0)
        {
            return $Filter -> GP($gpFields, $filterMethod);
        } 
        else
        {
            return $Filter; //不传入参数时则返回Filter对象
        } 
    } 

    /**
     * +--------------------------------------------------------------------------
     */
} 

?>
