<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 封装SQL类
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

class DB
{
    private $db;

    /**
     * 初始化数据库
     */
    public function __construct()
    {
        $dbConfig = _config('DB');
        $this -> db = _class($dbConfig['DBdriver'], $dbConfig);
    } 

    /**
     * 查询结果集并转换为二维数组，返回数组
     * 
     * @param  $sql SQL查询语句
     */
    public function findAll($sql)
    {
        $data = array();
        $row = array ();
        $i = 0;
        $result = $this -> db -> query($sql);
        if (!$result) _error('queryError', 'findAll');
        while (($row = $this -> db -> fetch_array($result)))
        {
            $data[$i++] = $row;
        } 
        $this -> db -> free_result($result);
        return $data;
    } 

    /**
     * 查询结果集数组（一维数组）返回数组
     * 
     * @param  $sql SQL查询语句
     */
    public function findOne($sql)
    {
        $result = $this -> db -> query($sql);
        if (!$result) _error('queryError', 'findOne');
        $data = $this -> db -> fetch_array($result);
        $this -> db -> free_result($result);
        return $data;
    } 

    /**
     * 计算数据记录条数，返回数据记录数
     * 
     * @param  $sql SQL语句
     */
    public function countRecords($sql)
    {
        $result = $this -> db -> query($sql);
        if (!$result) _error('queryError', 'countRecords');
        return $this -> db -> num_rows($result);
    } 

    /**
     * 更新数据，返回值：新增数据ID、影响的记录条数
     * 
     * @param  $sql SQL更新语句
     */
    public function update($sql)
    {
        $result = $this -> db -> query($sql);
        if (!$result)
        {
            return -1; //更新失败返回-1
        } 
        else
        {
            $sql = trim($sql);
            $method = strtolower (substr($sql, 0, 6));
            if ($method == 'insert' || $method == 'replace')
            {
                return $this -> db -> insert_id();
            } 
            else
            {
                return $this -> db -> affected_rows();
            } 
        } 
    } 

    /**
     * +------------------------------------------------------------------------------
     */

} //

?>
