<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 安全过滤验证
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

class Filter
{
    /**
     * 
     * @param  $gpFields 过滤$_POST[]与$_GET[]数组的值
     * @param  $errorKey 错误索引键
     * @param  $filterMethod 过滤方法，多个方法以','逗号分开
     */
    public function GP($gpFields, $filterMethod)
    {
        $arr = explode (',', $gpFields);
        $filterArr = array();
        foreach ($arr as $value)
        {
            if (isset($_GET[$value])) $filterArr[$value] = $_GET[$value];
            if (isset($_POST[$value])) $filterArr[$value] = $_POST[$value];
            if (!isset($_GET[$value]) && !isset($_POST[$value]))_error('GPError', $value);
            $filterArr[$value] = $this -> mergeFilter($filterArr[$value], $filterMethod);
        } 
        return $filterArr;
    } 

    /**
     * 组合过滤方法
     * 
     * @param  $value 需要过滤的内容
     * @param  $filterMethod 过滤的方法
     */
    function mergeFilter($value, $filterMethod)
    {
        if (empty($filterMethod))
        {
            $value = $this -> _addslashes($value); //默认的过滤方法
        } 
        else
        {
            $methodArr = explode (',', $filterMethod);
            foreach ($methodArr as $method)
            {
                $value = $this -> $method($value);
            } 
        } 
        return $value;
    } 

    /**
     * 过滤HTML
     */
    function _addslashes($content)
    {
        if (get_magic_quotes_gpc()) return $content;
        if (is_array($content))
        {
            foreach ($content as $key => $value)
            {
                $content[$key] = addslashes($value);
            } 
        } 
        else
        {
            $content = addslashes($content);
        } 
        return $content;
    } 

    /**
     * 过滤HTML
     */
    public function filter_html($value)
    {
        if (function_exists('htmlspecialchars'))
        {
            $value = htmlspecialchars($value);
        } 
        else
        {
            $value = str_replace(array("&", '"', "'", "<", ">"), array("&amp;", "&quot;", "&#039;", "&lt;", "&gt;"), $value);
        } 
        return $value;
    } 

    /**
     * 防SQL注入
     */
    public function filter_sql($value)
    {
        $block = array("select", 'insert', "update", "delete", "\'", "\/\*", "\.\.\/", "\.\/", "union", "into", "load_file", "outfile");
        $replace = array("", "", "", "", "", "", "", "", "", "", "", "");
        return str_replace($block, $replace, $value);
    } 

    /**
     * 过滤JS
     */
    public function filter_js($value)
    {
        $value = preg_replace("/<script(.*?)>(.*?)<\/script>/si", "", $value);
        $value = preg_replace("/<iframe(.*?)>(.*?)<\/iframe>/si", "", $value);
        $value = preg_replace ("/<object.+<\/object>/iesU", '', $value);
        return $value;
    } 

    /**
     * +------------------------------------------------------------------------------
     */
} //

?>
