<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 生成HTML
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

class Html
{
    /**
     * 循环生成静态缓存访问路径
     * 
     * @param  $arr 以访问路径为键，以静态文件路径为值的数组
     * @param  $more 循环的方法
     * @param  $htmlName 自定义的静态文件名，默认以Id或for循环变量为静态文件名
     * 
     * 使用示例：$list=$this->C()->findAll($this->table,'select * from TABLE');//查询数据列表	
     * $singHtml=_class('Html')->htmlList(array('/Article/one/id/'=> 'Html/'), $list);
     */
    public function htmlList($arr, $more, $htmlName = '')
    {
        if (empty($more) || !is_array($arr)) _error('HtmlParamsError', 'htmllist(Array,Array|int,Strig)');

        $listHtml = array();
        $a = array_keys($arr);
        $k = $a[0];
        $v = $arr[$k];
        if (is_array($more)) // 数据列表循环
        {
            foreach($more as $key => $value)
            {
                if (!empty($htmlName)) // 如果自定义静态文件名
                {
                    $listHtml[$k . $value['id']] = $v . $value[$htmlName] ;
                } 
                else
                {
                    $listHtml[$k . $value['id']] = $v . $value['id'] ; //否则以ID为静态文件名
                } 
            } 
        } 
        else
        {
            for($i = 1; $i <= $more; $i++) // FOR循环(分页可以用到)
            {
                $listHtml[$k . $i] = $v . $i ; //以$i为静态文件名	
            } 
        } 
        return $listHtml;
    } 

    /**
     * 创建静态缓存页，生成成功返回TRUE
     * 
     * @param  $html 以访问路径为键，以生成静态文件为值的数组
     * 
     * 使用示例：可合并生成，以下为增加数据时，生成当前新增的静态页与重新生成首页
$indexHtml= array('/Index' => 'index');
     * $oneHtml=array('/Article/one/id/'.$id => 'Html/'.$id );
     * _class('Html')->create( array_merge($indexHtml,$oneHtml) );
     */
    public function create($html)
    {
        if (!function_exists('file_get_contents') && !function_exists('curl_init')) _error('HtmlError');
        foreach($html as $key => $value)
        {
            $url = 'http://' . $_SERVER["SERVER_NAME"] . ':' . $_SERVER['SERVER_PORT'] . ACT . $key;
            $content = file_get_contents($url);
            if (!$content)
            {
                $ci = curl_init();
                curl_setopt ($ci, CURLOPT_URL, $url);
                curl_setopt ($ci, CURLOPT_RETURNTRANSFER, 1);
                $content = curl_exec($ch);
                curl_close($ch);
            } 
            _buildDir(dirname(APP_ROOT . $value));
            $htmlFile = APP_ROOT . $value . '.html';
            if (! file_put_contents($htmlFile, $content)) _error ('writeHtmlError', $file);
        } 
        return true;
    } 

    /**
     * 删除静态缓存页
     * 
     * @param  $html 目录，或静态文件名
     * 
     * 使用示例：
_class('Html')->clear('Html/'.$id);删除单个文件
     * _class('Html')->clear('Html/');	删除Html文件夹下所有静态页
     */
    public function clear($html)
    {
        $path = APP_ROOT . $html;
        if (substr(trim($html), -1) == '/') // 如果参数以/结尾则为删除目录下所有静态页，否则删除单个静态页
        {
            if ($dir = opendir($path))
            {
                while ($file = readdir($dir))
                {
                    $isDir = is_dir($file);
                    if (!$isDir)
                        @unlink($path . $file);
                } 
                closedir($dir);
            } 
        } 
        else
        {
            @unlink($path . '.html');
        } 
        return true;
    } 

    /**
     * +------------------------------------------------------------------------------
     */
} //

?>
