<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package LightPHP核心
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */ 
// 定义框架常量
header("content-Type: text/html; charset=utf-8 ");
define ('LIGHT_VERSION', '2.1');
define ('S', DIRECTORY_SEPARATOR);
define ('YUXI', dirname(__FILE__) . '/');
$appFolderName = array ('Action', 'Cache', 'Extend', 'View');
foreach ($appFolderName as $key => $value)
{
    define (strtoupper ($value), APP_ROOT . $value . '/');
} 
// 引入配置文件
require (YUXI . '_Function.php');
$GLOBALS['C'] = _config('Common');
if (PHP_VERSION < 5) _error('PHP_Version', PHP_VERSION);
date_default_timezone_set ('Asia/Shanghai');
@set_magic_quotes_runtime(0);
if ($GLOBALS['C']['Session'] && !isset($_SESSION))session_start();
$GLOBALS['blockAction'] = array('Action', 'Cache', 'View' , 'DB', 'Mysql' , 'Filter', 'Html', 'Page'); //已有的框架类	
$GLOBALS['C']['Debug'] ? error_reporting (E_ALL) : error_reporting (0);
// 引入用户扩展函数与框架核心文件
_import(EXTEND . 'Function.php');
_import(YUXI . 'Action.class.php');
_import(YUXI . 'Cache.class.php');
_import(YUXI . 'View.class.php');

function LightPHP()
{ 
    // 定义与项目名称相对路径APP、URL访问前缀ACT
    $scriptName = SCRIPT_NAME === '' ? $_SERVER ['SCRIPT_NAME'] : SCRIPT_NAME ;
    define ('APP', str_replace ('/' . basename($scriptName), '', $scriptName));
    define ('ACT', ($GLOBALS['C']['ReWrite'] ? APP : $scriptName));
    // 路由解析
    if (!empty($_SERVER['QUERY_STRING']))
    {
        $urlStr = str_replace(array('&', '='), '/', $_SERVER['QUERY_STRING']); //将请求模式替换成pathinfo模式
    } 
    else // 如果当前访问路径大于项目名则取得之后的字符串
    {
        $urlStr = ($_SERVER ['REQUEST_URI'] == APP . '/')? '': str_replace (ACT, '', $_SERVER ['REQUEST_URI']);
    } 
    if (strpos($urlStr, '/') == 0) $urlStr = substr($urlStr, 1);
    $urlArr = explode ('/', $urlStr);
    if (strpos($urlStr, '.html')) array_splice($urlArr, -1, 1, str_replace('.html', '', end($urlArr))); //剔除.html后缀		
    $actionDir = '';
    foreach($urlArr as $key => $value) // 获取Action目录
    {
        if (strcmp($value , ucfirst($value)) > 0) // 第一个字母小写被认为是目录名
        {
            $actionDir .= $value . '/' ;
            unset($urlArr[$key]);
        } 
        else
        {
            break;
        } 
    } 
    $urlArray = array_merge($urlArr, array()); //重新排序	 
    // 取得动作与方法并将参数添加到$_GET[]数组
    $action = empty($urlArray[0]) ? $GLOBALS['C']['Action'] :$urlArray[0];
    $method = empty($urlArray[1]) ? $GLOBALS['C']['Method'] :$urlArray[1];
    $paramsNum = count ($urlArray);
    if ($paramsNum > 2 && $paramsNum % 2 == 0) // 取动作与方法后的字符串,参数应成对
    {
        for ($i = 2;$i < $paramsNum;$i++)
        {
            $_GET[ $urlArray[$i] ] = $urlArray[++$i];
        } 
    } 
    // 执行动作方法
    if (in_array($action, $GLOBALS['blockAction'])) _error('ActionSameError', $action); //动作类不能与框架类名相同
    $_GET['Action'] = $action ;
    $_GET['Method'] = $method ;
    $ActObj = _class(ACTION . $actionDir . $action);
    if (method_exists ($ActObj, $method))
    {
        $ActObj -> $method();
    } 
    else
    {
        _error('methodNotExist', $action . '—>' . $method);
    } 
} 

/**
 * +------------------------------------------------------------------------------
 */
?>
