<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 分页
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

class Page
{ 
    // ///////////////////////////////
    private $totalRecord;
    private $currentPage;
    private $subUrl;
    private $ext = ''; //后缀，在用伪静态时在页数后加，.htm
    private $totalPage;
    private $pre = 1;
    private $_next;
    private $begin = 1;
    private $_end = 5; //页码长度
    private $jDiv = "#ajaxPage"; //层ID
    private $jsFun = "Jpage"; //js函数名
    public $startP;
    public $endP;

    public function __construct($params)
    {
        if (empty($_GET['page']))
        {
            $_GET['page'] = 1;
        } 
        $this -> currentPage = $_GET['page'];
        $this -> totalRecord = $params[0]; //总记录数
        $this -> totalPage = (int)ceil($params[0] / $params[1]); //总页数
        $this -> goSize = intval($this -> _end / 2); // 页数跳动幅度
        $this -> sartP = ($this -> currentPage-1) * $params[1];
        $this -> endP = $params[1];

        if (isset($params[3]))
        {
            $this -> subUrl = APP . $params[2]; //访问路径
            $this -> ext = '.html';
        } 
        else
        {
            $this -> subUrl = ACT . $params[2];
            $this -> ext = '';
        } 

        if ($this -> currentPage > 1)
        {
            $this -> pre = $this -> currentPage-1; //前一页
        } 
        if ($this -> currentPage == $this -> totalPage)
        {
            $this -> _next = $this -> totalPage; //下一页
        } 
        else
        {
            $this -> _next = $this -> currentPage + 1; //下一页
        } 
        if ($this -> currentPage > $this -> goSize)
        {
            $this -> begin = $this -> currentPage - $this -> goSize;
            $this -> _end = $this -> currentPage + $this -> goSize; //结束页递增到(当前面+gosize)
        } 
    } 
    // ///////////
    public function htmlPage()
    {
        $str = '<div id="pageNav"><ul><li><a href="' . $this -> subUrl . '1' . $this -> ext . '">&lt;&lt;</a></li>';
        $str .= '<li><a href="' . $this -> subUrl . $this -> pre . $this -> ext . '">&lt;</a></li>';
        for($i = $this -> begin;$i <= $this -> _end;$i++)
        {
            if ($i > $this -> totalPage)
            {
                $str .= '<li class="blankPage">' . $i . '</li>';
            } 
            else
            {
                if ($i == $this -> currentPage)
                {
                    $str .= "<li><span  class='navSelected'>$this->currentPage</span></li>";
                } 
                else
                {
                    $str .= '<li><a href="' . $this -> subUrl . $i . $this -> ext . '">' . $i . '</a></li>';
                } 
            } 
        } //for
        $str .= '<li><a href="' . $this -> subUrl . $this -> _next . $this -> ext . '">&gt;</a></li>';
        $str .= '<li><a href="' . $this -> subUrl . $this -> totalPage . $this -> ext . '">&gt;&gt;</a></li></ul></div>';
        return $str;
    } 
    // ///////////
    public function ajaxPage()
    {
        $str = "<script type='text/javascript'>
         function Jpage(path,div){
            $.ajax({
            beforeSend: function(){
            
            },
            success: function(){
                htmlobj=$.ajax({url:path,async:false});
                $(div).html(htmlobj.responseText);
            }
           })
        };
         </script>";

        $page_first = "javascript:" . $this -> jsFun . "('" . $this -> subUrl . '1' . $this -> ext . "','" . $this -> jDiv . "')";
        $page_pre = "javascript:" . $this -> jsFun . "('" . $this -> subUrl . $this -> pre . $this -> ext . "','" . $this -> jDiv . "')";
        $page_next = "javascript:" . $this -> jsFun . "('" . $this -> subUrl . $this -> _next . $this -> ext . "','" . $this -> jDiv . "')";
        $page_last = "javascript:" . $this -> jsFun . "('" . $this -> subUrl . $this -> totalPage . $this -> ext . "','" . $this -> jDiv . "')";

        $str .= '<div id="pageNav"><ul><li><a href="javascript:void(1)" onclick="' . $page_first . '">&lt;&lt;</a></li>';
        $str .= '<li><a href="javascript:void(' . $this -> pre . ')" onclick="' . $page_pre . '">&lt;</a></li>';
        for($i = $this -> begin;$i <= $this -> _end;$i++)
        {
            if ($i > $this -> totalPage)
            {
                $str .= '<li class="blankPage">' . $i . '</li>';
            } 
            else
            {
                if ($i == $this -> currentPage)
                {
                    $str .= "<li><span  class='navSelected'>$this->currentPage</span></li>";
                } 
                else
                {
                    $page_mid = "javascript:" . $this -> jsFun . "('" . $this -> subUrl . $i . $this -> ext . "','" . $this -> jDiv . "')";
                    $str .= '<li><a href="javascript:void(' . $i . ')" onclick="' . $page_mid . '">' . $i . '</a></li>';
                } 
            } 
        } //for
        $str .= '<li><a href="javascript:void(' . $this -> _next . ')" onclick="' . $page_next . '">&gt;</a></li>';
        $str .= '<li><a href="javascript:void(' . $this -> totalPage . ')" onclick="' . $page_last . '">&gt;&gt;</a></li></ul></div>';
        return $str;
    } 
    // ///////////////////////////////////
} 

?>
