<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 模板引擎
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

class View
{
    private $tplVar = array();

    /**
     * 变量注入视图
     * 
     * @param  $key 变量引用名称
     * @param  $value 变量值
     */
    public function _assign($key, $value)
    {
        if (is_array($key))
        {
            foreach ($key as $k => $v)
            {
                $this -> tplVar [$k] = $v;
            } 
        } 
        else
        {
            $this -> tplVar [$key] = $value;
        } 
    } 

    /**
     * 判断是否进行模板缓存生成，并加载视图文件
     * 
     * @param  $tpl 模板名称，留空则加载以当前操作的动作方法为名的模板
     */
    public function _show($tpl = '')
    {
        if (empty($tpl) || substr(trim($tpl), -1) == '/')
        {
            $tplName = trim($tpl) . $_GET['Method'] ;
        } 
        else
        {
            $tplName = trim($tpl);
        } 
        $tplFile = VIEW . $tplName . '.' . $GLOBALS['C']['TplExt']; //模板文件
        if (!file_exists ($tplFile))_error ('tplNotExist', $tplFile);
        extract ($this -> tplVar);
        if ($GLOBALS['C']['TplCompile']) // 如果需要进行模板编译
        {
            $CtplFile = $this -> compileTpl($tplName, $tplFile);
            require $CtplFile;
        } 
        else
        {
            require $tplFile;
        } 
    } 

    /**
     * 判断是否进行模板缓存生成，并返回缓存视图文件
     * 
     * @param  $tplName 模板名称
     * @param  $tplFile 模板文件
     */
    private function compileTpl($tplName, $tplFile)
    {
        (dirname($tplName) === '.')? $tplDir = '' : $tplDir = dirname($tplName) . S; //取得模板缓存目录
        $CtplFile = _buildDir (CACHE . 'TplCache' . S . $tplDir) . S . basename($tplName) . '.php'; //模板缓存文件
        if (!file_exists($CtplFile) || filemtime($CtplFile) < filemtime($tplFile)) // 判断模板缓存是否存在或过期
        {
            $tplContent = file_get_contents($tplFile);
            $replaceArr = $this -> _preg_replace();
            $tplContent = preg_replace ($replaceArr[0], $replaceArr[1], $tplContent); //替换模板标签内容
            if (! file_put_contents ($CtplFile, $tplContent)) _error ('writeCtplError', $CtplFile); //生成模板缓存
        } 
        return $CtplFile;
    } 

    /**
     * PHP代码高度显示，返回替换后的内容
     * 
     * @param  $str 字符串
     */
    private function codeLight($str)
    {
        $flag = preg_match ('/{code}(.*?){\/code}/is', $str, $matches);
        if ($flag > 0)
        {
            $code = preg_replace('(&lt;\?php&nbsp;)', '', highlight_string('<?php ' . $matches[1], TRUE));
            $str = preg_replace('/{code}(.*?){\/code}/is', $code, $str);
        } 
        return $str;
    } 

    /**
     * 替换标签
     */
    private function _preg_replace()
    {
        $L = '{';
        $R = '}';

        $pregStr = array ('/' . $L . '(foreach) (.*?)' . $R . '/i',
            '/' . $L . 'for (.*?)' . $R . '/i',
            '/' . $L . 'while (.*?)' . $R . '/i',
            '/' . $L . 'if (.*?)' . $R . '/i',
            '/' . $L . 'else' . $R . '/i',
            '/' . $L . '(else if|elseif) (.*?)' . $R . '/i',
            '/' . $L . '\/(foreach|for|while|if)' . $R . '/i',

            '/' . $L . 'include:(.*?)' . $R . '/i', // {include:'...'}
            '/' . $L . 'codeLight' . $R . '(.*?)' . $L . '\/codeLight' . $R . '/si', // {codeLight}...{/codeLight}
            '/' . $L . 'php' . $R . '(.*?)' . $L . '\/php' . $R . '/si', // {php}...{/php}
            '/' . $L . '#(.*?)#' . $R . '/si', // {#...#}
            '/' . $L . 'e:(.*?)' . $R . '/i', // {echo:'...'}
            '/' . $L . 'p:(.*?)' . $R . '/i', // {print_r:'...'}
            '/' . $L . 'act:(.*?)' . $R . '/i', // {act:'...'}
            '/' . $L . 'app:(.*?)' . $R . '/i', // {app:'...'}
            );

        $replaceStr = array ('<?php foreach ($2) { ?>',
            '<?php for ($1) { ?>',
            '<?php while ($1) { ?>',
            '<?php if ($1){ ?>',
            '<?php }else{ ?>',
            '<?php }else if ($2){ ?>',
            '<?php } ?>',
            '<?php $this->_show($1); ?> ',
            '<?php echo $this->codeLight($1); ?> ',
            '<?php $1 ?>',
            '',
            '<?php echo $1; ?>',
            '<?php dump ($1); ?>',
            '<?php echo ACT.$1;?>',
            '<?php echo APP.$1;?>',
            );
        return array($pregStr, $replaceStr);
    } 

    /**
     * +------------------------------------------------------------------------------
     */
} //

?>
