<?php
/**
 * +------------------------------------------------------------------------------
 * LightPHP 轻巧敏捷型PHP框架
 * +------------------------------------------------------------------------------
 * 
 * @package 公共方法扩展
 * @author webw3cs@gmail.com
+------------------------------------------------------------------------------ 
 */

/**
 * 获取Config.php中数组
 * 
 * @param  $key 配置数组的下标

 * 使用示例：$GLOBALS['C']= _config('Common');取得Common为名的数组
 */
function _config($key)
{
    static $config = array();
    $config = require(EXTEND . 'Config.php');
    $value = $config[$key];
    return $value;
}

/**
 * 安全过滤
 * 
 * @author webw3cs@gmail.com
 */
function h($text, $tags = null)
{
    $text = trim($text); 
    // 完全过滤注释
    $text = preg_replace('/<!--?.*-->/', '', $text); 
    // 完全过滤动态代码
    $text = preg_replace('/<\?|\?' . '>/', '', $text); 
    // 完全过滤js
    $text = preg_replace('/<script?.*\/script>/', '', $text);

    $text = str_replace('[', '&#091;', $text);
    $text = str_replace(']', '&#093;', $text);
    $text = str_replace('|', '&#124;', $text); 
    // 过滤换行符
    $text = preg_replace('/\r?\n/', '', $text); 
    // br
    $text = preg_replace('/<br(\s\/)?' . '>/i', '[br]', $text);
    $text = preg_replace('/(\[br\]\s*){10,}/i', '[br]', $text); 
    // 过滤危险的属性，如：过滤on事件lang js
    while (preg_match('/(<[^><]+)( lang|on|action|background|codebase|dynsrc|lowsrc)[^><]+/i', $text, $mat))
    {
        $text = str_replace($mat[0], $mat[1], $text);
    } 
    while (preg_match('/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat))
    {
        $text = str_replace($mat[0], $mat[1] . $mat[3], $text);
    } 
    if (empty($tags))
    {
        $tags = 'table|td|th|tr|i|b|u|strong|img|p|br|div|strong|em|ul|ol|li|dl|dd|dt|a';
    } 
    // 允许的HTML标签
    $text = preg_replace('/<(' . $tags . ')( [^><\[\]]*)>/i', '[\1\2]', $text); 
    // 过滤多余html
    $text = preg_replace('/<\/?(html|head|meta|link|base|basefont|body|bgsound|title|style|script|form|iframe|frame|frameset|applet|id|ilayer|layer|name|script|style|xml)[^><]*>/i', '', $text); 
    // 过滤合法的html标签
    while (preg_match('/<([a-z]+)[^><\[\]]*>[^><]*<\/\1>/i', $text, $mat))
    {
        $text = str_replace($mat[0], str_replace('>', ']', str_replace('<', '[', $mat[0])), $text);
    } 
    // 转换引号
    while (preg_match('/(\[[^\[\]]*=\s*)(\"|\')([^\2=\[\]]+)\2([^\[\]]*\])/i', $text, $mat))
    {
        $text = str_replace($mat[0], $mat[1] . '|' . $mat[3] . '|' . $mat[4], $text);
    } 
    // 过滤错误的单个引号
    while (preg_match('/\[[^\[\]]*(\"|\')[^\[\]]*\]/i', $text, $mat))
    {
        $text = str_replace($mat[0], str_replace($mat[1], '', $mat[0]), $text);
    } 
    // 转换其它所有不合法的 < >
    $text = str_replace('<', '&lt;', $text);
    $text = str_replace('>', '&gt;', $text);
    $text = str_replace('"', '&quot;', $text); 
    // 反转换
    $text = str_replace('[', '<', $text);
    $text = str_replace(']', '>', $text);
    $text = str_replace('|', '"', $text); 
    // 过滤多余空格
    $text = str_replace('  ', ' ', $text);
    return $text;
} 

/**
 * 获取客户端IP
 * 
 * @author webw3cs@gmail.com
 */
function get_client_ip()
{
    if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
        $ip = getenv("HTTP_CLIENT_IP");
    else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
        $ip = getenv("HTTP_X_FORWARDED_FOR");
    else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
        $ip = getenv("REMOTE_ADDR");
    else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
        $ip = $_SERVER['REMOTE_ADDR'];
    else
        $ip = "unknown";
    return($ip);
} 

/**
 * 加载文件,可自动搜索加载Extend与Action下的文件
 * 
 * @param  $file 加载的文件名称
 * @param  $autoSearch 是否要进行自动搜索

 * 使用示例：_import(YUXI.'Action.class.php');或	_import('Index.class.php',true);	或 _import('subDir/Index.class.php',true);
 * 前一种为完整路径不需要进行自动搜索，后两种需要进行自动搜索
 */
function _import($file, $autoSearch = false)
{
    static $isLoad = array();
    $importFile = str_replace ('/', S, $file);
    if (isset($isLoad[md5($importFile)])) return true; //避免重复加载
    if (is_readable($importFile))
    {
        require($importFile);
        $isLoad[md5($importFile)] = true; //加载文件后，添加已加载标记
        return true;
    } elseif ($autoSearch === true) // 进行自动搜索
    {
            $autoFilePath = array(EXTEND, ACTION);
        foreach($autoFilePath as $autoPath)
        {
            $autoImportFile = $autoPath . $file;
            if (isset($isLoad[md5($autoImportFile)])) return true;
            if (is_readable($autoImportFile))
            {
                require($autoImportFile);
                $isLoad[md5($autoImportFile)] = true;
                return true;
            } 
        } //foreach	
    } 
    else
    {
        _error ('fileNotExist', $importFile);
    } //else
} 

/**
 * 加载并实例化类; 返回值：类对象
 * 
 * @param  $classFile 加载的文件名称
 * @param  $args 实例化时传入的参数，以数组形式传入
 * @param  $autoSearch 是否要进行自动搜索，默认为真，如果用户加载的文件是完整路径，_import将不再进行下一步搜索

 * 使用示例： _class('Page',array($totalNum, $this->pageSize, '/Index/main/page/'));	
 * _class('Html');
 */
function _class($classFile, $args = array(), $autoSearch = true)
{
    $className = basename($classFile); //取得类名
    static $isNew = array();
    if (in_array($className, $GLOBALS['blockAction'])) // 加载位于框架下的类文件
    {
            _import(YUXI . $classFile . '.class.php');
    } 
    else
    {
        _import($classFile . '.class.php', $autoSearch); //加载其它类文件
    } 

    if (isset($isNew[$className])) // 判断是否已存在该实例，避免重复实例化同一个类
        {
            return $isNew[$className];
    } 
    else
    {
        if (class_exists($className))
        {
            $isNew[$className] = new $className($args); //实例化类，并添加已实例化的标记
            return $isNew[$className];
        } 
        else
        {
            _error ('classError', $classFile . '.class.php');
        } 
    } 
} 

/**
 * 建立多级目录; 返回值：目录
 * 
 * @param  $dir 目录路径
 * @param  $mode 权限
 * 
 * 使用示例： _buildDir ( CACHE.'Data/');
 */
function _buildDir($dir, $mode = 0777)
{
    if (strpos($dir, '/'))$dir = str_replace('/', S, $dir);
    if (is_dir ($dir)) // 如果存在则返回目录，否则循环建立多级目录再返回目录
        {
            return $dir;
    } 
    else
    {
        _buildDir(dirname($dir), $mode);
        if (!mkdir($dir, $mode)) _error ('buildDirError', $dir);
        return $dir;
    } 
} 

/**
 * 是否为AJAX链接或提交方式
 */
function _isAjax()
{
    if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 'xmlhttprequest' == strtolower($_SERVER['HTTP_X_REQUESTED_WITH']))return true;
    if (!empty($_POST['AJAX_SUBMIT']) || !empty($_GET['AJAX_SUBMIT']))return true;
    return false;
} 

/**
 * 跳转
 * 
 * @param  $url 跳转地址
 * @param  $noteMsg 提示信息
 * @param  $time 跳转停留时间
 * @param  $linkMsg 链接文字
 * 
 * 使用示例：redirect('/Index','添加失败!',1,'首页'); 表示 ：提示信息为添加成功，1秒后跳到首页，也可点击链接文字‘首页’进入
 */

function _redirect($url, $noteMsg = '', $time = 0, $linkMsg = '')
{
    (strpos($url, '.html'))? $url = APP . $url: $url = ACT . $url;
    $msg = '<div style="border:solid 1px #ccc;padding:5px;background-color:#eee;color:444;font-size:12px;">
        ' . $noteMsg . ' 系统将在' . $time . '秒之后自动跳转';
    (!empty($linkMsg))? $msg .= '到' . $linkMsg . ' &nbsp;&nbsp;&nbsp;<a href=' . $url . '>' . $linkMsg . '</a></div>':$msg .= '</div>';
    $str = '<meta http-equiv="Refresh" content=' . $time . ';URL=' . $url . '>';
    if ($time != 0) $str .= $msg;
    exit($str);
} 

/**
 * 错误提示; 输出错误信息
 * 
 * @param  $errorKey 错误索引键
 * @param  $detail 错误的详细信息

 * 使用示例：_error('methodNotExist','Database->'.$method);
 */

function _error($errorKey, $detail = '')
{
    $erroHtml = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <style type="text/css">
                body{font-family: "Microsoft Yahei", Verdana, arial, sans-serif;}
            </style>
            <div style="margin:50px 200px 0 200px; border-top:solid 1px #ccc; border-left:solid 1px #ccc; border-right:solid 1px #ccc;padding:5px;color:#000000;font-size:14px;line-height:25px;">
            DEBUG FOR LightPHP '.LIGHT_VERSION.'
        </div>
        <div style="margin:0 200px 0 200px;border:solid 1px #ccc;padding:5px;background-color:#eee;color:brown;font-size:13px;line-height:25px;">';
    if ($GLOBALS['C']['Debug'])
    {
        static $errorArray = array();
        $errorArray = require (YUXI . '_Error.php');
        if (array_key_exists($errorKey, $errorArray))
        {
            echo $erroHtml . '<h4 style="text-align:center; font-size:20px;"> ' . $errorArray[$errorKey] . ' : ' . $detail . ' </h4>';
            $traces = debug_backtrace();
            foreach($traces as $trace)
            {
                echo '<li style="margin-bottom:12px;color:#444;background-color:#fff; list-style-type:none; padding:1px 5px; border:solid 1px #C8C8C8">' . $trace["file"] . ' on Line:' . $trace["line"] . '</li>';
            } 
            echo '</div>';
        } 
        else
        {
            echo $erroHtml . '访问问出错，但该错误键没有定义 </div>';
        } 
    } 
    else
    {
        echo $erroHtml . '!访问出错</div>';
    } 
    exit();
}

/**
 * 浏览器输出友好的数据  变量|数组
 */
function dump($var, $echo=true, $label=null, $strict=true) {
    $label = ($label === null) ? '' : rtrim($label) . ' ';
    if (!$strict) {
        if (ini_get('html_errors')) {
            $output = print_r($var, true);
            $output = "<pre>" . $label . htmlspecialchars($output, ENT_QUOTES) . "</pre>";
        } else {
            $output = $label . print_r($var, true);
        }
    } else {
        ob_start();
        var_dump($var);
        $output = ob_get_clean();
        if (!extension_loaded('xdebug')) {
            $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
            $output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
        }
    }
    if ($echo) {
        echo($output);
        return null;
    }else
        return $output;
}

/**
 * +------------------------------------------------------------------------------
 */
?>
