<?php
/**
 * The model ext file of contract module of Ranzhi.
 *
 * @copyright   Copyright 2009-2016 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     商业软件，非开源软件
 * @author      Xiying Guan <guanxiying@xirangit.com>
 * @package     contract
 * @version     $Id$
 * @link        http://www.ranzhico.com
 */

/**
 * Create a contract.
 * 
 * @access public
 * @return void
 */
public function create()
{
    return $this->loadExtension('bizext')->create();
}

public function update($contractID)
{
    return $this->loadExtension('bizext')->update($contractID);
}

public function receive($contractID)
{
    return $this->loadExtension('bizext')->receive($contractID);
}

public function editReturn($return, $contract)
{
    return $this->loadExtension('bizext')->editReturn($return, $contract);
}

public function deleteReturn($returnID)
{
    return $this->loadExtension('bizext')->deleteReturn($returnID);
}

public function cancel($contractID)
{
    return $this->loadExtension('bizext')->cancel($contractID);
}

public function finish($contractID)
{
    return $this->loadExtension('bizext')->finish($contractID);
}

/**
 * Set contract code's format. 
 * 
 * @access public
 * @return void
 */
public function setCodeFormat()
{
    return $this->loadExtension('bizext')->setCodeFormat();
}

/**
 * Build form of code.
 * 
 * @access public
 * @return string
 */
public function buildCodeForm()
{
    return $this->loadExtension('bizext')->buildCodeForm();
}

/**
 * Parse code.
 * 
 * @access public
 * @return string
 */
public function parseCode()
{
    return $this->loadExtension('bizext')->parseCode();
}
