$(function()
{
    $('.panel table tbody').sortable(
    {
        trigger: '.icon-move',
        selector: 'table tbody tr',
        finish: function()
        {
            var orders = {};     
            var orderNext = 1;
            $('table tbody tr').each(function()
            {
                orders[$(this).data('id')] = orderNext ++;
            });

             $.post(createLink('workflow', 'sortModuleMenu'), orders, function(data)
             {
                 if(data.result == 'success')
                 {
                     return location.reload(); 
                 }
                 else
                 {
                     alert(data.message);
                     return location.reload(); 
                 }
             }, 'json');
        }
    });

    $(document).on('click', '.icon-plus', function()
    {
        var $rowspan = parseInt($('th.params').attr('rowspan'));
        $rowspan ++;

        $('th.params').attr('rowspan', $rowspan);
        $(this).parents('tr').after(v.itemRow);
    })

    $(document).on('click', '.icon-remove', function()
    {
        if($('th.params').attr('rowspan') < 2) return false;

        var rowspan = parseInt($('th.params').attr('rowspan'));
        rowspan --;

        if($(this).parents('tr').find('th').length) 
        {
            $(this).parents('tr').next().prepend(v.th.replace(/ROWSPAN/g, rowspan));
        }
        else
        {
            $('th.params').attr('rowspan', rowspan);
        }
        $(this).parents('tr').remove();
    })

    $(document).on('change', '[name*=keys]', function()
    {
        var $fieldCode = $(this).find('option:selected').val();
        $(this).parents('.row').find('span.value').load(createLink('workflow', 'ajaxGetFieldControl', 'module=' + v.module + '&fieldCode=' + $fieldCode), function()
        {
            $('select.chosen').chosen(window.chosenDefaultOptions);

            $('.form-datetime').datetimepicker(
            {
                language:  config.clientLang,
                weekStart: 1,
                todayBtn:  1,
                autoclose: 1,
                todayHighlight: 1,
                startView: 2,
                forceParse: 0,
                showMeridian: 1,
                format: 'yyyy-mm-dd hh:ii'
            });

            $('.form-date').datetimepicker(
            {
                language:  config.clientLang,
                weekStart: 1,
                todayBtn:  1,
                autoclose: 1,
                todayHighlight: 1,
                startView: 2,
                minView: 2,
                forceParse: 0,
                format: 'yyyy-mm-dd'
            });
        });
    });
});
