$(function()
{
    $('#origin').change(function()
    {
        if($(this).val() == 'other')
        {
            $('#contract, #order, #batch').parents('tr').hide();
            $('#desc').prev('div.required').show();
        }
        else if($(this).val() == 'early')
        {
            $('#contract, #order, #batch').parents('tr').hide();
            $('#desc').prev('div.required').hide();
        }
        else if($(this).val() == 'contract')
        {
            $('#contract').parents('tr').show();
            $('#order, #batch').parents('tr').hide();
            $('#desc').prev('div.required').hide();
            var url = createLink('receivable', 'ajaxGetContracts', 'trader=' + $('#trader').val());
            $('#contract').load(url, function()
            {
                if(v.contract) $('#contract').val(v.contract);
                $('#contract').trigger('chosen:updated');
            });
        }
        else
        {
            $('#contract').parents('tr').hide();
            $('#order, #batch').parents('tr').show();
            $('#desc').prev('div.required').hide();
            var url = createLink('receivable', 'ajaxGetOrders', 'type=' + $(this).val() + '&trader=' + $('#trader').val());
            $('#order').load(url, function()
            {
                if(v.order) $('#order').val(v.order);
                $('#order').trigger('chosen:updated');
            });
            url = createLink('receivable', 'ajaxGetBatches', 'type=' + $(this).val() + '&trader=' + $('#trader').val());
            $('#batch').load(url, function()
            {
                if(v.batch) $('#batch').val(v.batch);
                $('#batch').trigger('chosen:updated');
            });
        }
    });

    $('#contract').change(function()
    {
        if($(this).val() != 0)
        {
            $('#deserved').val($(this).find('option:selected').data('money'));
        }
    });

    $('#order').change(function()
    {
        if($(this).val() != 0)
        {
            $('#deserved').val($(this).find('option:selected').data('money'));
            var url = createLink('receivable', 'ajaxGetBatches', 'type=' + $('#origin').val() + '&trader=' + $('#trader').val() + '&order=' + $(this).val());
            $('#batch').load(url, function()
            {
                $('#batch').trigger('chosen:updated');
            });
        }
    });

    $('#batch').change(function()
    {
        if($(this).val() != 0)
        {
            $('#deserved').val($(this).find('option:selected').data('money'));
        }
    });

    $('#deserved, #actual').change(function()
    {
        var deserved = $.isNumeric($('#deserved').val()) ? parseFloat($('#deserved').val()) : 0;
        var actual   = $.isNumeric($('#actual').val())   ? parseFloat($('#actual').val()) : 0;
        $('#balance').val(deserved - actual);
    });

    $('#origin').change();
})
