-- DROP TABLE IF EXISTS `crm_address`;
CREATE TABLE `crm_address` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `area` mediumint(8) unsigned NOT NULL,
  `location` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`,`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_contact`;
CREATE TABLE `crm_contact` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `realname` char(30) NOT NULL DEFAULT '',
  `nickname` char(30) NOT NULL,
  `resume` mediumint(8) unsigned NOT NULL,
  `origin` varchar(150) NOT NULL,
  `originAccount` varchar(255) NOT NULL,
  `status` enum('normal','wait','ignore') NOT NULL DEFAULT 'normal',
  `avatar` varchar(255) NOT NULL,
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m','u') NOT NULL DEFAULT 'u',
  `email` char(50) NOT NULL DEFAULT '',
  `skype` char(50) NOT NULL,
  `qq` char(20) NOT NULL DEFAULT '',
  `yahoo` char(50) NOT NULL DEFAULT '',
  `gtalk` char(50) NOT NULL DEFAULT '',
  `wangwang` char(50) NOT NULL DEFAULT '',
  `site` varchar(100) NOT NULL,
  `mobile` char(11) NOT NULL DEFAULT '',
  `phone` char(20) NOT NULL DEFAULT '',
  `company` varchar(255) NOT NULL,
  `fax` char(20) NOT NULL DEFAULT '',
  `weibo` char(50) NOT NULL,
  `weixin` char(50) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `contactedBy` char(30) NOT NULL,
  `contactedDate` datetime NOT NULL,
  `nextDate` date NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `ignoredBy` char(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `realname` (`realname`),
  KEY `nickname` (`nickname`),
  KEY `origin` (`origin`),
  KEY `birthday` (`birthday`),
  KEY `email` (`email`),
  KEY `qq` (`qq`),
  KEY `mobile` (`mobile`),
  KEY `phone` (`phone`),
  KEY `createdBy` (`createdBy`),
  KEY `contactedBy` (`contactedBy`),
  KEY `contactedDate` (`contactedDate`),
  KEY `nextDate` (`nextDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_delivery`;
CREATE TABLE `crm_delivery` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `contract` mediumint(8) unsigned NOT NULL,
  `deliveredBy` char(30) COLLATE 'utf8_general_ci' NOT NULL,
  `deliveredDate` date NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contract` (`contract`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_plan`;
CREATE TABLE `crm_plan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `amount` decimal(12,2) NOT NULL,
  `contract` mediumint(8) unsigned NOT NULL,
  `returnedBy` char(30) COLLATE 'utf8_general_ci' NOT NULL,
  `returnedDate` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contract` (`contract`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_contract`;
CREATE TABLE `crm_contract` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `customer` mediumint(8) unsigned NOT NULL,
  `name` char(100) NOT NULL,
  `code` char(30) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `items` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `delivery` char(30) NOT NULL,
  `return` char(30) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `status` enum('normal', 'closed', 'canceled') NOT NULL DEFAULT 'normal',
  `contact` mediumint(8) unsigned NOT NULL,
  `address` varchar(255) NOT NULL,
  `handlers` varchar(255) NOT NULL,
  `signedBy` char(30) NOT NULL,
  `signedDate` date NOT NULL,
  `deliveredBy` char(30) COLLATE 'utf8_general_ci' NOT NULL,
  `deliveredDate` date NOT NULL,
  `returnedBy` char(30) COLLATE 'utf8_general_ci' NOT NULL,
  `returnedDate` date NOT NULL,
  `finishedBy` char(30) NOT NULL,
  `finishedDate` date NOT NULL,
  `canceledBy` char(30) NOT NULL,
  `canceledDate` date NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `contactedBy` char(30) NOT NULL,
  `contactedDate` datetime NOT NULL,
  `nextDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `customer` (`customer`),
  KEY `amount` (`amount`),
  KEY `delivery` (`delivery`),
  KEY `return` (`return`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `handlers` (`handlers`),
  KEY `contactedDate` (`contactedDate`),
  KEY `nextDate` (`nextDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_contractorder`;
CREATE TABLE `crm_contractorder` (
  `contract` mediumint(8) unsigned NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `contract` (`contract`,`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_customer`;
CREATE TABLE `crm_customer` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(100) NOT NULL,
  `type` char(30) NOT NULL,
  `relation` enum('client', 'provider', 'partner') NOT NULL default 'client',
  `size` tinyint(3) unsigned NOT NULL,
  `industry` mediumint(8) unsigned NOT NULL,
  `area` mediumint(8) unsigned NOT NULL,
  `status` char(30) NOT NULL,
  `level` char(10) NOT NULL,
  `intension` text NOT NULL,
  `site` varchar(100) NOT NULL,
  `weibo` char(50) NOT NULL,
  `weixin` char(50) NOT NULL,
  `category` char(30) NOT NULL,
  `depositor` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `contactedBy` char(30) NOT NULL,
  `contactedDate` datetime NOT NULL,
  `nextDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `industry` (`industry`),
  KEY `size` (`size`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `relation` (`relation`),
  KEY `area` (`area`),
  KEY `status` (`status`),
  KEY `level` (`level`),
  KEY `category` (`category`),
  KEY `public` (`public`),
  KEY `assignedTo` (`assignedTo`),
  KEY `contactedDate` (`contactedDate`),
  KEY `nextDate` (`nextDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_order`;
CREATE TABLE `crm_order` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` char(255) NOT NULL,
  `customer` mediumint(8) unsigned NOT NULL,
  `plan` decimal(12,2) NOT NULL,
  `real` decimal(12,2) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `status` enum('normal', 'signed', 'closed') NOT NULL DEFAULT 'normal',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `signedBy` char(30) NOT NULL,
  `signedDate` date NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` enum('', 'payed', 'failed', 'postponed') NOT NULL DEFAULT '',
  `activatedBy` char(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `contactedBy` char(30) NOT NULL,
  `contactedDate` datetime NOT NULL,
  `nextDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `customer` (`customer`),
  KEY `plan` (`plan`),
  KEY `real` (`real`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`),
  KEY `assignedTo` (`assignedTo`),
  KEY `closedBy` (`closedBy`),
  KEY `closedReason` (`closedReason`),
  KEY `contactedDate` (`contactedDate`),
  KEY `nextDate` (`nextDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_resume`;
CREATE TABLE `crm_resume` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `contact` mediumint(8) unsigned NOT NULL,
  `customer` mediumint(8) unsigned NOT NULL,
  `maker` enum('0','1') NOT NULL DEFAULT '0',
  `dept` char(100) NOT NULL,
  `title` char(100) NOT NULL,
  `address` mediumint(8) unsigned NOT NULL,
  `join` char(10) NOT NULL,
  `left` char(10) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `contact` (`contact`),
  KEY `customer` (`customer`),
  KEY `left` (`left`),
  KEY `maker` (`maker`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_service`;
CREATE TABLE `crm_service` (
  `customer` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `expire` date NOT NULL,
  UNIQUE KEY `customer` (`customer`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_salesgroup`;
CREATE TABLE `crm_salesgroup` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `users` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `crm_salespriv`;
CREATE TABLE `crm_salespriv` (
  `account` char(30) NOT NULL,
  `salesgroup` mediumint(8) unsigned NOT NULL,
  `priv` enum('view','edit') NOT NULL,
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_doc`;
CREATE TABLE `oa_doc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL,
  `module` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `views` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `private` enum('0', '1') NOT NULL DEFAULT '0',
  `users` text NOT NULL,
  `groups` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_doccontent`;
CREATE TABLE IF NOT EXISTS `oa_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `files` text NOT NULL,
  `type` varchar(10) NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `docVersion` (`doc`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_doclib`;
CREATE TABLE `oa_doclib` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `private` enum('0', '1') NOT NULL DEFAULT '0',
  `users` text NOT NULL,
  `groups` varchar(255) NOT NULL DEFAULT '',
  `main` enum('0', '1') NOT NULL DEFAULT '0',
  `order` tinyint(5) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_project`;
CREATE TABLE `oa_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `desc` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `status` enum('doing','finished','suspend') NOT NULL DEFAULT 'doing',
  `whitelist` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE='MyISAM' COLLATE 'utf8_general_ci'; 
-- DROP TABLE IF EXISTS `oa_attend`;
CREATE TABLE `oa_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `signIn` time NOT NULL,
  `signOut` time NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL,
  `device` varchar(30) NOT NULL,
  `manualIn` time NOT NULL,
  `manualOut` time NOT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`),
  UNIQUE KEY `attend` (`date`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_attendstat`;
CREATE TABLE `oa_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`),
  UNIQUE KEY `attend` (`month`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_overtime`;
CREATE TABLE `oa_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_holiday`;
CREATE TABLE `oa_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_leave`;
CREATE TABLE `oa_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_lieu`;
CREATE TABLE `oa_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_trip`;
CREATE TABLE `oa_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL,
  `name` char(30) NOT NULL,
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL,
  `to` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_todo`;
CREATE TABLE IF NOT EXISTS `oa_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(20) NOT NULL,
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `oa_refund`;
CREATE TABLE IF NOT EXISTS `oa_refund` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(150) NOT NULL,
  `parent`  mediumint(8) NOT NULL DEFAULT 0,
  `category` char(30) NOT NULL,
  `date` date NOT NULL,
  `money` decimal(12,2) NOT NULL,
  `currency` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `related` char(200) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT 'wait',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  `firstReviewer` char(30) NOT NULL DEFAULT '',
  `firstReviewDate` datetime NOT NULL,
  `secondReviewer` char(30) NOT NULL DEFAULT '',
  `secondReviewDate` datetime NOT NULL,
  `refundBy` char(30) NOT NULL DEFAULT '',
  `refundDate` datetime NOT NULL,
  `reason` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `createdBy` (`createdBy`),
  KEY `firstReviewer` (`firstReviewer`),
  KEY `secondReviewer` (`secondReviewer`),
  KEY `refundBy` (`refundBy`),
  KEY `category` (`category`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_relation`;
CREATE TABLE `sys_relation` (
  `type` char(20) NOT NULL,
  `id` mediumint(8) NOT NULL,
  `category` mediumint(8) NOT NULL,
  UNIQUE KEY `relation` (`type`,`id`,`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `cash_depositor`;
CREATE TABLE `cash_depositor` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `abbr` char(60) NOT NULL,
  `provider` char(100) NOT NULL,
  `title` char(100) NOT NULL,
  `tags` varchar(255) NOT NULL,
  `account` char(90) NOT NULL,
  `bankcode` varchar(30) NOT NULL,
  `public` enum('0','1') NOT NULL,
  `type` enum('cash','bank','online') NOT NULL,
  `currency` char(30) NOT NULL,
  `status` enum('normal','disable') NOT NULL DEFAULT 'normal',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `cash_balance`;
CREATE TABLE `cash_balance` ( 
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `depositor` mediumint(8) unsigned NOT NULL,
  `date` date NOT NULL,
  `money` decimal(12,2) NOT NULL,
  `currency` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `depositor` (`depositor`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `cash_trade`;
CREATE TABLE `cash_trade` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT, 
  `depositor` mediumint(8) unsigned NOT NULL,
  `parent`  mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL,
  `trader` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `order` mediumint(8) unsigned NOT NULL,
  `contract` mediumint(8) unsigned NOT NULL,
  `investID` mediumint(8) unsigned NOT NULL,
  `loanID` mediumint(8) unsigned NOT NULL,
  `dept` mediumint(8) unsigned NOT NULL,
  `type` enum('in', 'out', 'transferin', 'transferout', 'invest', 'redeem', 'loan', 'repay') NOT NULL,
  `money` decimal(12,2) NOT NULL,
  `currency` varchar(30) NOT NULL,
  `date` date NOT NULL,
  `handlers` varchar(255) NOT NULL,
  `category` char(30) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `depositor` (`depositor`),
  KEY `parent` (`parent`),
  KEY `product` (`product`),
  KEY `trader` (`trader`),
  KEY `order` (`order`),
  KEY `contract` (`contract`),
  KEY `investID` (`investID`),
  KEY `loanID` (`loanID`),
  KEY `dept` (`dept`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `team_thread`;
CREATE TABLE IF NOT EXISTS `team_thread` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `board` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `author` varchar(60) NOT NULL,
  `editor` varchar(60) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  `views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `stick` enum('0','1','2','3') NOT NULL DEFAULT '0',
  `replies` mediumint(8) unsigned NOT NULL,
  `repliedBy` varchar(30) NOT NULL,
  `repliedDate` datetime NOT NULL,
  `replyID` mediumint(8) unsigned NOT NULL,
  `hidden` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category` (`board`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `team_reply`;
CREATE TABLE IF NOT EXISTS `team_reply` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `thread` mediumint(8) unsigned NOT NULL,
  `content` text NOT NULL,
  `author` char(30) NOT NULL,
  `editor` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  `hidden` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `thread` (`thread`),
  KEY `author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_action`;
CREATE TABLE `sys_action` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `customer` mediumint(8) unsigned DEFAULT NULL,
  `contact` mediumint(8) unsigned DEFAULT NULL,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` varchar(255) NOT NULL,
  `read` enum('0', '1') NOT NULL DEFAULT '0',
  `reader` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer` (`customer`),
  KEY `contact` (`contact`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_block`;
CREATE TABLE `sys_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `app` varchar(20) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(20) NOT NULL,
  `block` varchar(20) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `accountAppOrder` (`account`, `app`, `order`),
  KEY `account` (`account`, `app`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_category`;
CREATE TABLE `sys_category` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `alias` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `keywords` varchar(150) NOT NULL,
  `root` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL,
  `readonly` enum('0','1') NOT NULL DEFAULT '0',
  `moderators` varchar(255) NOT NULL,
  `threads` smallint(5) NOT NULL,
  `posts` smallint(5) NOT NULL,
  `postedBy` varchar(30) NOT NULL,
  `postedDate` datetime NOT NULL,
  `postID` mediumint(8) unsigned NOT NULL,
  `replyID` mediumint(8) unsigned NOT NULL,
  `users` text NOT NULL,
  `rights` varchar(255) NOT NULL,
  `refund` enum('0','1') NOT NULL DEFAULT '0',
  `major` enum('0','1','2','3','4','5','6','7','8') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tree` (`type`),
  KEY `order` (`order`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_package`;
CREATE TABLE IF NOT EXISTS `sys_package` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `ranzhiCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` text NOT NULL,
  `files` text NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `addedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `owner` char(30) NOT NULL DEFAULT '',
  `app` varchar(30) NOT NULL DEFAULT 'sys',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL DEFAULT '',
  `key` char(30) DEFAULT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`owner`,`app`,`module`,`section`,`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_entry`;
CREATE TABLE `sys_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `abbr` char(6) NOT NULL,
  `code` varchar(20) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `integration` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `open` varchar(20) NOT NULL,
  `key` char(32) NOT NULL,
  `ip` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `login` varchar(255) NOT NULL,
  `logout` varchar(255) NOT NULL,
  `block` varchar(255) NOT NULL,
  `control` varchar(10) NOT NULL DEFAULT 'simple',
  `size` varchar(50) NOT NULL DEFAULT 'max',
  `position` varchar(10) NOT NULL DEFAULT 'default',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` tinyint(5) unsigned NOT NULL DEFAULT '0',
  `zentao` enum('0', '1') NOT NULL DEFAULT '0',
  `category` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_article`;
CREATE TABLE `sys_article` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `keywords` varchar(150) NOT NULL,
  `summary` text NOT NULL,
  `content` text NOT NULL,
  `original` enum('1','0') NOT NULL,
  `copySite` varchar(60) NOT NULL,
  `copyURL` varchar(255) NOT NULL,
  `author` varchar(60) NOT NULL,
  `editor` varchar(60) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'normal',
  `type` varchar(30) NOT NULL,
  `views` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `sticky` enum('0','1','2','3') NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL,
  `private` enum('0', '1') NOT NULL DEFAULT '0',
  `users` text NOT NULL,
  `groups` varchar(255) NOT NULL DEFAULT '',
  `readers` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order` (`order`),
  KEY `views` (`views`),
  KEY `sticky` (`sticky`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_tag`;
CREATE TABLE `sys_tag` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) NOT NULL,
  `rank` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`),
  KEY `rank` (`rank`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_message`;
CREATE TABLE IF NOT EXISTS `sys_message` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(20) NOT NULL,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `account` char(30) DEFAULT NULL,
  `from` char(30) NOT NULL,
  `to` char(30) NOT NULL,
  `date` datetime NOT NULL,
  `content` text NOT NULL,
  `status` char(20) NOT NULL,
  `readed` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `object` (`objectType`,`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_file`;
CREATE TABLE `sys_file` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pathname` char(50) NOT NULL,
  `title` char(90) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL,
  `editor` enum('1','0') NOT NULL DEFAULT '0',
  `primary` enum('1','0') DEFAULT '0',
  `public` enum('1','0') NOT NULL DEFAULT '1',
  `downloads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object` (`objectType`,`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_history`;
CREATE TABLE `sys_history` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `action` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `field` varchar(30) NOT NULL DEFAULT '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_lang`;
CREATE TABLE `sys_lang` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(30) NOT NULL,
  `app` varchar(30) NOT NULL DEFAULT 'sys',
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang` (`app`,`lang`,`module`,`section`,`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_product`;
CREATE TABLE `sys_product` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `code` varchar(20) NOT NULL, 
  `type` varchar(10) NOT NULL,
  `status` varchar(10) NOT NULL,
  `line` varchar(30) NOT NULL DEFAULT 'default',
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_schema`;
CREATE TABLE `sys_schema` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `category` char(10) NOT NULL,
  `trader`   char(10) NOT NULL,
  `type`     char(10) NOT NULL,
  `money`    char(10) NOT NULL,
  `desc`     char(10) NOT NULL,
  `date`     char(10) NOT NULL,
  `fee`      char(10) NOT NULL,
  `dept`     char(10) NOT NULL,
  `product`  char(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_sso`;
CREATE TABLE `sys_sso` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sid` char(32) NOT NULL,
  `entry` mediumint(8) unsigned NOT NULL,
  `token` char(32) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_task`;
CREATE TABLE `sys_task` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `customer` mediumint(8) unsigned NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `category` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `estimate` decimal(12,1) unsigned NOT NULL,
  `consumed` decimal(12,1) unsigned NOT NULL,
  `left` decimal(12,1) unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','cancel','closed') NOT NULL DEFAULT 'wait',
  `statusCustom` tinyint(3) unsigned NOT NULL,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` date NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `key` smallint(5) unsigned NOT NULL default 0,
  PRIMARY KEY (`id`),
  KEY `statusOrder` (`statusCustom`),
  KEY `assignedTo` (`assignedTo`),
  KEY `createdBy` (`createdBy`),
  KEY `finishedBy` (`finishedBy`),
  KEY `closedBy` (`closedBy`),
  KEY `closedReason` (`closedReason`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_team`;
CREATE TABLE `sys_team` (
  `type` char(30) NOT NULL,
  `id` mediumint(8) NOT NULL DEFAULT '0',
  `account` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `join` date NOT NULL DEFAULT '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(2,1) unsigned NOT NULL DEFAULT '0.0',
  `estimate` decimal(12,1) unsigned NOT NULL,
  `consumed` decimal(12,1) unsigned NOT NULL,
  `left` decimal(12,1) unsigned NOT NULL,
  `order` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`type`,`id`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dept` mediumint(8) unsigned NOT NULL,
  `account` char(30) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `realname` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL,
  `nickname` char(60) NOT NULL DEFAULT '',
  `admin` enum('no','common','super') NOT NULL DEFAULT 'no',
  `avatar` varchar(255) NOT NULL DEFAULT '',
  `birthday` date NOT NULL,
  `gender` enum('f','m','u') NOT NULL DEFAULT 'u',
  `email` char(90) NOT NULL DEFAULT '',
  `skype` char(90) NOT NULL,
  `qq` char(20) NOT NULL DEFAULT '',
  `yahoo` char(90) NOT NULL DEFAULT '',
  `gtalk` char(90) NOT NULL DEFAULT '',
  `wangwang` char(90) NOT NULL DEFAULT '',
  `site` varchar(100) NOT NULL,
  `mobile` char(11) NOT NULL DEFAULT '',
  `phone` char(20) NOT NULL DEFAULT '',
  `address` char(120) NOT NULL DEFAULT '',
  `zipcode` char(10) NOT NULL DEFAULT '',
  `visits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(50) NOT NULL DEFAULT '',
  `last` datetime NOT NULL,
  `ping` datetime NOT NULL,
  `fails` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `join` datetime NOT NULL,
  `locked` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `admin` (`admin`),
  KEY `accountPassword` (`account`,`password`),
  KEY `dept` (`dept`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_group`;
CREATE TABLE IF NOT EXISTS `sys_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(30) NOT NULL,
  `desc` char(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_usergroup`;
CREATE TABLE `sys_usergroup` (
  `account` char(30) NOT NULL DEFAULT '',
  `group` mediumint(8) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_grouppriv`;
CREATE TABLE IF NOT EXISTS `sys_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `sys_userquery`;
CREATE TABLE IF NOT EXISTS `sys_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_cron`;
CREATE TABLE IF NOT EXISTS `sys_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sys_category` (`id`, `name`, `parent`, `path`, `grade`, `type`, `major`) VALUES
('1', '主营业务收入',   '0', ',1,', 1, 'in',  '1'),
('2', '非主营业务收入', '0', ',2,', 1, 'in',  '2'),
('3', '主营业务成本',   '0', ',3,', 1, 'out', '3'),
('4', '非主营业务成本', '0', ',4,', 1, 'out', '4'),
('5', '理财盈利',       '0', ',5,', 1, 'in',  '5'),
('6', '理财亏损',       '0', ',6,', 1, 'out', '6'),
('7', '手续费',         '0', ',7,', 1, 'out', '7'),
('8', '借贷利息',       '0', ',8,', 1, 'out', '8');

INSERT INTO `sys_group` VALUES (1,'管理员','管理员拥有前台所有权限'),(2,'财务专员','财务专员拥有现金流所有权限'),(3,'销售经理','销售经理拥有客户管理所有权限'),(4,'销售人员','默认的销售人员权限'),(5,'普通用户','默认的普通账号权限');
INSERT INTO `sys_usergroup` (account,`group`) SELECT account,5 FROM `sys_user`;
INSERT INTO `sys_schema` (`name`, `category`, `trader`, `type`, `money`, `desc`, `date`, `fee`) VALUES
('支付宝',       '', 'H', 'K', 'J',   'I,O', 'D', 'M'),
('中信银行简版', '', 'C', '',  'E,D', 'G,H', 'A', '');

INSERT INTO `sys_grouppriv` (`group`, `module`, `method`) VALUES
(1,'address','browse'),
(1,'address','create'),
(1,'address','delete'),
(1,'address','edit'),
(1,'announce','browse'),
(1,'announce','create'),
(1,'announce','delete'),
(1,'announce','edit'),
(1,'announce','view'),
(1,'apppriv','cash'),
(1,'apppriv','crm'),
(1,'apppriv','doc'),
(1,'apppriv','oa'),
(1,'apppriv','proj'),
(1,'apppriv','superadmin'),
(1,'apppriv','team'),
(1,'attend','browseReview'),
(1,'attend','company'),
(1,'attend','department'),
(1,'attend','export'),
(1,'attend','exportStat'),
(1,'attend','personalSettings'),
(1,'attend','review'),
(1,'attend','saveStat'),
(1,'attend','setManager'),
(1,'attend','settings'),
(1,'attend','stat'),
(1,'attend','detail'),
(1,'attend','exportDetail'),
(1,'balance','browse'),
(1,'balance','create'),
(1,'balance','delete'),
(1,'balance','edit'),
(1,'blog','create'),
(1,'blog','delete'),
(1,'blog','edit'),
(1,'blog','index'),
(1,'blog','view'),
(1,'contact','browse'),
(1,'contact','create'),
(1,'contact','delete'),
(1,'contact','edit'),
(1,'contact','export'),
(1,'contact','exportTemplate'),
(1,'contact','import'),
(1,'contact','showImport'),
(1,'contact','vcard'),
(1,'contact','view'),
(1,'contract','browse'),
(1,'contract','cancel'),
(1,'contract','create'),
(1,'contract','delete'),
(1,'contract','deleteDelivery'),
(1,'contract','deleteReturn'),
(1,'contract','delivery'),
(1,'contract','edit'),
(1,'contract','editDelivery'),
(1,'contract','editReturn'),
(1,'contract','export'),
(1,'contract','finish'),
(1,'contract','receive'),
(1,'contract','view'),
(1,'crm','manageAll'),
(1,'customer','assign'),
(1,'customer','batchAssign'),
(1,'customer','browse'),
(1,'customer','contact'),
(1,'customer','contract'),
(1,'customer','create'),
(1,'customer','delete'),
(1,'customer','edit'),
(1,'customer','export'),
(1,'customer','linkContact'),
(1,'customer','order'),
(1,'customer','view'),
(1,'customer','merge'),
(1,'depositor','activate'),
(1,'depositor','browse'),
(1,'depositor','check'),
(1,'depositor','create'),
(1,'depositor','delete'),
(1,'depositor','edit'),
(1,'depositor','export'),
(1,'depositor','forbid'),
(1,'depositor','savebalance'),
(1,'doc','index'),
(1,'doc','allLibs'),
(1,'doc','projectLibs'),
(1,'doc','showFiles'),
(1,'doc','browse'),
(1,'doc','create'),
(1,'doc','createLib'),
(1,'doc','delete'),
(1,'doc','deleteLib'),
(1,'doc','edit'),
(1,'doc','editLib'),
(1,'doc','view'),
(1,'doc','sort'),
(1,'egress','department'),
(1,'egress','company'),
(1,'forum','admin'),
(1,'forum','board'),
(1,'forum','index'),
(1,'forum','update'),
(1,'holiday','create'),
(1,'holiday','delete'),
(1,'holiday','edit'),
(1,'leads','apply'),
(1,'leads','assign'),
(1,'leads','browse'),
(1,'leads','create'),
(1,'leads','edit'),
(1,'leads','delete'),
(1,'leads','ignore'),
(1,'leads','transform'),
(1,'leads','view'),
(1,'leads','setting'),
(1,'leave','browseReview'),
(1,'leave','company'),
(1,'leave','review'),
(1,'leave','export'),
(1,'leave','setReviewer'),
(1,'lieu','browseReview'),
(1,'lieu','company'),
(1,'lieu','review'),
(1,'lieu','setReviewer'),
(1,'makeup','browseReview'),
(1,'makeup','company'),
(1,'makeup','review'),
(1,'makeup','export'),
(1,'makeup','setReviewer'),
(1,'my','company'),
(1,'order','activate'),
(1,'order','assign'),
(1,'order','browse'),
(1,'order','close'),
(1,'order','contact'),
(1,'order','create'),
(1,'order','delete'),
(1,'order','edit'),
(1,'order','export'),
(1,'order','view'),
(1,'overtime','browseReview'),
(1,'overtime','company'),
(1,'overtime','review'),
(1,'overtime','export'),
(1,'overtime','setReviewer'),
(1,'product','browse'),
(1,'product','create'),
(1,'product','delete'),
(1,'product','edit'),
(1,'product','view'),
(1,'provider','browse'),
(1,'provider','contact'),
(1,'provider','create'),
(1,'provider','delete'),
(1,'provider','edit'),
(1,'provider','linkContact'),
(1,'provider','view'),
(1,'refund','browseReview'),
(1,'refund','company'),
(1,'refund','reimburse'),
(1,'refund','review'),
(1,'refund','todo'),
(1,'refund','setReviewer'),
(1,'refund','setCategory'),
(1,'refund','setDepositor'),
(1,'refund','setRefundBy'),
(1,'refund','export'),
(1,'report','browse'),
(1,'resume','browse'),
(1,'resume','create'),
(1,'resume','delete'),
(1,'resume','edit'),
(1,'resume','leave'),
(1,'sales','admin'),
(1,'sales','browse'),
(1,'sales','create'),
(1,'sales','delete'),
(1,'sales','edit'),
(1,'schema','browse'),
(1,'schema','create'),
(1,'schema','delete'),
(1,'schema','edit'),
(1,'schema','view'),
(1,'setting','customerPool'),
(1,'setting','lang'),
(1,'setting','modules'),
(1,'setting','reset'),
(1,'user','active'),
(1,'user','admin'),
(1,'user','create'),
(1,'user','delete'),
(1,'user','edit'),
(1,'user','forbid'),
(1,'task','deleteAll'),
(1,'task','editAll'),
(1,'task','viewAll'),
(1,'thread','delete'),
(1,'thread','deleteFile'),
(1,'thread','edit'),
(1,'thread','post'),
(1,'thread','stick'),
(1,'thread','switchStatus'),
(1,'thread','transfer'),
(1,'thread','view'),
(1,'trade','batchCreate'),
(1,'trade','batchEdit'),
(1,'trade','browse'),
(1,'trade','view'),
(1,'trade','create'),
(1,'trade','delete'),
(1,'trade','detail'),
(1,'trade','edit'),
(1,'trade','export'),
(1,'trade','import'),
(1,'trade','invest'),
(1,'trade','loan'),
(1,'trade','report'),
(1,'trade','showImport'),
(1,'trade','transfer'),
(1,'trade','compare'),
(1,'trade','export2Excel'),
(1,'trade','setReportUnit'),
(1,'tree','browse'),
(1,'tree','children'),
(1,'tree','delete'),
(1,'tree','edit'),
(1,'tree','merge'),
(1,'trip','company'),
(1,'trip','department'),
(1,'user','colleague'),
(1,'company','index'),
(1,'file','upload'),
(1,'file','download'),
(1,'file','edit'),
(1,'file','delete'),
(2,'address','browse'),
(2,'announce','browse'),
(2,'announce','create'),
(2,'announce','edit'),
(2,'announce','view'),
(2,'apppriv','cash'),
(2,'apppriv','crm'),
(2,'apppriv','doc'),
(2,'apppriv','oa'),
(2,'apppriv','proj'),
(2,'apppriv','team'),
(2,'attend','company'),
(2,'attend','export'),
(2,'attend','exportStat'),
(2,'attend','saveStat'),
(2,'attend','stat'),
(2,'balance','browse'),
(2,'balance','create'),
(2,'balance','delete'),
(2,'balance','edit'),
(2,'blog','create'),
(2,'blog','edit'),
(2,'blog','index'),
(2,'blog','view'),
(2,'contact','browse'),
(2,'contact','vcard'),
(2,'contact','view'),
(2,'contract','browse'),
(2,'contract','view'),
(2,'crm','manageAll'),
(2,'customer','browse'),
(2,'customer','contact'),
(2,'customer','contract'),
(2,'customer','order'),
(2,'customer','view'),
(2,'depositor','activate'),
(2,'depositor','browse'),
(2,'depositor','check'),
(2,'depositor','create'),
(2,'depositor','delete'),
(2,'depositor','edit'),
(2,'depositor','export'),
(2,'depositor','forbid'),
(2,'depositor','savebalance'),
(2,'doc','index'),
(2,'doc','allLibs'),
(2,'doc','projectLibs'),
(2,'doc','showFiles'),
(2,'doc','browse'),
(2,'doc','create'),
(2,'doc','createLib'),
(2,'doc','edit'),
(2,'doc','editLib'),
(2,'doc','view'),
(2,'doc','sort'),
(2,'forum','admin'),
(2,'forum','board'),
(2,'forum','index'),
(2,'holiday','create'),
(2,'holiday','delete'),
(2,'holiday','edit'),
(2,'leads','browse'),
(2,'leads','view'),
(2,'leave','company'),
(2,'order','browse'),
(2,'order','contact'),
(2,'order','view'),
(2,'product','browse'),
(2,'product','view'),
(2,'provider','browse'),
(2,'provider','contact'),
(2,'provider','create'),
(2,'provider','delete'),
(2,'provider','edit'),
(2,'provider','linkContact'),
(2,'provider','view'),
(2,'refund','browseReview'),
(2,'refund','company'),
(2,'refund','reimburse'),
(2,'refund','review'),
(2,'refund','todo'),
(2,'refund','setCategory'),
(2,'refund','setDepositor'),
(2,'resume','browse'),
(2,'sales','browse'),
(2,'schema','browse'),
(2,'schema','create'),
(2,'schema','delete'),
(2,'schema','edit'),
(2,'schema','view'),
(2,'setting','lang'),
(2,'setting','reset'),
(2,'thread','edit'),
(2,'thread','post'),
(2,'thread','stick'),
(2,'thread','switchStatus'),
(2,'thread','transfer'),
(2,'thread','view'),
(2,'trade','batchCreate'),
(2,'trade','batchEdit'),
(2,'trade','browse'),
(2,'trade','view'),
(2,'trade','create'),
(2,'trade','delete'),
(2,'trade','detail'),
(2,'trade','edit'),
(2,'trade','export'),
(2,'trade','import'),
(2,'trade','invest'),
(2,'trade','report'),
(2,'trade','showimport'),
(2,'trade','transfer'),
(2,'trade','compare'),
(2,'trade','export2Excel'),
(2,'trade','setReportUnit'),
(2,'tree','browse'),
(2,'tree','children'),
(2,'tree','edit'),
(2,'tree','merge'),
(2,'trip','company'),
(2,'user','colleague'),
(2,'company','index'),
(2,'file','download'),
(2,'file','edit'),
(2,'file','delete'),
(3,'address','browse'),
(3,'address','create'),
(3,'address','delete'),
(3,'address','edit'),
(3,'announce','browse'),
(3,'announce','create'),
(3,'announce','edit'),
(3,'announce','view'),
(3,'apppriv','cash'),
(3,'apppriv','crm'),
(3,'apppriv','doc'),
(3,'apppriv','oa'),
(3,'apppriv','proj'),
(3,'apppriv','team'),
(3,'blog','create'),
(3,'blog','edit'),
(3,'blog','index'),
(3,'blog','view'),
(3,'contact','browse'),
(3,'contact','create'),
(3,'contact','delete'),
(3,'contact','edit'),
(3,'contact','export'),
(3,'contact','exportTemplate'),
(3,'contact','import'),
(3,'contact','showImport'),
(3,'contact','vcard'),
(3,'contact','view'),
(3,'contract','browse'),
(3,'contract','cancel'),
(3,'contract','create'),
(3,'contract','delete'),
(3,'contract','deleteDelivery'),
(3,'contract','deleteReturn'),
(3,'contract','delivery'),
(3,'contract','edit'),
(3,'contract','editDelivery'),
(3,'contract','editReturn'),
(3,'contract','export'),
(3,'contract','finish'),
(3,'contract','receive'),
(3,'contract','view'),
(3,'crm','manageAll'),
(3,'customer','assign'),
(3,'customer','browse'),
(3,'customer','contact'),
(3,'customer','contract'),
(3,'customer','create'),
(3,'customer','delete'),
(3,'customer','edit'),
(3,'customer','export'),
(3,'customer','linkContact'),
(3,'customer','order'),
(3,'customer','view'),
(3,'customer','merge'),
(3,'depositor','browse'),
(3,'doc','index'),
(3,'doc','allLibs'),
(3,'doc','projectLibs'),
(3,'doc','showFiles'),
(3,'doc','browse'),
(3,'doc','create'),
(3,'doc','createLib'),
(3,'doc','edit'),
(3,'doc','editLib'),
(3,'doc','view'),
(3,'doc','sort'),
(3,'forum','admin'),
(3,'forum','board'),
(3,'forum','index'),
(3,'leads','apply'),
(3,'leads','assign'),
(3,'leads','browse'),
(3,'leads','create'),
(3,'leads','edit'),
(3,'leads','delete'),
(3,'leads','ignore'),
(3,'leads','transform'),
(3,'leads','view'),
(3,'leads','setting'),
(3,'order','activate'),
(3,'order','assign'),
(3,'order','browse'),
(3,'order','close'),
(3,'order','contact'),
(3,'order','create'),
(3,'order','delete'),
(3,'order','edit'),
(3,'order','export'),
(3,'order','view'),
(3,'product','browse'),
(3,'product','create'),
(3,'product','delete'),
(3,'product','edit'),
(3,'product','view'),
(3,'refund','browseReview'),
(3,'refund','review'),
(3,'resume','browse'),
(3,'resume','create'),
(3,'resume','delete'),
(3,'resume','edit'),
(3,'resume','leave'),
(3,'sales','browse'),
(3,'sales','create'),
(3,'sales','delete'),
(3,'sales','edit'),
(3,'setting','customerPool'),
(3,'setting','lang'),
(3,'setting','reset'),
(3,'thread','edit'),
(3,'thread','post'),
(3,'thread','stick'),
(3,'thread','switchStatus'),
(3,'thread','transfer'),
(3,'thread','view'),
(3,'tree','browse'),
(3,'tree','children'),
(3,'tree','edit'),
(3,'user','colleague'),
(3,'company','index'),
(3,'file','download'),
(3,'file','edit'),
(3,'file','delete'),
(4,'address','browse'),
(4,'address','create'),
(4,'address','edit'),
(4,'announce','browse'),
(4,'announce','create'),
(4,'announce','edit'),
(4,'announce','view'),
(4,'apppriv','cash'),
(4,'apppriv','crm'),
(4,'apppriv','doc'),
(4,'apppriv','oa'),
(4,'apppriv','proj'),
(4,'apppriv','team'),
(4,'attend','browseReview'),
(4,'attend','department'),
(4,'attend','export'),
(4,'attend','review'),
(4,'blog','create'),
(4,'blog','edit'),
(4,'blog','index'),
(4,'blog','view'),
(4,'contact','browse'),
(4,'contact','create'),
(4,'contact','edit'),
(4,'contact','export'),
(4,'contact','exportTemplate'),
(4,'contact','import'),
(4,'contact','showImport'),
(4,'contact','vcard'),
(4,'contact','view'),
(4,'contract','browse'),
(4,'contract','cancel'),
(4,'contract','create'),
(4,'contract','delivery'),
(4,'contract','edit'),
(4,'contract','editDelivery'),
(4,'contract','editReturn'),
(4,'contract','export'),
(4,'contract','finish'),
(4,'contract','receive'),
(4,'contract','view'),
(4,'customer','assign'),
(4,'customer','batchAssign'),
(4,'customer','browse'),
(4,'customer','contact'),
(4,'customer','contract'),
(4,'customer','create'),
(4,'customer','edit'),
(4,'customer','export'),
(4,'customer','linkContact'),
(4,'customer','order'),
(4,'customer','view'),
(4,'customer','merge'),
(4,'depositor','browse'),
(4,'doc','index'),
(4,'doc','allLibs'),
(4,'doc','projectLibs'),
(4,'doc','showFiles'),
(4,'doc','browse'),
(4,'doc','create'),
(4,'doc','createLib'),
(4,'doc','edit'),
(4,'doc','editLib'),
(4,'doc','view'),
(4,'doc','sort'),
(4,'forum','admin'),
(4,'forum','board'),
(4,'forum','index'),
(4,'leads','apply'),
(4,'leads','assign'),
(4,'leads','browse'),
(4,'leads','create'),
(4,'leads','edit'),
(4,'leads','ignore'),
(4,'leads','transform'),
(4,'leads','view'),
(4,'leave','browseReview'),
(4,'leave','review'),
(4,'order','activate'),
(4,'order','assign'),
(4,'order','browse'),
(4,'order','close'),
(4,'order','contact'),
(4,'order','create'),
(4,'order','edit'),
(4,'order','export'),
(4,'order','view'),
(4,'product','browse'),
(4,'product','create'),
(4,'product','edit'),
(4,'product','view'),
(4,'resume','browse'),
(4,'resume','create'),
(4,'resume','edit'),
(4,'sales','browse'),
(4,'setting','lang'),
(4,'setting','reset'),
(4,'thread','edit'),
(4,'thread','post'),
(4,'thread','stick'),
(4,'thread','switchStatus'),
(4,'thread','transfer'),
(4,'thread','view'),
(4,'tree','browse'),
(4,'tree','children'),
(4,'tree','edit'),
(4,'trip','department'),
(4,'user','colleague'),
(4,'company','index'),
(4,'file','edit'),
(4,'file','delete'),
(5,'announce','browse'),
(5,'announce','create'),
(5,'announce','edit'),
(5,'announce','view'),
(5,'apppriv','oa'),
(5,'apppriv','doc'),
(5,'apppriv','proj'),
(5,'apppriv','team'),
(5,'blog','create'),
(5,'blog','edit'),
(5,'blog','index'),
(5,'blog','view'),
(5,'doc','index'),
(5,'doc','allLibs'),
(5,'doc','projectLibs'),
(5,'doc','showFiles'),
(5,'doc','browse'),
(5,'doc','create'),
(5,'doc','createLib'),
(5,'doc','edit'),
(5,'doc','editLib'),
(5,'doc','view'),
(5,'doc','sort'),
(5,'forum','admin'),
(5,'forum','board'),
(5,'forum','index'),
(5,'thread','edit'),
(5,'thread','post'),
(5,'thread','stick'),
(5,'thread','switchStatus'),
(5,'thread','transfer'),
(5,'thread','view'),
(5,'user','colleague'),
(5,'company','index'),
(5,'file','edit'),
(5,'file','delete');

INSERT INTO `sys_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*', '*', '*', '*', '*', '', '监控定时任务', 'ranzhi', 1, 'normal', '0000-00-00 00:00:00'),
('1', '1', '*', '*', '*', 'appName=sys&moduleName=backup&methodName=backup&reload=0', '定时备份任务', 'ranzhi', 0, 'normal', '0000-00-00 00:00:00'),
('1', '1', '*', '*', '*', 'appName=sys&moduleName=backup&methodName=batchdelete&saveDays=30', '删除30天前的备份', 'ranzhi', 0, 'normal', '0000-00-00 00:00:00');
-- DROP TABLE IF EXISTS `im_chat`;
CREATE TABLE IF NOT EXISTS `im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastActiveTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `im_message`;
CREATE TABLE IF NOT EXISTS `im_message` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('normal', 'broadcast') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'emotion', 'image', 'file', 'object') NOT NULL DEFAULT 'text',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `im_chatuser`;
CREATE TABLE IF NOT EXISTS `im_chatuser`(
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`),
  UNIQUE KEY `chatuser` (`cgid`, `user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `im_usermessage`;
CREATE TABLE IF NOT EXISTS `im_usermessage`(
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `level` smallint(5) NOT NULL DEFAULT 3,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `data` text NOT NULL DEFAULT '',
  PRIMARY KEY `id` (`id`),
  KEY `muser` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `im_chatfile`;
CREATE TABLE IF NOT EXISTS `im_chatfile`(
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `file` mediumint(8) NOT NULL DEFAULT 0,
  `title` char(90) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chatfile` (`gid`, `file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `sys_user` ADD `status` enum('online', 'away', 'busy', 'offline') NOT NULL DEFAULT 'offline'; 
-- DROP TABLE IF EXISTS `cash_fund`;
CREATE TABLE IF NOT EXISTS `cash_fund` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL DEFAULT 'receivable',
  `origin` varchar(20) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `trader` mediumint(8) unsigned NOT NULL,
  `contract` mediumint(8) unsigned NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `batch` mediumint(8) unsigned NOT NULL,
  `deserved` decimal(15,2) NOT NULL,
  `actual` decimal(15,2) NOT NULL,
  `in` decimal(15,2) NOT NULL,
  `out` decimal(15,2) NOT NULL,
  `balance` decimal(15,2) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `origin` (`origin`),
  KEY `parent` (`parent`),
  KEY `trader` (`trader`),
  KEY `order` (`order`),
  KEY `batch` (`batch`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `crm_orderaction`;
CREATE TABLE `crm_orderaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `action` char(30) NOT NULL,
  `name` char(100) NOT NULL,
  `conditions` text NOT NULL,
  `inputs` text NOT NULL,
  `results` text NOT NULL,
  `tasks` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `crm_orderfield`;
CREATE TABLE `crm_orderfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `field` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `order` tinyint(3) NOT NULL,
  `control` varchar(10) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `desc` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `hr_salary`;
CREATE TABLE `hr_salary` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `month` char(10) NOT NULL,
  `account` char(30) NOT NULL,
  `dept` mediumint(8) NOT NULL,
  `basic` decimal(12,2) NOT NULL,
  `benefit` decimal(12,2) NOT NULL,
  `bonus` decimal(12,2) NOT NULL,
  `allowance` decimal(12,2) NOT NULL,
  `deduction` decimal(12,2) NOT NULL,
  `deserved` decimal(12,2) NOT NULL,
  `actual` decimal(12,2) NOT NULL,
  `companySSF` decimal(12,2) NOT NULL,
  `companyHPF` decimal(12,2) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`),
  KEY `month` (`month`),
  KEY `account` (`account`),
  KEY `dept` (`dept`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `hr_salarydetail`;
CREATE TABLE `hr_salarydetail` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `salary` mediumint(8) NOT NULL,
  `item` enum('bonus', 'allowance', 'deduction') NOT NULL,
  `type` varchar(100) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `desc` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `salary` (`salary`),
  KEY `item` (`item`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `hr_salarycommission`;
CREATE TABLE `hr_salarycommission` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `salary` mediumint(8) NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'sale',
  `line` varchar(60) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `rate` decimal(12,2) NOT NULL,
  `commission` decimal(12,2) NOT NULL,
  `desc` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `salarycommission` (`salary`, `type`, `line`),
  KEY `salary` (`salary`),
  KEY `line` (`line`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `hr_tradecommission`;
CREATE TABLE `hr_tradecommission` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT 'sale',
  `trade` mediumint(8) NOT NULL,
  `account` char(30) NOT NULL,
  `contribution` decimal(12,2) NOT NULL,
  `rate` decimal(12,2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `desc` text,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `trade` (`trade`),
  UNIQUE KEY `tradecommission` (`type`, `trade`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `hr_commissionrule`;
CREATE TABLE `hr_commissionrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `month` char(10) NOT NULL,
  `account` char(30) NOT NULL,
  `sale` text NOT NULL,
  `line` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `month` (`month`),
  KEY `account` (`account`),
  UNIQUE KEY `monthaccount` (`month`, `account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `psi_batch`;
CREATE TABLE IF NOT EXISTS `psi_batch` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `batchNo` varchar(255) NOT NULL,
  `type` enum('in', 'out') NOT NULL DEFAULT 'in',
  `trader` mediumint(8) unsigned NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `fund` mediumint(8) unsigned NOT NULL,
  `money` decimal(15,2) NOT NULL,
  `pickedBy` char(30) NOT NULL,
  `pickedDate` datetime  NOT NULL,
  `expressedBy` char(30) NOT NULL,
  `expressedDate` datetime NOT NULL,
  `express` smallint(5) unsigned NOT NULL,
  `waybill` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `status` char(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order` (`order`),
  KEY `trader` (`trader`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `psi_batchproduct`;
CREATE TABLE IF NOT EXISTS `psi_batchproduct` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `order` mediumint(8) unsigned NOT NULL,
  `trader` mediumint(8) unsigned NOT NULL,
  `batch` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `money` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `batch` (`batch`),
  KEY `order` (`order`),
  KEY `trader` (`trader`),
  KEY `product` (`product`),
  UNIQUE KEY `batchProduct` (`batch`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `psi_order`;
CREATE TABLE IF NOT EXISTS `psi_order` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `orderNo` varchar(255) NOT NULL,
  `type` enum('sale', 'purchase') NOT NULL DEFAULT 'sale',
  `trader` mediumint(8) unsigned NOT NULL,
  `contract` mediumint(8) unsigned NOT NULL,
  `money` decimal(15,2) NOT NULL,
  `taxed` enum('0', '1') NOT NULL DEFAULT '1',
  `settlement` char(30) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedDate` datetime NOT NULL,
  `status` char(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `trader` (`trader`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `psi_orderproduct`;
CREATE TABLE IF NOT EXISTS `psi_orderproduct` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `order` mediumint(8) unsigned NOT NULL,
  `trader` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `money` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order` (`order`),
  KEY `trader` (`trader`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `psi_purchaseproduct`;
CREATE TABLE IF NOT EXISTS `psi_purchaseproduct` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `order` mediumint(8) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `status` char(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order` (`order`),
  KEY `product` (`product`),
  UNIQUE KEY `orderProduct` (`order`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_issue`;
CREATE TABLE `sys_issue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `category` mediumint(8) unsigned NOT NULL,
  `customer` mediumint(8) NOT NULL,
  `contact` mediumint(8) NOT NULL,
  `pri` tinyint(3) unsigned DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` varchar(30) NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `viewedDate` datetime NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `repliedBy` char(30) NOT NULL,
  `repliedDate` datetime NOT NULL,
  `transferedBy` char(30) NOT NULL,
  `transferedDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `activatedBy` char(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `toObjectType` varchar(30) NOT NULL,
  `toObjectID` mediumint(8) unsigned NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_searchdict`;
CREATE TABLE IF NOT EXISTS `sys_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_searchindex`;
CREATE TABLE IF NOT EXISTS `sys_searchindex` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`title`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_store`;
CREATE TABLE IF NOT EXISTS `sys_store` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `location` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `manager` varchar(100) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_weekly`;
CREATE TABLE IF NOT EXISTS `sys_weekly` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `summary` text NOT NULL,
  `content` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `status` enum('draft', 'normal') NOT NULL DEFAULT 'normal',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;

-- DROP TABLE IF EXISTS `sys_workflow`;
CREATE TABLE `sys_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` varchar(30) NOT NULL, 
  `child` varchar(30) NOT NULL, 
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `app` varchar(20) NOT NULL,
  `position` varchar(20) NOT NULL,
  `module` varchar(30) NOT NULL,
  `name` varchar(30) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `administrator` text NOT NULL,
  `desc` text NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`app`, `module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowaction`;
CREATE TABLE `sys_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `open` varchar(20) NOT NULL,
  `position` enum('menu', 'browseandview', 'browse', 'view') NOT NULL DEFAULT 'browseandview',
  `show` enum('dropdownlist', 'direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL,
  `conditions` text NOT NULL,
  `verifications` text NOT NULL,
  `results` text NOT NULL,
  `toList` char(255) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowdatasource`;
CREATE TABLE `sys_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'sql', 'func', 'option', 'lang') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL,
  `datasource` text NOT NULL, 
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowfield`;
CREATE TABLE `sys_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `control` varchar(10) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `canSearch` enum('0', '1') NOT NULL DEFAULT '1',
  `isForeignKey` enum('0', '1') NOT NULL DEFAULT '0',
  `isKey` enum('0', '1') NOT NULL DEFAULT '0',
  `isValue` enum('0', '1') NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowlayout`;
CREATE TABLE `sys_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `width` smallint(5) NOT NULL,
  `position` text NOT NULL,
  `mobileShow` enum('1', '0') NOT NULL DEFAULT '0',
  `defaultValue` text NOT NULL,
  `layoutRules` varchar(255) NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowmenu`;
CREATE TABLE `sys_workflowmenu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `label` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowrule`;
CREATE TABLE `sys_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('regex', 'func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL,
  `rule` text NOT NULL, 
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowsql`;
CREATE TABLE `sys_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_workflowversion`;
CREATE TABLE IF NOT EXISTS `sys_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `version` varchar(10) NOT NULL,
  `fields` text NOT NULL,
  `actions` text NOT NULL,
  `layouts` text NOT NULL,
  `sqls` text NOT NULL,
  `menus` text NOT NULL,
  `table` text NOT NULL,
  `datas` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`, `version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_effort`;
CREATE TABLE IF NOT EXISTS `sys_effort` (
  `id` MEDIUMINT( 8 ) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `objectType` VARCHAR( 30 ) NOT NULL,
  `objectID` SMALLINT( 8 ) UNSIGNED NOT NULL,
  `project` MEDIUMINT( 8 ) UNSIGNED NOT NULL,
  `account` VARCHAR( 30 ) NOT NULL,
  `work` VARCHAR( 255 ) NOT NULL,
  `date` DATE NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `begin` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL,
  `end` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL,
  KEY `effort` (`project`,`objectID`,`date`,`account`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;

-- DROP TABLE IF EXISTS `sys_oauth`;
CREATE TABLE IF NOT EXISTS `sys_oauth` (
  `account` varchar(30) NOT NULL,
  `provider` varchar(30) NOT NULL,
  `openID` varchar(60) NOT NULL,
  UNIQUE KEY `account` (`account`,`provider`,`openID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_searchdict`;
CREATE TABLE IF NOT EXISTS `sys_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `sys_searchindex`;
CREATE TABLE IF NOT EXISTS `sys_searchindex` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`title`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `cash_trade`  ADD `commission` decimal(12,2) NOT NULL AFTER `money`;

ALTER TABLE `crm_contact`  ADD `register` datetime NOT NULL;
ALTER TABLE `crm_contact`  ADD `last` datetime NOT NULL;
ALTER TABLE `crm_contact`  ADD `visits` mediumint(8) NOT NULL;
ALTER TABLE `crm_contact`  ADD `ip` char(50) NOT NULL;
ALTER TABLE `crm_contract` ADD `fund` mediumint(8) unsigned NOT NULL AFTER `contact`;

ALTER TABLE `oa_leave` ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `oa_leave` ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `oa_leave` ADD `reviewers` text NOT NULL;
ALTER TABLE `oa_lieu` ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `oa_lieu` ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `oa_lieu` ADD `reviewers` text NOT NULL;
ALTER TABLE `oa_overtime` ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `oa_overtime` ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `oa_overtime` ADD `reviewers` text NOT NULL;
ALTER TABLE `oa_refund` ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `oa_refund` ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `oa_refund` ADD `reviewers` text NOT NULL;

ALTER TABLE `sys_action`  CHANGE `extra` `extra` text;
ALTER TABLE `sys_action`   ADD `origin` varchar(256) NOT NULL;
ALTER TABLE `sys_action`   ADD `efforted` BOOL NOT NULL DEFAULT  '0';
ALTER TABLE `sys_category` ADD `wechatDept` varchar(100) NOT NULL AFTER `id`;
ALTER TABLE `sys_product`  ADD `roles` varchar(255) NOT NULL;
ALTER TABLE `sys_product`  ADD `category` mediumint(8) unsigned NOT NULL AFTER `type`;
ALTER TABLE `sys_product`  ADD `pinyin` char(200) NOT NULL AFTER `category`;
ALTER TABLE `sys_product`  ADD `model` char(30) NOT NULL AFTER `pinyin`;
ALTER TABLE `sys_product`  ADD `unit` char(30) NOT NULL AFTER `model`;
ALTER TABLE `sys_product`  ADD `barcode` char(30) NOT NULL AFTER `unit`;
ALTER TABLE `sys_product`  ADD `brand` varchar(100) NOT NULL AFTER `barcode`;
ALTER TABLE `sys_product`  ADD `store` smallint(5) unsigned NOT NULL AFTER `brand`;
ALTER TABLE `sys_product`  ADD `price` decimal(15,2) NOT NULL AFTER `store`;
ALTER TABLE `sys_product`  ADD `amount` decimal(15,2) NOT NULL AFTER `price`;

INSERT INTO `sys_config` (`owner`, `app`, `module`, `section`, `key`, `value`) VALUES ('system','psi','order','orderNo','sale','[{\"type\":\"fixed\",\"fixed\":\"SO\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"year\",\"fixed\":\"\",\"yearLength\":\"4\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"month\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"day\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"AI\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"3\",\"AIClearType\":\"day\"}]'),('system','psi','order','orderNo','purchase','[{\"type\":\"fixed\",\"fixed\":\"PI\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"year\",\"fixed\":\"\",\"yearLength\":\"4\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"month\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"day\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"AI\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"3\",\"AIClearType\":\"day\"}]'),('system','psi','order','orderNo','out','[{\"type\":\"fixed\",\"fixed\":\"IO\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"year\",\"fixed\":\"\",\"yearLength\":\"4\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"month\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"day\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"AI\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"3\",\"AIClearType\":\"day\"}]'),('system','psi','order','orderNo','in','[{\"type\":\"fixed\",\"fixed\":\"II\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"year\",\"fixed\":\"\",\"yearLength\":\"4\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"month\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"day\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"\",\"AIClearType\":\"\"},{\"type\":\"AI\",\"fixed\":\"\",\"yearLength\":\"\",\"AILength\":\"3\",\"AIClearType\":\"day\"}]');

INSERT INTO `sys_entry` (`name`, `abbr`, `code`, `buildin`, `integration`, `open`, `key`, `ip`, `logo`, `login`, `control`, `size`, `position`, `visible`, `order`) VALUES
('人力资源', '人资', 'hr', 1, 1, 'iframe', '70a4ec7bf82d831b09578f554141eed0', '*', 'theme/default/images/ips/app-hr.png', '../hr', 'simple', 'max', 'default', 1, 70),
('进销存', '进销存', 'psi', 1, 1, 'iframe', 'be546d3fbb91fa8236b53a8c5fa90884', '*', 'theme/default/images/ips/app-psi.png', '../psi', 'simple', 'max', 'default', 1, 80),
('工作流', '工作流', 'flow', 1, 1, 'iframe', '68149a7806b73b5b0e16bc0a42bfcf43', '*', 'theme/default/images/ips/app-flow.png', '../flow', 'simple', 'max', 'default', 1, 90);

INSERT INTO `sys_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('1', '1', '*', '*', '*', 'appName=crm&moduleName=leads&methodName=sync', '名单同步任务', 'ranzhi', 0, 'normal', '0000-00-00 00:00:00');

INSERT INTO `sys_grouppriv` (`group`, `module`, `method`) VALUES
(1,'apppriv','flow'),
(1,'apppriv','hr'),
(1,'apppriv','psi'),
(1,'batch','browse'),
(1,'batch','browsePurchaseOrders'),
(1,'batch','browseFinished'),
(1,'batch','detail'),
(1,'batch','deliver'),
(1,'batch','editDeliver'),
(1,'batch','receive'),
(1,'batch','editReceive'),
(1,'batch','editPick'),
(1,'batch','printBatch'),
(1,'commission','batchSwitchIgnore'),
(1,'commission','browse'),
(1,'commission','create'),
(1,'commission','export'),
(1,'commission','report'),
(1,'commission','setCategory'),
(1,'commission','setLineCommission'),
(1,'commission','setSaleCommission'),
(1,'commission','setting'),
(1,'commission','switchIgnore'),
(1,'contract','expense'),
(1,'contract','setting'),
(1,'feedback','activate'),
(1,'feedback','assignTo'),
(1,'feedback','close'),
(1,'feedback','company'),
(1,'feedback','create'),
(1,'feedback','delete'),
(1,'feedback','doubt'),
(1,'feedback','edit'),
(1,'feedback','reply'),
(1,'feedback','transfer'),
(1,'feedback','view'),
(1,'leads','adminSites'),
(1,'leads','createSite'),
(1,'leads','deleteSite'),
(1,'leads','editSite'),
(1,'leads','sync'),
(1,'my','deptSalary'),
(1,'order','team'),
(1,'payable','payable'),
(1,'payable','paid'),
(1,'payable','create'),
(1,'payable','edit'),
(1,'payable','delete'),
(1,'payable','view'),
(1,'payable','pay'),
(1,'product','actionconditions'),
(1,'product','actioninputs'),
(1,'product','actionresults'),
(1,'product','actiontasks'),
(1,'product','adminaction'),
(1,'product','adminfield'),
(1,'product','adminroles'),
(1,'product','batchCreate'),
(1,'product','batchCreateProperties'),
(1,'product','browseProperties'),
(1,'product','copy'),
(1,'product','createaction'),
(1,'product','createfield'),
(1,'product','createresult'),
(1,'product','createFromOrder'),
(1,'product','createProperty'),
(1,'product','deleteaction'),
(1,'product','deletefield'),
(1,'product','deleteProperty'),
(1,'product','deleteresult'),
(1,'product','editaction'),
(1,'product','editfield'),
(1,'product','editProperty'),
(1,'product','editresult'),
(1,'purchase','browse'),
(1,'purchase','create'),
(1,'purchase','edit'),
(1,'purchase','delete'),
(1,'purchase','detail'),
(1,'purchase','cancel'),
(1,'purchase','activate'),
(1,'purchase','finish'),
(1,'purchase','purchase'),
(1,'purchase','sendMail'),
(1,'purchase','printOrder'),
(1,'purchase','report'),
(1,'receivable','receivable'),
(1,'receivable','received'),
(1,'receivable','create'),
(1,'receivable','edit'),
(1,'receivable','delete'),
(1,'receivable','view'),
(1,'receivable','receive'),
(1,'salary','batchConfirm'),
(1,'salary','batchCreate'),
(1,'salary','batchDelete'),
(1,'salary','batchEdit'),
(1,'salary','company'),
(1,'salary','confirm'),
(1,'salary','delete'),
(1,'salary','dept'),
(1,'salary','edit'),
(1,'salary','export'),
(1,'salary','report'),
(1,'salary','setAllowance'),
(1,'salary','setBasic'),
(1,'salary','setBonus'),
(1,'salary','setSSF'),
(1,'sale','browse'),
(1,'sale','create'),
(1,'sale','edit'),
(1,'sale','delete'),
(1,'sale','detail'),
(1,'sale','cancel'),
(1,'sale','activate'),
(1,'sale','finish'),
(1,'sale','assignToPick'),
(1,'sale','assignToPurchase'),
(1,'sale','printOrder'),
(1,'sale','report'),
(1,'store','browse'),
(1,'store','create'),
(1,'store','edit'),
(1,'store','delete'),
(1,'user','importLDAP'),
(1,'workflow','adminAction'),
(1,'workflow','adminCondition'),
(1,'workflow','adminDatasource'),
(1,'workflow','adminField'),
(1,'workflow','adminLayout'),
(1,'workflow','adminModuleMenu'),
(1,'workflow','adminResult'),
(1,'workflow','adminRule'),
(1,'workflow','backup'),
(1,'workflow','browse'),
(1,'workflow','browseTable'),
(1,'workflow','create'),
(1,'workflow','createAction'),
(1,'workflow','createDatasource'),
(1,'workflow','createField'),
(1,'workflow','createModuleMenu'),
(1,'workflow','createResult'),
(1,'workflow','createRule'),
(1,'workflow','delete'),
(1,'workflow','deleteAction'),
(1,'workflow','deleteDatasource'),
(1,'workflow','deleteField'),
(1,'workflow','deleteModuleMenu'),
(1,'workflow','deleteResult'),
(1,'workflow','deleteRule'),
(1,'workflow','edit'),
(1,'workflow','editAction'),
(1,'workflow','editDatasource'),
(1,'workflow','editField'),
(1,'workflow','editModuleMenu'),
(1,'workflow','editResult'),
(1,'workflow','editRule'),
(1,'workflow','setNotice'),
(1,'workflow','setSubModule'),
(1,'workflow','upgrade'),
(1,'workflow','verification'),
(1,'workflow','view'),
(1,'workflow','viewRule'),
(2,'apppriv','hr'),
(2,'salary','dept'),
(2,'salary','company'),
(2,'salary','batchCreate'),
(2,'salary', 'batchEdit'),
(2,'salary','export'),
(2,'salary','edit'),
(2,'salary','confirm'),
(2,'salary','batchConfirm'),
(2,'salary','delete'),
(2,'salary','batchDelete'),
(2,'salary','setBasic'),
(2,'salary','setBonus'),
(2,'salary','setAllowance'),
(2,'salary','setSSF'),
(2,'salary','report'),
(2,'commission','browse'),
(2,'commission','create'),
(2,'commission','batchCreate'),
(2,'commission','report'),
(2,'commission','setting'),
(2,'commission','setSaleCommission'),
(2,'commission','setLineCommission'),
(2,'commission','setCategory'),
(2,'commission','switchIgnore'),
(2,'commission','batchSwitchIgnore'),
(3,'feedback','company'),
(3,'feedback','create'),
(3,'feedback','edit'),
(3,'feedback','view'),
(3,'feedback','reply'),
(3,'feedback','doubt'),
(3,'feedback','transfer'),
(3,'feedback','assignTo'),
(3,'feedback','close'),
(3,'feedback','delete'),
(3,'leads','adminSites'),
(3,'leads','createSite'),
(3,'leads','deleteSite'),
(3,'leads','editSite'),
(3,'leads','sync'),
(3,'order','team'),
(3,'product','actionconditions'),
(3,'product','actioninputs'),
(3,'product','actionresults'),
(3,'product','actiontasks'),
(3,'product','adminaction'),
(3,'product','adminfield'),
(3,'product','adminroles'),
(3,'product','copy'),
(3,'product','createaction'),
(3,'product','createfield'),
(3,'product','createresult'),
(3,'product','deleteaction'),
(3,'product','deletefield'),
(3,'product','deleteresult'),
(3,'product','editaction'),
(3,'product','editfield'),
(3,'product','editresult'),
(4,'feedback','company'),
(4,'feedback','create'),
(4,'feedback','edit'),
(4,'feedback','view'),
(4,'feedback','reply'),
(4,'feedback','doubt'),
(4,'feedback','transfer'),
(4,'feedback','assignTo');

-- DROP TABLE IF EXISTS `flow_car`;
CREATE TABLE `flow_car` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `code` varchar(200) NOT NULL,
  `driver` varchar(200) NOT NULL,
  `mobile` varchar(200) NOT NULL,
  `buyDate` date NOT NULL,
  `price` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'normal',
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_carbooking`;
CREATE TABLE `flow_carbooking` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `appliedBy` varchar(200) NOT NULL,
  `appliedDate` datetime NOT NULL,
  `car` varchar(200) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `reason` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'wait',
  `reviewedBy` varchar(200) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_collect`;
CREATE TABLE `flow_collect` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `appliedBy` varchar(200) NOT NULL,
  `appliedDate` datetime NOT NULL,
  `money` varchar(200) NOT NULL,
  `reason` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'wait',
  `reviewedBy` varchar(200) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `depositor` varchar(200) NOT NULL,
  `category` varchar(200) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_meetingroom`;
CREATE TABLE `flow_meetingroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `position` varchar(200) NOT NULL,
  `seats` varchar(200) NOT NULL,
  `equipment` varchar(200) NOT NULL,
  `workday` varchar(200) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_meetingroombooking`;
CREATE TABLE `flow_meetingroombooking` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `room` varchar(200) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `orderedBy` varchar(200) NOT NULL,
  `orderedDate` datetime NOT NULL,
  `desc` varchar(200) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_buy`;
CREATE TABLE `flow_buy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `provider` varchar(200) NOT NULL,
  `goods` varchar(200) NOT NULL,
  `money` varchar(200) NOT NULL,
  `desc` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `depositor` varchar(200) NOT NULL,
  `category` varchar(200) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `flow_stamp`;
CREATE TABLE `flow_stamp` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `proposer` varchar(200) NOT NULL,
  `reason` varchar(200) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `type` varchar(200) NOT NULL,
  `desc` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'wait',
  `reviewedBy` varchar(200) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `sys_workflow` VALUES (1,'meetingroombooking','','flow','flow','','meetingroom','会议室',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(2,'','meetingroom','flow','flow','','meetingroombooking','会议室预订',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(3,'','','flow','flow','','stamp','印章申请',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(4,'carbooking','','flow','flow','','car','车辆信息',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(5,'','car','flow','flow','','carbooking','车辆预订',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(6,'','','flow','flow','','collect','请款',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(7,'','','flow','flow','','buy','采购',0,'{\"users\":[],\"groups\":[]}','','1.0','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0');
INSERT INTO `sys_workflowaction` VALUES (1,'meetingroom','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(2,'meetingroom','create','新建','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(3,'meetingroom','edit','编辑','','browseandview','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(4,'meetingroom','view','详情','normal','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 11:13:08','0'),(5,'meetingroom','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(6,'meetingroombooking','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(7,'meetingroombooking','create','预订','','menu','direct',0,'[]','{\"type\":\"sql\",\"message\":\"\\u8be5\\u65f6\\u95f4\\u6bb5\\u5df2\\u88ab\\u9884\\u8ba2\",\"sql\":\"select * from flow_meetingroombooking where deleted=\'0\' and room=\'$room\' and ((begin >= \'$begin\' and end <= \'$end\') or (begin <= \'$begin\' and end >= \'$end\') or (begin > \'$begin\' and begin < \'$end\') or (end > \'$begin\' and end < \'$end\'))\",\"sqlVars\":[{\"varName\":\"room\",\"paramType\":\"form\",\"param\":\"room\"},{\"varName\":\"begin\",\"paramType\":\"form\",\"param\":\"begin\"},{\"varName\":\"end\",\"paramType\":\"form\",\"param\":\"end\"}],\"sqlResult\":\"empty\"}','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 10:49:48','0'),(8,'meetingroombooking','edit','编辑','','browseandview','direct',0,'[]','{\"type\":\"sql\",\"message\":\"\\u8be5\\u65f6\\u95f4\\u6bb5\\u5df2\\u88ab\\u9884\\u8ba2\",\"sql\":\"select * from flow_meetingroombooking where deleted=\'0\' and room=\'$room\' and id != \'$id\' and ((begin >= \'$begin\' and end <= \'$end\') or (begin <= \'$begin\' and end >= \'$end\') or (begin > \'$begin\' and begin < \'$end\') or (end > \'$begin\' and end < \'$end\'))\",\"sqlVars\":[{\"varName\":\"room\",\"paramType\":\"form\",\"param\":\"room\"},{\"varName\":\"begin\",\"paramType\":\"form\",\"param\":\"begin\"},{\"varName\":\"end\",\"paramType\":\"form\",\"param\":\"end\"},{\"varName\":\"id\",\"paramType\":\"record\",\"param\":\"id\"}],\"sqlResult\":\"empty\"}','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(9,'meetingroombooking','view','详情','normal','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 11:14:53','0'),(10,'meetingroombooking','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(11,'stamp','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(12,'stamp','create','新建','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(13,'stamp','edit','编辑','','browseandview','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(14,'stamp','view','查看详情','','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(15,'stamp','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(16,'stamp','revoke','撤销','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"proposer\",\"operator\":\"equal\",\"param\":\"currentUser\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"stamp\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"draft\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_stamp`  SET  `status` = \'draft\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(17,'stamp','submit','提交','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"draft\"},{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"proposer\",\"operator\":\"equal\",\"param\":\"currentUser\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"stamp\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"wait\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_stamp`  SET  `status` = \'wait\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(18,'stamp','pass','通过','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"stamp\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"pass\"},{\"field\":\"reviewedBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"reviewedDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_stamp`  SET  `status` = \'pass\',  `reviewedBy` = \'$actor\',  `reviewedDate` = \'$now\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":{\"reviewedBy\":\"actor\",\"reviewedDate\":\"now\"},\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 14:09:09','0'),(19,'stamp','reject','拒绝','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"},{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"stamp\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"reject\"},{\"field\":\"reviewedBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"reviewedDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_stamp`  SET  `status` = \'reject\',  `reviewedBy` = \'$actor\',  `reviewedDate` = \'$now\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":{\"reviewedBy\":\"actor\",\"reviewedDate\":\"now\"},\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(20,'car','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(21,'car','create','新建','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(22,'car','edit','编辑','','browseandview','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(23,'car','view','详情','normal','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 13:18:22','0'),(24,'car','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(25,'carbooking','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(26,'carbooking','create','预订','','menu','direct',0,'[]','{\"type\":\"sql\",\"message\":\"\\u8be5\\u65f6\\u95f4\\u6bb5\\u5df2\\u88ab\\u9884\\u8ba2\",\"sql\":\"select * from flow_carbooking where deleted=\'0\' and car=\'$car\' and ((begin >= \'$begin\' and end <= \'$end\') or (begin <= \'$begin\' and end >= \'$end\') or (begin > \'$begin\' and begin < \'$end\') or (end > \'$begin\' and end < \'$end\'))\",\"sqlVars\":[{\"varName\":\"car\",\"paramType\":\"form\",\"param\":\"car\"},{\"varName\":\"begin\",\"paramType\":\"form\",\"param\":\"begin\"},{\"varName\":\"end\",\"paramType\":\"form\",\"param\":\"end\"}],\"sqlResult\":\"empty\"}','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 13:36:02','0'),(27,'carbooking','edit','编辑','','browseandview','direct',0,'[]','{\"type\":\"sql\",\"message\":\"\\u8be5\\u65f6\\u95f4\\u6bb5\\u5df2\\u88ab\\u9884\\u8ba2\",\"sql\":\"select * from flow_carbooking where deleted=\'0\' and car = \'$car\' and id != \'$id\' and  ((begin >= \'$begin\' and end <= \'$end\') or (begin <= \'$begin\' and end >= \'$end\') or (begin > \'$begin\' and begin < \'$end\') or (end > \'$begin\' and end < \'$end\'))\",\"sqlVars\":[{\"varName\":\"car\",\"paramType\":\"form\",\"param\":\"car\"},{\"varName\":\"begin\",\"paramType\":\"form\",\"param\":\"begin\"},{\"varName\":\"end\",\"paramType\":\"form\",\"param\":\"end\"},{\"varName\":\"id\",\"paramType\":\"record\",\"param\":\"id\"}],\"sqlResult\":\"empty\"}','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(28,'carbooking','view','详情','normal','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 13:25:59','0'),(29,'carbooking','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(30,'carbooking','pass','通过','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"carbooking\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"pass\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_carbooking`  SET  `status` = \'pass\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(31,'carbooking','reject','拒绝','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"carbooking\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"reject\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_carbooking`  SET  `status` = \'reject\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(32,'collect','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(33,'collect','create','新建','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(34,'collect','edit','编辑','','browseandview','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(35,'collect','view','详情','normal','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','admin','2016-11-23 14:00:40','0'),(36,'collect','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(37,'collect','pass','通过','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"},{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"collect\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"pass\"},{\"field\":\"reviewedBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"reviewedDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_collect`  SET  `status` = \'pass\',  `reviewedBy` = \'$actor\',  `reviewedDate` = \'$now\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":{\"reviewedBy\":\"actor\",\"reviewedDate\":\"now\"},\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(38,'collect','reject','拒绝','none','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"wait\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"collect\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"reject\"},{\"field\":\"reviewedBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"reviewedDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_collect`  SET  `status` = \'reject\',  `reviewedBy` = \'$actor\',  `reviewedDate` = \'$now\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":{\"reviewedBy\":\"actor\",\"reviewedDate\":\"now\"},\"formVars\":[],\"recordVars\":{\"id\":\"id\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(39,'collect','pay','付款','modal','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"pass\"},{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"collect\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"closed\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_collect`  SET  `status` = \'closed\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}},{\"action\":\"insert\",\"table\":\"trade\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"depositor\",\"paramType\":\"form\",\"param\":\"depositor\"},{\"field\":\"category\",\"paramType\":\"form\",\"param\":\"category\"},{\"field\":\"type\",\"paramType\":\"custom\",\"param\":\"out\"},{\"field\":\"desc\",\"paramType\":\"record\",\"param\":\"reason\"},{\"field\":\"money\",\"paramType\":\"record\",\"param\":\"money\"},{\"field\":\"handlers\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"date\",\"paramType\":\"today\",\"param\":\"today\"},{\"field\":\"createdBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"createdDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[],\"sql\":\"INSERT INTO `cash_trade` (`depositor`, `category`, `type`, `desc`, `money`, `handlers`, `date`, `createdBy`, `createdDate`) VALUES (\'#depositor\', \'#category\', \'out\', \'@reason\', \'@money\', \'$actor\', \'$today\', \'$actor\', \'$now\') \",\"sqlVars\":{\"handlers\":\"actor\",\"date\":\"today\",\"createdBy\":\"actor\",\"createdDate\":\"now\"},\"formVars\":{\"depositor\":\"depositor\",\"category\":\"category\"},\"recordVars\":{\"desc\":\"reason\",\"money\":\"money\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(40,'buy','browse','浏览列表','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(41,'buy','create','新建','','menu','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(42,'buy','edit','编辑','','browseandview','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(43,'buy','view','查看详情','','browse','direct',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(44,'buy','delete','删除','','browseandview','dropdownlist',0,'[]','','[]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(45,'buy','pay','付款','modal','browseandview','direct',0,'{\"conditionType\":\"data\",\"fields\":[{\"field\":\"deleted\",\"operator\":\"equal\",\"param\":\"0\"},{\"field\":\"status\",\"operator\":\"equal\",\"param\":\"unpaid\"}],\"sql\":\"\",\"sqlResult\":\"empty\"}','','[{\"action\":\"update\",\"table\":\"buy\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"status\",\"paramType\":\"custom\",\"param\":\"paid\"}],\"conditions\":[],\"wheres\":[{\"field\":\"id\",\"logicalOperator\":\"and\",\"operator\":\"equal\",\"paramType\":\"record\",\"param\":\"id\"}],\"sql\":\"UPDATE `flow_buy`  SET  `status` = \'paid\' WHERE 1 AND (1  AND `id` = \'@id\' )\",\"sqlVars\":[],\"formVars\":[],\"recordVars\":{\"id\":\"id\"}},{\"action\":\"insert\",\"table\":\"trade\",\"conditionType\":\"data\",\"message\":\"\",\"fields\":[{\"field\":\"depositor\",\"paramType\":\"form\",\"param\":\"depositor\"},{\"field\":\"category\",\"paramType\":\"form\",\"param\":\"category\"},{\"field\":\"trader\",\"paramType\":\"record\",\"param\":\"provider\"},{\"field\":\"type\",\"paramType\":\"custom\",\"param\":\"out\"},{\"field\":\"handlers\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"desc\",\"paramType\":\"record\",\"param\":\"desc\"},{\"field\":\"money\",\"paramType\":\"record\",\"param\":\"money\"},{\"field\":\"date\",\"paramType\":\"today\",\"param\":\"today\"},{\"field\":\"createdBy\",\"paramType\":\"actor\",\"param\":\"actor\"},{\"field\":\"createdDate\",\"paramType\":\"now\",\"param\":\"now\"}],\"conditions\":[],\"wheres\":[],\"sql\":\"INSERT INTO `cash_trade` (`depositor`, `category`, `trader`, `type`, `handlers`, `desc`, `money`, `date`, `createdBy`, `createdDate`) VALUES (\'#depositor\', \'#category\', \'@provider\', \'out\', \'$actor\', \'@desc\', \'@money\', \'$today\', \'$actor\', \'$now\') \",\"sqlVars\":{\"handlers\":\"actor\",\"date\":\"today\",\"createdBy\":\"actor\",\"createdDate\":\"now\"},\"formVars\":{\"depositor\":\"depositor\",\"category\":\"category\"},\"recordVars\":{\"trader\":\"provider\",\"desc\":\"desc\",\"money\":\"money\"}}]','','','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0');
INSERT INTO `sys_workflowdatasource` VALUES (1,'system','订单','{\"app\":\"crm\",\"module\":\"order\",\"method\":\"getPairs\",\"methodDesc\":\"Get order pairs.\",\"params\":[{\"name\":\"customer\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"status\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(2,'system','合同','{\"app\":\"crm\",\"module\":\"contract\",\"method\":\"getPairs\",\"methodDesc\":\"Get contract pairs.\",\"params\":[{\"name\":\"customerID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(3,'system','客户','{\"app\":\"crm\",\"module\":\"customer\",\"method\":\"getPairs\",\"methodDesc\":\"Get customer pairs.\",\"params\":[{\"name\":\"relation\",\"type\":\"string\",\"desc\":\"\",\"value\":\"customer\"},{\"name\":\"emptyOption\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"1\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(4,'system','供应商','{\"app\":\"crm\",\"module\":\"customer\",\"method\":\"getPairs\",\"methodDesc\":\"Get customer pairs.\",\"params\":[{\"name\":\"relation\",\"type\":\"string\",\"desc\":\"\",\"value\":\"provider\"},{\"name\":\"emptyOption\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"1\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(5,'system','联系人','{\"app\":\"crm\",\"module\":\"contact\",\"method\":\"getPairs\",\"methodDesc\":\"Get common selecter of contact.\",\"params\":[{\"name\":\"customer\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"emptyOption\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"1\"},{\"name\":\"status\",\"type\":\"string\",\"desc\":\"\",\"value\":\"normal\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(6,'system','产品','{\"app\":\"crm\",\"module\":\"product\",\"method\":\"getPairs\",\"methodDesc\":\"Get product pairs.\",\"params\":[{\"name\":\"status\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"},{\"name\":\"orderBy\",\"type\":\"string\",\"desc\":\"\",\"value\":\"id_desc\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(7,'sql','会议室','select id, name from flow_meetingroom where deleted = \'0\'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(8,'option','设备','{\"computer\":\"\\u7535\\u8111\",\"projector\":\"\\u6295\\u5f71\\u4eea\",\"micphone\":\"\\u9ea6\\u514b\\u98ce\",\"audio\":\"\\u97f3\\u54cd\",\"whiteboard\":\"\\u767d\\u677f\"}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(9,'option','工作日','{\"1\":\"\\u5468\\u4e00\",\"2\":\"\\u5468\\u4e8c\",\"3\":\"\\u5468\\u4e09\",\"4\":\"\\u5468\\u56db\",\"5\":\"\\u5468\\u4e94\",\"6\":\"\\u5468\\u516d\",\"7\":\"\\u5468\\u65e5\"}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(10,'system','账号','{\"app\":\"cash\",\"module\":\"depositor\",\"method\":\"getPairs\",\"methodDesc\":\"Get depositor option menu.\",\"params\":[]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(11,'system','支出科目','{\"app\":\"sys\",\"module\":\"tree\",\"method\":\"getPairs\",\"methodDesc\":\"Get the id => name pairs of some categories.\",\"params\":[{\"name\":\"categories\",\"type\":\"string\",\"desc\":\"the category lists\",\"value\":\"\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"the type\",\"value\":\"out\"}]}','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0');
INSERT INTO `sys_workflowfield` VALUES (1,'meetingroom','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',1,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(2,'meetingroom','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',9,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(3,'meetingroom','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',11,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(4,'meetingroom','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',12,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(5,'meetingroom','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',13,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(6,'meetingroom','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',20,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(7,'meetingroom','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',21,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(8,'meetingroom','name','varchar','200','名称','input','[]','','notempty','','1','0','0','1',3,'','admin','2017-03-14 10:22:48','admin','2016-11-23 11:14:10'),(9,'meetingroom','position','varchar','200','位置','select','{\"1\":\"\\u4e00\\u697c\",\"2\":\"\\u4e8c\\u697c\",\"3\":\"\\u4e09\\u697c\",\"4\":\"\\u56db\\u697c\",\"5\":\"\\u4e94\\u697c\"}','','notempty','','1','0','0','0',4,'','admin','2017-03-14 10:22:48','admin','2016-11-23 10:24:40'),(10,'meetingroom','seats','varchar','200','容纳人数','input','[]','','notempty','','1','0','0','0',5,'','admin','2017-03-14 10:22:48','admin','2016-11-23 10:24:46'),(11,'meetingroom','equipment','varchar','200','设备','checkbox','8','','notempty','','1','0','0','0',6,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(12,'meetingroom','workday','varchar','200','开放时间','checkbox','9','','notempty','','1','0','0','0',7,'','admin','2017-03-14 10:22:48','admin','2016-11-23 10:39:48'),(13,'meetingroombooking','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',13,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(14,'meetingroombooking','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',20,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(15,'meetingroombooking','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',21,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(16,'meetingroombooking','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',22,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(17,'meetingroombooking','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',23,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(18,'meetingroombooking','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',24,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(19,'meetingroombooking','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',25,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(20,'meetingroombooking','room','varchar','200','会议室','select','submodule','','notempty','','1','1','0','0',14,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(21,'meetingroombooking','begin','datetime','','开始时间','datetime','[]','','notempty,date','','1','0','0','0',15,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(22,'meetingroombooking','end','datetime','','结束时间','datetime','[]','','notempty,date','','1','0','0','0',16,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(23,'meetingroombooking','orderedBy','varchar','200','由谁预订','select','user','','notempty','','1','0','0','0',17,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(24,'meetingroombooking','orderedDate','datetime','','预订时间','datetime','[]','','notempty,date','','1','0','0','0',18,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(25,'meetingroombooking','desc','varchar','200','描述','input','[]','','','','1','0','0','0',19,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(26,'stamp','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',26,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(27,'stamp','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',36,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(28,'stamp','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',37,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(29,'stamp','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',38,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(30,'stamp','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',39,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(31,'stamp','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',40,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(32,'stamp','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',41,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(33,'stamp','proposer','varchar','200','申请人','select','user','','notempty','','1','0','0','0',27,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(34,'stamp','reason','varchar','200','申请事由','input','[]','','notempty','','1','0','0','0',28,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(35,'stamp','begin','datetime','','开始时间','datetime','[]','','notempty','','1','0','0','0',29,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(36,'stamp','end','datetime','','结束时间','datetime','[]','','notempty','','1','0','0','0',30,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(37,'stamp','type','varchar','200','印章类型','checkbox','{\"1\":\"\\u516c\\u7ae0\",\"2\":\"\\u6cd5\\u4eba\\u7ae0\",\"3\":\"\\u5408\\u540c\\u7ae0\",\"4\":\"\\u8d22\\u52a1\\u7ae0\"}','','notempty','','1','0','0','0',31,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(38,'stamp','desc','varchar','200','备注','input','[]','','','','1','0','0','0',32,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(39,'stamp','status','varchar','200','状态','radio','{\"draft\":\"\\u8349\\u7a3f\",\"wait\":\"\\u7b49\\u5f85\\u5ba1\\u6279\",\"pass\":\"\\u901a\\u8fc7\",\"reject\":\"\\u62d2\\u7edd\"}','wait','notempty','','1','0','0','0',33,'','admin','2017-03-14 10:22:48','admin','2016-11-23 11:25:25'),(40,'stamp','reviewedBy','varchar','200','审批人','select','user','','notempty','','1','0','0','0',34,'','admin','2017-03-14 10:22:48','admin','2016-11-23 11:23:27'),(41,'stamp','reviewedDate','datetime','','审批时间','datetime','[]','','notempty','','1','0','0','0',35,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(42,'car','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',42,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(43,'car','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',50,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(44,'car','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',51,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(45,'car','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',52,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(46,'car','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',53,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(47,'car','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',54,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(48,'car','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',55,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(49,'car','type','varchar','200','车辆类型','select','{\"audi\":\"\\u5965\\u8fea\",\"benz\":\"\\u5954\\u9a70\",\"vw\":\"\\u5927\\u4f17\"}','','notempty','','1','0','0','0',43,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(50,'car','code','varchar','200','车牌号','input','[]','','notempty','','1','0','0','1',44,'','admin','2017-03-14 10:22:48','admin','2016-11-23 13:40:14'),(51,'car','driver','varchar','200','司机','select','user','','','','1','0','0','0',45,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(52,'car','mobile','varchar','200','手机','input','[]','','float','','1','0','0','0',46,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(53,'car','buyDate','date','','购买日期','date','[]','','date','','1','0','0','0',47,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(54,'car','price','varchar','200','价格','input','[]','','','','1','0','0','0',48,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(55,'car','status','varchar','200','状态','select','{\"normal\":\"\\u6b63\\u5e38\",\"repairing\":\"\\u7ef4\\u4fee\\u4e2d\",\"broken\":\"\\u635f\\u574f\",\"scrapped\":\"\\u62a5\\u5e9f\"}','normal','notempty','','1','0','0','0',49,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(56,'carbooking','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',56,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(57,'carbooking','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',66,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(58,'carbooking','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',67,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(59,'carbooking','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',68,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(60,'carbooking','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',69,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(61,'carbooking','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',70,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(62,'carbooking','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',71,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(63,'carbooking','appliedBy','varchar','200','申请人','select','user','','notempty','','1','0','0','0',57,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(64,'carbooking','appliedDate','datetime','','申请时间','datetime','[]','','notempty,date','','1','0','0','0',58,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(65,'carbooking','car','varchar','200','车辆','select','submodule','','notempty','','1','1','0','0',59,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(66,'carbooking','begin','datetime','','开始时间','datetime','[]','','notempty,date','','1','0','0','0',60,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(67,'carbooking','end','datetime','','结束时间','datetime','[]','','notempty,date','','1','0','0','0',61,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(68,'carbooking','reason','varchar','200','理由','input','[]','','','','1','0','0','0',62,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(69,'carbooking','status','varchar','200','状态','select','{\"wait\":\"\\u7b49\\u5f85\\u5ba1\\u6838\",\"pass\":\"\\u901a\\u8fc7\",\"reject\":\"\\u62d2\\u7edd\"}','wait','notempty','','1','0','0','0',63,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(70,'carbooking','reviewedBy','varchar','200','审核人','select','user','','','','1','0','0','0',64,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(71,'carbooking','reviewedDate','datetime','','审核时间','datetime','[]','','date','','1','0','0','0',65,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(72,'collect','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',72,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(73,'collect','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',82,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(74,'collect','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',83,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(75,'collect','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',84,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(76,'collect','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',85,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(77,'collect','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',86,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(78,'collect','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',87,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(79,'collect','appliedBy','varchar','200','申请人','select','user','','notempty','','1','0','0','0',73,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(80,'collect','appliedDate','datetime','','申请时间','datetime','[]','','notempty,date','','1','0','0','0',74,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(81,'collect','money','varchar','200','金额','input','[]','','notempty','','1','0','0','0',75,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(82,'collect','reason','varchar','200','用途','input','[]','','','','1','0','0','0',76,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(83,'collect','status','varchar','200','状态','select','{\"wait\":\"\\u7b49\\u5f85\\u5ba1\\u6838\",\"pass\":\"\\u901a\\u8fc7\",\"reject\":\"\\u62d2\\u7edd\",\"closed\":\"\\u5df2\\u5b8c\\u6210\"}','wait','','','1','0','0','0',77,'','admin','2017-03-14 10:22:48','admin','2016-11-23 13:52:21'),(84,'collect','reviewedBy','varchar','200','由谁审核','select','user','','','','1','0','0','0',78,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(85,'collect','reviewedDate','datetime','','审核时间','datetime','[]','','date','','1','0','0','0',79,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(86,'collect','depositor','varchar','200','付款账号','select','10','','notempty','','1','0','0','0',80,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(87,'collect','category','varchar','200','支出科目','select','11','','notempty','','1','0','0','0',81,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(88,'buy','id','mediumint','8','编号','label','[]','','unique','','1','0','1','0',88,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(89,'buy','parent','mediumint','8','父流程ID','label','[]','0','','','1','0','0','0',96,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(90,'buy','createdBy','varchar','30','由谁创建','select','user','','','','1','0','0','0',97,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(91,'buy','createdDate','datetime','','创建日期','datetime','[]','','','','1','0','0','0',98,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(92,'buy','editedBy','varchar','30','由谁编辑','select','user','','','','1','0','0','0',99,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(93,'buy','editedDate','datetime','','编辑日期','datetime','[]','','','','1','0','0','0',100,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(94,'buy','deleted','varchar','200','是否删除','radio','[\"\\u672a\\u5220\\u9664\",\"\\u5df2\\u5220\\u9664\"]','0','','','0','0','0','0',101,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(95,'buy','provider','varchar','200','供应商','select','4','','notempty','','1','0','0','0',89,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(96,'buy','goods','varchar','200','商品','input','[]','','notempty','','1','0','0','0',90,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(97,'buy','money','varchar','200','金额','input','[]','','notempty','','1','0','0','0',91,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(98,'buy','desc','varchar','200','备注','input','[]','','','','1','0','0','0',92,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(99,'buy','status','varchar','200','状态','select','{\"unpaid\":\"\\u672a\\u652f\\u4ed8\",\"paid\":\"\\u5df2\\u652f\\u4ed8\"}','','','','1','0','0','0',93,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(100,'buy','depositor','varchar','200','付款账号','select','10','','notempty','','1','0','0','0',94,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00'),(101,'buy','category','varchar','200','支出科目','select','11','','notempty','','1','0','0','0',95,'','admin','2017-03-14 10:22:48','','0000-00-00 00:00:00');
INSERT INTO `sys_workflowlayout` VALUES (84,'meetingroom','browse','createdBy',7,0,'left','0','',''),(83,'meetingroom','browse','workday',6,0,'left','0','',''),(82,'meetingroom','browse','equipment',5,0,'left','0','',''),(81,'meetingroom','browse','seats',4,0,'left','0','',''),(80,'meetingroom','browse','position',3,0,'left','0','',''),(79,'meetingroom','browse','name',2,0,'left','0','',''),(78,'meetingroom','browse','id',1,0,'left','0','',''),(10,'meetingroom','create','name',1,0,'','0','',''),(11,'meetingroom','create','position',2,0,'','0','',''),(12,'meetingroom','create','seats',3,0,'','0','',''),(13,'meetingroom','create','equipment',4,0,'','0','',''),(14,'meetingroom','create','workday',5,0,'','0','',''),(15,'meetingroom','edit','name',1,0,'','0','',''),(16,'meetingroom','edit','position',2,0,'','0','',''),(17,'meetingroom','edit','seats',3,0,'','0','',''),(18,'meetingroom','edit','equipment',4,0,'','0','',''),(19,'meetingroom','edit','workday',5,0,'','0','',''),(20,'meetingroom','view','id',1,0,'basic','0','',''),(21,'meetingroom','view','name',2,0,'basic','0','',''),(22,'meetingroom','view','position',3,0,'basic','0','',''),(23,'meetingroom','view','seats',4,0,'basic','0','',''),(24,'meetingroom','view','equipment',5,0,'basic','0','',''),(25,'meetingroom','view','workday',6,0,'basic','0','',''),(26,'meetingroom','view','createdBy',7,0,'basic','0','',''),(27,'meetingroom','view','createdDate',8,0,'basic','0','',''),(28,'meetingroom','view','editedBy',9,0,'basic','0','',''),(29,'meetingroom','view','editedDate',10,0,'basic','0','',''),(30,'meetingroombooking','browse','id',1,0,'left','0','',''),(31,'meetingroombooking','browse','room',2,0,'left','0','',''),(32,'meetingroombooking','browse','begin',3,0,'left','0','',''),(33,'meetingroombooking','browse','end',4,0,'left','0','',''),(34,'meetingroombooking','browse','orderedBy',5,0,'left','0','',''),(35,'meetingroombooking','browse','orderedDate',6,0,'left','0','',''),(36,'meetingroombooking','browse','desc',7,0,'left','0','',''),(37,'meetingroombooking','browse','actions',8,120,'','0','',''),(47,'meetingroombooking','create','orderedBy',4,0,'','0','currentUser',''),(46,'meetingroombooking','create','end',3,0,'','0','',''),(45,'meetingroombooking','create','begin',2,0,'','0','',''),(44,'meetingroombooking','create','room',1,0,'','0','',''),(48,'meetingroombooking','create','orderedDate',5,0,'','0','currentTime',''),(49,'meetingroombooking','create','desc',6,0,'','0','',''),(50,'meetingroombooking','edit','room',1,0,'','0','',''),(51,'meetingroombooking','edit','begin',2,0,'','0','',''),(52,'meetingroombooking','edit','end',3,0,'','0','',''),(53,'meetingroombooking','edit','orderedBy',4,0,'','0','currentUser',''),(54,'meetingroombooking','edit','orderedDate',5,0,'','0','currentTime',''),(55,'meetingroombooking','edit','desc',6,0,'','0','',''),(74,'meetingroombooking','view','createdDate',8,0,'basic','0','',''),(73,'meetingroombooking','view','createdBy',7,0,'basic','0','',''),(72,'meetingroombooking','view','orderedDate',6,0,'basic','0','',''),(71,'meetingroombooking','view','orderedBy',5,0,'basic','0','',''),(70,'meetingroombooking','view','end',4,0,'basic','0','',''),(69,'meetingroombooking','view','begin',3,0,'basic','0','',''),(68,'meetingroombooking','view','room',2,0,'basic','0','',''),(67,'meetingroombooking','view','id',1,0,'basic','0','',''),(75,'meetingroombooking','view','editedBy',9,0,'basic','0','',''),(76,'meetingroombooking','view','editedDate',10,0,'basic','0','',''),(77,'meetingroombooking','view','desc',11,0,'info','0','',''),(85,'meetingroom','browse','createdDate',8,0,'left','0','',''),(86,'meetingroom','browse','actions',9,130,'','0','',''),(87,'stamp','browse','id',1,0,'left','0','',''),(88,'stamp','browse','proposer',2,0,'left','0','',''),(89,'stamp','browse','reason',3,0,'left','0','',''),(90,'stamp','browse','begin',4,0,'left','0','',''),(91,'stamp','browse','end',5,0,'left','0','',''),(92,'stamp','browse','type',6,0,'left','0','',''),(93,'stamp','browse','desc',7,0,'left','0','',''),(94,'stamp','browse','status',8,0,'left','0','',''),(95,'stamp','browse','reviewedBy',9,0,'left','0','',''),(96,'stamp','browse','reviewedDate',10,0,'left','0','',''),(97,'stamp','browse','actions',11,120,'','0','',''),(98,'stamp','create','proposer',1,0,'','0','currentUser',''),(99,'stamp','create','reason',2,0,'','0','',''),(100,'stamp','create','begin',3,0,'','0','',''),(101,'stamp','create','end',4,0,'','0','',''),(102,'stamp','create','type',5,0,'','0','',''),(103,'stamp','create','desc',6,0,'','0','',''),(113,'stamp','edit','end',4,0,'','0','',''),(112,'stamp','edit','begin',3,0,'','0','',''),(111,'stamp','edit','reason',2,0,'','0','',''),(110,'stamp','edit','proposer',1,0,'','0','currentUser',''),(114,'stamp','edit','type',5,0,'','0','',''),(115,'stamp','edit','desc',6,0,'','0','',''),(116,'stamp','view','id',1,0,'basic','0','',''),(117,'stamp','view','proposer',2,0,'basic','0','',''),(118,'stamp','view','reason',3,0,'info','0','',''),(119,'stamp','view','begin',4,0,'basic','0','',''),(120,'stamp','view','end',5,0,'basic','0','',''),(121,'stamp','view','type',6,0,'basic','0','',''),(122,'stamp','view','desc',7,0,'info','0','',''),(123,'stamp','view','status',8,0,'basic','0','',''),(124,'stamp','view','reviewedBy',9,0,'basic','0','',''),(125,'stamp','view','reviewedDate',10,0,'basic','0','',''),(126,'stamp','view','createdBy',11,0,'basic','0','',''),(127,'stamp','view','createdDate',12,0,'basic','0','',''),(128,'stamp','view','editedBy',13,0,'basic','0','',''),(129,'stamp','view','editedDate',14,0,'basic','0','',''),(215,'car','browse','status',8,0,'left','0','',''),(214,'car','browse','price',7,0,'left','0','',''),(213,'car','browse','buyDate',6,0,'left','0','',''),(212,'car','browse','mobile',5,0,'left','0','',''),(211,'car','browse','driver',4,0,'left','0','',''),(210,'car','browse','code',3,0,'left','0','',''),(209,'car','browse','type',2,0,'left','0','',''),(208,'car','browse','id',1,0,'left','0','',''),(139,'car','create','type',1,0,'','0','',''),(140,'car','create','code',2,0,'','0','',''),(141,'car','create','driver',3,0,'','0','',''),(142,'car','create','mobile',4,0,'','0','',''),(143,'car','create','buyDate',5,0,'','0','',''),(144,'car','create','price',6,0,'','0','',''),(145,'car','create','status',7,0,'','0','',''),(146,'car','edit','type',1,0,'','0','',''),(147,'car','edit','code',2,0,'','0','',''),(148,'car','edit','driver',3,0,'','0','',''),(149,'car','edit','mobile',4,0,'','0','',''),(150,'car','edit','buyDate',5,0,'','0','',''),(151,'car','edit','price',6,0,'','0','',''),(152,'car','edit','status',7,0,'','0','',''),(153,'car','view','id',1,0,'basic','0','',''),(154,'car','view','type',2,0,'basic','0','',''),(155,'car','view','code',3,0,'basic','0','',''),(156,'car','view','driver',4,0,'basic','0','',''),(157,'car','view','mobile',5,0,'basic','0','',''),(158,'car','view','buyDate',6,0,'basic','0','',''),(159,'car','view','price',7,0,'basic','0','',''),(160,'car','view','status',8,0,'basic','0','',''),(161,'car','view','createdBy',9,0,'basic','0','',''),(162,'car','view','createdDate',10,0,'basic','0','',''),(163,'car','view','editedBy',11,0,'basic','0','',''),(164,'car','view','editedDate',12,0,'basic','0','',''),(236,'carbooking','browse','reviewedBy',9,0,'left','0','',''),(235,'carbooking','browse','appliedDate',8,0,'left','0','',''),(234,'carbooking','browse','status',7,0,'left','0','',''),(233,'carbooking','browse','reason',6,0,'left','0','',''),(232,'carbooking','browse','end',5,0,'left','0','',''),(231,'carbooking','browse','begin',4,0,'left','0','',''),(230,'carbooking','browse','car',3,0,'left','0','',''),(183,'carbooking','create','appliedDate',2,0,'','0','currentTime',''),(182,'carbooking','create','appliedBy',1,0,'','0','currentUser',''),(184,'carbooking','create','car',3,0,'','0','',''),(185,'carbooking','create','begin',4,0,'','0','',''),(186,'carbooking','create','end',5,0,'','0','',''),(187,'carbooking','create','reason',6,0,'','0','',''),(188,'carbooking','edit','appliedBy',1,0,'','0','currentUser',''),(189,'carbooking','edit','appliedDate',2,0,'','0','currentTime',''),(190,'carbooking','edit','car',3,0,'','0','',''),(191,'carbooking','edit','begin',4,0,'','0','',''),(192,'carbooking','edit','end',5,0,'','0','',''),(193,'carbooking','edit','reason',6,0,'','0','',''),(194,'carbooking','view','id',1,0,'basic','0','',''),(195,'carbooking','view','appliedBy',2,0,'basic','0','',''),(196,'carbooking','view','appliedDate',3,0,'basic','0','',''),(197,'carbooking','view','car',4,0,'basic','0','',''),(198,'carbooking','view','begin',5,0,'basic','0','',''),(199,'carbooking','view','end',6,0,'basic','0','',''),(200,'carbooking','view','reason',7,0,'info','0','',''),(201,'carbooking','view','status',8,0,'basic','0','',''),(202,'carbooking','view','reviewedBy',9,0,'basic','0','',''),(203,'carbooking','view','reviewedDate',10,0,'basic','0','',''),(204,'carbooking','view','createdBy',11,0,'basic','0','',''),(205,'carbooking','view','createdDate',12,0,'basic','0','',''),(206,'carbooking','view','editedBy',13,0,'basic','0','',''),(207,'carbooking','view','editedDate',14,0,'basic','0','',''),(216,'car','browse','actions',9,130,'','0','',''),(237,'carbooking','browse','reviewedDate',10,0,'left','0','',''),(229,'carbooking','browse','appliedBy',2,0,'left','0','',''),(228,'carbooking','browse','id',1,0,'left','0','',''),(238,'carbooking','browse','actions',11,160,'','0','',''),(302,'collect','browse','reviewedBy',7,0,'left','0','',''),(303,'collect','browse','reviewedDate',8,0,'left','0','',''),(301,'collect','browse','appliedDate',6,0,'left','0','',''),(300,'collect','browse','status',5,0,'left','0','',''),(299,'collect','browse','reason',4,0,'left','0','',''),(298,'collect','browse','money',3,0,'left','0','',''),(257,'collect','create','appliedDate',2,0,'','0','currentTime',''),(256,'collect','create','appliedBy',1,0,'','0','currentUser',''),(261,'collect','edit','appliedDate',2,0,'','0','currentTime',''),(260,'collect','edit','appliedBy',1,0,'','0','currentUser',''),(258,'collect','create','money',3,0,'','0','',''),(259,'collect','create','reason',4,0,'','0','',''),(262,'collect','edit','money',3,0,'','0','',''),(263,'collect','edit','reason',4,0,'','0','',''),(264,'collect','view','id',1,0,'basic','0','',''),(265,'collect','view','appliedBy',2,0,'basic','0','',''),(266,'collect','view','appliedDate',3,0,'basic','0','',''),(267,'collect','view','money',4,0,'basic','0','',''),(268,'collect','view','reason',5,0,'info','0','',''),(269,'collect','view','status',6,0,'basic','0','',''),(270,'collect','view','reviewedBy',7,0,'basic','0','',''),(271,'collect','view','reviewedDate',8,0,'basic','0','',''),(272,'collect','view','createdBy',9,0,'basic','0','',''),(273,'collect','view','createdDate',10,0,'basic','0','',''),(274,'collect','view','editedBy',11,0,'basic','0','',''),(275,'collect','view','editedDate',12,0,'basic','0','',''),(276,'collect','pay','depositor',1,0,'','0','',''),(277,'collect','pay','category',2,0,'','0','',''),(297,'collect','browse','appliedBy',2,0,'left','0','',''),(296,'collect','browse','id',1,0,'left','0','',''),(304,'collect','browse','actions',9,180,'','0','',''),(305,'buy','browse','id',1,0,'left','0','',''),(306,'buy','browse','provider',2,0,'left','0','',''),(307,'buy','browse','goods',3,0,'left','0','',''),(308,'buy','browse','money',4,0,'left','0','',''),(309,'buy','browse','desc',5,0,'left','0','',''),(310,'buy','browse','status',6,0,'left','0','',''),(311,'buy','browse','createdBy',7,0,'left','0','',''),(312,'buy','browse','createdDate',8,0,'left','0','',''),(313,'buy','browse','actions',9,120,'','0','',''),(324,'buy','create','money',3,0,'','0','',''),(323,'buy','create','goods',2,0,'','0','',''),(322,'buy','create','provider',1,0,'','0','',''),(329,'buy','edit','money',3,0,'','0','',''),(328,'buy','edit','goods',2,0,'','0','',''),(327,'buy','edit','provider',1,0,'','0','',''),(325,'buy','create','desc',4,0,'','0','',''),(326,'buy','create','file',5,0,'','0','',''),(330,'buy','edit','desc',4,0,'','0','',''),(331,'buy','edit','file',5,0,'','0','',''),(332,'buy','view','id',1,0,'basic','0','',''),(333,'buy','view','provider',2,0,'basic','0','',''),(334,'buy','view','goods',3,0,'basic','0','',''),(335,'buy','view','money',4,0,'basic','0','',''),(336,'buy','view','desc',5,0,'info','0','',''),(337,'buy','view','status',6,0,'basic','0','',''),(338,'buy','view','createdBy',7,0,'basic','0','',''),(339,'buy','view','createdDate',8,0,'basic','0','',''),(340,'buy','view','editedBy',9,0,'basic','0','',''),(341,'buy','view','editedDate',10,0,'basic','0','',''),(342,'buy','view','file',11,0,'info','0','',''),(343,'buy','pay','depositor',1,0,'','0','',''),(344,'buy','pay','category',2,0,'','0','','');
INSERT INTO `sys_workflowmenu` VALUES (1,'meetingroom','所有会议室','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 10:48:04','0'),(2,'meetingroombooking','所有预订','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 11:07:32','0'),(3,'meetingroom','一楼会议室','[{\"key\":\"position\",\"operator\":\"equal\",\"value\":\"1\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(4,'meetingroom','二楼会议室','[{\"key\":\"position\",\"operator\":\"equal\",\"value\":\"2\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(5,'meetingroom','三楼会议室','[{\"key\":\"position\",\"operator\":\"equal\",\"value\":\"3\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(6,'meetingroombooking','我的预订','[{\"key\":\"orderedBy\",\"operator\":\"equal\",\"value\":\"currentUser\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(7,'stamp','所有','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(8,'car','车辆列表','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 13:28:10','0'),(9,'carbooking','所有预订','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 13:29:07','0'),(10,'stamp','我的申请','[{\"key\":\"proposer\",\"operator\":\"equal\",\"value\":\"currentUser\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 13:27:26','0'),(11,'stamp','我的审核','[{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"wait\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-24 13:56:12','0'),(12,'carbooking','我的预订','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"},{\"key\":\"appliedBy\",\"operator\":\"equal\",\"value\":\"currentUser\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(13,'carbooking','我的审核','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"},{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"wait\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-24 13:56:46','0'),(14,'collect','所有','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(15,'collect','我的请款','[{\"key\":\"appliedBy\",\"operator\":\"equal\",\"value\":\"currentUser\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(16,'collect','我的审核','[{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"wait\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-24 14:02:10','0'),(17,'collect','待付款','[{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"pass\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(18,'buy','所有','[{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(19,'buy','待付款','[{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"unpaid\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','','0000-00-00 00:00:00','0'),(20,'buy','已付款','[{\"key\":\"status\",\"operator\":\"equal\",\"value\":\"paid\"},{\"key\":\"deleted\",\"operator\":\"equal\",\"value\":\"0\"}]',0,'admin','2017-03-14 10:22:48','admin','2016-11-23 14:22:20','0');

INSERT INTO `sys_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'car', 'browse'),
(1, 'car', '8'),
(1, 'car', 'create'),
(1, 'car', 'edit'),
(1, 'car', 'view'),
(1, 'car', 'delete'),
(1, 'carbooking', 'browse'),
(1, 'carbooking', '9'),
(1, 'carbooking', '12'),
(1, 'carbooking', '13'),
(1, 'carbooking', 'create'),
(1, 'carbooking', 'edit'),
(1, 'carbooking', 'view'),
(1, 'carbooking', 'delete'),
(1, 'carbooking', 'pass'),
(1, 'carbooking', 'reject'),
(1, 'collect', 'browse'),
(1, 'collect', '14'),
(1, 'collect', '15'),
(1, 'collect', '16'),
(1, 'collect', '17'),
(1, 'collect', 'create'),
(1, 'collect', 'edit'),
(1, 'collect', 'view'),
(1, 'collect', 'delete'),
(1, 'collect', 'pass'),
(1, 'collect', 'reject'),
(1, 'collect', 'pay'),
(1, 'meetingroom', 'browse'),
(1, 'meetingroom', '1'),
(1, 'meetingroom', '3'),
(1, 'meetingroom', '4'),
(1, 'meetingroom', '5'),
(1, 'meetingroom', 'create'),
(1, 'meetingroom', 'edit'),
(1, 'meetingroom', 'view'),
(1, 'meetingroom', 'delete'),
(1, 'meetingroombooking', 'browse'),
(1, 'meetingroombooking', '2'),
(1, 'meetingroombooking', '6'),
(1, 'meetingroombooking', 'create'),
(1, 'meetingroombooking', 'edit'),
(1, 'meetingroombooking', 'view'),
(1, 'meetingroombooking', 'delete'),
(1, 'buy', 'browse'),
(1, 'buy', '18'),
(1, 'buy', '19'),
(1, 'buy', '20'),
(1, 'buy', 'create'),
(1, 'buy', 'edit'),
(1, 'buy', 'view'),
(1, 'buy', 'delete'),
(1, 'buy', 'pay'),
(1, 'stamp', 'browse'),
(1, 'stamp', '7'),
(1, 'stamp', '10'),
(1, 'stamp', '11'),
(1, 'stamp', 'create'),
(1, 'stamp', 'edit'),
(1, 'stamp', 'view'),
(1, 'stamp', 'delete'),
(1, 'stamp', 'revoke'),
(1, 'stamp', 'submit'),
(1, 'stamp', 'pass'),
(1, 'stamp', 'reject');
