<?php
!defined('IN_ONEZ') && exit('Access Denied');
onez('admin')->title=$G['title']=onez('install')->title('env');

include(dirname(__FILE__).'/top.php');
$G['error']=0;
function _check_server($type){
  $item=array();
  if($type=='system'){
    $item['name']='操作系统';
    $item['need']='不限制';
    $item['best']='类Unix';
    $item['current']=_result(1,PHP_OS);
  }elseif($type=='php'){
    $item['name']='PHP 版本';
    $item['need']='5.1';
    $item['best']='5.3';
    
    $item['current']=PHP_VERSION;
    if(strcmp($item['current'], $item['need']) < 0) {
			$item['current']=_result(0,'版本低于最低要求');
		}else{
			$item['current']=_result(1,$item['current']);
    }
  }elseif($type=='upload'){
    $item['name']='附件上传';
    $item['need']='不限制';
    $item['best']='2M';
    $item['current']=@ini_get('file_uploads') ? _result(1,ini_get('upload_max_filesize')) : '未知';
		$item['current']=_result(1,$item['current']);
  }elseif($type=='gd'){
    $item['name']='GD 库';
    $item['need']='1.0';
    $item['best']='2.0';
		$tmp = function_exists('gd_info') ? gd_info() : array();
		$item['current'] = empty($tmp['GD Version']) ? _result(0) : _result(1,$tmp['GD Version']);
  }elseif($type=='disk'){
    $item['name']='磁盘空间';
    $item['need']='10M';
    $item['best']='不限制';
		if(function_exists('disk_free_space')) {
			$item['current'] = floor(disk_free_space(ONEZ_ROOT) / (1024*1024)).'M';
		  $item['current']=_result(1,$item['current']);
		} else {
			$item['current'] = '未知';
		}
  }
  
  return $item;
}
function _check_file($item_path,$type='dir'){
  $item=array();
  $item['name']='.'.$item_path;
  $item['need']=_result(1,'可写');
	if($type == 'dir') {
		if(!dir_writeable(ONEZ_ROOT.$item_path)) {
			if(is_dir(ONEZ_ROOT.$item_path)) {
        $item['current']=_result(0,'只读');
			} else {
        $item['current']=_result(0,'目录不存在');
			}
		} else {
      $item['current']=_result(1,'可写');
		}
	} else {
		if(file_exists(ONEZ_ROOT.$item_path)) {
			if(is_writable(ONEZ_ROOT.$item_path)) {
        $item['current']=_result(1,'可写');
			} else {
        $item['current']=_result(0,'只读');
			}
		} else {
			if(dir_writeable(dirname(ONEZ_ROOT.$item_path))) {
        $item['current']=_result(1,'可写');
			} else {
        $item['current']=_result(0,'无权限');
			}
		}
	}
  return $item;
}
function dir_writeable($dir) {
	$writeable = 0;
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = @fopen("$dir/test.txt", 'w')) {
			@fclose($fp);
			@unlink("$dir/test.txt");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}
function _check_function($name){
  $item=array();
  $item['name']=$name;
  $r=function_exists($name);
  $item['current']=_result($r);
  $item['readme']='无';
  return $item;
}
function _result($s,$name=''){
  global $G;
  $html='';
  if($s){
    !$name && $name='支持';
    $html='<label class="label label-success">'.$name.'</label>';
  }else{
    !$name && $name='不支持';
    $html='<label class="label label-danger">'.$name.'</label>';
    $G['error']++;
  }
  return $html;
}
$G['title']='应用设置';
#初始化表单
$form=onez('admin')->widget('form')
  ->set('title',$G['title'])
  ->set('values',$item)
;
#预加载上传扩展
$support['server']=array();
$support['server'][]=_check_server('system');
$support['server'][]=_check_server('php');
$support['server'][]=_check_server('upload');
$support['server'][]=_check_server('gd');
$support['server'][]=_check_server('disk');
$support['file']=array();
$support['file'][]=_check_file('/cache');
$support['file'][]=_check_file('/plugins');
$support['function']=array();
$support['function'][]=_check_function('mysql_connect');
$support['function'][]=_check_function('file_get_contents');
$support['function'][]=_check_function('curl_init');
onez('admin')->header();
?>
<section class="content-header">
  <h1>
    1、开始安装<small>环境以及文件目录权限检查</small>
  </h1>
  <ol class="breadcrumb">
    <li class="active">
      <?php echo $G['title'];?>
    </li>
  </ol>
</section>
<section class="content">

<div class="box box-primary">
  <div class="box-header with-border">
    <h3 class="box-title">环境检查</h3></div>
  <div class="box-body  table-responsive no-padding">
    <table class="table table-striped">
      <thead>
        <tr>
          <th>项目</th>
          <th>Onez! 所需配置</th>
          <th>Onez! 最佳</th>
          <th>当前服务器</th></tr>
      </thead>
      <tbody>
      <?foreach($support['server'] as $rs){?>
        <tr>
          <td><?=$rs['name']?></td>
          <td><?=$rs['need']?></td>
          <td><?=$rs['best']?></td>
          <td><?=$rs['current']?></td>
        </tr>
      <?}?>
      </tbody>
    </table>
  </div>
</div>

<div class="box box-primary">
  <div class="box-header with-border">
    <h3 class="box-title">目录、文件权限检查</h3></div>
  <div class="box-body  table-responsive no-padding">
    <table class="table table-striped">
      <thead>
        <tr>
          <th>目录文件</th>
          <th>所需状态</th>
          <th>当前状态</th></tr>
      </thead>
      <tbody>
      <?foreach($support['file'] as $rs){?>
        <tr>
          <td><?=$rs['name']?></td>
          <td><?=$rs['need']?></td>
          <td><?=$rs['current']?></td>
        </tr>
      <?}?>
      </tbody>
    </table>
  </div>
</div>

<div class="box box-primary">
  <div class="box-header with-border">
    <h3 class="box-title">函数依赖性检查</h3></div>
  <div class="box-body  table-responsive no-padding">
    <table class="table table-striped">
      <thead>
        <tr>
          <th>函数名称</th>
          <th>检查结果</th>
          <th>建议</th>
      </thead>
      <tbody>
      <?foreach($support['function'] as $rs){?>
        <tr>
          <td><?=$rs['name']?></td>
          <td><?=$rs['current']?></td>
          <td><?=$rs['readme']?></td>
        </tr>
      <?}?>
      </tbody>
    </table>
  </div>
</div>
<p class="btns text-center">
<?if($G['error']){?>
<button type="button" class="btn btn-danger">安装无法继续，请检查并解决以上问题！</button>
<?}else{?>
<a class="btn btn-primary" href="<?=onez()->href('/index.php')?>">上一步</a>
<a class="btn btn-primary" href="<?=onez()->href('/db.php')?>">下一步</a>
<?}?>
</p>

</section>
<?php
echo $form->js();
onez('admin')->footer();
?>