<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

if (!defined('IN_DISCUZ')) {
    exit('Access Denied');
}
define('DISABLEXSSCHECK', true);
require_once(DISCUZ_ROOT . 'source/plugin/targetany/targetany.config.php');

$ac = $_GET['ac'];
if (!empty($ac)) {
    $_POSTDATA = decodeForBase64($_POST);
    if (!ta_check_user($_POSTDATA)) {
        $data = array("username" => $_POSTDATA["diz_username"],
            "password" => $_POSTDATA["diz_password"],
            "question" => $_POSTDATA["diz_question"],
            "answer" => $_POSTDATA["diz_answer"]);
        ta_fail(TA_ERROR_ERROR, $data, iconv('GB2312', 'UTF-8', "ԱУʧ"));
    }

    if (!in_array($ac, array('question_post', 'details', 'version', 'article_post'))) {
        ta_fail(TA_ERROR_ERROR, $ac, iconv('GB2312', 'UTF-8', "ַ쳣"));
    }

    try {
        $ac = "ta_" . $ac . "_action";
        $ac($_POSTDATA);
    } catch (Exception $e) {
        $trace = $e->getTraceAsString();
        ta_fail(TA_ERROR_ERROR, $trace, iconv('GB2312', 'UTF-8', "ϵͳ쳣"));
    }
}

/**
 * check user Access
 * @param type $postData
 * @return boolean
 */
function ta_check_user($postData) {
    if (!isset($postData['diz_username']) || $postData['diz_username'] == '' || !isset($postData['diz_password']) || $postData['diz_password'] == '') {
        return false;
    }

    $questionid = isset($postData['diz_question']) && $postData['diz_question'] ? $postData['diz_question'] : '';
    $answer = isset($postData['diz_answer']) && $postData['diz_answer'] ? $postData['diz_answer'] : '';

    $result = userlogin(diconv($postData['diz_username'], 'utf-8'), diconv($postData['diz_password'], 'utf-8'), $questionid, diconv($answer, 'utf-8'));
    if ($result['ucresult']['uid'] > 0 && $result['status'] == 1) {
        $member = getuserbyuid($result['ucresult']['uid'], 1);
        if ($member['adminid'] > 0 && $member['freeze'] == 0 && $member['allowadmincp'] > 0) {
            return true;
        }
    } else {
        return false;
    }
}

function ta_validation($postData) {
    global $_G;
    if (!($postData && isset($postData['__sign']) && $postData['__sign']) || !(isset($_G['cache']['plugin']['targetany']) && isset($_G['cache']['plugin']['targetany']['anytarget_token']) && $_G['cache']['plugin']['targetany']['anytarget_token'] == $postData['__sign'])) {
        ta_fail(TA_ERROR_INVALID_PWD, "password is wrong", iconv('GB2312', 'UTF-8', "д"));
    }
}

function ta_details_action($postData) {
    global $_G;
    ta_validation($postData);
    $returnData = array();
    if (isset($postData['forumsType']) && $postData["forumsType"] === "cate") {
        loadcache('forums');
        $forums = $_G['cache']['forums'];
        foreach ($forums as $k => $v) {
            if (isset($v['type']) && ($v['type'] == 'forum' || $v['type'] == 'sub')) {
                $parents = getForumParentName($forums, $v['fup']);
                $returnData[] = array('value' => $v['fid'], 'text' => urlencode(iconv('GB2312', 'UTF-8', $v['name'].(empty($parents) ? '' : '('.implode('-', $parents).')'))));
            }
        }
    } else if (isset($postData['portalType']) && $postData["portalType"] === "cate") {
        loadcache('portalcategory');
        $categorys = $_G['cache']['portalcategory'];
        foreach ($categorys as $k => $v) {
            $parents = getParentName($categorys, $v['upid']);
            $returnData[] = array('value' => $v['catid'], 'text' => urlencode(iconv('GB2312', 'UTF-8', $v['catname'].(empty($parents) ? '' : '('.implode('-', $parents).')'))));
        }
    }
    ta_success($returnData);
}

function getForumParentName($forums, $pid, $names = array()) {
    if ($pid && isset($forums[$pid]) && ($forums[$pid]['type'] == 'forum' || $forums[$pid]['type'] == 'sub')) {
        $names[] = $forums[$pid]['name'];
        if (isset($forums[$pid]['fup']) && $forums[$pid]['fup']) {
            $names = getForumParentName($forums, $forums[$pid]['fup'], $names);
        }
    }
    return $names;
}

function getParentName($categorys, $pid, $names = array()) {
    if ($pid && isset($categorys[$pid])) {
        $names[] = $categorys[$pid]['catname'];
        if (isset($categorys[$pid]['upid']) && $categorys[$pid]['upid']) {
            $names = getParentName($categorys, $categorys[$pid]['upid'], $names);
        }
    }
    return $names;
}

function ta_question_post_action($postData) {
    ta_validation($postData);
    $question = new targetany_question($postData);
    $question->processData();
}

function ta_article_post_action($postData) {
    ta_validation($postData);
    $article = new targetany_article($postData);
    $article->processData();
}

function ta_version_action($postData = array()) {
    ta_validation($postData);
    $reply = ta_get_version();
    ta_success($reply);
}