<?php
/*
	Plugin Name:	Similar input
	Plugin URL:		https://www.similar.eu.org/
	Description:	Enhanced WordPress Search drop-down box similar input auxiliary plug.
	Author:			Luois lee
	Version:		0.0.4
	Author URL:		https://www.similar.eu.org/
*/
$short = 'similar_';
add_action('admin_menu', function(){add_menu_page('similar config page', 'similar config', 'administrator', 'ConfigPageSimilar','my_plugin_function2');});
function my_plugin_function2(){
	global $short;
	if(!empty($_POST[$short .'ID'])){
		update_option($short .'ID',$_POST[$short .'ID']);
		update_option($short .'x',$_POST[$short .'x']);
		update_option($short .'y',$_POST[$short .'y']);
		update_option($short .'a',$_POST[$short .'a']);
		update_option($short .'b',$_POST[$short .'b']);
		update_option($short .'c',$_POST[$short .'c']);
		update_option($short .'d',$_POST[$short .'d']);
		update_option($short .'e',$_POST[$short .'e']);
		update_option($short .'f',$_POST[$short .'f']);
		update_option($short .'g',$_POST[$short .'g']);
		update_option($short .'h',$_POST[$short .'h']);
		update_option($short .'v',$_POST[$short .'v']);
		update_option($short .'t',$_POST[$short .'t']);
		?>
		<div class="updated settings-error notice is-dismissible">
			<p><strong>Similar.js config saved.</strong></p>
			<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
		</div>
	<?php }?>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/1.7.1/jquery.js"></script>
	<div class="wrap">
	<h1>similar.js config</h1>
	<p>Enhanced WordPress Search drop-down box similar input auxiliary plug.<br />Default use libs sources: <a target="_blank" href="https://cdn.jsdelivr.net/similar/1.1.0/similar.eva.js">https://cdn.jsdelivr.net/</a>, Porject home: <a href="https://www.similar.eu.org/" target="_blank">https://www.similar.eu.org/</a></p>
	<form action="" method="post" id="ConfigFormSimilar">
		<table class="form-table">
		<tbody>
		<tr>
			<th scope="row"><label for="similar_ID">Bind input to id：</label></th>
			<td><input type="text" class="regular-text" id="similar_ID" name="similar_ID" value="<?php echo esc_attr(get_option($short .'ID')) ? esc_attr(get_option($short .'ID')) : 'InputID'; ?>" required="required" placeholder="e.g: InputID" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_x">X-axis:<br />(Negative offset to the left)</label></th>
			<td><input type="text" class="regular-text" id="similar_x" name="similar_x" value="<?php echo esc_attr(get_option($short .'x')); ?>" placeholder="e.g: -10" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_y">Y - axis:</label></th>
			<td><input type="text" class="regular-text" id="similar_y" name="similar_y" value="<?php echo esc_attr(get_option($short .'y')); ?>" placeholder="e.g: -5" /> (Negative offset to the down)</td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_a">Widths:</label></th>
			<td><input type="text" class="regular-text" id="similar_a" name="similar_a" value="<?php echo esc_attr(get_option($short .'a')); ?>" placeholder="e.g: 600" /> (Undefined inherited his father)</td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_b">Border Color:</label></th>
			<td><input type="text" class="regular-text" id="similar_b" name="similar_b" value="<?php echo esc_attr(get_option($short .'b')); ?>" placeholder="e.g: #FF6600" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_c">Font family:</label></th>
			<td><input type="text" class="regular-text" id="similar_c" name="similar_c" value="<?php echo esc_attr(get_option($short .'c')) ? esc_attr(get_option($short .'c')) : 'Microsoft YaHei'; ?>" placeholder="e.g: Microsoft YaHei" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_d">Font color:</label></th>
			<td><input type="text" class="regular-text" id="similar_d" name="similar_d" value="<?php echo esc_attr(get_option($short .'d')); ?>" placeholder="e.g: blue" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_e">Font size:</label></th>
			<td><input type="text" class="regular-text" id="similar_e" name="similar_e" value="<?php echo esc_attr(get_option($short .'e')) ? esc_attr(get_option($short .'e')) : '14px'; ?>" placeholder="e.g: 14px" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_f">Hover text <font color="#FF0000">background</font> color:</label></th>
			<td><input type="text" class="regular-text" id="similar_f" name="similar_f" value="<?php echo esc_attr(get_option($short .'f')); ?>" placeholder="e.g: red" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_g">Hover text <font color="#FF0000">font</font> color:</label></th>
			<td><input type="text" class="regular-text" id="similar_g" name="similar_g" value="<?php echo esc_attr(get_option($short .'g')); ?>" placeholder="e.g: green" /></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_h">Select the default action:</label></th>
			<td><select name="similar_h" id="similar_h"><option <?php if(esc_attr(get_option($short .'h')) != 'false')echo 'selected="selected"';?> value="true">Selected submission(default)</option><option <?php if(esc_attr(get_option($short .'h')) == 'false')echo 'selected="selected"';?> value="false">Manual submission</option></select></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_v">Preset keywords:<br />(Use comma split keyword.)<br />e.g: key1,key2,key3...</label></th>
			<td><textarea name="similar_v" id="similar_v" class="large-text code" rows="6" placeholder="e.g: key1,key2,key3..."><?php echo esc_attr(get_option($short .'v'));?></textarea></td>
		</tr>
		<tr>
			<th scope="row"><label for="similar_t">Switching time<br />(millisecond):</label></th>
			<td><input type="text" class="regular-text" id="similar_t" name="similar_t" value="<?php echo esc_attr(get_option($short .'t')); ?>" placeholder="e.g: 3000" /></td>
		</tr>
		</tbody>
		</table>
		<p class="submit"><input type="submit" class="button button-primary" name="submit" value="Save" /></p>
	</form>
	<script type="text/javascript">
		$("input:text").click(function(){
			$(this).select();
		});
		
	</script>
	</div>
	<?php
}

add_action( 'wp_enqueue_scripts', function(){wp_enqueue_script( '', 'https://cdn.jsdelivr.net/similar/1.1.0/similar.eva.js', '', '20160703', true );} );
add_action('wp_footer', function(){
	global $short;
	echo "<script type=\"text/javascript\">\r\n/* 请在配置文件前先加载 similar.js 库.[配置文件加载开始] */\r\nwordpress.$('" . esc_attr(get_option($short .'ID')) ."',{		// 绑定到InputID
	_:'" . esc_attr(get_option($short .'x')) ."',			// X-axis 轴(负数向左偏移).
	$:'" . esc_attr(get_option($short .'y')) ."',			// Y-axis 轴(负数向下偏移).
	a:'" . esc_attr(get_option($short .'a')) ."',			// 宽度(空值继承父).
	b:'" . esc_attr(get_option($short .'b')) ."',			// 边框颜色.
	c:'" . esc_attr(get_option($short .'c')) ."',	// 字体.
	d:'" . esc_attr(get_option($short .'d')) ."',			// 字体颜色.
	e:'" . esc_attr(get_option($short .'e')) ."',		// 字体大小.
	f:'" . esc_attr(get_option($short .'f')) ."',			// 鼠标经过候选文字(背景)颜色.
	g:'" . esc_attr(get_option($short .'g')) ."',			// 鼠标经过候选文字(字体)颜色.
	h:" . esc_attr(get_option($short .'h')) ."			// 选中默认动作. [true & false]
},true);			// 增强WordPress搜索下拉框相关提示的辅助插件.[配置文件加载结束]\r\n/* Porject home: https://www.similar.eu.org/ */\r\n</script>\r\n";},99);

$vote_keys = esc_attr(get_option($short .'v'));
if(!empty( $vote_keys )){
	add_action('wp_footer', function(){
		global $short;
		global $vote_keys;
		$res = explode(',', $vote_keys);
		for($i = 0; $i<=(count($res)-1); $i++) $res1 .=  '\''. $res[$i]. '\',';
		echo "<script type=\"text/javascript\">similar.vote('" . esc_attr(get_option($short .'ID')) ."',[". rtrim($res1, ',') ."],". (esc_attr(get_option($short .'t')) ? esc_attr(get_option($short .'t')) : 3000) .");</script>\r\n";
	},100);
}











