<?php
define('TA_ERROR_NONE',0);
define('TA_ERROR_ERROR',1);
define('TA_ERROR_PLUGIN_ERROR',2);
define('TA_ERROR_INVALID_PWD',100);
define('TA_ERROR_MISSING_FIELD',101);

function ta_success($data="",$message=""){
	ta_result(1, $data, $message);
}
function ta_fail($code=2,$data="",$message=""){
	ta_result($code, $data, $message);
}
function ta_result($result=1,$data="",$message=""){
	die(json_encode(array("result"=> $result,"data"=> $data,"message"=> urlencode($message))));
}

// Get Real Url for 302 URL
function ta_redirect_url($url) {
    if (empty($url)) {
        return false;
    }
    $result = ta_curl_headers($url.'-dl');
    if ($result !== false && strpos($result, "302 Moved Temporarily")) {
        $headers = preg_split("/\r\n+/", $result);
        if (is_array($headers)) {
            $real_url = null;
            $referer = '';
            foreach ($headers as $header) {
                $header = trim($header);
                $locpos = stripos($header, "location");
                $refererpos = stripos($header, "X-Referer");
                if ($locpos === 0) {
                    $pp = strpos($header, ":");
                    $real_url = trim(substr($header, $pp + 1));
                }
                if ($refererpos === 0) {
                    $pp = strpos($header, ":");
                    $referer = trim(substr($header, $pp + 1));
                }
            }
            if (!empty($real_url) && stripos($real_url, "http") === 0) {
                return array('realurl' => $real_url, 'referer' => $referer);
            }
        }
    }
    return false;
}

function ta_curl_headers($url){
  // ʼCurl
  $ch = curl_init();
  // headerʾ
  curl_setopt($ch, CURLOPT_HEADER, true);
  // ҳ
  curl_setopt($ch, CURLOPT_NOBODY, true);
  // ֹԶ
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  // Զת
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
  // תʱԶԴַ
  curl_setopt($ch, CURLOPT_AUTOREFERER, true);
  // ʱʱ
  curl_setopt($ch, CURLOPT_TIMEOUT, 60);
  // URL
  curl_setopt($ch, CURLOPT_URL, $url);
  // رSSL֤֤
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  // ؽ
  return curl_exec($ch);
}

function ta_log($data) {
    if ($data && (is_array($data) || is_object($data))) {
        if (method_exists($data, 'jsonSerialize')) {
            $data = $data->jsonSerialize();
        }
        $str = json_encode($data);
    } else {
        $str = $data;
    }
    $myfile = fopen("ta_log.txt", "a") or die("Unable to open file!");
    fwrite($myfile, $str);
    fclose($myfile);
}

function diconv($str, $in_charset = 'utf-8', $out_charset = 'GB2312', $ForceTable = FALSE) {

    $in_charset = strtoupper($in_charset);
    $out_charset = strtoupper($out_charset);

    if (empty($str) || $in_charset == $out_charset) {
        return $str;
    }

    $out = '';

    if (!$ForceTable) {
        if (function_exists('iconv')) {
            $out = iconv($in_charset, $out_charset . '//IGNORE', $str);
        } elseif (function_exists('mb_convert_encoding')) {
            $out = mb_convert_encoding($str, $out_charset, $in_charset);
        }
    }

    return $out;
}
