/*! Websql - v0.1.0 - 2013-10-19
* https://github.com/yelouafi/websql.js
* Copyright (c) 2013 Elouafi Yassine; Licensed MIT */
var utils=utils||{};!function(){var a=utils;a.toArray=function(a){return Array.prototype.slice.call(a)},a.isUndef=function(a){return void 0===a},a.isObject=function(a){return"object"==typeof a&&null!==a},a.isFunction=function(a){return!!(a&&a.constructor&&a.call&&a.apply)};var b=["Arguments","Function","String","Number","Date","RegExp"];b.forEach(function(b){a["is"+b]=function(a){return Object.prototype.toString.call(a)==="[object "+b+"]"}}),a.isBoolean=function(a){return a===!0||a===!1||"[object Boolean]"===Object.prototype.toString.call(a)},a.each=function(a,b){for(var c in a)b(a[c],c)},utils.has=function(a,b){return hasOwnProperty.call(a,b)},a.format=function(a){var b=arguments;return a.replace(/{(\d+)}/g,function(a,c){var d=parseInt(c,10);return isFinite(d)?b[1+d]:a})}}();var websql=websql||{},utils=utils||{};!function(a){websql.Db=function(b,c,d,e){var f=this;this.dbType="SQLite",this.tables=[];var g=/^(\d{4}|\+\d{6})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2}):(\d{2})\.(\d{1,3})(?:Z|([\-+])(\d{2}):(\d{2}))?)?)?)?$/;this.cs={pk:"pk",text:"text",integer:"integer",numeric:"numeric",date:"date",bool:"boolean",rowset:"rowset",row:"row",scalar:"scalar",nonQuery:"non-query",insert:"insert",any:"any"},this.client=openDatabase(b,c||"1.0",d||b,e||2097152),this.tableSQL="SELECT name FROM sqlite_master	WHERE type='table' ORDER BY name",this.modelsTableSchema={model:"text"},this.model={tables:{}},f.debug=!1,f.log=function(a){f.debug&&console.log(a)},this.placeholder=function(){return"?"},this.typeToDb=function(a){return utils.isDate(a)?a.toISOString():utils.isBoolean(a)?a?1:0:a},f.inferQueryType=function(a){var b=a.toLowerCase();return 0===b.indexOf("insert")?f.cs.insert:0===b.indexOf("select")?b.indexOf("limit(1)")>0?f.cs.row:f.cs.rowset:0===b.indexOf("update")||0===b.indexOf("delete")?f.cs.nonQuery:f.cs.any},this.processRow=function(a){var b={};for(var c in a){var d=a[c];if(utils.isString(d)&&d.match(g)){var e=Date.parse(d);e&&(d=new Date(e))}b[c]=d}return b},f.processResultType=function(a,b){switch(b){case f.cs.any:return a;case f.cs.insert:return a.insertId;case f.cs.rowset:var c,d=a.rows.length,e=[];for(c=0;d>c;c++){var g=f.processRow(a.rows.item(c));e.push(g)}return e;case f.cs.row:return a.rows.length?f.processRow(a.rows.item(0)):null;case f.cs.scalar:if(a.rows.length){var h=f.processRow(a.rows.item(0));for(var i in h)return h[i]}return null;case f.cs.nonQuery:return a.rowsAffected;default:return a}};var h=function(a){var b=a;switch(a){case"pk":b="INTEGER PRIMARY KEY  AUTOINCREMENT";break;case"int":b="INTEGER";break;case"decimal":b="numeric";break;case"date":b="datetime";break;case"text":b="text";break;case"boolean":b="boolean"}return b};this.forward=function(b,c){return a.Deferred(function(a){a.resolve(b,c)}).promise()};var i=function(a){return function(b,c){var d=f.processResultType(c,a.queryType);a.resolve(d,b)}},j=function(a){return function(b,c){return f.log("sql error on : "+a.sql+" --- message: "+c.message),a.reject(c),!0}};this._exec=function(b,c,d,e){var g=c?c.join(", "):"";return f.log("exec : "+b+" : ["+g+"]"),a.Deferred(function(a){var g=c?c.map(f.typeToDb):c;a.sql=b,a.queryType=e||f.cs.any,d?d.executeSql(b,g,i(a),j(a)):f.client.transaction(function(c){c.executeSql(b,g,i(a),j(a))})})},f.query=function(a,b,c){return f._exec(a,b,c,f.cs.rowset)},f.queryOne=function(a,b,c){return f._exec(a,b,c,f.cs.row)},f.scalar=function(a,b,c){return f._exec(a,b,c,f.cs.scalar)},f.execNonQuery=function(a,b,c){return f._exec(a,b,c,f.cs.nonQuery)},f.exec=function(a,b,c,d){var e=d||f.inferQueryType(a);return f._exec(a,b,c,e)},this.getQuery=function(a,b,c){return new websql.Query(a,b,new websql.Table("","",f),c)},this.fnRunQuery=function(a){return function(b,c){return a.run(c)}},this.runQueries=function(a,b){for(var c=a[0].run(b),d=1;d<a.length;d++){var e=a[d];c=c.then(f.fnRunQuery(e))}return c},this.runSqls=function(a,b){var c=new websql.Table("","",f),d=a.map(function(a){return Array.isArray(a)?new websql.Query(a[0],a.slice(1),c,f.cs.any):new websql.Query(a.toString(),[],c,c,f.cs.any)});return f.runQueries(d,b)},this.dropTable=function(a){return new websql.Query("DROP TABLE IF EXISTS "+a,[],new websql.Table(a,"",f),f.cs.any)};var k=function(a,b){return utils.isString(b)?a+" "+h(b):a+" "+h(b.type)+(b.required?" NOT NULL":"")+(b.unique?" UNIQUE":"")};this.createTable=function(a,b,c){var d="CREATE TABLE "+(c?"IF NOT EXISTS ":"")+a+"(",e=[];e.push(k("id","pk"));for(var g in b)"timestamps"===g?(e.push("created_at int"),e.push("updated_at int")):"id"!==g&&e.push(k(g,b[g]));return d+=e.join(", ")+")",new websql.Query(d,[],new websql.Table(a,"id",f),f.cs.any)},this.createColumn=function(a,b,c){return new websql.Query("ALTER TABLE "+a+" ADD COLUMN "+k(b,c),[],new websql.Table(a,"",f),f.cs.any)},this.createModelsTable=function(){return f.createTable("_models",f.modelsTableSchema,!0)},this.loadModel=function(a){var b=f.createModelsTable().run(a).then(function(a,b){return f._models=new websql.Table("_models","id",f),f._models.last(b)}).then(function(a,b){return a&&(f.model=JSON.parse(a.model)),f.forward(f.newModel,b)});return b},this.reloadModel=function(a){f._models.last(a).then(function(a,b){return a&&(f.model=JSON.parse(a.model)),f.forward(f.newModel,b)})},this.upgrade=function(a,b){return f.loadModel(b).then(function(b,c){var d=[];return utils.each(a.tables,function(b,c){if(utils.has(f.model.tables,c)){var e=f.model.tables[c],g=a.tables[c];utils.each(g,function(a,b){utils.has(e,b)||d.push(f.createColumn(c,b,a))})}else d.push(f.createTable(c,b))}),d.length?(d.push(f._models.insert({model:JSON.stringify(a)})),f.runQueries(d,c)):f.forward(b,c)}).then(function(b,c){return f.model=a,utils.each(a.tables,function(a,b){f[b]=new websql.Table(b,"id",f)}),f.forward(b,c)})}},websql.Query=function(a,b,c,d){var e={"=":"=","!":"!=",">":">","<":"<",">=":">=","<=":"<=","!=":"<>","<>":"<>"},f=this;f.sql=a,f.params=b||[],f.table=c,f.db=c.db,f.queryType=d,f.append=function(a){return f.sql+=1===arguments.length?a:utils.format.apply(null,utils.toArray(arguments)),f},f.order=function(a,b){return f.append(" ORDER BY {0}{1}",a,b?" DESC":"")},f.limit=function(a,b){return utils.isUndef(b)?f.append(" LIMIT {0}",a):f.append(" LIMIT {0} OFFSET {1}",a,b)},f.first=function(){return f.append(" LIMIT(1)")},f.last=function(){return f.append(" ORDER BY {0} DESC LIMIT(1)",f.table.pk)},f.where=function(a){if(utils.isUndef(a))return f;if(utils.isNumber(a))return f.append(' WHERE "{0}" = {1}',f.table.pk,a);if(utils.isString(a))return f.params.push(a),f.append(' WHERE "{0}" = {1}',f.table.pk,f.db.placeholder(f.params.length));var b=[];for(var c in a){var d=a[c],g=c.trim().split(/ +/),h=g[0],i=e[g[1]]||"=";if(Array.isArray(d)){var j=[];d.forEach(function(a){f.params.push(a),j.push(f.db.placeholder(f.params.length))}),b.push(utils.format('"{0}" {1} ({2})',h,"!="===i||"<>"===i?"NOT IN":"IN",j.join(", ")))}else f.params.push(d),b.push(utils.format('"{0}" {1} {2}',h,i,f.db.placeholder(f.params.length)))}return f.append(" WHERE "+b.join(" AND "))},f.parseArgs=function(a){var b=utils.toArray(a);if(0===b.length)return f;var c;return b.forEach(function(a){if(utils.isNumber(a)||utils.isString(a)){var b={};b[f.table.pk]=a,f.where(b)}else if(Array.isArray(a))c=a;else if(utils.isObject(a)){var d=a.where||a;c=a.columns,utils.isObject(d)&&f.where(d)}}),c&&(f.sql=f.sql.replace("*",c.join(","))),f},this.find=function(){return f.sql="select * from "+f.table.name,f.parseArgs(arguments)},this.run=function(a,b){var c=b||f.queryType||f.db.cs.any;return f.db._exec(f.sql,f.params,a,c)},this.all=function(a){return f.db._exec(f.sql,f.params,a,f.db.cs.rowset)},this.one=function(a){return f.db._exec(f.sql,f.params,a,f.db.cs.row)},this.scalar=function(a){return f.db._exec(f.sql,f.params,a,f.db.cs.scalar)},this.nonQuery=function(a){return f.db._exec(f.sql,f.params,a,f.db.cs.nonQuery)},this.each=function(a,b){var c=f.all(b);return a&&c.done(function(b){for(var c=b.length,d=0;c>d;d++)a(b[d])}),c}},websql.Table=function(a,b,c){var d=this;this.name=a,this.pk=b,this.db=c,this.find=function(){return new websql.Query("SELECT * FROM "+this.name,[],d,d.db.cs.rowset).parseArgs(arguments)},this.first=function(a){return d.find().first().run(a,d.db.cs.row)},this.last=function(a){return d.find().last().run(a,d.db.cs.row)},this.each=function(a){this.find().each(a)},this.count=function(a,b){return new websql.Query("SELECT COUNT(1) FROM "+d.name,[],d,d.db.cs.scalar).where(a).run(b)},this.all=function(a){return new websql.Query("SELECT * FROM "+d.name,[],d).all(a)},this.insert=function(a){if(!a)throw"insert should be called with data";var b=utils.format("INSERT INTO {0} ({1}) VALUES(",d.name,Object.keys(a).join(", ")),c=[],e=[],f=0;for(var g in a)e.push(d.db.placeholder(++f)),c.push(a[g]);return b+=e.join(", ")+")",new websql.Query(b,c,d,d.db.cs.insert)},this.update=function(a,b){if(utils.isObject(a)===!1)throw"Update requires a hash of fields=>values to update to";var c=[],e=[],f=0;for(var g in a)e.push(g+" = "+d.db.placeholder(++f)),c.push(a[g]);var h=utils.format("UPDATE {0} SET {1}",this.name,e.join(", "));return new websql.Query(h,c,d,d.db.cs.nonQuery).where(b)},this.destroy=function(){return new websql.Query("DELETE FROM "+d.name,[],d,d.db.cs.nonQuery).parseArgs(arguments)}}}(jQuery);