<?php

	/**
	 * 麦迪文件缓存类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	class DvFile implements CaInterface{

		public $option;

		/**
		 * 实例化
		 * @param	array	$option	配置项
		 */
		public function __construct($option){

			//压缩处理
			empty($option['GZIP']) && $option['GZIP']=C('CACHE.GZIP');

			//缓存目录
			$option['PATH'] = empty($option['PATH']) ? MD_PATH_CACHE : str_replace('\\', '/', $option['PATH']);

			//创建目录
			substr($option['PATH'], -1)=='/' || $option['PATH'].='/';
			createDir($option['PATH']);

			$this->option = $option;

		}

		/**
		 * 添加缓存
		 * @param	string	$name	缓存名称
		 * @param	[type]	$data	缓存数据
		 */
		public function add($name, $data){

			$name = $this->getCacheFile($name);

			//删除
			if(is_null($data))
				return file_exists($name) ? unlink($name) : true;

			//数据处理
			$data = serialize($data);
			if($this->option['GZIP'] && function_exists('gzcompress'))
				$data = gzcompress($data);
			$data = '<?php die; ?>' . $data;

			return (bool)file_put_contents($name, $data);

		}

		/**
		 * 获取缓存
		 * @param	string	$name	缓存名称
		 * @return	[type]			缓存数据
		 */
		public function get($name){

			$name = $this->getCacheFile($name);

			//不存在
			if(!file_exists($name))
				return null;

			//失效
			if(fileatime($name)+$this->option['EXPIRE'] < time()){
				unlink($name);
				return null;
			}

			$data = substr(file_get_contents($name), 13);
			if($this->option['GZIP'] && function_exists('gzuncompress'))
				$data = gzuncompress($data);

			return unserialize($data);

		}

		/**
		 * 删除缓存
		 * @param	string	$name	缓存名称
		 * @return	boolean			是否成功
		 */
		public function del($name){

			$name = $this->getCacheFile($name);

			return (file_exists($name) ? unlink($name) : true);

		}

		/**
		 * 删除所有缓存
		 * @param	string	$time	有效时间
		 * @return	boolean			是否成功
		 */
		public function delAll($time=null){
			foreach(glob($this->option['PATH'] . '/*.php') as $file) {
				if(file_exists($file)){
					if($time)
						(fileatime($file)+$time < time()) && unlink($file);
					else
						unlink($file);
				}
			}
			return true;
		}

		public function getCacheFile($name){
			return $this->option['PATH'] . md5(base64_encode($name)) . '.php';
		}

	}

