<?php

	/**
	 * 麦迪缓存类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	import('$->Library->Cache->Dv->interface');

	final class Cache{

		private $obj;

		public function __construct($option=null){

			is_null($option) && $option=C('CACHE');

			//缓存类型
			$option['TYPE'] = empty($option['TYPE']) ? 'file' : $option['TYPE'];

			//缓存时间
			$option['EXPIRE'] = intval(empty($option['EXPIRE']) ? C('CACHE.EXPIRE') : $option['EXPIRE']);

			//初始化驱动
			$driver = strtolower($option['TYPE']);
			$className = 'MDPHP\Dv' . ucfirst($driver);
			import('$->Library->Cache->Dv->' . $driver);

			//建立驱动对象
			$this->obj = new $className($option);

		}

		public function __set($name, $value){
			return $this->obj->add($name, $value);
		}

		public function __get($name){
			return $this->obj->get($name);
		}

		public function __call($method, $args){
			if(method_exists($this->obj, $method))
				return call_user_func_array(array($this->obj, $method), $args);
			else
				return false;
		}

		public function __unset($name){
			return $this->obj->del($name);
		}

	}

