<?php

	/**
	 * 麦迪PHP核心类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	class MDPHP{

		public $var = array();

		final public function __construct(){

			//自动运行(模块)
			if(MD_PATH_MODULE && file_exists(MD_PATH_COMPLETE.'loading.php')){
				$func = include MD_PATH_COMPLETE.'loading.php';
				$func();
			}

			//自动运行(项目)
			if(file_exists(MD_PATH.'loading.php')){
				$func = include MD_PATH.'loading.php';
				$func();
			}

		}

		/**
		 * 定义模板变量
		 * @param	string	$name	变量名
		 * @param	string	$value	值
		 * @return					MDPHP类
		 */
		public function assign($name, $value){
			$this->var[$name] = $value;
			return $this;
		}

		/**
		 * 引入模板文件
		 * @param	string	$name	模板文件名
		 */
		public function display($name=MD_ACT, $path=null){

			//模板目录
			is_null($path) && $path=MD_PATH_VIEW.ucfirst(MD_CTR).'/';
			$file = $path . $name . C('TMPL_SUFFIX');

			if(file_exists($file)){

				$cache = MD_PATH_CACHE . md5(MD_CTR.MD_ACT) . '.php';

				//编译模板
				if(!file_put_contents($cache, '<?php if(!defined(\'MDPHP_CACHE\')) exit; ?>' . MDPHP\Custom::parsing(file_get_contents($file))))
					error('Not_Compile_Template', $cache);

				//转换变量
				extract($this->var);

				//添加日志
				MDPHP\Custom::log(array('name'=>$name, 'cache'=>$cache), 'T');

				require $cache;

			}else{
				error('Template_Not_Exist', $file);
			}

		}

		/**
		 * 页面跳转
		 * @param	string	$url	URL地址
		 * @param	integer	$time	等待时间
		 */
		public function jump($url, $time=0){
			if(!headers_sent()){
				if($time)
					header('refresh:' . $time . ';url=' . $url);
				else
					header('Location: ' . $url);
			}else{
				echo '<meta http-equiv="Refresh" content="' . $time . ';URL=' . $url . '">';
			}
			exit;
		}

	}

