<?php

	/**
	 * 麦迪DB接口类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	interface DbInterface{

		public function __construct($connection);		//建立数据通道

		public function query($sql);					//执行SQL

		public function fetch();						//从结果集中取出一行

		public function getInsertId();					//获取最后插入主键ID

		public function getAffectedRows();				//获取受影响的行数

		public function getVersion();					//获取数据库版本

		public function beginTrans();					//开启事务处理

		public function commit();						//提供一个事务

		public function rollback();						//回滚事务

		public function escapeString($str);				//数据安全处理

		public function close();						//资源回收

		public function __destruct();					//析构函数

	}

