<?php

	/**
	 * 麦迪MySql驱动
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	class DbMysql implements DbInterface{

		public $error, $result;
		static protected $link;

		/**
		 * 建立数据通道
		 * @param	mixed	$connection	数据库连接信息
		 */
		public function __construct($connection){
			if(!self::$link){
				if($connection['PCONNECT']){
					$link = mysql_pconnect($connection['HOST'].':'.$connection['PORT'], $connection['USER'], $connection['PWD'], true);
				}else{
					$link = mysql_connect($connection['HOST'].':'.$connection['PORT'], $connection['USER'], $connection['PWD'], true, 131072);
				}
				if(!$link){
					$this->error = array('id'=>'Not_Load_DB', 'title'=>'数据库连接失败', 'content'=>mysql_error());
				}else{
					self::$link = $link;
					if(!mysql_select_db($connection['NAME'], self::$link))
						$this->error = array('id'=>'Not_Load_DBTab', 'title'=>'数据库连接失败', 'content'=>mysql_error());
					else
						mysql_query('SET character_set_connection='.$connection['CHARSET'].',character_set_results='.$connection['CHARSET'].',character_set_client=binary', self::$link);
				}
			}
		}

		/**
		 * 执行SQL
		 * @param	string	$sql	SQL语句
		 * @return	index			MYSQL资源标识符
		 */
		public function query($sql){
			if(is_resource($this->result))
				mysql_free_result($this->result);
			return ($this->result = mysql_query($sql, self::$link));
		}

		/**
		 * 从结果集中取出一行
		 * @return	array/bool	成功返回一组, 失败返回False
		 */
		public function fetch($close=true){
			$array = is_resource($this->result) ? mysql_fetch_assoc($this->result) : array();
			if($close && is_resource($this->result)){
				mysql_free_result($this->result);
				$this->result = null;
			}
			return $array;
		}

		/**
		 * 获取最后插入主键ID
		 * @return	int		ID
		 */
		public function getInsertId(){
			return mysql_insert_id(self::$link);
		}

		/**
		 * 获取受影响行数
		 * @return	int		行数
		 */
		public function getAffectedRows(){
			return mysql_affected_rows(self::$link);
		}

		/**
		 * 获取数据库版本
		 * @return	int		版本
		 */
		public function getVersion(){
			return preg_replace('/[a-z-]/i', '', mysql_get_server_info());
		}

		/**
		 * 开启事务处理
		 */
		public function beginTrans(){
			mysql_query('START AUTOCOMMIT=0');
		}

		/**
		 * 提供一个事务
		 */
		public function commit(){
			mysql_query('COMMIT', self::$link);
			mysql_query('START AUTOCOMMIT=1');
		}

		/**
		 * 回滚事务
		 */
		public function rollback(){
			mysql_query('ROLLBACK', self::$link);
			mysql_query('START AUTOCOMMIT=1');
		}

		/**
		 * 数据安全处理
		 * @return	int		处理后数据
		 */
		public function escapeString($str){
			$quot = is_numeric($str) ? '' : '"';
			if(self::$link){
				return $quot . mysql_real_escape_string($str, self::$link) . $quot;
			}else{
				return $quot . mysql_escape_string($str) . $quot;
			}
		}

		/**
		 * 资源回收
		 */
		public function close(){
			if(is_resource(self::$link)){
				mysql_close(self::$link);
				self::$link = null;
			}
		}

		/**
		 * 析构函数
		 */
		public function __destruct(){
			$this->close();
		}

	}

