<?php

	/**
	 * 麦迪MySqli驱动
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	class DbMysqli implements DbInterface{

		public $error, $result;
		static protected $link;

		/**
		 * 建立数据通道
		 * @param	mixed	$connection	数据库连接信息
		 */
		public function __construct($connection){
			if(!self::$link){
				$link = new \mysqli($connection['HOST'], $connection['USER'], $connection['PWD'], $connection['NAME'], $connection['PORT']);
				if(mysqli_connect_errno()){
					$this->error = array('id'=>'Not_Load_DB', 'title'=>'数据库连接失败', 'content'=>mysqli_connect_error());
					return;
				}
				$link->set_charset($connection['CHARSET']);
				self::$link = $link;
			}
		}

		/**
		 * 执行SQL
		 * @param	string	$sql	SQL语句
		 * @return	index			MYSQL资源标识符
		 */
		public function query($sql){
			if(is_object($this->result))
				$this->result->close();
			return ($this->result = self::$link->query($sql));
		}

		/**
		 * 从结果集中取出一行
		 * @return	array/bool	成功返回一组, 失败返回False
		 */
		public function fetch($close=true){
			$array = is_object($this->result) ? $this->result->fetch_assoc() : array();
			if($close && is_object($this->result)){
				$this->result->close();
				$this->result = null;
			}
			return $array;
		}

		/**
		 * 获取最后插入主键ID
		 * @return	int		ID
		 */
		public function getInsertId(){
			return self::$link->insert_id;
		}

		/**
		 * 获取受影响行数
		 * @return	int		行数
		 */
		public function getAffectedRows(){
			return self::$link->affected_rows;
		}

		/**
		 * 获取数据库版本
		 * @return	int		版本
		 */
		public function getVersion(){
			return self::$link->server_info;
		}

		/**
		 * 开启事务处理
		 */
		public function beginTrans(){
			return self::$link->autocommit(0);
		}

		/**
		 * 提供一个事务
		 */
		public function commit(){
			self::$link->commit();
			self::$link->autocommit(1);
		}

		/**
		 * 回滚事务
		 */
		public function rollback(){
			self::$link->rollback();
			self::$link->autocommit(1);
		}

		/**
		 * 数据安全处理
		 * @return	int		处理后数据
		 */
		public function escapeString($str){
			$quot = is_numeric($str) ? '' : '"';
			if(self::$link)
				return $quot . self::$link->real_escape_string($str) . $quot;
			else
				return $quot . addslashes($str) . $quot;
		}

		/**
		 * 资源回收
		 */
		public function close(){
			if(is_resource(self::$link)){
				self::$link->close();
				self::$link = null;
			}
		}

		/**
		 * 析构函数
		 */
		public function __destruct(){
			$this->close();
		}

	}

