<?php

	/**
	 * 麦迪Pdo驱动
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	class DbPdo implements DbInterface{

		public $error, $result, $affectedRows;
		static protected $link;

		/**
		 * 建立数据通道
		 * @param	mixed	$connection	数据库连接信息
		 */
		public function __construct($connection){
			if(!self::$link){
				try{
					self::$link = new \Pdo('mysql:host=' . $connection['HOST'] . ';dbname=' . $connection['NAME'], $connection['USER'], $connection['PWD']);
					self::$link->query('SET character_set_connection=' . $connection['CHARSET'] . ',character_set_results=' . $connection['CHARSET'] . ',character_set_client=binary');
				}catch(PDOException $e){
					$this->error = array('id'=>'Not_Load_DB', 'title'=>'数据库连接失败', 'content'=>$e->getMessage());
				}
			}
		}

		/**
		 * 执行SQL
		 * @param	string	$sql	SQL语句
		 * @return	index			MYSQL资源标识符
		 */
		public function query($sql){
			$this->result = self::$link->prepare($sql);
			//预处理失败
			if($this->result === false){
				//error(self::$link->errorCode());
				return false;
			}
			//SQL执行失败
			if($this->result->execute() === false){
				//error(self::$link->errorCode());
				return false;
			}
			return $this->result;
		}

		/**
		 * 从结果集中取出一行
		 * @return	array/bool	成功返回一组, 失败返回False
		 */
		public function fetch($close=true){
			$array = is_object($this->result) ? $this->result->fetch(\PDO::FETCH_ASSOC) : array();
			if($close && !is_null($this->result)) $this->result = null;
			return $array;
		}

		/**
		 * 获取最后插入主键ID
		 * @return	int		ID
		 */
		public function getInsertId(){
			return self::$link->lastInsertId;
		}

		/**
		 * 获取受影响行数
		 * @return	int		行数
		 */
		public function getAffectedRows(){
			return count($this->result->fetchAll(4));
		}

		/**
		 * 获取数据库版本
		 * @return	int		版本
		 */
		public function getVersion(){
			return self::$link->getAttribute(4);
		}

		/**
		 * 开启事务处理
		 */
		public function beginTrans(){
			return self::$link->beginTransaction();
		}

		/**
		 * 提供一个事务
		 */
		public function commit(){
			self::$link->commit();
		}

		/**
		 * 回滚事务
		 */
		public function rollback(){
			self::$link->rollback();
		}

		/**
		 * 数据安全处理
		 * @return	int		处理后数据
		 */
		public function escapeString($str){
			$quot = is_numeric($str) ? '' : '"';
			return $quot . addslashes($str) . $quot;
		}

		/**
		 * 资源回收
		 */
		public function close(){
			self::$link = null;
			$this->result = null;
		}

		/**
		 * 析构函数
		 */
		public function __destruct(){
			$this->close();
		}

	}

