<?php

	/**
	 * 麦迪分页类
	 * @author: 麦迪科技 <i@md8.cc>
	 * @link: http://soft.md8.cc
	 * @version: 1.0
	 */

	namespace MDPHP;

	final class Page{

		public $firstRow;				//起始行数
		public $listRows;				//列表每页显示行数
		public $parameter;				//分页跳转时要带的参数
		public $totalRows;				//总行数
		public $totalPages;				//分页总页面数
		public $rollPage = 11;			//分页栏每页显示的页数
		public $lastSuffix = true;		//最后一页是否显示总页数

		private $p			=	'p';	//分页参数名
		private $url		=	'';		//当前URL链接
		private $nowPage	=	1;

		//分页显示定制
		private $config  = array(
			'header' => '<span class="rows">共 %TOTAL_ROW% 条记录</span>',
			'prev'   => '<<',
			'next'   => '>>',
			'first'  => '1...',
			'last'   => '...%TOTAL_PAGE%',
			'theme'  => '%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%',
		);

		/**
		 * 架构函数
		 * @param	integer	$totalRows	总记录数
		 * @param	integer	$listRows	每页显示记录数
		 * @param	array	$parameter	分页参数
		 */
		public function __construct($totalRows, $listRows=20, $parameter=array()){
			$this->totalRows	=	$totalRows;
			$this->listRows		=	$listRows;
			$this->parameter	=	empty($parameter) ? $_GET : $parameter;
			$this->nowPage		=	empty($_GET[$this->p]) ? 1 : intval($_GET[$this->p]);
			$this->nowPage		=	$this->nowPage>0 ? $this->nowPage : 1;
			$this->firstRow		=	$this->listRows * ($this->nowPage - 1);
		}

		/**
		 * 定制分页链接设置
		 * @param	string	$name	设置名称
		 * @param	string	$value	设置值
		 */
		public function set($name,$value){
			if(isset($this->config[$name])){
				$this->config[$name] = $value;
			}
		}

		/**
		 * 生成链接URL
		 * @param	integer	$page	页码
		 * @return	string
		 */
		private function url($page){
			return str_replace('[PAGE]', $page, $this->url);
		}

		/**
		 * 生成代码
		 * @return	string
		 */
		public function get(){
			if($this->totalRows==0) return '';

			//生成URL
			$this->parameter[$this->p] = '[PAGE]';
			$this->url = U(MD_ACT, $this->parameter);

			//计算分页信息
			$this->totalPages = ceil($this->totalRows / $this->listRows); //总页数
			if(!empty($this->totalPages) && $this->nowPage > $this->totalPages){
				$this->nowPage = $this->totalPages;
			}

			//计算分页临时变量
			$now_cool_page								=	$this->rollPage/2;
			$now_cool_page_ceil							=	ceil($now_cool_page);
			$this->lastSuffix && $this->config['last']	=	$this->totalPages;

			//上一页
			$up_row  = $this->nowPage - 1;
			$up_page = $up_row > 0 ? '<a class="prev" href="' . $this->url($up_row) . '">' . $this->config['prev'] . '</a>' : '';

			//下一页
			$down_row  = $this->nowPage + 1;
			$down_page = ($down_row <= $this->totalPages) ? '<a class="next" href="' . $this->url($down_row) . '">' . $this->config['next'] . '</a>' : '';

			//第一页
			$the_first = '';
			if($this->totalPages > $this->rollPage && ($this->nowPage - $now_cool_page) >= 1){
				$the_first = '<a class="first" href="' . $this->url(1) . '">' . $this->config['first'] . '</a>';
			}

			//最后一页
			$the_end = '';
			if($this->totalPages > $this->rollPage && ($this->nowPage + $now_cool_page) < $this->totalPages){
				$the_end = '<a class="end" href="' . $this->url($this->totalPages) . '">' . $this->config['last'] . '</a>';
			}

			//数字连接
			$link_page = '';
			for($i = 1; $i <= $this->rollPage; $i++){
				if(($this->nowPage - $now_cool_page) <= 0 ){
					$page = $i;
				}elseif(($this->nowPage + $now_cool_page - 1) >= $this->totalPages){
					$page = $this->totalPages - $this->rollPage + $i;
				}else{
					$page = $this->nowPage - $now_cool_page_ceil + $i;
				}
				if($page > 0 && $page != $this->nowPage){
					if($page <= $this->totalPages){
						$link_page .= '<a class="num" href="' . $this->url($page) . '">' . $page . '</a>';
					}else{
						break;
					}
				}else{
					if($page > 0 && $this->totalPages != 1){
						$link_page .= '<span class="current">' . $page . '</span>';
					}
				}
			}

			//生成分页代码
			$page_str = str_replace(array('%HEADER%', '%NOW_PAGE%', '%UP_PAGE%', '%DOWN_PAGE%', '%FIRST%', '%LINK_PAGE%', '%END%', '%TOTAL_ROW%', '%TOTAL_PAGE%'), array($this->config['header'], $this->nowPage, $up_page, $down_page, $the_first, $link_page, $the_end, $this->totalRows, $this->totalPages), $this->config['theme']);
			return '<div class="md-page">'.$page_str.'</div>';
		}
	}

